/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.base;

import com.sap.engine.lib.util.base.BaseBinaryTree;
import com.sap.engine.lib.util.base.BinTreeItem;
import com.sap.engine.lib.util.base.TreapItem;
import java.util.Random;

public class BaseTreap
extends BaseBinaryTree {
    protected Random random = new Random();

    public Object clone() {
        BaseTreap tree = (BaseTreap)this.getNewInstance();
        tree.random = new Random();
        this.clone(tree, this.root);
        return tree;
    }

    protected BinTreeItem insert(BinTreeItem current) {
        if (current == null) {
            ((TreapItem)this.recValue).setPriority(this.random.nextInt());
            return this.recValue;
        }
        int cmp = this.searchKey.compareTo(current.getKey());
        if (cmp < 0) {
            current.setLeft(this.insert(current.getLeft()));
            if (((TreapItem)current).getPriority() > ((TreapItem)current.getLeft()).getPriority()) {
                current = this.rotateRight(current);
            }
        } else if (cmp > 0) {
            current.setRight(this.insert(current.getRight()));
            if (((TreapItem)current).getPriority() > ((TreapItem)current.getRight()).getPriority()) {
                current = this.rotateLeft(current);
            }
        } else {
            this.resultValue = current;
            this.recValue.setLeft(current.getLeft());
            this.recValue.setRight(current.getRight());
            return this.recValue;
        }
        return current;
    }

    protected BinTreeItem delete(BinTreeItem current) {
        if (current == null) {
            return null;
        }
        int cmp = this.searchKey.compareTo(current.getKey());
        if (cmp < 0) {
            current.setLeft(this.delete(current.getLeft()));
        } else if (cmp > 0) {
            current.setRight(this.delete(current.getRight()));
        } else {
            this.resultValue = current;
            current = this.delete_(current);
        }
        return current;
    }

    protected BinTreeItem delete_(BinTreeItem node) {
        BinTreeItem tmp;
        if (node.getLeft() == null) {
            return node.getRight();
        }
        if (node.getRight() == null) {
            return node.getLeft();
        }
        if (((TreapItem)node.getLeft()).getPriority() < ((TreapItem)node.getRight()).getPriority()) {
            tmp = this.rotateRight(node);
            tmp.setRight(this.delete_(node));
        } else {
            tmp = this.rotateLeft(node);
            tmp.setLeft(this.delete_(node));
        }
        return tmp;
    }

    protected BinTreeItem rotateLeft(BinTreeItem node) {
        BinTreeItem tmp = node.getRight();
        node.setRight(tmp.getLeft());
        tmp.setLeft(node);
        return tmp;
    }

    protected BinTreeItem rotateRight(BinTreeItem node) {
        BinTreeItem tmp = node.getLeft();
        node.setLeft(tmp.getRight());
        tmp.setRight(node);
        return tmp;
    }

    public String toString() {
        return this.getNode("", this.root, true);
    }

    protected String getNode(String depth, BinTreeItem current, boolean isLeft) {
        String t;
        String string = t = isLeft ? "--- " : "R--- ";
        if (current == null) {
            return depth + t + null + "\n";
        }
        return depth + t + current.getKey() + " : " + ((TreapItem)current).getPriority() + "\n" + this.getNode(depth + "    |", current.getLeft(), true) + this.getNode(depth + "    ", current.getRight(), false);
    }
}

