/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.base;

import com.sap.engine.lib.util.AbstractDataStructure;
import com.sap.engine.lib.util.NotSupportedException;
import com.sap.engine.lib.util.RootDataStructure;
import com.sap.engine.lib.util.base.LinearItem;
import com.sap.engine.lib.util.base.NextItem;
import com.sap.engine.lib.util.base.Pointer;
import com.sap.engine.lib.util.base.PrevItem;
import com.sap.engine.lib.util.iterators.ArrayEnumeration;
import com.sap.engine.lib.util.iterators.BidirectionalIterator;
import com.sap.engine.lib.util.iterators.IteratorException;
import com.sap.engine.lib.util.iterators.RootIterator;
import com.sap.engine.lib.util.iterators.SnapShotEnumeration;

public class BaseDoublyLinkedList
extends AbstractDataStructure {
    static final long serialVersionUID = 3640819823862105131L;
    protected LinearItem first = null;
    protected LinearItem last = null;
    protected int limit;

    public BaseDoublyLinkedList() {
        this(0);
    }

    public BaseDoublyLinkedList(int limit) {
        this.setLimit(limit);
    }

    public boolean addFirstItem(LinearItem item) {
        if (this.count >= this.limit) {
            return false;
        }
        this.addFirst_(item);
        return true;
    }

    protected void addFirst_(LinearItem item) {
        item.setPrev(null);
        item.setNext(this.first);
        if (this.count == 0) {
            this.last = item;
        } else {
            this.first.setPrev(item);
        }
        this.first = item;
        ++this.count;
    }

    public boolean addItem(LinearItem item) {
        return this.addLastItem(item);
    }

    public boolean addLastItem(LinearItem item) {
        if (this.count >= this.limit) {
            return false;
        }
        this.addLast_(item);
        return true;
    }

    protected void addLast_(LinearItem item) {
        item.setPrev(this.last);
        item.setNext(null);
        if (this.count == 0) {
            this.first = item;
        } else {
            this.last.setNext(item);
        }
        this.last = item;
        ++this.count;
    }

    public boolean addItem(int index, LinearItem item) {
        if (index > this.count || index < 0 || this.count >= this.limit) {
            return false;
        }
        if (index == 0) {
            this.addFirst_(item);
            return true;
        }
        if (index == this.count) {
            this.addLast_(item);
            return true;
        }
        LinearItem prev = this.getItem_(index - 1);
        LinearItem next = (LinearItem)prev.getNext();
        item.setPrev(prev);
        item.setNext(next);
        prev.setNext(item);
        next.setPrev(item);
        ++this.count;
        return true;
    }

    public LinearItem removeItem(int index) {
        if (index == 0) {
            if (this.count == 0) {
                return null;
            }
            LinearItem result = this.first;
            this.first = (LinearItem)this.first.getNext();
            --this.count;
            if (this.count == 0) {
                this.last = null;
            } else {
                this.first.setPrev(null);
            }
            result.clearItem();
            return result;
        }
        if (index == this.count - 1) {
            if (this.count == 0) {
                return null;
            }
            LinearItem result = this.last;
            this.last = (LinearItem)this.last.getPrev();
            --this.count;
            this.last.setNext(null);
            result.clearItem();
            return result;
        }
        LinearItem item = this.getItem_(index);
        if (item == null) {
            return null;
        }
        LinearItem prev = (LinearItem)item.getPrev();
        LinearItem next = (LinearItem)item.getNext();
        prev.setNext(next);
        next.setPrev(prev);
        --this.count;
        item.clearItem();
        return item;
    }

    public LinearItem removeItem(LinearItem item) {
        if (this.count == 0) {
            return null;
        }
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                LinearItem result = temp;
                LinearItem prev = (LinearItem)result.getPrev();
                LinearItem next = (LinearItem)result.getNext();
                if (prev == null) {
                    this.first = next;
                } else {
                    prev.setNext(next);
                }
                if (next == null) {
                    this.last = prev;
                } else {
                    next.setPrev(prev);
                }
                result.clearItem();
                --this.count;
                return result;
            }
            temp = temp.getNext();
            ++i;
        }
        return null;
    }

    public int removeAllItems(LinearItem item) {
        int deleted = 0;
        LinearItem prev = null;
        PrevItem start = null;
        NextItem temp = this.first;
        while (temp != null) {
            if (temp.equals(item)) {
                ++deleted;
                if (start == null) {
                    start = temp;
                }
            } else if (start != null) {
                prev = (LinearItem)start.getPrev();
                if (prev == null) {
                    this.first = temp;
                    this.first.setPrev(null);
                } else {
                    prev.setNext(temp);
                    temp.setPrev(prev);
                }
                start = null;
            }
            temp = temp.getNext();
        }
        if (start != null) {
            this.last = (LinearItem)start.getPrev();
            if (this.last != null) {
                this.last.setNext(null);
            } else {
                this.first = null;
            }
        }
        this.count -= deleted;
        return deleted;
    }

    public LinearItem removeFirstItem() {
        if (this.count == 0) {
            return null;
        }
        LinearItem result = this.first;
        this.first = (LinearItem)this.first.getNext();
        --this.count;
        if (this.count == 0) {
            this.last = null;
        } else {
            this.first.setPrev(null);
        }
        result.clearItem();
        return result;
    }

    public LinearItem removeLastItem() {
        if (this.count == 0) {
            return null;
        }
        LinearItem result = this.last;
        this.last = (LinearItem)this.last.getPrev();
        --this.count;
        if (this.count == 0) {
            this.first = null;
        } else {
            this.last.setNext(null);
        }
        result.clearItem();
        return result;
    }

    public LinearItem setItem(int index, LinearItem item) {
        LinearItem result = this.getItem_(index);
        if (result == null) {
            return null;
        }
        LinearItem prev = (LinearItem)result.getPrev();
        LinearItem next = (LinearItem)result.getNext();
        item.setPrev(prev);
        item.setNext(next);
        if (index == 0) {
            this.first = item;
        } else {
            prev.setNext(item);
        }
        if (index == this.count - 1) {
            this.last = item;
        } else {
            next.setPrev(item);
        }
        result.clearItem();
        return result;
    }

    public void clear() {
        this.first = null;
        this.last = null;
        this.count = 0;
    }

    public Object clone() {
        return this.clone_();
    }

    private Object clone_() {
        LinearItem newFirst;
        BaseDoublyLinkedList result = (BaseDoublyLinkedList)super.clone();
        if (this.count == 0) {
            return result;
        }
        LinearItem temp = null;
        NextItem index = this.first;
        LinearItem newItem = newFirst = (LinearItem)this.first.clone();
        newFirst.setPrev(null);
        int i = 1;
        while (i < this.count) {
            index = index.getNext();
            temp = (LinearItem)index.clone();
            newItem.setNext(temp);
            temp.setPrev(newItem);
            newItem = temp;
            ++i;
        }
        newItem.setNext(null);
        result.first = newFirst;
        result.last = newItem;
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseDoublyLinkedList)) {
            return false;
        }
        if (this.count != ((BaseDoublyLinkedList)obj).count) {
            return false;
        }
        if (this.count == 0) {
            return true;
        }
        NextItem currentTemp = this.first;
        NextItem checkedTemp = ((BaseDoublyLinkedList)obj).first;
        int i = 0;
        while (i < this.count) {
            if (!currentTemp.equals(checkedTemp)) {
                return false;
            }
            currentTemp = currentTemp.getNext();
            checkedTemp = checkedTemp.getNext();
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean containsItem(LinearItem item) {
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                return true;
            }
            temp = temp.getNext();
            ++i;
        }
        return false;
    }

    public LinearItem getItem(LinearItem item) {
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                return temp;
            }
            temp = temp.getNext();
            ++i;
        }
        return null;
    }

    public LinearItem getItem(int index) {
        return this.getItem_(index);
    }

    protected LinearItem getItem_(int index) {
        LinearItem result;
        if (index >= this.count || index < 0) {
            return null;
        }
        if (index < this.count / 2) {
            NextItem temp = this.first;
            int i = 0;
            while (i < index) {
                temp = temp.getNext();
                ++i;
            }
            result = temp;
        } else {
            PrevItem temp = this.last;
            int i = this.count - 1;
            while (i > index) {
                temp = temp.getPrev();
                --i;
            }
            result = temp;
        }
        return result;
    }

    public LinearItem getFirstItem() {
        return this.first;
    }

    public LinearItem getLastItem() {
        return this.last;
    }

    public int indexOfItem(LinearItem item) {
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                return i;
            }
            temp = temp.getNext();
            ++i;
        }
        return -1;
    }

    public int lastIndexOfItem(LinearItem item) {
        PrevItem temp = this.last;
        int i = this.count - 1;
        while (i >= 0) {
            if (temp.equals(item)) {
                return i;
            }
            temp = temp.getPrev();
            --i;
        }
        return -1;
    }

    public boolean isFull() {
        return this.count >= this.limit;
    }

    public LinearItem[] toItemArray() {
        LinearItem[] array = new LinearItem[this.count];
        LinearItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            array[i] = temp;
            temp = (LinearItem)temp.getNext();
            ++i;
        }
        return array;
    }

    protected void init(LinearItem first, LinearItem last, int count) {
        this.first = first;
        this.last = last;
        this.count = count;
    }

    public BaseDoublyLinkedList sublist(int index) {
        return this.sublist_(index);
    }

    private BaseDoublyLinkedList sublist_(int index) {
        LinearItem newFirst;
        if (index <= 0) {
            return (BaseDoublyLinkedList)this.clone_();
        }
        BaseDoublyLinkedList result = (BaseDoublyLinkedList)super.clone();
        if (index >= this.count) {
            result.init(null, null, 0);
            return result;
        }
        NextItem counter = this.getItem_(index);
        LinearItem temp = null;
        LinearItem newItem = newFirst = (LinearItem)counter.clone();
        newFirst.setPrev(null);
        int i = index + 1;
        while (i < this.count) {
            counter = counter.getNext();
            temp = (LinearItem)counter.clone();
            newItem.setNext(temp);
            temp.setPrev(newItem);
            newItem = temp;
            ++i;
        }
        newItem.setNext(null);
        result.init(newFirst, newItem, this.count - index);
        return result;
    }

    public BaseDoublyLinkedList sublist(int lowerBoundary, int upperBoundary) {
        LinearItem newFirst;
        if (upperBoundary >= this.count) {
            upperBoundary = this.count - 1;
        }
        if (lowerBoundary < 0) {
            lowerBoundary = 0;
        }
        if (upperBoundary == this.count - 1) {
            return this.sublist_(lowerBoundary);
        }
        BaseDoublyLinkedList result = (BaseDoublyLinkedList)super.clone();
        if (lowerBoundary > upperBoundary) {
            result.init(null, null, 0);
            return result;
        }
        NextItem counter = this.getItem_(lowerBoundary);
        LinearItem temp = null;
        LinearItem newItem = newFirst = (LinearItem)counter.clone();
        newFirst.setPrev(null);
        int i = lowerBoundary;
        while (i < upperBoundary) {
            counter = counter.getNext();
            temp = (LinearItem)counter.clone();
            newItem.setNext(temp);
            temp.setPrev(newItem);
            newItem = temp;
            ++i;
        }
        newItem.setNext(null);
        result.init(newFirst, newItem, upperBoundary - lowerBoundary + 1);
        return result;
    }

    public boolean removeSublist(int index) {
        if (index >= this.count || this.count == 0) {
            return false;
        }
        if (index <= 0) {
            this.first = null;
            this.last = null;
            this.count = 0;
        } else {
            LinearItem temp = (LinearItem)this.getItem_(index).getPrev();
            temp.setNext(null);
            this.last = temp;
            this.count = index;
        }
        return true;
    }

    public boolean removeRange(int lowerBoundary, int upperBoundary) {
        if (upperBoundary >= this.count) {
            upperBoundary = this.count - 1;
        }
        if (lowerBoundary < 0) {
            lowerBoundary = 0;
        }
        if (lowerBoundary > upperBoundary || lowerBoundary >= this.count) {
            return false;
        }
        int dif = upperBoundary - lowerBoundary + 1;
        int s1 = upperBoundary + 1;
        int s2 = this.count - lowerBoundary;
        int s3 = this.count - dif;
        if (s1 <= s2 && s1 <= s3) {
            if (lowerBoundary == 0) {
                NextItem right = this.first;
                int i = 0;
                while (i < dif) {
                    ++i;
                    right = right.getNext();
                }
                right.setPrev(null);
                this.first = right;
            } else {
                NextItem left = this.first;
                int i = 1;
                while (i < lowerBoundary) {
                    ++i;
                    left = left.getNext();
                }
                NextItem right = left;
                int i2 = 0;
                while (i2 <= dif) {
                    ++i2;
                    right = right.getNext();
                }
                left.setNext(right);
                right.setPrev((PrevItem)((Object)left));
            }
        } else if (s2 <= s1 && s2 <= s3) {
            if (upperBoundary + 1 == this.count) {
                PrevItem left = this.last;
                int i = 0;
                while (i < dif) {
                    ++i;
                    left = left.getPrev();
                }
                left.setNext(null);
                this.last = left;
            } else {
                PrevItem right = this.last;
                int i = this.count - 2;
                while (i > upperBoundary) {
                    --i;
                    right = right.getPrev();
                }
                PrevItem left = right;
                int i3 = 0;
                while (i3 <= dif) {
                    ++i3;
                    left = left.getPrev();
                }
                left.setNext((NextItem)((Object)right));
                right.setPrev(left);
            }
        } else if (lowerBoundary == 0) {
            if (upperBoundary + 1 == this.count) {
                this.first = null;
                this.last = null;
            } else {
                PrevItem right = this.last;
                int i = this.count - 2;
                while (i > upperBoundary) {
                    --i;
                    right = right.getPrev();
                }
                right.setPrev(null);
                this.first = right;
            }
        } else if (upperBoundary + 1 == this.count) {
            NextItem left = this.first;
            int i = 1;
            while (i < lowerBoundary) {
                ++i;
                left = left.getNext();
            }
            left.setNext(null);
            this.last = left;
        } else {
            PrevItem right = this.last;
            int i = this.count - 2;
            while (i > upperBoundary) {
                --i;
                right = right.getPrev();
            }
            NextItem left = this.first;
            int i4 = 1;
            while (i4 < lowerBoundary) {
                ++i4;
                left = left.getNext();
            }
            left.setNext((NextItem)((Object)right));
            right.setPrev((PrevItem)((Object)left));
        }
        this.count -= dif;
        return true;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append(" [Size = " + this.count + "; First = " + this.first + "; Last = " + this.last + "; Limit = " + this.limit + "]\n[");
        NextItem temp = this.first;
        while (temp != null) {
            s.append(temp + ", ");
            temp = temp.getNext();
        }
        s.append("]\n[");
        PrevItem temp2 = this.last;
        while (temp2 != null) {
            s.append(temp2 + ", ");
            temp2 = temp2.getPrev();
        }
        s.append("]");
        return s.toString();
    }

    public SnapShotEnumeration itemsEnumeration() {
        return new ArrayEnumeration(this.toItemArray());
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit <= 0 ? Integer.MAX_VALUE : limit;
    }

    protected Object getNewInstance() {
        return super.clone();
    }

    public boolean addBefore(LinearItem index, LinearItem item) {
        if (this.count >= this.limit) {
            return false;
        }
        LinearItem prev = (LinearItem)index.getPrev();
        item.setPrev(prev);
        if (prev == null) {
            this.first = item;
        } else {
            prev.setNext(item);
        }
        item.setNext(index);
        index.setPrev(item);
        ++this.count;
        return true;
    }

    public boolean addAfter(LinearItem index, LinearItem item) {
        if (this.count >= this.limit) {
            return false;
        }
        LinearItem next = (LinearItem)index.getNext();
        item.setNext(next);
        if (next == null) {
            this.last = item;
        } else {
            next.setPrev(item);
        }
        item.setPrev(index);
        index.setNext(item);
        ++this.count;
        return true;
    }

    public void removeElement(LinearItem item) {
        LinearItem prev = (LinearItem)item.getPrev();
        LinearItem next = (LinearItem)item.getNext();
        if (prev == null) {
            this.first = next;
        } else {
            prev.setNext(next);
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.setPrev(prev);
        }
        item.clearItem();
        --this.count;
    }

    public void removeRange(LinearItem start, LinearItem end) {
        int counter = 1;
        NextItem temp = start;
        while (temp != end) {
            temp = temp.getNext();
            ++counter;
        }
        LinearItem prev = (LinearItem)start.getPrev();
        LinearItem next = (LinearItem)end.getNext();
        if (prev == null) {
            this.first = next;
        } else {
            prev.setNext(next);
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.setPrev(prev);
        }
        this.count -= counter;
    }

    public void replace(LinearItem oldItem, LinearItem newItem) {
        LinearItem prev = (LinearItem)oldItem.getPrev();
        LinearItem next = (LinearItem)oldItem.getNext();
        newItem.setNext(next);
        newItem.setPrev(prev);
        if (prev == null) {
            this.first = newItem;
        } else {
            prev.setNext(newItem);
        }
        if (next == null) {
            this.last = newItem;
        } else {
            next.setPrev(newItem);
        }
        oldItem.clearItem();
    }

    public SnapShotEnumeration elementsEnumeration() {
        return new ArrayEnumeration(this.toArray());
    }

    public Pointer[] toPointerArray() {
        throw new NotSupportedException("Use toArray() method instead!");
    }

    public Object deepClone() {
        throw new NotSupportedException("Use clone() method instead!");
    }

    public Object[] toArray() {
        return this.toItemArray();
    }

    public RootIterator elementsIterator() {
        return new BaseDoublyLinkedListIterator();
    }

    protected LinearItem iterGet(RootIterator rootIter) {
        BaseDoublyLinkedListIterator iter = (BaseDoublyLinkedListIterator)rootIter;
        if (iter.pointer == iter.end.getNext()) {
            throw new IteratorException("End of Iterator reached!");
        }
        return iter.pointer;
    }

    protected LinearItem iterNext(RootIterator rootIter, int offset) {
        BaseDoublyLinkedListIterator iter = (BaseDoublyLinkedListIterator)rootIter;
        LinearItem endNext = (LinearItem)iter.end.getNext();
        if (offset < 0) {
            throw new IteratorException("Invalid argument: " + offset + " < 0");
        }
        if (iter.pointer == endNext) {
            throw new IteratorException("End of Iterator reached!");
        }
        int i = 0;
        while (i < offset) {
            if (iter.pointer == endNext) {
                throw new IteratorException("Specified position exceeds the end of Iterator!");
            }
            ++i;
            iter.pointer = (LinearItem)iter.pointer.getNext();
        }
        LinearItem res = iter.pointer;
        iter.pointer = (LinearItem)iter.pointer.getNext();
        return res;
    }

    protected LinearItem iterAdd(Object obj, RootIterator rootIter) {
        BaseDoublyLinkedListIterator iter = (BaseDoublyLinkedListIterator)rootIter;
        if (obj == null) {
            throw new IteratorException("An illegal attempt to add null element!");
        }
        if (this.count >= this.limit) {
            throw new IteratorException("The limit ot LinkedList exceeded!");
        }
        LinearItem item = (LinearItem)obj;
        item.setPrev(iter.end);
        if (this.count == 0) {
            item.setNext(null);
            this.first = item;
            iter.start = item;
            this.last = item;
        } else {
            if (iter.end == this.last) {
                this.last = item;
            }
            item.setNext(iter.end.getNext());
            iter.end.setNext(item);
        }
        ++this.count;
        iter.end = item;
        return item;
    }

    protected LinearItem iterChange(Object obj, RootIterator rootIter) {
        BaseDoublyLinkedListIterator iter = (BaseDoublyLinkedListIterator)rootIter;
        if (obj == null) {
            throw new IteratorException("An illegal attempt to change an element to null!");
        }
        if (iter.pointer == iter.end.getNext()) {
            throw new IteratorException("End of Iterator reached!");
        }
        LinearItem item = (LinearItem)obj;
        LinearItem old = iter.pointer;
        item.setNext(iter.pointer.getNext());
        item.setPrev(iter.pointer.getPrev());
        iter.pointer = item;
        return old;
    }

    protected LinearItem iterRemove(RootIterator rootIter) {
        BaseDoublyLinkedListIterator iter = (BaseDoublyLinkedListIterator)rootIter;
        if (iter.pointer == iter.end.getNext()) {
            throw new IteratorException("End of Iterator reached!");
        }
        if (this.count == 0) {
            throw new IteratorException("Iterator is empty!");
        }
        LinearItem temp = iter.pointer;
        LinearItem prev = (LinearItem)iter.pointer.getPrev();
        iter.pointer = (LinearItem)iter.pointer.getNext();
        if (iter.pointer != null) {
            iter.pointer.setPrev(prev);
        }
        if (temp == iter.start) {
            if (iter.start == this.first) {
                this.first = iter.pointer;
            } else {
                prev.setNext(iter.pointer);
            }
            LinearItem linearItem = iter.start = temp == iter.end ? null : iter.pointer;
            if (--this.count == 0) {
                iter.end = this.last = null;
            }
        } else {
            prev.setNext(iter.pointer);
            --this.count;
        }
        if (iter.end == temp) {
            boolean isLast = iter.end == this.last;
            iter.end = prev;
            if (isLast) {
                this.last = iter.end;
            }
        }
        temp.clearItem();
        return temp;
    }

    protected LinearItem iterInsert(Object obj, RootIterator rootIter) {
        BaseDoublyLinkedListIterator iter = (BaseDoublyLinkedListIterator)rootIter;
        if (obj == null) {
            throw new IteratorException("An illegal attempt to add null element!");
        }
        if (this.count >= this.limit) {
            throw new IteratorException("The limit ot LinkedList exceeded!");
        }
        LinearItem item = (LinearItem)obj;
        LinearItem prev = iter.pointer == null ? null : (LinearItem)iter.pointer.getPrev();
        item.setPrev(prev);
        item.setNext(iter.pointer);
        if (this.count == 0) {
            this.first = item;
            iter.start = item;
            this.last = item;
            iter.end = item;
        } else if (iter.pointer == iter.start) {
            if (iter.start == this.first) {
                this.first = item;
            }
            iter.start = item;
        } else if (iter.pointer == iter.end.getNext()) {
            if (iter.end == this.last) {
                this.last = item;
            }
            iter.end = item;
        }
        if (prev != null) {
            prev.setNext(item);
        }
        iter.pointer = item;
        ++this.count;
        return item;
    }

    protected LinearItem iterPrev(RootIterator rootIter, int offset) {
        BaseDoublyLinkedListIterator iter = (BaseDoublyLinkedListIterator)rootIter;
        if (offset < 0) {
            throw new IteratorException("Invalid argument: " + offset + " < 0");
        }
        if (iter.pointer == iter.start) {
            throw new IteratorException("Beginning of Iterator reached!");
        }
        int i = 0;
        while (i < offset) {
            if (iter.pointer == iter.start) {
                throw new IteratorException("Specified position is underneath the start of Iterator!");
            }
            ++i;
            iter.pointer = (LinearItem)iter.pointer.getPrev();
        }
        iter.pointer = (LinearItem)iter.pointer.getPrev();
        return iter.pointer;
    }

    protected int iterSize(RootIterator rootIter) {
        BaseDoublyLinkedListIterator iter = (BaseDoublyLinkedListIterator)rootIter;
        NextItem endNext = iter.end.getNext();
        int counter = 0;
        if (iter.start == null || iter.start == iter.end) {
            return 0;
        }
        NextItem ptr = iter.start;
        while (ptr != endNext) {
            if (ptr == null) {
                throw new IteratorException("Start of Iterator was set after its end!");
            }
            ++counter;
            ptr = ptr.getNext();
        }
        return counter;
    }

    protected class BaseDoublyLinkedListIterator
    implements BidirectionalIterator {
        protected LinearItem start;
        protected LinearItem end;
        protected LinearItem pointer;

        protected BaseDoublyLinkedListIterator() {
            this.start = BaseDoublyLinkedList.this.first;
            this.end = BaseDoublyLinkedList.this.last;
            this.pointer = this.start;
        }

        public Object get() {
            return BaseDoublyLinkedList.this.iterGet(this);
        }

        public boolean isAtBegin() {
            return this.start == null ? true : this.pointer == this.start;
        }

        public boolean isAtEnd() {
            return this.end == null ? true : this.pointer == this.end.getNext();
        }

        public RootDataStructure getDataStructure() {
            return BaseDoublyLinkedList.this;
        }

        public Object next() {
            return BaseDoublyLinkedList.this.iterNext(this, 0);
        }

        public Object next(int n) {
            return BaseDoublyLinkedList.this.iterNext(this, n);
        }

        public void setStartFromIterator(RootIterator iterator) {
            BaseDoublyLinkedListIterator bdlli = (BaseDoublyLinkedListIterator)iterator;
            if (BaseDoublyLinkedList.this != bdlli.getDataStructure()) {
                throw new IteratorException("An attempt to set start from an Iterator over a different DoublyLinkerList instance!");
            }
            LinearItem newPointer = bdlli.pointer;
            if (newPointer == null) {
                throw new IteratorException("Illegal argument: pointer == null");
            }
            this.pointer = this.start = newPointer;
        }

        public void setEndFromIterator(RootIterator iterator) {
            BaseDoublyLinkedListIterator bdlli = (BaseDoublyLinkedListIterator)iterator;
            if (BaseDoublyLinkedList.this != bdlli.getDataStructure()) {
                throw new IteratorException("An attempt to set end from an Iterator over a different DoublyLinkerList instance!");
            }
            LinearItem newPointer = (LinearItem)bdlli.pointer.getPrev();
            if (this.pointer == null) {
                throw new IteratorException("End of Iterator reached!");
            }
            if (newPointer == null) {
                throw new IteratorException("An attempt to set the end from an exhausted Iterator!");
            }
            this.end = newPointer;
        }

        public Object add(Object obj) {
            return BaseDoublyLinkedList.this.iterAdd(obj, this);
        }

        public Object change(Object obj) {
            return BaseDoublyLinkedList.this.iterChange(obj, this);
        }

        public Object remove() {
            return BaseDoublyLinkedList.this.iterRemove(this);
        }

        public Object insert(Object obj) {
            return BaseDoublyLinkedList.this.iterInsert(obj, this);
        }

        public int size() {
            return BaseDoublyLinkedList.this.iterSize(this);
        }

        public boolean isInsertable() {
            return true;
        }

        public boolean isRemoveable() {
            return true;
        }

        public boolean isChangeable() {
            return true;
        }

        public boolean isAddable() {
            return true;
        }

        public Object prev() {
            return BaseDoublyLinkedList.this.iterPrev(this, 0);
        }

        public Object prev(int n) {
            return BaseDoublyLinkedList.this.iterPrev(this, n);
        }
    }
}

