/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.base;

import com.sap.engine.lib.util.base.AVLItem;
import com.sap.engine.lib.util.base.BaseBinaryTree;
import com.sap.engine.lib.util.base.BinTreeItem;

public class BaseAVLTree
extends BaseBinaryTree {
    protected transient boolean isModified;
    protected transient BinTreeItem tmpValue;

    public BinTreeItem removeMinItem() {
        if (this.root == null) {
            return null;
        }
        this.root = this.deleteMin(this.root);
        --this.count;
        this.resultValue.clearItem();
        BinTreeItem result = this.resultValue;
        this.resultValue = null;
        return result;
    }

    public BinTreeItem removeMaxItem() {
        if (this.root == null) {
            return null;
        }
        this.root = this.deleteMax(this.root);
        --this.count;
        this.resultValue.clearItem();
        BinTreeItem result = this.resultValue;
        this.resultValue = null;
        return result;
    }

    protected BinTreeItem deleteMin(BinTreeItem current) {
        if (current.getLeft() != null) {
            current.setLeft(this.deleteMin(current.getLeft()));
            if (this.isModified) {
                current = this.rotateLeft(current);
            }
        } else {
            this.resultValue = current;
            this.isModified = true;
            return current.getRight();
        }
        return current;
    }

    protected BinTreeItem deleteMax(BinTreeItem current) {
        if (current.getRight() != null) {
            current.setRight(this.deleteMax(current.getRight()));
            if (this.isModified) {
                current = this.rotateRight(current);
            }
        } else {
            this.resultValue = current;
            this.isModified = true;
            return current.getLeft();
        }
        return current;
    }

    protected BinTreeItem insert(BinTreeItem current) {
        if (current == null) {
            this.isModified = true;
            ((AVLItem)this.recValue).setBalance(0);
            return this.recValue;
        }
        int cmp = this.searchKey.compareTo(current.getKey());
        if (cmp < 0) {
            current.setLeft(this.insert(current.getLeft()));
            if (this.isModified) {
                switch (((AVLItem)current).getBalance()) {
                    case 1: {
                        ((AVLItem)current).setBalance(0);
                        this.isModified = false;
                        break;
                    }
                    case 0: {
                        ((AVLItem)current).setBalance(-1);
                        break;
                    }
                    case -1: {
                        BinTreeItem tmp1 = current.getLeft();
                        if (((AVLItem)tmp1).getBalance() == -1) {
                            current.setLeft(tmp1.getRight());
                            tmp1.setRight(current);
                            ((AVLItem)current).setBalance(0);
                            current = tmp1;
                        } else {
                            BinTreeItem tmp2 = tmp1.getRight();
                            tmp1.setRight(tmp2.getLeft());
                            tmp2.setLeft(tmp1);
                            current.setLeft(tmp2.getRight());
                            tmp2.setRight(current);
                            int bal2 = ((AVLItem)tmp2).getBalance();
                            ((AVLItem)current).setBalance(bal2 == -1 ? 1 : 0);
                            ((AVLItem)tmp1).setBalance(bal2 == 1 ? -1 : 0);
                            current = tmp2;
                        }
                        ((AVLItem)current).setBalance(0);
                        this.isModified = false;
                    }
                }
            }
        } else if (cmp > 0) {
            current.setRight(this.insert(current.getRight()));
            if (this.isModified) {
                switch (((AVLItem)current).getBalance()) {
                    case -1: {
                        ((AVLItem)current).setBalance(0);
                        this.isModified = false;
                        break;
                    }
                    case 0: {
                        ((AVLItem)current).setBalance(1);
                        break;
                    }
                    case 1: {
                        BinTreeItem tmp1 = current.getRight();
                        if (((AVLItem)tmp1).getBalance() == 1) {
                            current.setRight(tmp1.getLeft());
                            tmp1.setLeft(current);
                            ((AVLItem)current).setBalance(0);
                            current = tmp1;
                        } else {
                            BinTreeItem tmp2 = tmp1.getLeft();
                            tmp1.setLeft(tmp2.getRight());
                            tmp2.setRight(tmp1);
                            current.setRight(tmp2.getLeft());
                            tmp2.setLeft(current);
                            int bal2 = ((AVLItem)tmp2).getBalance();
                            ((AVLItem)current).setBalance(bal2 == 1 ? -1 : 0);
                            ((AVLItem)tmp1).setBalance(bal2 == -1 ? 1 : 0);
                            current = tmp2;
                        }
                        ((AVLItem)current).setBalance(0);
                        this.isModified = false;
                    }
                }
            }
        } else {
            this.isModified = false;
            this.resultValue = current;
            this.recValue.setLeft(current.getLeft());
            this.recValue.setRight(current.getRight());
            ((AVLItem)this.recValue).setBalance(((AVLItem)current).getBalance());
            return this.recValue;
        }
        return current;
    }

    protected BinTreeItem delete(BinTreeItem current) {
        if (current == null) {
            this.isModified = false;
            return null;
        }
        int cmp = this.searchKey.compareTo(current.getKey());
        if (cmp < 0) {
            current.setLeft(this.delete(current.getLeft()));
            if (this.isModified) {
                current = this.rotateLeft(current);
            }
        } else if (cmp > 0) {
            current.setRight(this.delete(current.getRight()));
            if (this.isModified) {
                current = this.rotateRight(current);
            }
        } else {
            this.resultValue = current;
            if (current.getRight() == null) {
                this.isModified = true;
                return current.getLeft();
            }
            if (current.getLeft() == null) {
                this.isModified = true;
                return current.getRight();
            }
            current = this.delete_(current.getLeft());
            this.tmpValue.setLeft(current);
            this.tmpValue.setRight(this.resultValue.getRight());
            ((AVLItem)this.tmpValue).setBalance(((AVLItem)this.resultValue).getBalance());
            current = this.isModified ? this.rotateLeft(this.tmpValue) : this.tmpValue;
            this.tmpValue = null;
        }
        return current;
    }

    protected BinTreeItem delete_(BinTreeItem current) {
        if (current.getRight() != null) {
            current.setRight(this.delete_(current.getRight()));
            if (this.isModified) {
                current = this.rotateRight(current);
            }
        } else {
            this.isModified = true;
            this.tmpValue = current;
            return current.getLeft();
        }
        return current;
    }

    protected BinTreeItem rotateLeft(BinTreeItem current) {
        switch (((AVLItem)current).getBalance()) {
            case -1: {
                ((AVLItem)current).setBalance(0);
                break;
            }
            case 0: {
                ((AVLItem)current).setBalance(1);
                this.isModified = false;
                break;
            }
            case 1: {
                BinTreeItem tmp1 = current.getRight();
                int bal1 = ((AVLItem)tmp1).getBalance();
                if (bal1 >= 0) {
                    current.setRight(tmp1.getLeft());
                    tmp1.setLeft(current);
                    if (bal1 == 0) {
                        ((AVLItem)current).setBalance(1);
                        ((AVLItem)tmp1).setBalance(-1);
                        this.isModified = false;
                    } else {
                        ((AVLItem)current).setBalance(0);
                        ((AVLItem)tmp1).setBalance(0);
                    }
                    current = tmp1;
                    break;
                }
                BinTreeItem tmp2 = tmp1.getLeft();
                tmp1.setLeft(tmp2.getRight());
                tmp2.setRight(tmp1);
                current.setRight(tmp2.getLeft());
                tmp2.setLeft(current);
                int bal2 = ((AVLItem)tmp2).getBalance();
                ((AVLItem)current).setBalance(bal2 == 1 ? -1 : 0);
                ((AVLItem)tmp1).setBalance(bal2 == -1 ? 1 : 0);
                ((AVLItem)tmp2).setBalance(0);
                current = tmp2;
            }
        }
        return current;
    }

    protected BinTreeItem rotateRight(BinTreeItem current) {
        switch (((AVLItem)current).getBalance()) {
            case 1: {
                ((AVLItem)current).setBalance(0);
                break;
            }
            case 0: {
                ((AVLItem)current).setBalance(-1);
                this.isModified = false;
                break;
            }
            case -1: {
                BinTreeItem tmp1 = current.getLeft();
                int bal1 = ((AVLItem)tmp1).getBalance();
                if (bal1 <= 0) {
                    current.setLeft(tmp1.getRight());
                    tmp1.setRight(current);
                    if (bal1 == 0) {
                        ((AVLItem)current).setBalance(-1);
                        ((AVLItem)tmp1).setBalance(1);
                        this.isModified = false;
                    } else {
                        ((AVLItem)current).setBalance(0);
                        ((AVLItem)tmp1).setBalance(0);
                    }
                    current = tmp1;
                    break;
                }
                BinTreeItem tmp2 = tmp1.getRight();
                tmp1.setRight(tmp2.getLeft());
                tmp2.setLeft(tmp1);
                current.setLeft(tmp2.getRight());
                tmp2.setRight(current);
                int bal2 = ((AVLItem)tmp2).getBalance();
                ((AVLItem)current).setBalance(bal2 == -1 ? 1 : 0);
                ((AVLItem)tmp1).setBalance(bal2 == 1 ? -1 : 0);
                ((AVLItem)tmp2).setBalance(0);
                current = tmp2;
            }
        }
        return current;
    }

    public void checkBal() {
        this.checkBal(this.root);
    }

    protected int checkBal(BinTreeItem current) {
        if (current == null) {
            return -1;
        }
        int hl = this.checkBal(current.getLeft());
        int hr = this.checkBal(current.getRight());
        int bal = hr - hl;
        if (((AVLItem)current).getBalance() != bal) {
            throw new RuntimeException(current + "     Clalculated Balance = : " + bal);
        }
        return Math.max(hr, hl) + 1;
    }
}

