/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.Queue;

public class WaitQueue
extends Queue {
    private transient int pushWaiting = 0;
    private transient int popWaiting = 0;
    private transient Object pushMonitor = new Object();
    private transient int id = 0;
    private transient int pushWillWait = 0;

    public WaitQueue() {
        this(0);
    }

    public WaitQueue(int limit) {
        super(limit);
    }

    public synchronized Object head() {
        Object result;
        while ((result = this.getFirst()) == null) {
            Object var4_2;
            ++this.popWaiting;
            try {
                try {
                    this.wait();
                }
                catch (InterruptedException _) {
                    var4_2 = null;
                    --this.popWaiting;
                    break;
                }
                var4_2 = null;
                --this.popWaiting;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.popWaiting;
                throw throwable;
            }
        }
        return result;
    }

    public synchronized Object head(long timeout) throws InterruptedException {
        Object result;
        long startTime = System.currentTimeMillis();
        while ((result = this.getFirst()) == null && timeout > System.currentTimeMillis() - startTime) {
            Object var7_4;
            ++this.popWaiting;
            try {
                this.wait();
                var7_4 = null;
                --this.popWaiting;
            }
            catch (Throwable throwable) {
                var7_4 = null;
                --this.popWaiting;
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object dequeue() {
        while (true) {
            Object var5_2;
            Object result;
            if ((result = this.removeFirst()) != null) {
                if (this.pushWillWait <= 0) return result;
                Object object = this.pushMonitor;
                synchronized (object) {
                    if (this.pushWaiting > 0) {
                        this.pushMonitor.notify();
                    } else {
                        ++this.id;
                    }
                    return result;
                }
            }
            ++this.popWaiting;
            try {
                try {
                    this.wait();
                }
                catch (InterruptedException _) {
                    var5_2 = null;
                    --this.popWaiting;
                    return result;
                }
                var5_2 = null;
                --this.popWaiting;
            }
            catch (Throwable throwable) {
                var5_2 = null;
                --this.popWaiting;
                throw throwable;
            }
        }
    }

    public synchronized Object dequeue(long timeout) throws InterruptedException {
        Object result;
        long startTime = System.currentTimeMillis();
        while (true) {
            Object var9_4;
            if ((result = this.removeFirst()) != null) {
                if (this.pushWillWait <= 0) break;
                Object object = this.pushMonitor;
                synchronized (object) {
                    if (this.pushWaiting > 0) {
                        this.pushMonitor.notify();
                    } else {
                        ++this.id;
                    }
                    break;
                }
            }
            if (timeout <= System.currentTimeMillis() - startTime) break;
            ++this.popWaiting;
            try {
                this.wait();
                var9_4 = null;
                --this.popWaiting;
            }
            catch (Throwable throwable) {
                var9_4 = null;
                --this.popWaiting;
                throw throwable;
            }
        }
        return result;
    }

    public boolean enqueueNoWait(Object item) {
        boolean result = false;
        WaitQueue waitQueue = this;
        synchronized (waitQueue) {
            if (super.size() < this.popWaiting) {
                boolean bl = result = this.addLast(item) != null;
                if (result) {
                    this.notify();
                }
            }
        }
        return result;
    }

    public boolean enqueue(Object item) {
        boolean result;
        block18: {
            boolean firstTime = true;
            boolean exit = false;
            int localId = 0;
            do {
                WaitQueue waitQueue = this;
                synchronized (waitQueue) {
                    if (!firstTime) {
                        --this.pushWillWait;
                    }
                    boolean bl = result = this.addLast(item) != null;
                    if (result) {
                        if (this.popWaiting > 0) {
                            this.notify();
                        }
                        break block18;
                    }
                    localId = this.id;
                    ++this.pushWillWait;
                    firstTime = false;
                }
                Object object = this.pushMonitor;
                synchronized (object) {
                    if (localId == this.id) {
                        Object var10_11;
                        try {
                            try {
                                ++this.pushWaiting;
                                this.pushMonitor.wait();
                            }
                            catch (InterruptedException e) {
                                exit = true;
                                var10_11 = null;
                                --this.pushWaiting;
                            }
                            var10_11 = null;
                            --this.pushWaiting;
                        }
                        catch (Throwable throwable) {
                            var10_11 = null;
                            --this.pushWaiting;
                            throw throwable;
                        }
                    }
                }
            } while (!exit);
            WaitQueue waitQueue = this;
            synchronized (waitQueue) {
                --this.pushWillWait;
            }
        }
        return result;
    }

    public boolean enqueue(Object item, long timeout) throws InterruptedException {
        boolean result;
        block21: {
            long startTime = System.currentTimeMillis();
            boolean firstTime = true;
            boolean exit = false;
            InterruptedException localExc = null;
            int localId = 0;
            do {
                WaitQueue waitQueue = this;
                synchronized (waitQueue) {
                    if (!firstTime) {
                        --this.pushWillWait;
                    }
                    boolean bl = result = this.addLast(item) != null;
                    if (result) {
                        if (this.popWaiting > 0) {
                            this.notify();
                        }
                        break block21;
                    }
                    localId = this.id;
                    ++this.pushWillWait;
                    firstTime = false;
                }
                Object object = this.pushMonitor;
                synchronized (object) {
                    if (timeout > System.currentTimeMillis() - startTime) {
                        if (localId == this.id) {
                            Object var15_14;
                            try {
                                try {
                                    ++this.pushWaiting;
                                    this.pushMonitor.wait();
                                }
                                catch (InterruptedException e) {
                                    localExc = e;
                                    exit = true;
                                    var15_14 = null;
                                    --this.pushWaiting;
                                }
                                var15_14 = null;
                                --this.pushWaiting;
                            }
                            catch (Throwable throwable) {
                                var15_14 = null;
                                --this.pushWaiting;
                                throw throwable;
                            }
                        }
                    } else {
                        exit = true;
                    }
                }
            } while (!exit);
            WaitQueue waitQueue = this;
            synchronized (waitQueue) {
                --this.pushWillWait;
            }
            if (localExc != null) {
                throw localExc;
            }
        }
        return result;
    }

    public int getWaitingDequeueThreadsCount() {
        WaitQueue waitQueue = this;
        synchronized (waitQueue) {
            int n = this.popWaiting;
            return n;
        }
    }

    public int getWaitingEnqueueThreadsCount() {
        Object object = this.pushMonitor;
        synchronized (object) {
            int n = this.pushWaiting;
            return n;
        }
    }

    public int size() {
        WaitQueue waitQueue = this;
        synchronized (waitQueue) {
            int n = super.size();
            return n;
        }
    }
}

