/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.Deque;

public class WaitDeque
extends Deque {
    private transient int waitPush = 0;
    private transient int waitPop = 0;

    public WaitDeque() {
    }

    public WaitDeque(int limit) {
        super(limit);
    }

    public synchronized boolean pushLeft(Object item) {
        boolean result;
        while (!(result = this.addFirst(item) != null)) {
            Object var5_3;
            ++this.waitPush;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var5_3 = null;
                    --this.waitPush;
                    break;
                }
                var5_3 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                var5_3 = null;
                --this.waitPush;
                throw throwable;
            }
        }
        if (this.waitPop > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized boolean pushLeft(Object item, long timeout) throws InterruptedException {
        boolean result;
        long lastTime = System.currentTimeMillis();
        while (!(result = this.addFirst(item) != null && (timeout -= System.currentTimeMillis() - lastTime) > 0L)) {
            Object var8_5;
            ++this.waitPush;
            try {
                lastTime = System.currentTimeMillis();
                this.wait(timeout);
                var8_5 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                var8_5 = null;
                --this.waitPush;
                throw throwable;
            }
        }
        if (this.waitPop > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized Object popLeft() {
        Object result;
        while ((result = this.removeFirst()) == null) {
            Object var4_2;
            ++this.waitPop;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var4_2 = null;
                    --this.waitPop;
                    break;
                }
                var4_2 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitPop;
                throw throwable;
            }
        }
        if (this.waitPush > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized Object popLeft(long timeout) throws InterruptedException {
        Object result;
        long lastTime = System.currentTimeMillis();
        while ((result = this.removeFirst()) == null && (timeout -= System.currentTimeMillis() - lastTime) > 0L) {
            Object var7_4;
            ++this.waitPop;
            try {
                lastTime = System.currentTimeMillis();
                this.wait(timeout);
                var7_4 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                var7_4 = null;
                --this.waitPop;
                throw throwable;
            }
        }
        if (this.waitPush > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized Object topLeft() {
        Object result;
        while ((result = this.getFirst()) == null) {
            Object var4_2;
            ++this.waitPop;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var4_2 = null;
                    --this.waitPop;
                    break;
                }
                var4_2 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitPop;
                throw throwable;
            }
        }
        return result;
    }

    public synchronized Object topLeft(long timeout) throws InterruptedException {
        long lastTime = System.currentTimeMillis();
        Object result = this.getFirst();
        if (result == null && (timeout -= System.currentTimeMillis() - lastTime) > 0L) {
            ++this.waitPop;
            try {
                lastTime = System.currentTimeMillis();
                this.wait(timeout);
                Object var7_3 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                Object var7_4 = null;
                --this.waitPop;
                throw throwable;
            }
            return this.getFirst();
        }
        return result;
    }

    public synchronized boolean pushRight(Object item) {
        boolean result;
        while (!(result = this.addLast(item) != null)) {
            Object var5_3;
            ++this.waitPush;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var5_3 = null;
                    --this.waitPush;
                    break;
                }
                var5_3 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                var5_3 = null;
                --this.waitPush;
                throw throwable;
            }
        }
        if (this.waitPop > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized boolean pushRight(Object item, long timeout) throws InterruptedException {
        boolean result;
        long lastTime = System.currentTimeMillis();
        while (!(result = this.addLast(item) != null) && (timeout -= System.currentTimeMillis() - lastTime) > 0L) {
            Object var8_5;
            ++this.waitPush;
            try {
                lastTime = System.currentTimeMillis();
                this.wait(timeout);
                var8_5 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                var8_5 = null;
                --this.waitPush;
                throw throwable;
            }
        }
        if (this.waitPop > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized Object popRight() {
        Object result;
        while ((result = this.removeLast()) == null) {
            Object var4_2;
            ++this.waitPop;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var4_2 = null;
                    --this.waitPop;
                    break;
                }
                var4_2 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitPop;
                throw throwable;
            }
        }
        if (this.waitPush > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized Object popRight(long timeout) throws InterruptedException {
        Object result;
        long lastTime = System.currentTimeMillis();
        while ((result = this.removeLast()) == null && (timeout -= System.currentTimeMillis() - lastTime) > 0L) {
            Object var7_4;
            ++this.waitPop;
            try {
                lastTime = System.currentTimeMillis();
                this.wait(timeout);
                var7_4 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                var7_4 = null;
                --this.waitPop;
                throw throwable;
            }
        }
        if (this.waitPush > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized Object topRight() {
        Object result;
        while ((result = this.getLast()) == null) {
            Object var4_2;
            ++this.waitPop;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var4_2 = null;
                    --this.waitPop;
                    break;
                }
                var4_2 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitPop;
                throw throwable;
            }
        }
        return result;
    }

    public synchronized Object topRight(long timeout) throws InterruptedException {
        Object result;
        long lastTime = System.currentTimeMillis();
        while ((result = this.getLast()) == null && (timeout -= System.currentTimeMillis() - lastTime) > 0L) {
            Object var7_4;
            ++this.waitPop;
            try {
                lastTime = System.currentTimeMillis();
                this.wait(timeout);
                var7_4 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                var7_4 = null;
                --this.waitPop;
                throw throwable;
            }
        }
        return result;
    }
}

