/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.EnumerationLong;
import com.sap.engine.lib.util.LongHashHolder;
import com.sap.engine.lib.util.LongHashHolderImpl;
import com.sap.engine.lib.util.PrimeGenerator;
import com.sap.engine.lib.util.PrimitiveTypeDataStructure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;

public class SetLong
extends PrimitiveTypeDataStructure {
    static final long serialVersionUID = -7045169532835870108L;
    public static final float LOAD_FACTOR = 0.75f;
    public static final int INITIAL_CAPACITY = 13;
    public static final int GROW_STEP = 2;
    protected static final int LAST = -1;
    protected int growStep;
    protected int growSimpl;
    protected float loadFactor;
    protected LongHashHolder hasher;
    protected int simplIndex;
    protected int limit;
    protected int capacity;
    protected transient int nextFree;
    protected transient long[] keys;
    protected transient int[] nextPtr;

    public SetLong() {
        this(13, 2, 0.75f, new LongHashHolderImpl());
    }

    public SetLong(int initialCapacity) {
        this(initialCapacity, 2, 0.75f, new LongHashHolderImpl());
    }

    public SetLong(int initialCapacity, int growStep, float loadFactor, LongHashHolder hasher) {
        if ((double)loadFactor > 1.0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Load Factor = " + loadFactor);
        }
        if (growStep <= 1) {
            throw new IllegalArgumentException("Grow step = " + growStep);
        }
        this.growStep = growStep;
        this.growSimpl = growStep == 2 ? 4 : (growStep < 10 ? growStep + 4 : 13);
        this.loadFactor = loadFactor;
        this.hasher = hasher;
        this.simplIndex = 0;
        this.init(initialCapacity);
    }

    public EnumerationLong elements() {
        return new EnumerationLong(){
            private int i = 0;
            private int pos;
            private int counter;
            {
                this.pos = SetLong.this.nextPtr[this.i];
                this.counter = 0;
            }

            public boolean hasMoreElements() {
                return this.counter < SetLong.this.count;
            }

            public long nextElement() {
                while (this.i < SetLong.this.capacity) {
                    if (this.pos != -1) {
                        long result = SetLong.this.keys[this.pos - SetLong.this.capacity];
                        this.pos = SetLong.this.nextPtr[this.pos];
                        ++this.counter;
                        return result;
                    }
                    this.pos = SetLong.this.nextPtr[++this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public long[] toArray() {
        int index = 0;
        long[] result = new long[this.count];
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                result[index++] = this.keys[pos - this.capacity];
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return result;
    }

    public boolean contains(long key) {
        int pos = this.nextPtr[this.hasher.hash(key) % this.capacity];
        while (pos != -1) {
            if (this.keys[pos - this.capacity] == key) {
                return true;
            }
            pos = this.nextPtr[pos];
        }
        return false;
    }

    public void clear() {
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.nextFree = this.capacity;
        this.count = 0;
    }

    public Object clone() {
        SetLong result = (SetLong)super.clone();
        result.keys = new long[this.keys.length];
        result.nextPtr = new int[this.nextPtr.length];
        System.arraycopy(this.nextPtr, 0, result.nextPtr, 0, this.nextPtr.length);
        System.arraycopy(this.keys, 0, result.keys, 0, this.keys.length);
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SetLong)) {
            return false;
        }
        SetLong t = (SetLong)object;
        if (t.count != this.count) {
            return false;
        }
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                if (!t.contains(this.keys[pos - this.capacity])) {
                    return false;
                }
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void shrink() {
        this.shrink(0.75f);
    }

    public void shrink(float shrinkFactor) {
        if (shrinkFactor <= 0.0f || (double)shrinkFactor > 1.0) {
            throw new IllegalArgumentException("Shrink Factor = " + shrinkFactor);
        }
        int newCapacity = (int)((float)this.count / (this.loadFactor * shrinkFactor));
        long l = PrimeGenerator.getClosestPrime(newCapacity);
        this.simplIndex = (int)(l >> 32);
        newCapacity = (int)l;
        if (newCapacity < this.capacity) {
            int oldCapacity = this.capacity;
            int[] oldPtr = this.nextPtr;
            long[] oldKeys = this.keys;
            this.init(newCapacity);
            int i = 0;
            while (i < oldCapacity) {
                int pos = oldPtr[i];
                while (pos != -1) {
                    this.putQuick(oldKeys[pos - oldCapacity]);
                    pos = oldPtr[pos];
                }
                ++i;
            }
        }
    }

    public boolean add(long key) {
        if (this.count == this.limit) {
            this.rehash();
        }
        int pos = this.hasher.hash(key) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            if (this.keys[(pos = this.nextPtr[pos]) - this.capacity] != key) continue;
            return false;
        }
        this.nextPtr[pos] = this.nextFree;
        this.keys[this.nextFree - this.capacity] = key;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
        return true;
    }

    protected void putQuick(long key) {
        int pos = this.hasher.hash(key) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            pos = this.nextPtr[pos];
        }
        this.nextPtr[pos] = this.nextFree;
        this.keys[this.nextFree - this.capacity] = key;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
    }

    public boolean remove(long key) {
        int prevPos = this.hasher.hash(key) % this.capacity;
        int pos = this.nextPtr[prevPos];
        while (pos != -1) {
            if (this.keys[pos - this.capacity] == key) {
                this.nextPtr[prevPos] = this.nextPtr[pos];
                this.nextPtr[pos] = this.nextFree;
                this.nextFree = pos;
                --this.count;
                return true;
            }
            prevPos = pos;
            pos = this.nextPtr[pos];
        }
        return false;
    }

    protected void init(int initialCapacity) {
        if (this.growStep > 17) {
            this.capacity = (int)PrimeGenerator.getClosestPrime(initialCapacity);
        } else {
            long l = PrimeGenerator.getClosestPrime(initialCapacity, this.simplIndex);
            this.simplIndex = (int)(l >> 32) + this.growSimpl;
            this.capacity = (int)l;
        }
        this.limit = (int)((float)this.capacity * this.loadFactor);
        this.nextPtr = new int[this.capacity + this.limit];
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new long[this.limit];
        this.nextFree = this.capacity;
        this.count = 0;
    }

    protected void rehash() {
        long[] oldKeys = this.keys;
        this.init(this.capacity * this.growStep);
        int i = 0;
        while (i < oldKeys.length) {
            this.putQuick(oldKeys[i]);
            ++i;
        }
    }

    public String toString() {
        int c = 0;
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                buf.append(this.keys[pos - this.capacity]);
                if (++c < this.count) {
                    buf.append(", ");
                }
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public void setHasher(LongHashHolder hasher) {
        this.hasher = hasher;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                stream.writeLong(this.keys[pos - this.capacity]);
                pos = this.nextPtr[pos];
            }
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.nextPtr = new int[this.capacity + this.limit];
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new long[this.limit];
        this.nextFree = this.capacity;
        int size = this.count;
        this.count = 0;
        int i3 = 0;
        while (i3 < size) {
            this.putQuick(stream.readLong());
            ++i3;
        }
    }
}

