/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class PriorityQueue
implements Serializable {
    private transient long[] priorities;
    private transient Object[] items;
    private int itemsCounter;
    private int MAX_SIZE;
    private byte trigger;

    public PriorityQueue() {
        this(-1, Integer.MAX_VALUE);
    }

    public PriorityQueue(int capacity) {
        this(capacity, Integer.MAX_VALUE);
    }

    public PriorityQueue(int capacity, int maxSize) throws IllegalArgumentException {
        this.MAX_SIZE = maxSize < 0 ? Integer.MAX_VALUE : maxSize;
        if (this.MAX_SIZE < capacity || this.MAX_SIZE == 0) {
            throw new IllegalArgumentException();
        }
        if (capacity < 0) {
            capacity = this.MAX_SIZE < 10 ? this.MAX_SIZE : 10;
        }
        this.trigger = 0;
        this.itemsCounter = 0;
        this.priorities = new long[capacity];
        this.items = new Object[capacity];
    }

    public Object inspect() {
        if (this.isEmpty()) {
            return null;
        }
        return this.items[0];
    }

    public boolean isEmpty() {
        return this.itemsCounter == 0;
    }

    public boolean isFull() {
        return this.itemsCounter == this.MAX_SIZE;
    }

    public synchronized Object serve() throws IllegalStateException {
        if (this.isEmpty()) {
            throw new IllegalStateException("The Queue is empty.");
        }
        Object theHead = this.items[0];
        --this.itemsCounter;
        int hole = 0;
        int child = 2;
        while (child < this.itemsCounter) {
            if (this.priorities[child] < this.priorities[--child]) {
                ++child;
            }
            if (this.priorities[this.itemsCounter] <= this.priorities[child]) break;
            this.items[hole] = this.items[child];
            this.priorities[hole] = this.priorities[child];
            hole = child++;
            child *= 2;
        }
        if (child == this.itemsCounter && this.priorities[this.itemsCounter] > this.priorities[--child]) {
            this.items[hole] = this.items[child];
            this.priorities[hole] = this.priorities[child];
            hole = child;
        }
        this.items[hole] = this.items[this.itemsCounter];
        this.priorities[hole] = this.priorities[this.itemsCounter];
        this.items[this.itemsCounter] = null;
        this.trigger = (byte)(this.trigger + 1);
        this.trigger = (byte)(this.trigger % 5);
        if (this.trigger == 0) {
            try {
                this.setLength(this.itemsCounter);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return theHead;
    }

    public synchronized boolean enqueue(long priority, Object value) throws IllegalStateException, IOException {
        if (this.isFull()) {
            throw new IllegalStateException("The Queue is full.");
        }
        this.setLength(this.itemsCounter + 1);
        int hole = this.itemsCounter++;
        int parent = this.itemsCounter / 2;
        while (parent > 0) {
            if (priority >= this.priorities[--parent]) break;
            this.items[hole] = this.items[parent];
            this.priorities[hole] = this.priorities[parent];
            hole = parent++;
            parent /= 2;
        }
        this.items[hole] = value;
        this.priorities[hole] = priority;
        return hole == 0;
    }

    private synchronized void setLength(int newLength) throws IOException {
        try {
            if (newLength < this.priorities.length / 2) {
                long[] newPriorities = new long[newLength];
                Object[] newItems = new Object[newLength];
                System.arraycopy(this.priorities, 0, newPriorities, 0, newLength);
                System.arraycopy(this.items, 0, newItems, 0, newLength);
                this.priorities = newPriorities;
                this.items = newItems;
            }
            if (newLength > this.priorities.length) {
                int newCapacity = this.priorities.length;
                if (newLength > (newCapacity = (int)((double)newCapacity * 1.75))) {
                    newCapacity = newLength;
                }
                if (newCapacity > this.MAX_SIZE) {
                    newCapacity = this.MAX_SIZE;
                }
                long[] newPriorities = new long[newCapacity];
                Object[] newItems = new Object[newCapacity];
                System.arraycopy(this.priorities, 0, newPriorities, 0, this.priorities.length);
                System.arraycopy(this.items, 0, newItems, 0, this.priorities.length);
                this.priorities = newPriorities;
                this.items = newItems;
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.priorities.length);
        int i = 0;
        while (i < this.itemsCounter) {
            s.writeLong(this.priorities[i]);
            s.writeObject(this.items[i]);
            ++i;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.items = new Object[arrayLength];
        this.priorities = new long[arrayLength];
        int i = 0;
        while (i < this.itemsCounter) {
            this.priorities[i] = s.readLong();
            this.items[i] = s.readObject();
            ++i;
        }
    }
}

