/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.NextItemPointer;
import com.sap.engine.lib.util.PoolInstanceCreator;
import com.sap.engine.lib.util.PoolObject;
import com.sap.engine.lib.util.RootDataStructure;
import com.sap.engine.lib.util.base.BaseLinkedList;
import com.sap.engine.lib.util.base.NextItem;
import com.sap.engine.lib.util.base.Pointer;
import com.sap.engine.lib.util.iterators.ArrayEnumeration;
import com.sap.engine.lib.util.iterators.IteratorException;
import com.sap.engine.lib.util.iterators.RootIterator;
import com.sap.engine.lib.util.iterators.SnapShotEnumeration;

public class LinkedList
extends BaseLinkedList
implements PoolInstanceCreator {
    protected transient PoolObject pool;

    public LinkedList() {
        this(0);
    }

    public LinkedList(int limit) {
        super(limit);
    }

    public void setPool(PoolObject pool) {
        this.pool = pool;
    }

    public PoolObject getPool() {
        return this.pool;
    }

    public Object newInstance() {
        return new NextItemPointer();
    }

    protected NextItemPointer getNextItemPointer(Object value) {
        if (this.pool == null) {
            return new NextItemPointer(value);
        }
        NextItemPointer wrapper = (NextItemPointer)this.pool.getObject();
        wrapper.value = value;
        return wrapper;
    }

    protected void releaseNextItemPointer(NextItemPointer wrapper) {
        if (this.pool != null) {
            wrapper.value = null;
            this.pool.releaseObject(wrapper);
        }
    }

    public NextItemPointer add(int index, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.count >= this.limit || index > this.count || index < 0) {
            return null;
        }
        NextItemPointer wrapper = this.getNextItemPointer(value);
        this.add_(index, wrapper);
        return wrapper;
    }

    public NextItemPointer addFirst(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.count >= this.limit) {
            return null;
        }
        NextItemPointer wrapper = this.getNextItemPointer(value);
        this.addFirst_(wrapper);
        return wrapper;
    }

    public NextItemPointer add(Object value) {
        return this.addLast(value);
    }

    public NextItemPointer addLast(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.count >= this.limit) {
            return null;
        }
        NextItemPointer wrapper = this.getNextItemPointer(value);
        this.addLast_(wrapper);
        return wrapper;
    }

    public Object remove(int index) {
        NextItemPointer wrapper = (NextItemPointer)this.removeItem(index);
        if (wrapper == null) {
            return null;
        }
        Object result = wrapper.value;
        this.releaseNextItemPointer(wrapper);
        return result;
    }

    public Object remove(Object value) {
        if (this.count == 0) {
            return null;
        }
        NextItem old = null;
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (((NextItemPointer)temp).value.equals(value)) {
                if (old != null) {
                    old.setNext(temp.getNext());
                } else {
                    this.first = temp.getNext();
                }
                if (temp == this.last) {
                    this.last = old;
                }
                Object result = ((NextItemPointer)temp).value;
                temp.clearItem();
                --this.count;
                this.releaseNextItemPointer((NextItemPointer)temp);
                return result;
            }
            old = temp;
            temp = temp.getNext();
            ++i;
        }
        return null;
    }

    public int removeAll(Object value) {
        int deleted = 0;
        NextItem prev = null;
        NextItem next = null;
        NextItem temp = this.first;
        while (temp != null) {
            next = temp.getNext();
            if (((NextItemPointer)temp).value.equals(value)) {
                ++deleted;
                if (prev != null) {
                    prev.setNext(next);
                } else {
                    this.first = next;
                }
                temp.clearItem();
                this.releaseNextItemPointer((NextItemPointer)temp);
            } else {
                prev = temp;
            }
            temp = next;
        }
        this.last = prev;
        this.count -= deleted;
        return deleted;
    }

    public Object removeFirst() {
        NextItemPointer wrapper = (NextItemPointer)this.removeFirstItem();
        if (wrapper == null) {
            return null;
        }
        Object result = wrapper.value;
        this.releaseNextItemPointer(wrapper);
        return result;
    }

    public Object removeLast() {
        NextItemPointer wrapper = (NextItemPointer)this.removeLastItem();
        if (wrapper == null) {
            return null;
        }
        Object result = wrapper.value;
        this.releaseNextItemPointer(wrapper);
        return result;
    }

    public Object set(int index, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        NextItemPointer wrapper = (NextItemPointer)this.getItem(index);
        if (wrapper == null) {
            return null;
        }
        Object result = wrapper.value;
        wrapper.value = value;
        return result;
    }

    public void clear() {
        if (this.pool == null) {
            super.clear();
        } else {
            this.clear_();
        }
    }

    private void clear_() {
        NextItem eraser = this.first;
        while (eraser != null) {
            NextItem next = eraser.getNext();
            eraser.clearItem();
            ((NextItemPointer)eraser).value = null;
            this.pool.releaseObject(eraser);
            eraser = next;
        }
        super.clear();
    }

    public Object clone() {
        if (this.pool == null) {
            return super.clone();
        }
        return this.clone_();
    }

    private Object clone_() {
        LinkedList result = (LinkedList)this.getNewInstance();
        if (this.count == 0) {
            return result;
        }
        NextItem temp = this.first;
        NextItemPointer newFirst = (NextItemPointer)this.pool.getObject();
        newFirst.value = ((NextItemPointer)this.first).value;
        NextItemPointer newItem = newFirst;
        int i = 1;
        while (i < this.count) {
            temp = temp.getNext();
            NextItemPointer next = (NextItemPointer)this.pool.getObject();
            next.value = ((NextItemPointer)temp).value;
            newItem.setNext(next);
            newItem = next;
            ++i;
        }
        newItem.setNext(null);
        result.first = newFirst;
        result.last = newItem;
        return result;
    }

    public boolean contains(Object value) {
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (((NextItemPointer)temp).value.equals(value)) {
                return true;
            }
            temp = temp.getNext();
            ++i;
        }
        return false;
    }

    public Object get(Object value) {
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (((NextItemPointer)temp).value.equals(value)) {
                return ((NextItemPointer)temp).value;
            }
            temp = temp.getNext();
            ++i;
        }
        return null;
    }

    public Object get(int index) {
        NextItemPointer result = (NextItemPointer)this.getItem(index);
        return result == null ? null : result.value;
    }

    public Object getFirst() {
        return this.first == null ? null : ((NextItemPointer)this.first).value;
    }

    public Object getLast() {
        return this.last == null ? null : ((NextItemPointer)this.last).value;
    }

    public int indexOf(Object value) {
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (((NextItemPointer)temp).value.equals(value)) {
                return i;
            }
            temp = temp.getNext();
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object value) {
        NextItem temp = this.first;
        int lastIndex = -1;
        int i = 0;
        while (i < this.count) {
            if (((NextItemPointer)temp).value.equals(value)) {
                lastIndex = i;
            }
            temp = temp.getNext();
            ++i;
        }
        return lastIndex;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.count];
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            array[i] = ((NextItemPointer)temp).value;
            temp = temp.getNext();
            ++i;
        }
        return array;
    }

    public BaseLinkedList sublist(int index) {
        if (this.pool == null) {
            return super.sublist(index);
        }
        return this.sublist_(index);
    }

    private BaseLinkedList sublist_(int index) {
        if (index <= 0) {
            return (LinkedList)this.clone_();
        }
        LinkedList result = (LinkedList)this.getNewInstance();
        if (index >= this.count) {
            result.init(null, null, 0);
            return result;
        }
        NextItem temp = this.first;
        int i = 0;
        while (i < index) {
            temp = temp.getNext();
            ++i;
        }
        NextItemPointer newFirst = (NextItemPointer)this.pool.getObject();
        newFirst.value = ((NextItemPointer)temp).value;
        NextItemPointer newItem = newFirst;
        int i2 = index + 1;
        while (i2 < this.count) {
            temp = temp.getNext();
            NextItemPointer next = (NextItemPointer)this.pool.getObject();
            next.value = ((NextItemPointer)temp).value;
            newItem.setNext(next);
            newItem = next;
            ++i2;
        }
        newItem.setNext(null);
        result.init(newFirst, newItem, this.count - index);
        return result;
    }

    public BaseLinkedList sublist(int lowerBoundary, int upperBoundary) {
        if (this.pool == null) {
            return super.sublist(lowerBoundary, upperBoundary);
        }
        if (upperBoundary >= this.count) {
            upperBoundary = this.count - 1;
        }
        if (lowerBoundary < 0) {
            lowerBoundary = 0;
        }
        if (upperBoundary == this.count - 1) {
            return this.sublist_(lowerBoundary);
        }
        LinkedList result = (LinkedList)this.getNewInstance();
        if (lowerBoundary > upperBoundary) {
            result.init(null, null, 0);
            return result;
        }
        NextItem temp = this.first;
        int i = 0;
        while (i < lowerBoundary) {
            temp = temp.getNext();
            ++i;
        }
        NextItemPointer newFirst = (NextItemPointer)this.pool.getObject();
        newFirst.value = ((NextItemPointer)temp).value;
        NextItem newItem = newFirst;
        int i2 = lowerBoundary;
        while (i2 < upperBoundary) {
            temp = temp.getNext();
            newItem.setNext(this.getNextItemPointer(((NextItemPointer)temp).value));
            newItem = newItem.getNext();
            ++i2;
        }
        newItem.setNext(null);
        result.init(newFirst, newItem, upperBoundary - lowerBoundary + 1);
        return result;
    }

    public SnapShotEnumeration elementsEnumeration() {
        return new ArrayEnumeration(this.toArray());
    }

    public boolean removeSublist(int index) {
        if (this.pool == null) {
            return super.removeSublist(index);
        }
        if (index >= this.count || this.count == 0) {
            return false;
        }
        if (index <= 0) {
            this.clear_();
        } else {
            NextItem temp = this.first;
            int i = 1;
            while (i < index) {
                ++i;
                temp = temp.getNext();
            }
            NextItem eraser = temp.getNext();
            temp.setNext(null);
            this.last = temp;
            this.count = index;
            while (eraser != null) {
                NextItem next = eraser.getNext();
                eraser.clearItem();
                ((NextItemPointer)eraser).value = null;
                this.pool.releaseObject(eraser);
                eraser = next;
            }
        }
        return true;
    }

    public boolean removeRange(int lowerBoundary, int upperBoundary) {
        if (this.pool == null) {
            return super.removeRange(lowerBoundary, upperBoundary);
        }
        if (upperBoundary >= this.count) {
            upperBoundary = this.count - 1;
        }
        if (lowerBoundary < 0) {
            lowerBoundary = 0;
        }
        if (lowerBoundary > upperBoundary || lowerBoundary >= this.count) {
            return false;
        }
        int dif = upperBoundary - lowerBoundary;
        if (lowerBoundary == 0) {
            NextItem temp = this.first;
            NextItem next = null;
            int i = 0;
            while (i <= upperBoundary) {
                next = temp.getNext();
                temp.clearItem();
                ((NextItemPointer)temp).value = null;
                this.pool.releaseObject(temp);
                ++i;
                temp = next;
            }
            this.first = next;
            if (this.first == null) {
                this.last = null;
            }
        } else {
            NextItem old = this.first;
            int i = 1;
            while (i < lowerBoundary) {
                old = old.getNext();
                ++i;
            }
            NextItem temp = old.getNext();
            NextItem next = null;
            int i2 = 0;
            while (i2 <= dif) {
                next = temp.getNext();
                temp.clearItem();
                ((NextItemPointer)temp).value = null;
                this.pool.releaseObject(temp);
                ++i2;
                temp = next;
            }
            old.setNext(next);
            if (next == null) {
                this.last = old;
            }
        }
        this.count -= dif + 1;
        return true;
    }

    public NextItemPointer addAfterPointer(NextItem index, Object value) {
        if (this.count >= this.limit) {
            return null;
        }
        NextItemPointer item = this.getNextItemPointer(value);
        NextItem next = index.getNext();
        item.setNext(next);
        if (next == null) {
            this.last = item;
        }
        index.setNext(item);
        ++this.count;
        return item;
    }

    public void removeAfter(NextItem index) {
        NextItem target = index.getNext();
        if (target != null) {
            NextItem next = target.getNext();
            index.setNext(next);
            if (next == null) {
                this.last = index;
            }
            target.clearItem();
            this.releaseNextItemPointer((NextItemPointer)target);
            --this.count;
        }
    }

    public void removeRange(NextItem start, NextItem end) {
        NextItem next;
        if (this.pool == null) {
            super.removeRange(start, end);
            return;
        }
        int counter = 1;
        NextItem temp = next = start.getNext();
        while (temp != end) {
            next = temp.getNext();
            temp.clearItem();
            ((NextItemPointer)temp).value = null;
            this.pool.releaseObject(temp);
            temp = next;
            ++counter;
        }
        end = end.getNext();
        start.setNext(end);
        if (end == null) {
            this.last = start;
        }
        next.clearItem();
        this.releaseNextItemPointer((NextItemPointer)next);
        this.count -= counter;
    }

    public Pointer[] toPointerArray() {
        Pointer[] array = new NextItemPointer[this.count];
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            array[i] = (NextItemPointer)temp;
            temp = temp.getNext();
            ++i;
        }
        return array;
    }

    public RootIterator elementsIterator() {
        return new LinkedListIterator();
    }

    protected Object iterChange(Object obj, NextItem pointer, NextItem end) {
        if (obj == null) {
            throw new IteratorException("An illegal attempt to change a value to null!");
        }
        if (pointer == end.getNext()) {
            throw new IteratorException("End of Iterator reached!");
        }
        NextItemPointer wrapper = (NextItemPointer)pointer;
        Object tmp = wrapper.value;
        wrapper.value = obj;
        return tmp;
    }

    protected class LinkedListIterator
    extends BaseLinkedList.BaseLinkedListIterator {
        protected LinkedListIterator() {
        }

        public Object get() {
            return ((NextItemPointer)super.get()).value;
        }

        public RootDataStructure getDataStructure() {
            return LinkedList.this;
        }

        public Object next() {
            return ((NextItemPointer)super.next()).value;
        }

        public Object next(int n) {
            return ((NextItemPointer)super.next((int)n)).value;
        }

        public void setStartFromIterator(RootIterator iterator) {
            LinkedListIterator lli = (LinkedListIterator)iterator;
            if (LinkedList.this != lli.getDataStructure()) {
                throw new IteratorException("An attempt to set start from an Iterator over a different LinkedList instance!");
            }
            NextItem newPointer = lli.pointer;
            if (newPointer == null) {
                throw new IteratorException("Illegal argument: pointer == null");
            }
            this.pointer = this.start = newPointer;
            this.beforePointer = lli.beforePointer;
        }

        public void setEndFromIterator(RootIterator iterator) {
            LinkedListIterator lli = (LinkedListIterator)iterator;
            if (LinkedList.this != lli.getDataStructure()) {
                throw new IteratorException("An attempt to set end from an Iterator over a different LinkedList instance!");
            }
            NextItem newPointer = lli.beforePointer;
            if (this.pointer == null) {
                throw new IteratorException("End of Iterator reached!");
            }
            if (newPointer == null) {
                throw new IteratorException("An attempt to set the end from an exhausted Iterator!");
            }
            this.end = newPointer;
        }

        public Object add(Object obj) {
            NextItemPointer wrapper = LinkedList.this.getNextItemPointer(obj);
            return ((NextItemPointer)super.add((Object)wrapper)).value;
        }

        public Object change(Object obj) {
            return LinkedList.this.iterChange(obj, this.pointer, this.end);
        }

        public Object remove() {
            NextItemPointer tmp = (NextItemPointer)super.remove();
            Object res = tmp.value;
            LinkedList.this.releaseNextItemPointer(tmp);
            return res;
        }

        public Object insert(Object obj) {
            NextItemPointer wrapper = LinkedList.this.getNextItemPointer(obj);
            return ((NextItemPointer)super.insert((Object)wrapper)).value;
        }
    }
}

