/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.base.ListPool;
import com.sap.engine.lib.util.base.NextItem;

public abstract class LimitedWaitListPool
extends ListPool {
    protected int inUse;
    protected int useLimit;

    public LimitedWaitListPool() {
        this(0, 0, 0);
    }

    public LimitedWaitListPool(int useLimit) {
        this(0, 0, useLimit);
    }

    public LimitedWaitListPool(int initialSize, int useLimit) {
        this(initialSize, 0, useLimit);
    }

    public LimitedWaitListPool(int initialSize, int limit, int useLimit) {
        super(initialSize, limit);
        this.useLimit = useLimit;
        this.inUse = 0;
    }

    public synchronized NextItem getObject() {
        NextItem result = null;
        while ((result = this.removeFirstItem()) == null) {
            if (this.useLimit <= 0 || this.inUse < this.useLimit) {
                result = this.newInstance();
                break;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        ++this.inUse;
        return result;
    }

    public synchronized Object getObject(long timeout) {
        NextItem result;
        long lastTime = System.currentTimeMillis();
        while ((result = this.removeFirstItem()) == null && (timeout -= System.currentTimeMillis() - lastTime) > 0L) {
            if (this.useLimit <= 0 || this.inUse < this.useLimit) {
                result = this.newInstance();
                break;
            }
            lastTime = System.currentTimeMillis();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        if (result != null) {
            ++this.inUse;
        }
        return result;
    }

    public synchronized void releaseObject(NextItem item) {
        this.addFirstItem(item);
        --this.inUse;
        if (this.inUse == this.useLimit - 1) {
            this.notifyAll();
        }
    }

    public synchronized int itemsInUseCount() {
        return this.inUse;
    }

    public String toString() {
        int _useLimit;
        int _inUse;
        int _limit;
        int _count;
        StringBuffer buffer = new StringBuffer();
        LimitedWaitListPool limitedWaitListPool = this;
        synchronized (limitedWaitListPool) {
            _count = this.count;
            _limit = this.limit;
            _inUse = this.inUse;
            _useLimit = this.useLimit;
        }
        buffer.append(this.getClass().getName());
        buffer.append("@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append("[count=");
        buffer.append(_count);
        buffer.append(",limit=");
        buffer.append(_limit);
        buffer.append(",inUse=");
        buffer.append(_inUse);
        buffer.append(",useLimit=");
        buffer.append(_useLimit);
        buffer.append("]");
        return buffer.toString();
    }
}

