/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.Set;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class LRUSet
extends Set {
    static final long serialVersionUID = -1325998530097046225L;
    private LRUQueue queue = null;

    public LRUSet(int maxSize) {
        this.queue = new LRUQueue(maxSize);
    }

    public LRUSet(int initialCapacity, int maxSize) {
        super(initialCapacity);
        this.queue = new LRUQueue(maxSize);
    }

    public boolean add(Object obj) {
        SetItem si = new SetItem();
        si.data = obj;
        SetItem removed = this.queue.add(si);
        if (removed != null) {
            super.remove(removed.data);
        }
        return super.add(si);
    }

    public boolean contains(Object obj) {
        SetItem getted = (SetItem)this.get(obj);
        if (getted != null) {
            this.queue.update(getted);
            return true;
        }
        return false;
    }

    public boolean remove(Object obj) {
        SetItem getted = (SetItem)this.get(obj);
        if (getted != null) {
            return super.remove(getted);
        }
        return false;
    }

    private Object get(Object obj) {
        int pos = this.nextPtr[this.hasher.hash(obj.hashCode()) % this.capacity];
        while (pos != -1) {
            if (this.keys[pos - this.capacity].equals(obj)) {
                return this.keys[pos - this.capacity];
            }
            pos = this.nextPtr[pos];
        }
        return null;
    }

    private void writeObject(ObjectOutputStream oos) throws NotSerializableException {
        try {
            oos.defaultWriteObject();
        }
        catch (IOException ioex) {
            throw new NotSerializableException("Cannot serialize class " + this.getClass().getName() + ". Error is " + ioex.toString());
        }
    }

    private void readObject(ObjectInputStream oos) throws NotSerializableException {
        try {
            oos.defaultReadObject();
        }
        catch (IOException ioex) {
            throw new NotSerializableException("Cannot deserialize class " + this.getClass().getName() + ". Error is " + ioex.toString());
        }
        catch (ClassNotFoundException cnfe) {
            throw new NotSerializableException("Cannot deserialize class " + this.getClass().getName() + ". Error is " + cnfe.toString());
        }
    }

    private class LRUQueue {
        protected static final int MIN_SIZE_DEFAULT = 10;
        protected static final int MAX_SIZE_DEFAULT = 100;
        protected int maxSize;
        protected int minSize;
        protected int size;
        protected SetItem first;
        protected SetItem last;

        public LRUQueue() {
            this(10, 100);
        }

        public LRUQueue(int maxSize) {
            this(10, maxSize);
        }

        public LRUQueue(int minSize, int maxSize) {
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.size = 0;
            this.first = null;
            this.last = null;
        }

        public void update(SetItem node) {
            if (node != this.first) {
                if (this.last == node) {
                    this.first = this.last;
                    this.last = this.last.prev;
                } else {
                    node.prev.next = node.next;
                    node.next.prev = node.prev;
                    node.next = this.first;
                    node.prev = this.last;
                    this.first.prev = node;
                    this.last.next = node;
                    this.first = node;
                }
            }
        }

        public SetItem add(SetItem node) {
            SetItem removed = null;
            if (this.first == null) {
                this.size = 1;
                node.prev = node;
                node.next = node;
                this.first = node;
                this.last = node;
                return null;
            }
            if (this.size < this.maxSize) {
                ++this.size;
                node.next = this.first;
                node.prev = this.last;
                this.last.next = node;
                this.first.prev = node;
                this.first = node;
            } else {
                node.next = this.first;
                node.prev = this.last.prev;
                this.last.prev.next = node;
                this.first.prev = node;
                this.first = node;
                removed = this.last;
                this.last = this.last.prev;
            }
            return removed;
        }

        public boolean isFull() {
            return this.size >= this.maxSize;
        }

        public SetItem remove(SetItem node) {
            SetItem snode = node;
            --this.size;
            if (this.size > 0) {
                if (this.first == node) {
                    this.last.next = this.first = node.next;
                    node.prev.next = node.next;
                    node.next.prev = node.prev;
                } else if (this.last == node) {
                    this.first.prev = this.last = node.prev;
                    node.prev.next = node.next;
                    node.next.prev = node.prev;
                } else {
                    node.prev.next = node.next;
                    node.next.prev = node.prev;
                }
                node.next = null;
                node.prev = null;
            } else {
                this.first = null;
                this.last = null;
            }
            return snode;
        }

        public SetItem removeLast() {
            return this.remove(this.last);
        }

        public void print() {
            System.out.print("QUEUE ");
            System.out.print("(size:" + this.size + ")");
            if (this.first != null) {
                SetItem temp = this.first.next;
                while (temp != this.last) {
                    temp = temp.next;
                }
            } else {
                System.out.println("Queue empty.");
            }
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public int getMinSize() {
            return this.minSize;
        }

        public int getSize() {
            return this.size;
        }

        public void clear() {
            this.size = 0;
            this.first = null;
            this.last = null;
        }
    }

    private class SetItem {
        public SetItem prev;
        public SetItem next;
        public Object data;

        private SetItem() {
        }

        public boolean equals(Object obj) {
            return this.data.equals(obj);
        }

        public int hashCode() {
            return this.data.hashCode();
        }
    }
}

