/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.EnumerationByte;
import com.sap.engine.lib.util.IntHashHolder;
import com.sap.engine.lib.util.IntHashHolderImpl;
import com.sap.engine.lib.util.PrimeGenerator;
import com.sap.engine.lib.util.PrimitiveTypeDataStructure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class HashMapObjectByte
extends PrimitiveTypeDataStructure {
    static final long serialVersionUID = 4178458027921802042L;
    public static final float LOAD_FACTOR = 0.75f;
    public static final int INITIAL_CAPACITY = 13;
    public static final int GROW_STEP = 2;
    protected static final int LAST = -1;
    protected static final NoSuchElementException noSuchElementException = new NoSuchElementException("This is static exception, there is no stack trace available. It is thrown by get() method.");
    protected int growStep;
    protected int growSimpl;
    protected float loadFactor;
    protected IntHashHolder hasher;
    protected int simplIndex;
    protected int limit;
    protected int capacity;
    protected transient int nextFree;
    protected transient Object[] keys;
    protected transient byte[] elements;
    protected transient int[] nextPtr;

    public HashMapObjectByte() {
        this(13, 2, 0.75f, new IntHashHolderImpl());
    }

    public HashMapObjectByte(int initialCapacity) {
        this(initialCapacity, 2, 0.75f, new IntHashHolderImpl());
    }

    public HashMapObjectByte(int initialCapacity, int growStep, float loadFactor, IntHashHolder hasher) {
        if ((double)loadFactor > 1.0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Load Factor = " + loadFactor);
        }
        if (growStep <= 1) {
            throw new IllegalArgumentException("Grow step = " + growStep);
        }
        this.growStep = growStep;
        this.growSimpl = growStep == 2 ? 4 : (growStep < 10 ? growStep + 4 : 13);
        this.loadFactor = loadFactor;
        this.hasher = hasher;
        this.simplIndex = 0;
        this.init(initialCapacity);
    }

    public Enumeration keys() {
        return new Enumeration(){
            private int i;
            private int counter;
            {
                this.i = HashMapObjectByte.this.keys.length;
                this.counter = 0;
            }

            public boolean hasMoreElements() {
                return this.counter < HashMapObjectByte.this.count;
            }

            public Object nextElement() {
                while (--this.i >= 0) {
                    if (HashMapObjectByte.this.keys[this.i] == null) continue;
                    ++this.counter;
                    return HashMapObjectByte.this.keys[this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Object[] getAllKeys() {
        return this.getAllKeys(new Object[this.count], 0);
    }

    public Object[] getAllKeys(Object[] result, int index) {
        if (result.length - index < this.count) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), this.count);
            index = 0;
        }
        int i = this.keys.length;
        while (--i >= 0) {
            if (this.keys[i] == null) continue;
            result[index++] = this.keys[i];
        }
        return result;
    }

    public EnumerationByte elements() {
        return new EnumerationByte(){
            private int i;
            private int counter;
            {
                this.i = HashMapObjectByte.this.keys.length;
                this.counter = 0;
            }

            public boolean hasMoreElements() {
                return this.counter < HashMapObjectByte.this.count;
            }

            public byte nextElement() {
                while (--this.i >= 0) {
                    if (HashMapObjectByte.this.keys[this.i] == null) continue;
                    ++this.counter;
                    return HashMapObjectByte.this.elements[this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public byte[] getAllValues() {
        return this.getAllValues(new byte[this.count], 0);
    }

    public byte[] getAllValues(byte[] result, int index) {
        if (result.length - index < this.count) {
            result = new byte[this.count];
            index = 0;
        }
        int i = this.keys.length;
        while (--i >= 0) {
            if (this.keys[i] == null) continue;
            result[index++] = this.elements[i];
        }
        return result;
    }

    public boolean contains(byte value) {
        int i = this.capacity;
        while (--i >= 0) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                if (this.elements[pos - this.capacity] == value) {
                    return true;
                }
                pos = this.nextPtr[pos];
            }
        }
        return false;
    }

    public boolean containsValue(byte value) {
        return this.contains(value);
    }

    public boolean containsKey(Object key) {
        int pos = this.nextPtr[this.hasher.hash(key.hashCode()) % this.capacity];
        while (pos != -1) {
            if (this.keys[pos - this.capacity].equals(key)) {
                return true;
            }
            pos = this.nextPtr[pos];
        }
        return false;
    }

    public void clear() {
        int i = this.keys.length;
        while (--i >= 0) {
            this.nextPtr[i] = -1;
            this.keys[i] = null;
        }
        int i2 = this.keys.length;
        while (i2 < this.capacity) {
            this.nextPtr[i2] = -1;
            ++i2;
        }
        int i3 = this.capacity;
        while (i3 < this.nextPtr.length) {
            this.nextPtr[i3++] = i3;
        }
        this.nextFree = this.capacity;
        this.count = 0;
    }

    public Object clone() {
        HashMapObjectByte result = (HashMapObjectByte)super.clone();
        result.keys = new Object[this.keys.length];
        result.elements = new byte[this.elements.length];
        result.nextPtr = new int[this.nextPtr.length];
        System.arraycopy(this.nextPtr, 0, result.nextPtr, 0, this.nextPtr.length);
        System.arraycopy(this.keys, 0, result.keys, 0, this.keys.length);
        System.arraycopy(this.elements, 0, result.elements, 0, this.elements.length);
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HashMapObjectByte)) {
            return false;
        }
        HashMapObjectByte t = (HashMapObjectByte)object;
        if (t.count != this.count) {
            return false;
        }
        int i = 0;
        while (i < this.limit) {
            if (this.keys[i] != null) {
                try {
                    if (this.elements[i] != t.get(this.keys[i])) {
                        return false;
                    }
                }
                catch (NoSuchElementException _) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void shrink() {
        this.shrink(0.75f);
    }

    public void shrink(float shrinkFactor) {
        if (shrinkFactor <= 0.0f || (double)shrinkFactor > 1.0) {
            throw new IllegalArgumentException("Shrink Factor = " + shrinkFactor);
        }
        int newCapacity = (int)((float)this.count / (this.loadFactor * shrinkFactor));
        long l = PrimeGenerator.getClosestPrime(newCapacity);
        this.simplIndex = (int)(l >> 32);
        newCapacity = (int)l;
        if (newCapacity < this.capacity) {
            Object[] oldKeys = this.keys;
            byte[] oldElements = this.elements;
            this.init(newCapacity);
            int i = oldKeys.length;
            while (--i >= 0) {
                if (oldKeys[i] == null) continue;
                this.putQuick(oldKeys[i], oldElements[i]);
            }
        }
    }

    public boolean put(Object key, byte value) {
        int index;
        if (this.count == this.limit) {
            this.rehash();
        }
        int pos = this.hasher.hash(key.hashCode()) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            index = (pos = this.nextPtr[pos]) - this.capacity;
            if (!this.keys[index].equals(key)) continue;
            this.elements[index] = value;
            return true;
        }
        index = this.nextFree - this.capacity;
        this.nextPtr[pos] = this.nextFree;
        this.keys[index] = key;
        this.elements[index] = value;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
        return false;
    }

    protected void putQuick(Object key, byte value) {
        int pos = this.hasher.hash(key.hashCode()) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            pos = this.nextPtr[pos];
        }
        int index = this.nextFree - this.capacity;
        this.nextPtr[pos] = this.nextFree;
        this.keys[index] = key;
        this.elements[index] = value;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
    }

    public byte get(Object key) {
        int pos = this.nextPtr[this.hasher.hash(key.hashCode()) % this.capacity];
        while (pos != -1) {
            int index = pos - this.capacity;
            if (this.keys[index].equals(key)) {
                return this.elements[index];
            }
            pos = this.nextPtr[pos];
        }
        throw new NoSuchElementException("There is not a key " + key.toString() + " in the HashMapObjectByte structure.");
    }

    public boolean remove(Object key) {
        int prevPos = this.hasher.hash(key.hashCode()) % this.capacity;
        int pos = this.nextPtr[prevPos];
        while (pos != -1) {
            int index = pos - this.capacity;
            if (this.keys[index].equals(key)) {
                this.keys[index] = null;
                this.nextPtr[prevPos] = this.nextPtr[pos];
                this.nextPtr[pos] = this.nextFree;
                this.nextFree = pos;
                --this.count;
                return true;
            }
            prevPos = pos;
            pos = this.nextPtr[pos];
        }
        return false;
    }

    protected void init(int initialCapacity) {
        if (this.growStep > 17) {
            this.capacity = (int)PrimeGenerator.getClosestPrime(initialCapacity);
        } else {
            long l = PrimeGenerator.getClosestPrime(initialCapacity, this.simplIndex);
            this.simplIndex = (int)(l >> 32) + this.growSimpl;
            this.capacity = (int)l;
        }
        this.limit = (int)((float)this.capacity * this.loadFactor);
        this.nextPtr = new int[this.capacity + this.limit];
        int i = this.capacity;
        while (--i >= 0) {
            this.nextPtr[i] = -1;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new Object[this.limit];
        this.elements = new byte[this.limit];
        this.nextFree = this.capacity;
        this.count = 0;
    }

    protected void rehash() {
        Object[] oldKeys = this.keys;
        byte[] oldElements = this.elements;
        this.init(this.capacity * this.growStep);
        int i = oldKeys.length;
        while (--i >= 0) {
            this.putQuick(oldKeys[i], oldElements[i]);
        }
    }

    public String toString() {
        int c = 0;
        StringBuffer buf = new StringBuffer(4 * this.count + 1);
        buf.append("{");
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                int index = pos - this.capacity;
                buf.append(this.keys[index] + "=" + this.elements[index]);
                if (++c < this.count) {
                    buf.append(", ");
                }
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public void setHasher(IntHashHolder hasher) {
        this.hasher = hasher;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int i = this.keys.length;
        while (--i >= 0) {
            if (this.keys[i] == null) continue;
            stream.writeObject(this.keys[i]);
            stream.writeByte(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.nextPtr = new int[this.capacity + this.limit];
        int i = this.capacity;
        while (--i >= 0) {
            this.nextPtr[i] = -1;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new Object[this.limit];
        this.elements = new byte[this.limit];
        this.nextFree = this.capacity;
        int size = this.count;
        this.count = 0;
        int i3 = size;
        while (--i3 >= 0) {
            this.putQuick(stream.readObject(), stream.readByte());
        }
    }
}

