/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.EnumerationInt;
import com.sap.engine.lib.util.IntHashHolder;
import com.sap.engine.lib.util.IntHashHolderImpl;
import com.sap.engine.lib.util.PrimeGenerator;
import com.sap.engine.lib.util.PrimitiveTypeDataStructure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class HashMapIntObject
extends PrimitiveTypeDataStructure {
    static final long serialVersionUID = 2133400657572598967L;
    public static final float LOAD_FACTOR = 0.75f;
    public static final int INITIAL_CAPACITY = 13;
    public static final int GROW_STEP = 2;
    protected static final int LAST = -1;
    protected int growStep;
    protected int growSimpl;
    protected float loadFactor;
    protected IntHashHolder hasher;
    protected int simplIndex;
    protected int limit;
    protected int capacity;
    protected transient int nextFree;
    protected transient int[] keys;
    protected transient Object[] elements;
    protected transient int[] nextPtr;

    public HashMapIntObject() {
        this(13, 2, 0.75f, new IntHashHolderImpl());
    }

    public HashMapIntObject(int initialCapacity) {
        this(initialCapacity, 2, 0.75f, new IntHashHolderImpl());
    }

    public HashMapIntObject(int initialCapacity, int growStep, float loadFactor, IntHashHolder hasher) {
        if ((double)loadFactor > 1.0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Load Factor = " + loadFactor);
        }
        if (growStep <= 1) {
            throw new IllegalArgumentException("Grow step = " + growStep);
        }
        this.growStep = growStep;
        this.growSimpl = growStep == 2 ? 4 : (growStep < 10 ? growStep + 4 : 13);
        this.loadFactor = loadFactor;
        this.hasher = hasher;
        this.simplIndex = 0;
        this.init(initialCapacity);
    }

    public EnumerationInt keys() {
        return new EnumerationInt(){
            private int i = 0;
            private int pos;
            private int counter;
            {
                this.pos = HashMapIntObject.this.nextPtr[this.i];
                this.counter = 0;
            }

            public boolean hasMoreElements() {
                return this.counter < HashMapIntObject.this.count;
            }

            public int nextElement() {
                while (this.i < HashMapIntObject.this.capacity) {
                    if (this.pos != -1) {
                        int result = HashMapIntObject.this.keys[this.pos - HashMapIntObject.this.capacity];
                        this.pos = HashMapIntObject.this.nextPtr[this.pos];
                        ++this.counter;
                        return result;
                    }
                    this.pos = HashMapIntObject.this.nextPtr[++this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public int[] getAllKeys() {
        int index = 0;
        int[] result = new int[this.count];
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                result[index++] = this.keys[pos - this.capacity];
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return result;
    }

    public int[] getAllKeys(int[] result) {
        int index = 0;
        if (result.length < this.count) {
            result = new int[this.count];
        }
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                result[index++] = this.keys[pos - this.capacity];
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return result;
    }

    public Enumeration elements() {
        return new Enumeration(){
            private int i = 0;
            private int pos;
            private int counter;
            {
                this.pos = HashMapIntObject.this.nextPtr[this.i];
                this.counter = 0;
            }

            public boolean hasMoreElements() {
                return this.counter < HashMapIntObject.this.count;
            }

            public Object nextElement() {
                while (this.i < HashMapIntObject.this.capacity) {
                    if (this.pos != -1) {
                        Object result = HashMapIntObject.this.elements[this.pos - HashMapIntObject.this.capacity];
                        this.pos = HashMapIntObject.this.nextPtr[this.pos];
                        ++this.counter;
                        return result;
                    }
                    this.pos = HashMapIntObject.this.nextPtr[++this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Object[] getAllValues() {
        return this.getAllValues(new Object[this.count]);
    }

    public Object[] getAllValues(Object[] result) {
        int index = 0;
        if (result.length < this.count) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), this.count);
        }
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                result[index++] = this.elements[pos - this.capacity];
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return result;
    }

    public void copyAllValues(Object[] result) {
        int index = 0;
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                result[index++] = this.elements[pos - this.capacity];
                pos = this.nextPtr[pos];
            }
            ++i;
        }
    }

    public boolean contains(Object value) {
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                if (this.elements[pos - this.capacity].equals(value)) {
                    return true;
                }
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    public void clear() {
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        int i3 = 0;
        while (i3 < this.elements.length) {
            this.elements[i3] = null;
            ++i3;
        }
        this.nextFree = this.capacity;
        this.count = 0;
    }

    public Object clone() {
        HashMapIntObject result = (HashMapIntObject)super.clone();
        result.keys = new int[this.keys.length];
        result.elements = new Object[this.elements.length];
        result.nextPtr = new int[this.nextPtr.length];
        System.arraycopy(this.nextPtr, 0, result.nextPtr, 0, this.nextPtr.length);
        System.arraycopy(this.keys, 0, result.keys, 0, this.keys.length);
        System.arraycopy(this.elements, 0, result.elements, 0, this.elements.length);
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HashMapIntObject)) {
            return false;
        }
        HashMapIntObject t = (HashMapIntObject)object;
        if (t.count != this.count) {
            return false;
        }
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                int index = pos - this.capacity;
                Object temp = t.get(this.keys[index]);
                if (temp == null) {
                    return false;
                }
                if (!this.elements[index].equals(temp)) {
                    return false;
                }
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void shrink() {
        this.shrink(0.75f);
    }

    public void shrink(float shrinkFactor) {
        if (shrinkFactor <= 0.0f || (double)shrinkFactor > 1.0) {
            throw new IllegalArgumentException("Shrink Factor = " + shrinkFactor);
        }
        int newCapacity = (int)((float)this.count / (this.loadFactor * shrinkFactor));
        long l = PrimeGenerator.getClosestPrime(newCapacity);
        this.simplIndex = (int)(l >> 32);
        newCapacity = (int)l;
        if (newCapacity < this.capacity) {
            int oldCapacity = this.capacity;
            int[] oldPtr = this.nextPtr;
            int[] oldKeys = this.keys;
            Object[] oldElements = this.elements;
            this.init(newCapacity);
            int i = 0;
            while (i < oldCapacity) {
                int pos = oldPtr[i];
                while (pos != -1) {
                    int index = pos - oldCapacity;
                    this.putQuick(oldKeys[index], oldElements[index]);
                    pos = oldPtr[pos];
                }
                ++i;
            }
        }
    }

    public Object put(int key, Object value) {
        int index;
        if (value == null) {
            throw new NullPointerException("Value can not be null.");
        }
        if (this.count == this.limit) {
            this.rehash();
        }
        int pos = this.hasher.hash(key) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            index = (pos = this.nextPtr[pos]) - this.capacity;
            if (this.keys[index] != key) continue;
            Object temp = this.elements[index];
            this.elements[index] = value;
            return temp;
        }
        index = this.nextFree - this.capacity;
        this.nextPtr[pos] = this.nextFree;
        this.keys[index] = key;
        this.elements[index] = value;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
        return null;
    }

    protected void putQuick(int key, Object value) {
        int pos = this.hasher.hash(key) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            pos = this.nextPtr[pos];
        }
        int index = this.nextFree - this.capacity;
        this.nextPtr[pos] = this.nextFree;
        this.keys[index] = key;
        this.elements[index] = value;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
    }

    public Object get(int key) {
        int pos = this.nextPtr[this.hasher.hash(key) % this.capacity];
        while (pos != -1) {
            int index = pos - this.capacity;
            if (this.keys[index] == key) {
                return this.elements[index];
            }
            pos = this.nextPtr[pos];
        }
        return null;
    }

    public Object remove(int key) {
        int prevPos = this.hasher.hash(key) % this.capacity;
        int pos = this.nextPtr[prevPos];
        while (pos != -1) {
            int index = pos - this.capacity;
            if (this.keys[index] == key) {
                Object result = this.elements[index];
                this.elements[index] = null;
                this.nextPtr[prevPos] = this.nextPtr[pos];
                this.nextPtr[pos] = this.nextFree;
                this.nextFree = pos;
                --this.count;
                return result;
            }
            prevPos = pos;
            pos = this.nextPtr[pos];
        }
        return null;
    }

    protected void init(int initialCapacity) {
        if (this.growStep > 17) {
            this.capacity = (int)PrimeGenerator.getClosestPrime(initialCapacity);
        } else {
            long l = PrimeGenerator.getClosestPrime(initialCapacity, this.simplIndex);
            this.simplIndex = (int)(l >> 32) + this.growSimpl;
            this.capacity = (int)l;
        }
        this.limit = (int)((float)this.capacity * this.loadFactor);
        this.nextPtr = new int[this.capacity + this.limit];
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new int[this.limit];
        this.elements = new Object[this.limit];
        this.nextFree = this.capacity;
        this.count = 0;
    }

    protected void rehash() {
        int[] oldKeys = this.keys;
        Object[] oldElements = this.elements;
        this.init(this.capacity * this.growStep);
        int i = 0;
        while (i < oldKeys.length) {
            this.putQuick(oldKeys[i], oldElements[i]);
            ++i;
        }
    }

    public String toString() {
        int c = 0;
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                int index = pos - this.capacity;
                buf.append(this.keys[index] + "=" + this.elements[index]);
                if (++c < this.count) {
                    buf.append(", ");
                }
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public void setHasher(IntHashHolder hasher) {
        this.hasher = hasher;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                int index = pos - this.capacity;
                stream.writeInt(this.keys[index]);
                stream.writeObject(this.elements[index]);
                pos = this.nextPtr[pos];
            }
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.nextPtr = new int[this.capacity + this.limit];
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new int[this.limit];
        this.elements = new Object[this.limit];
        this.nextFree = this.capacity;
        int size = this.count;
        this.count = 0;
        int i3 = 0;
        while (i3 < size) {
            this.putQuick(stream.readInt(), stream.readObject());
            ++i3;
        }
    }
}

