/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.LinearItemPointer;
import com.sap.engine.lib.util.PoolInstanceCreator;
import com.sap.engine.lib.util.PoolObject;
import com.sap.engine.lib.util.RootDataStructure;
import com.sap.engine.lib.util.base.BaseDoublyLinkedList;
import com.sap.engine.lib.util.base.Item;
import com.sap.engine.lib.util.base.LinearItem;
import com.sap.engine.lib.util.base.NextItem;
import com.sap.engine.lib.util.base.Pointer;
import com.sap.engine.lib.util.base.PrevItem;
import com.sap.engine.lib.util.iterators.ArrayEnumeration;
import com.sap.engine.lib.util.iterators.IteratorException;
import com.sap.engine.lib.util.iterators.RootIterator;
import com.sap.engine.lib.util.iterators.SnapShotEnumeration;

public class DoublyLinkedList
extends BaseDoublyLinkedList
implements PoolInstanceCreator {
    protected LinearItemPointer tmp = this.getLinearItemPointer(null);
    protected transient PoolObject pool;

    public DoublyLinkedList() {
        this(0);
    }

    public DoublyLinkedList(int limit) {
        super(limit);
    }

    public void setPool(PoolObject pool) {
        this.pool = pool;
    }

    public PoolObject getPool() {
        return this.pool;
    }

    public Object newInstance() {
        return new LinearItemPointer();
    }

    protected LinearItemPointer getLinearItemPointer(Object value) {
        if (this.pool == null) {
            return new LinearItemPointer(value);
        }
        LinearItemPointer wrapper = (LinearItemPointer)this.pool.getObject();
        wrapper.value = value;
        return wrapper;
    }

    protected void releaseLinearItemPointer(LinearItemPointer wrapper) {
        if (this.pool != null) {
            wrapper.value = null;
            this.pool.releaseObject(wrapper);
        }
    }

    public LinearItemPointer addFirst(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.count >= this.limit) {
            return null;
        }
        LinearItemPointer result = this.getLinearItemPointer(value);
        this.addFirst_(result);
        return result;
    }

    public LinearItemPointer add(Object value) {
        return this.addLast(value);
    }

    public LinearItemPointer addLast(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.count >= this.limit) {
            return null;
        }
        LinearItemPointer result = this.getLinearItemPointer(value);
        this.addLast_(result);
        return result;
    }

    public LinearItemPointer add(int index, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        LinearItemPointer result = this.getLinearItemPointer(value);
        if (this.addItem(index, result)) {
            return result;
        }
        this.releaseLinearItemPointer(result);
        return null;
    }

    public Object remove(int index) {
        LinearItemPointer wrapper = (LinearItemPointer)this.removeItem(index);
        if (wrapper == null) {
            return null;
        }
        Object result = wrapper.value;
        this.releaseLinearItemPointer(wrapper);
        return result;
    }

    public Object remove(Object value) {
        this.tmp.value = value;
        LinearItemPointer wrapper = (LinearItemPointer)this.removeItem(this.tmp);
        this.tmp.value = null;
        if (wrapper == null) {
            return null;
        }
        Object result = wrapper.value;
        this.releaseLinearItemPointer(wrapper);
        return result;
    }

    public int removeAll(Object value) {
        NextItem next;
        Item eraser;
        int deleted = 0;
        LinearItem prev = null;
        PrevItem start = null;
        NextItem temp = this.first;
        while (temp != null) {
            if (((LinearItemPointer)temp).value.equals(value)) {
                ++deleted;
                if (start == null) {
                    start = temp;
                }
            } else if (start != null) {
                prev = (LinearItem)start.getPrev();
                if (prev == null) {
                    this.first = temp;
                    this.first.setPrev(null);
                } else {
                    prev.setNext(temp);
                    temp.setPrev(prev);
                }
                eraser = start;
                while (eraser != temp) {
                    next = eraser.getNext();
                    eraser.clearItem();
                    this.releaseLinearItemPointer((LinearItemPointer)eraser);
                    eraser = next;
                }
                start = null;
            }
            temp = temp.getNext();
        }
        if (start != null) {
            this.last = (LinearItem)start.getPrev();
            if (this.last != null) {
                this.last.setNext(null);
            } else {
                this.first = null;
            }
            eraser = start;
            while (eraser != null) {
                next = eraser.getNext();
                eraser.clearItem();
                this.releaseLinearItemPointer((LinearItemPointer)eraser);
                eraser = next;
            }
        }
        this.count -= deleted;
        return deleted;
    }

    public Object removeFirst() {
        LinearItemPointer wrapper = (LinearItemPointer)this.removeFirstItem();
        if (wrapper == null) {
            return null;
        }
        Object result = wrapper.value;
        this.releaseLinearItemPointer(wrapper);
        return result;
    }

    public Object removeLast() {
        LinearItemPointer wrapper = (LinearItemPointer)this.removeLastItem();
        if (wrapper == null) {
            return null;
        }
        Object result = wrapper.value;
        this.releaseLinearItemPointer(wrapper);
        return result;
    }

    public Object set(int index, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        LinearItemPointer wrapper = (LinearItemPointer)this.getItem_(index);
        if (wrapper == null) {
            return null;
        }
        Object result = wrapper.value;
        wrapper.value = value;
        return result;
    }

    public void clear() {
        if (this.pool == null) {
            super.clear();
            return;
        }
        this.clear_();
    }

    private void clear_() {
        NextItem eraser = this.first;
        while (eraser != null) {
            NextItem next = eraser.getNext();
            eraser.clearItem();
            ((LinearItemPointer)eraser).value = null;
            this.pool.releaseObject(eraser);
            eraser = next;
        }
        super.clear();
    }

    public Object clone() {
        if (this.pool == null) {
            return super.clone();
        }
        return this.clone_();
    }

    private Object clone_() {
        DoublyLinkedList result = (DoublyLinkedList)this.getNewInstance();
        if (this.count == 0) {
            return result;
        }
        LinearItem temp = null;
        NextItem index = this.first;
        LinearItemPointer newFirst = (LinearItemPointer)this.pool.getObject();
        newFirst.value = ((LinearItemPointer)this.first).value;
        LinearItem newItem = newFirst;
        newFirst.setPrev(null);
        int i = 1;
        while (i < this.count) {
            index = index.getNext();
            temp = (LinearItem)this.pool.getObject();
            ((LinearItemPointer)temp).value = ((LinearItemPointer)index).value;
            newItem.setNext(temp);
            temp.setPrev(newItem);
            newItem = temp;
            ++i;
        }
        newItem.setNext(null);
        result.first = newFirst;
        result.last = newItem;
        return result;
    }

    public boolean contains(Object value) {
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (((LinearItemPointer)temp).value.equals(value)) {
                return true;
            }
            temp = temp.getNext();
            ++i;
        }
        return false;
    }

    public Object get(Object value) {
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (((LinearItemPointer)temp).value.equals(value)) {
                return ((LinearItemPointer)temp).value;
            }
            temp = temp.getNext();
            ++i;
        }
        return null;
    }

    public Object get(int index) {
        LinearItemPointer result = (LinearItemPointer)this.getItem(index);
        return result == null ? null : result.value;
    }

    public Object getFirst() {
        return this.first == null ? null : ((LinearItemPointer)this.first).value;
    }

    public Object getLast() {
        return this.last == null ? null : ((LinearItemPointer)this.last).value;
    }

    public int indexOf(Object value) {
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (((LinearItemPointer)temp).value.equals(value)) {
                return i;
            }
            temp = temp.getNext();
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object value) {
        PrevItem temp = this.last;
        int i = this.count - 1;
        while (i >= 0) {
            if (((LinearItemPointer)temp).value.equals(value)) {
                return i;
            }
            temp = temp.getPrev();
            --i;
        }
        return -1;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.count];
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            array[i] = ((LinearItemPointer)temp).value;
            temp = temp.getNext();
            ++i;
        }
        return array;
    }

    public BaseDoublyLinkedList sublist(int index) {
        if (this.pool == null) {
            return super.sublist(index);
        }
        return this.sublist_(index);
    }

    private BaseDoublyLinkedList sublist_(int index) {
        if (index <= 0) {
            return (DoublyLinkedList)this.clone_();
        }
        DoublyLinkedList result = (DoublyLinkedList)this.getNewInstance();
        if (index >= this.count) {
            result.init(null, null, 0);
            return result;
        }
        NextItem counter = this.getItem_(index);
        LinearItemPointer temp = null;
        LinearItemPointer newFirst = (LinearItemPointer)this.pool.getObject();
        newFirst.value = ((LinearItemPointer)counter).value;
        LinearItemPointer newItem = newFirst;
        newFirst.setPrev(null);
        int i = index + 1;
        while (i < this.count) {
            counter = counter.getNext();
            temp = (LinearItemPointer)this.pool.getObject();
            temp.value = ((LinearItemPointer)counter).value;
            newItem.setNext(temp);
            temp.setPrev(newItem);
            newItem = temp;
            ++i;
        }
        newItem.setNext(null);
        result.init(newFirst, newItem, this.count - index);
        return result;
    }

    public BaseDoublyLinkedList sublist(int lowerBoundary, int upperBoundary) {
        if (this.pool == null) {
            return super.sublist(lowerBoundary, upperBoundary);
        }
        if (upperBoundary >= this.count) {
            upperBoundary = this.count - 1;
        }
        if (lowerBoundary < 0) {
            lowerBoundary = 0;
        }
        if (upperBoundary == this.count - 1) {
            return this.sublist_(lowerBoundary);
        }
        DoublyLinkedList result = (DoublyLinkedList)this.getNewInstance();
        if (lowerBoundary > upperBoundary) {
            return new DoublyLinkedList(this.limit);
        }
        NextItem counter = this.getItem_(lowerBoundary);
        LinearItemPointer temp = null;
        LinearItemPointer newFirst = (LinearItemPointer)this.pool.getObject();
        newFirst.value = ((LinearItemPointer)counter).value;
        LinearItemPointer newItem = newFirst;
        newFirst.setPrev(null);
        int i = lowerBoundary;
        while (i < upperBoundary) {
            counter = counter.getNext();
            temp = (LinearItemPointer)this.pool.getObject();
            temp.value = ((LinearItemPointer)counter).value;
            newItem.setNext(temp);
            temp.setPrev(newItem);
            newItem = temp;
            ++i;
        }
        newItem.setNext(null);
        result.init(newFirst, newItem, upperBoundary - lowerBoundary + 1);
        return result;
    }

    public boolean removeSublist(int index) {
        if (this.pool == null) {
            return super.removeSublist(index);
        }
        if (index >= this.count || this.count == 0) {
            return false;
        }
        if (index <= 0) {
            this.clear_();
        } else {
            LinearItem temp = this.getItem_(index);
            LinearItem prev = (LinearItem)temp.getPrev();
            while (temp != null) {
                NextItem next = temp.getNext();
                temp.clearItem();
                ((LinearItemPointer)temp).value = null;
                this.pool.releaseObject(temp);
                temp = (LinearItem)next;
            }
            prev.setNext(null);
            this.last = prev;
            this.count = index;
        }
        return true;
    }

    public boolean removeRange(int lowerBoundary, int upperBoundary) {
        if (this.pool == null) {
            return super.removeRange(lowerBoundary, upperBoundary);
        }
        if (upperBoundary >= this.count) {
            upperBoundary = this.count - 1;
        }
        if (lowerBoundary < 0) {
            lowerBoundary = 0;
        }
        if (lowerBoundary > upperBoundary || lowerBoundary >= this.count) {
            return false;
        }
        int dif = upperBoundary - lowerBoundary;
        if (lowerBoundary == 0) {
            NextItem temp = this.first;
            NextItem next = null;
            int i = 0;
            while (i <= upperBoundary) {
                next = temp.getNext();
                temp.clearItem();
                ((LinearItemPointer)temp).value = null;
                this.pool.releaseObject(temp);
                ++i;
                temp = next;
            }
            this.first = (LinearItem)next;
            if (this.first == null) {
                this.last = null;
            } else {
                this.first.setPrev(null);
            }
        } else {
            NextItem temp = this.getItem_(lowerBoundary);
            NextItem old = (NextItem)((Object)((PrevItem)((Object)temp)).getPrev());
            NextItem next = null;
            int i = 0;
            while (i <= dif) {
                next = temp.getNext();
                temp.clearItem();
                ((LinearItemPointer)temp).value = null;
                this.pool.releaseObject(temp);
                ++i;
                temp = next;
            }
            old.setNext(temp);
            if (temp == null) {
                this.last = (LinearItem)old;
            } else {
                temp.setPrev((LinearItem)old);
            }
        }
        this.count -= dif + 1;
        return true;
    }

    public SnapShotEnumeration elementsEnumeration() {
        return new ArrayEnumeration(this.toArray());
    }

    public LinearItemPointer addBeforePointer(LinearItem index, Object value) {
        if (this.count >= this.limit) {
            return null;
        }
        LinearItemPointer item = this.getLinearItemPointer(value);
        LinearItem prev = (LinearItem)index.getPrev();
        item.setPrev(prev);
        if (prev == null) {
            this.first = item;
        } else {
            prev.setNext(item);
        }
        item.setNext(index);
        index.setPrev(item);
        ++this.count;
        return item;
    }

    public LinearItemPointer addAfterPointer(LinearItem index, Object value) {
        if (this.count >= this.limit) {
            return null;
        }
        LinearItemPointer item = this.getLinearItemPointer(value);
        LinearItem next = (LinearItem)index.getNext();
        item.setNext(next);
        if (next == null) {
            this.last = item;
        } else {
            next.setPrev(item);
        }
        item.setPrev(index);
        index.setNext(item);
        ++this.count;
        return item;
    }

    public void removeElement(LinearItem item) {
        super.removeElement(item);
        this.releaseLinearItemPointer((LinearItemPointer)item);
    }

    public void removeRange(LinearItem start, LinearItem end) {
        NextItem nextItem;
        if (this.pool == null) {
            super.removeRange(start, end);
            return;
        }
        int counter = 0;
        LinearItem prev = (LinearItem)start.getPrev();
        LinearItem next = (LinearItem)end.getNext();
        if (prev == null) {
            this.first = next;
        } else {
            prev.setNext(next);
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.setPrev(prev);
        }
        NextItem temp = start;
        end = (LinearItem)end.getNext();
        do {
            nextItem = temp.getNext();
            ++counter;
            temp.clearItem();
            ((LinearItemPointer)temp).value = null;
            this.pool.releaseObject(temp);
        } while ((temp = nextItem) != end);
        this.count -= counter;
    }

    public Pointer[] toPointerArray() {
        Pointer[] array = new LinearItemPointer[this.count];
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            array[i] = (LinearItemPointer)temp;
            temp = temp.getNext();
            ++i;
        }
        return array;
    }

    public RootIterator elementsIterator() {
        return new DoublyLinkedListIterator();
    }

    protected Object iterChange(Object obj, LinearItem pointer, LinearItem end) {
        if (obj == null) {
            throw new IteratorException("An illegal attempt to change a value to null!");
        }
        if (pointer == end.getNext()) {
            throw new IteratorException("End of Iterator reached!");
        }
        LinearItemPointer wrapper = (LinearItemPointer)pointer;
        Object tmp = wrapper.value;
        wrapper.value = obj;
        return tmp;
    }

    protected class DoublyLinkedListIterator
    extends BaseDoublyLinkedList.BaseDoublyLinkedListIterator {
        protected DoublyLinkedListIterator() {
        }

        public Object get() {
            return ((LinearItemPointer)super.get()).value;
        }

        public RootDataStructure getDataStructure() {
            return DoublyLinkedList.this;
        }

        public Object next() {
            return ((LinearItemPointer)super.next()).value;
        }

        public Object next(int n) {
            return ((LinearItemPointer)super.next((int)n)).value;
        }

        public void setStartFromIterator(RootIterator iterator) {
            DoublyLinkedListIterator dlli = (DoublyLinkedListIterator)iterator;
            if (DoublyLinkedList.this != dlli.getDataStructure()) {
                throw new IteratorException("An attempt to set start from an Iterator over a different DoublyLinkerList instance!");
            }
            LinearItem newPointer = dlli.pointer;
            if (newPointer == null) {
                throw new IteratorException("Illegal argument: pointer == null");
            }
            this.pointer = this.start = newPointer;
        }

        public void setEndFromIterator(RootIterator iterator) {
            DoublyLinkedListIterator dlli = (DoublyLinkedListIterator)iterator;
            if (DoublyLinkedList.this != dlli.getDataStructure()) {
                throw new IteratorException("An attempt to set end from an Iterator over a different DoublyLinkerList instance!");
            }
            LinearItem newPointer = (LinearItem)dlli.pointer.getPrev();
            if (this.pointer == null) {
                throw new IteratorException("End of Iterator reached!");
            }
            if (newPointer == null) {
                throw new IteratorException("An attempt to set the end from an exhausted Iterator!");
            }
            this.end = newPointer;
        }

        public Object add(Object obj) {
            return ((LinearItemPointer)super.add((Object)DoublyLinkedList.this.getLinearItemPointer((Object)obj))).value;
        }

        public Object change(Object obj) {
            return DoublyLinkedList.this.iterChange(obj, this.pointer, this.end);
        }

        public Object remove() {
            LinearItemPointer tmp = (LinearItemPointer)super.remove();
            Object res = tmp.value;
            DoublyLinkedList.this.releaseLinearItemPointer(tmp);
            return res;
        }

        public Object insert(Object obj) {
            return ((LinearItemPointer)super.insert((Object)obj)).value;
        }

        public Object prev() {
            return ((LinearItemPointer)super.prev()).value;
        }

        public Object prev(int n) {
            return ((LinearItemPointer)super.prev((int)n)).value;
        }
    }
}

