/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.EnumerationShort;
import com.sap.engine.lib.util.PrimitiveTypeDataStructure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;

public class ArrayShort
extends PrimitiveTypeDataStructure {
    protected transient short[] elementData;
    protected int capacityIncrement;

    public ArrayShort(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new short[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public ArrayShort(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ArrayShort() {
        this(10);
    }

    public ArrayShort(short[] array, int offset, int length, int capacityIncrement) {
        this.elementData = new short[length];
        System.arraycopy(array, offset, this.elementData, 0, length);
        this.capacityIncrement = capacityIncrement;
        this.count = length;
    }

    public ArrayShort(short[] array) {
        this(array, 0, array.length, 0);
    }

    public ArrayShort(ArrayShort arrayShort, int offset, int length, int capacityIncrement) {
        this(length, capacityIncrement);
        arrayShort.copyInto(offset, this.elementData, 0, length);
        this.count = length;
    }

    public ArrayShort(ArrayShort arrayShort) {
        this.elementData = arrayShort.toArray();
        this.count = this.elementData.length;
    }

    public void copyInto(short[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.count);
    }

    public void copyInto(int index, short[] array, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        System.arraycopy(this.elementData, index, array, offset, length);
    }

    public void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.count < oldCapacity) {
            short[] newData = new short[this.count];
            System.arraycopy(this.elementData, 0, newData, 0, this.count);
            this.elementData = newData;
        }
    }

    protected void ensureCapacity(int minCapacity) {
        int capacity = this.elementData.length;
        if (minCapacity > capacity) {
            int n = capacity = this.capacityIncrement > 0 ? capacity + this.capacityIncrement : capacity << 1;
            if (capacity < minCapacity) {
                capacity = minCapacity;
            }
            short[] newData = new short[capacity];
            System.arraycopy(this.elementData, 0, newData, 0, this.count);
            this.elementData = newData;
        }
    }

    public void setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("Illegal newSize: " + newSize);
        }
        if (newSize > this.count) {
            this.ensureCapacity(newSize);
        }
        this.count = newSize;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public boolean contains(short elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public int indexOf(short elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(short elem, int index) {
        int i = index;
        while (i < this.count) {
            if (elem == this.elementData[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(short elem) {
        return this.lastIndexOf(elem, this.count - 1);
    }

    public int lastIndexOf(short elem, int index) {
        int i = index;
        while (i >= 0) {
            if (elem == this.elementData[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public short elementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        return this.elementData[index];
    }

    public short firstElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public short lastElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.count - 1];
    }

    public void setElementAt(short value, int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        this.elementData[index] = value;
    }

    public void removeElementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + 0);
        }
        int j = this.count - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.count;
    }

    public short removeLastElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[--this.count];
    }

    public void insertElementAt(short value, int index) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.count);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.count - index);
        this.elementData[index] = value;
        ++this.count;
    }

    public void addElement(short value) {
        this.ensureCapacity(this.count + 1);
        this.elementData[this.count++] = value;
    }

    public void removeAllElements() {
        this.count = 0;
    }

    public short get(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        return this.elementData[index];
    }

    public short set(int index, short element) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        short oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    public long remove(int index) {
        return this.removeAt(index);
    }

    public boolean remove(short value) {
        return this.removeElement(value);
    }

    public void add(int index, short element) {
        this.insertElementAt(element, index);
    }

    public short removeAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + 0);
        }
        short oldValue = this.elementData[index];
        int j = this.count - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.count;
        return oldValue;
    }

    public int hashCode() {
        int theCode = 0;
        int i = 0;
        while (i < this.count) {
            theCode += i;
            theCode ^= this.elementData[i];
            ++i;
        }
        return theCode;
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException(fromIndex + " >= " + toIndex);
        }
        if (toIndex > this.count) {
            throw new ArrayIndexOutOfBoundsException(toIndex + " > " + this.count);
        }
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, this.count - toIndex);
        this.count -= toIndex - fromIndex;
    }

    public void sort() {
        this.qsort(0, this.count);
    }

    public void sort(boolean descending) {
        if (descending) {
            this.qsortDesc(0, this.count);
            return;
        }
        this.qsort(0, this.count);
    }

    public void sort(int fromIndex, int toIndex) {
        this.rangeCheck(fromIndex, toIndex);
        this.qsort(fromIndex, toIndex - fromIndex);
    }

    public void sort(int fromIndex, int toIndex, boolean descending) {
        this.rangeCheck(fromIndex, toIndex);
        if (descending) {
            this.qsortDesc(fromIndex, toIndex - fromIndex);
        } else {
            this.qsort(fromIndex, toIndex - fromIndex);
        }
    }

    private void qsortDesc(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && this.elementData[j - 1] < this.elementData[j]) {
                    this.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >>> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len >>> 3;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        short v = this.elementData[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.elementData[b] >= v) {
                if (this.elementData[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.elementData[c] <= v) {
                if (this.elementData[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecSwap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecSwap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.qsortDesc(off, s);
        }
        if ((s = d - c) > 1) {
            this.qsortDesc(n - s, s);
        }
    }

    private void qsort(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && this.elementData[j - 1] > this.elementData[j]) {
                    this.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >>> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len >>> 3;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        short v = this.elementData[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.elementData[b] <= v) {
                if (this.elementData[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.elementData[c] >= v) {
                if (this.elementData[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecSwap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecSwap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.qsort(off, s);
        }
        if ((s = d - c) > 1) {
            this.qsort(n - s, s);
        }
    }

    private void swap(int a, int b) {
        short temp = this.elementData[a];
        this.elementData[a] = this.elementData[b];
        this.elementData[b] = temp;
    }

    private void vecSwap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private int med3(int a, int b, int c) {
        return this.elementData[a] < this.elementData[b] ? (this.elementData[b] < this.elementData[c] ? b : (this.elementData[a] < this.elementData[c] ? c : a)) : (this.elementData[b] > this.elementData[c] ? b : (this.elementData[a] > this.elementData[c] ? c : a));
    }

    public int binarySearch(short key) {
        int low = 0;
        int high = this.count - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            short midVal = this.elementData[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    /*
     * Unable to fully structure code
     */
    public int binarySearch(short key, boolean descending) {
        block6: {
            low = 0;
            high = this.count - 1;
            if (!descending) ** GOTO lbl24
            while (low <= high) {
                mid = low + high >>> 1;
                midVal = this.elementData[mid];
                if (midVal > key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal < key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                mid = low + high >>> 1;
                midVal = this.elementData[mid];
                if (midVal < key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
lbl24:
                // 3 sources

                ** while (low <= high)
            }
        }
        return -(low + 1);
    }

    public int binarySearch(short key, int low, int high) {
        this.rangeCheck(low, high + 1);
        while (low <= high) {
            int mid = low + high >>> 1;
            short midVal = this.elementData[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    /*
     * Unable to fully structure code
     */
    public int binarySearch(short key, int low, int high, boolean descending) {
        block6: {
            this.rangeCheck(low, high + 1);
            if (!descending) ** GOTO lbl23
            while (low <= high) {
                mid = low + high >>> 1;
                midVal = this.elementData[mid];
                if (midVal > key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal < key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                mid = low + high >>> 1;
                midVal = this.elementData[mid];
                if (midVal < key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
lbl23:
                // 3 sources

                ** while (low <= high)
            }
        }
        return -(low + 1);
    }

    private void rangeCheck(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this.count) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public void setAll(int index, ArrayShort arrayShort) {
        this.setAll(index, arrayShort, 0, arrayShort.size());
    }

    public void setAll(int index, ArrayShort arrayShort, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        arrayShort.copyInto(offset, this.elementData, index, length);
    }

    public void setAll(int index, short[] array) {
        this.setAll(index, array, 0, array.length);
    }

    public void setAll(int index, short[] array, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        System.arraycopy(array, offset, this.elementData, index, length);
    }

    public void addAll(ArrayShort arrayShort) {
        this.addAll(arrayShort, 0, arrayShort.size());
    }

    public void addAll(ArrayShort arrayShort, int offset, int length) {
        this.ensureCapacity(this.count + length);
        arrayShort.copyInto(offset, this.elementData, this.count, length);
        this.count += length;
    }

    public void addAll(short[] array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(short[] array, int offset, int length) {
        this.ensureCapacity(this.count + length);
        System.arraycopy(array, offset, this.elementData, this.count, length);
        this.count += length;
    }

    public void addAll(int index, ArrayShort arrayShort) {
        this.addAll(index, arrayShort, 0, arrayShort.size());
    }

    public void addAll(int index, ArrayShort arrayShort, int offset, int length) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + " > size=" + this.count);
        }
        this.ensureCapacity(this.count + length);
        System.arraycopy(this.elementData, index, this.elementData, index + length, this.count - index);
        arrayShort.copyInto(offset, this.elementData, index, length);
        this.count += length;
    }

    public void addAll(int index, short[] array) {
        this.addAll(index, array, 0, array.length);
    }

    public void addAll(int index, short[] array, int offset, int length) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + " > size=" + this.count);
        }
        this.ensureCapacity(this.count + length);
        System.arraycopy(this.elementData, index, this.elementData, index + length, this.count - index);
        System.arraycopy(array, offset, this.elementData, index, length);
        this.count += length;
    }

    public void clear() {
        this.removeAllElements();
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append("\n[ size = " + this.count + "; capacityIncrement = " + this.capacityIncrement + "; capacity = " + this.elementData.length + " ]\n the elements are: [ ");
        int i = 0;
        while (i < this.count - 1) {
            s.append(this.elementData[i] + ", ");
            ++i;
        }
        if (this.count != 0) {
            s.append(this.elementData[this.count - 1]);
        }
        s.append(" ]");
        return s.toString();
    }

    public boolean equals(Object arrayShort) {
        if (!(arrayShort instanceof ArrayShort)) {
            return false;
        }
        return ((ArrayShort)arrayShort).equals_(this);
    }

    protected boolean equals_(ArrayShort arrayShort) {
        if (this.count != arrayShort.count) {
            return false;
        }
        int i = 0;
        while (i < this.count) {
            if (this.elementData[i] != arrayShort.elementData[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public EnumerationShort elements() {
        return new EnumerationShort(){
            private int counter = 0;

            public boolean hasMoreElements() {
                return this.counter < ArrayShort.this.count;
            }

            public short nextElement() {
                return ArrayShort.this.elementData[this.counter++];
            }
        };
    }

    public Object clone() {
        ArrayShort v = (ArrayShort)super.clone();
        v.elementData = new short[this.count];
        System.arraycopy(this.elementData, 0, v.elementData, 0, this.count);
        return v;
    }

    public short[] toArray() {
        short[] result = new short[this.count];
        System.arraycopy(this.elementData, 0, result, 0, this.count);
        return result;
    }

    public void add(short value) {
        this.ensureCapacity(this.count + 1);
        this.elementData[this.count++] = value;
    }

    public boolean removeElement(short value) {
        int i = 0;
        while (i < this.count) {
            if (this.elementData[i] == value) {
                int j = this.count - i - 1;
                if (j > 0) {
                    System.arraycopy(this.elementData, i + 1, this.elementData, i, j);
                }
                --this.count;
                return true;
            }
            ++i;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.elementData.length);
        int i = 0;
        while (i < this.count) {
            stream.writeShort(this.elementData[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.elementData = new short[stream.readInt()];
        int i = 0;
        while (i < this.count) {
            this.elementData[i] = stream.readShort();
            ++i;
        }
    }
}

