/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.EnumerationDouble;
import com.sap.engine.lib.util.PrimitiveTypeDataStructure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;

public class ArrayDouble
extends PrimitiveTypeDataStructure {
    protected transient double[] elementData;
    protected int capacityIncrement;

    public ArrayDouble(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new double[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public ArrayDouble(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ArrayDouble() {
        this(10);
    }

    public ArrayDouble(double[] array, int offset, int length, int capacityIncrement) {
        this.elementData = new double[length];
        System.arraycopy(array, offset, this.elementData, 0, length);
        this.capacityIncrement = capacityIncrement;
        this.count = length;
    }

    public ArrayDouble(double[] array) {
        this(array, 0, array.length, 0);
    }

    public ArrayDouble(ArrayDouble arrayDouble, int offset, int length, int capacityIncrement) {
        this(length, capacityIncrement);
        arrayDouble.copyInto(offset, this.elementData, 0, length);
        this.count = length;
    }

    public ArrayDouble(ArrayDouble arrayDouble) {
        this.elementData = arrayDouble.toArray();
        this.count = this.elementData.length;
    }

    public void copyInto(double[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.count);
    }

    public void copyInto(int index, double[] array, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        System.arraycopy(this.elementData, index, array, offset, length);
    }

    public void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.count < oldCapacity) {
            double[] newData = new double[this.count];
            System.arraycopy(this.elementData, 0, newData, 0, this.count);
            this.elementData = newData;
        }
    }

    protected void ensureCapacity(int minCapacity) {
        int capacity = this.elementData.length;
        if (minCapacity > capacity) {
            int n = capacity = this.capacityIncrement > 0 ? capacity + this.capacityIncrement : capacity << 1;
            if (capacity < minCapacity) {
                capacity = minCapacity;
            }
            double[] newData = new double[capacity];
            System.arraycopy(this.elementData, 0, newData, 0, this.count);
            this.elementData = newData;
        }
    }

    public void setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("Illegal newSize: " + newSize);
        }
        if (newSize > this.count) {
            this.ensureCapacity(newSize);
        }
        this.count = newSize;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public boolean contains(double elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public int indexOf(double elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(double elem, int index) {
        int i = index;
        while (i < this.count) {
            if (Double.doubleToLongBits(elem) == Double.doubleToLongBits(this.elementData[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(double elem) {
        return this.lastIndexOf(elem, this.count - 1);
    }

    public int lastIndexOf(double elem, int index) {
        int i = index;
        while (i >= 0) {
            if (Double.doubleToLongBits(elem) == Double.doubleToLongBits(this.elementData[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public double elementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        return this.elementData[index];
    }

    public double firstElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public double lastElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.count - 1];
    }

    public void setElementAt(double value, int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        this.elementData[index] = value;
    }

    public void removeElementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + 0);
        }
        int j = this.count - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.count;
    }

    public double removeLastElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[--this.count];
    }

    public void insertElementAt(double value, int index) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.count);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.count - index);
        this.elementData[index] = value;
        ++this.count;
    }

    public void addElement(double value) {
        this.ensureCapacity(this.count + 1);
        this.elementData[this.count++] = value;
    }

    public boolean removeElement(double value) {
        int i = 0;
        while (i < this.count) {
            if (this.elementData[i] == value) {
                int j = this.count - i - 1;
                if (j > 0) {
                    System.arraycopy(this.elementData, i + 1, this.elementData, i, j);
                }
                --this.count;
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeAllElements() {
        this.count = 0;
    }

    public Object clone() {
        ArrayDouble v = (ArrayDouble)super.clone();
        v.elementData = new double[this.count];
        System.arraycopy(this.elementData, 0, v.elementData, 0, this.count);
        return v;
    }

    public double[] toArray() {
        double[] result = new double[this.count];
        System.arraycopy(this.elementData, 0, result, 0, this.count);
        return result;
    }

    public double get(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        return this.elementData[index];
    }

    public double set(int index, double element) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        double oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    public void add(double value) {
        this.ensureCapacity(this.count + 1);
        this.elementData[this.count++] = value;
    }

    public double remove(int index) {
        return this.removeAt(index);
    }

    public boolean remove(double value) {
        return this.removeElement(value);
    }

    public void add(int index, double element) {
        this.insertElementAt(element, index);
    }

    public double removeAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + 0);
        }
        double oldValue = this.elementData[index];
        int j = this.count - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.count;
        return oldValue;
    }

    public void clear() {
        this.removeAllElements();
    }

    public int hashCode() {
        int theCode = 0;
        int i = 0;
        while (i < this.count) {
            theCode += i;
            theCode = (int)((long)theCode ^ Double.doubleToLongBits(this.elementData[i]));
            ++i;
        }
        return theCode;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append("\n[ size = " + this.count + "; capacityIncrement = " + this.capacityIncrement + "; capacity = " + this.elementData.length + " ]\n the elements are: [ ");
        int i = 0;
        while (i < this.count - 1) {
            s.append(this.elementData[i] + ", ");
            ++i;
        }
        if (this.count != 0) {
            s.append(this.elementData[this.count - 1]);
        }
        s.append(" ]");
        return s.toString();
    }

    public boolean equals(Object arrayDouble) {
        if (!(arrayDouble instanceof ArrayDouble)) {
            return false;
        }
        return ((ArrayDouble)arrayDouble).equals_(this);
    }

    protected boolean equals_(ArrayDouble arrayDouble) {
        if (this.count != arrayDouble.count) {
            return false;
        }
        int i = 0;
        while (i < this.count) {
            if (Double.doubleToLongBits(this.elementData[i]) != Double.doubleToLongBits(arrayDouble.elementData[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public EnumerationDouble elements() {
        return new EnumerationDouble(){
            private int counter = 0;

            public boolean hasMoreElements() {
                return this.counter < ArrayDouble.this.count;
            }

            public double nextElement() {
                return ArrayDouble.this.elementData[this.counter++];
            }
        };
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException(fromIndex + " >= " + toIndex);
        }
        if (toIndex > this.count) {
            throw new ArrayIndexOutOfBoundsException(toIndex + " > " + this.count);
        }
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, this.count - toIndex);
        this.count -= toIndex - fromIndex;
    }

    public void sort() {
        long NEG_ZERO_BITS = Double.doubleToLongBits(-0.0);
        int numNegZeros = 0;
        int i = 0;
        int n = this.count;
        while (i < n) {
            if (this.elementData[i] != this.elementData[i]) {
                this.elementData[i] = this.elementData[--n];
                this.elementData[n] = Double.NaN;
                continue;
            }
            if (this.elementData[i] == 0.0 && Double.doubleToLongBits(this.elementData[i]) == NEG_ZERO_BITS) {
                this.elementData[i] = 0.0;
                ++numNegZeros;
            }
            ++i;
        }
        this.qsort(0, n);
        if (numNegZeros != 0) {
            int j = this.binarySearch_(0.0, 0, n - 1);
            while (--j > -1 && this.elementData[j] == 0.0) {
            }
            int k = 0;
            while (k < numNegZeros) {
                this.elementData[++j] = -0.0;
                ++k;
            }
        }
    }

    public void sort(boolean descending) {
        if (!descending) {
            this.sort();
            return;
        }
        long NEG_ZERO_BITS = Double.doubleToLongBits(-0.0);
        int numNegZeros = 0;
        int i = -1;
        int n = this.count - 1;
        while (i < n) {
            if (this.elementData[n] != this.elementData[n]) {
                this.elementData[n] = this.elementData[++i];
                this.elementData[i] = Double.NaN;
                continue;
            }
            if (this.elementData[n] == 0.0 && Double.doubleToLongBits(this.elementData[n]) == NEG_ZERO_BITS) {
                this.elementData[n] = 0.0;
                ++numNegZeros;
            }
            --n;
        }
        this.qsortDesc(i + 1, this.count - (i + 1));
        if (numNegZeros != 0) {
            int j = this.binarySearch_(0.0, i + 1, this.count - 1);
            while (++j < this.count && this.elementData[j] == 0.0) {
            }
            int k = 0;
            while (k < numNegZeros) {
                this.elementData[--j] = -0.0;
                ++k;
            }
        }
    }

    public void sort(int fromIndex, int toIndex) {
        this.rangeCheck(fromIndex, toIndex);
        long NEG_ZERO_BITS = Double.doubleToLongBits(-0.0);
        int numNegZeros = 0;
        int i = fromIndex;
        int n = toIndex;
        while (i < n) {
            if (this.elementData[i] != this.elementData[i]) {
                this.elementData[i] = this.elementData[--n];
                this.elementData[n] = Double.NaN;
                continue;
            }
            if (this.elementData[i] == 0.0 && Double.doubleToLongBits(this.elementData[i]) == NEG_ZERO_BITS) {
                this.elementData[i] = 0.0;
                ++numNegZeros;
            }
            ++i;
        }
        this.qsort(fromIndex, n - fromIndex);
        if (numNegZeros != 0) {
            int j = this.binarySearch_(0.0, fromIndex, n - 1);
            while (--j >= fromIndex && this.elementData[j] == 0.0) {
            }
            int k = 0;
            while (k < numNegZeros) {
                this.elementData[++j] = -0.0;
                ++k;
            }
        }
    }

    public void sort(int fromIndex, int toIndex, boolean descending) {
        if (!descending) {
            this.sort(fromIndex, toIndex);
            return;
        }
        this.rangeCheck(fromIndex, toIndex);
        long NEG_ZERO_BITS = Double.doubleToLongBits(-0.0);
        int numNegZeros = 0;
        int i = fromIndex - 1;
        int n = toIndex - 1;
        while (i < n) {
            if (this.elementData[n] != this.elementData[n]) {
                this.elementData[n] = this.elementData[++i];
                this.elementData[i] = Double.NaN;
                continue;
            }
            if (this.elementData[n] == 0.0 && Double.doubleToLongBits(this.elementData[n]) == NEG_ZERO_BITS) {
                this.elementData[n] = 0.0;
                ++numNegZeros;
            }
            --n;
        }
        this.qsortDesc(i + 1, toIndex - (i + 1));
        if (numNegZeros != 0) {
            int j = this.binarySearch_(0.0, i + 1, toIndex - 1);
            while (++j < toIndex && this.elementData[j] == 0.0) {
            }
            int k = 0;
            while (k < numNegZeros) {
                this.elementData[--j] = -0.0;
                ++k;
            }
        }
    }

    private void qsortDesc(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && this.elementData[j - 1] < this.elementData[j]) {
                    this.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >>> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len >>> 3;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        double v = this.elementData[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.elementData[b] >= v) {
                if (this.elementData[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.elementData[c] <= v) {
                if (this.elementData[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecSwap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecSwap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.qsortDesc(off, s);
        }
        if ((s = d - c) > 1) {
            this.qsortDesc(n - s, s);
        }
    }

    private void qsort(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && this.elementData[j - 1] > this.elementData[j]) {
                    this.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >>> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len >>> 3;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        double v = this.elementData[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.elementData[b] <= v) {
                if (this.elementData[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.elementData[c] >= v) {
                if (this.elementData[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecSwap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecSwap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.qsort(off, s);
        }
        if ((s = d - c) > 1) {
            this.qsort(n - s, s);
        }
    }

    private void swap(int a, int b) {
        double temp = this.elementData[a];
        this.elementData[a] = this.elementData[b];
        this.elementData[b] = temp;
    }

    private void vecSwap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private int med3(int a, int b, int c) {
        return this.elementData[a] < this.elementData[b] ? (this.elementData[b] < this.elementData[c] ? b : (this.elementData[a] < this.elementData[c] ? c : a)) : (this.elementData[b] > this.elementData[c] ? b : (this.elementData[a] > this.elementData[c] ? c : a));
    }

    public int binarySearch(double key) {
        return this.binarySearch_(key);
    }

    private int binarySearch_(double key) {
        int low = 0;
        int high = this.count - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            double midVal = this.elementData[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int binarySearch(double key, boolean descending) {
        if (!descending) {
            return this.binarySearch_(key);
        }
        int low = 0;
        int high = this.count - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            double midVal = this.elementData[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int binarySearch(double key, int low, int high) {
        return this.binarySearch_(key, low, high);
    }

    private int binarySearch_(double key, int low, int high) {
        this.rangeCheck(low, high + 1);
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            double midVal = this.elementData[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int binarySearch(double key, int low, int high, boolean descending) {
        if (!descending) {
            return this.binarySearch_(key, low, high);
        }
        this.rangeCheck(low, high + 1);
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            double midVal = this.elementData[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private void rangeCheck(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this.count) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public void setAll(int index, ArrayDouble arrayDouble) {
        this.setAll(index, arrayDouble, 0, arrayDouble.size());
    }

    public void setAll(int index, ArrayDouble arrayDouble, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        arrayDouble.copyInto(offset, this.elementData, index, length);
    }

    public void setAll(int index, double[] array) {
        this.setAll(index, array, 0, array.length);
    }

    public void setAll(int index, double[] array, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        System.arraycopy(array, offset, this.elementData, index, length);
    }

    public void addAll(ArrayDouble arrayDouble) {
        this.addAll(arrayDouble, 0, arrayDouble.size());
    }

    public void addAll(ArrayDouble arrayDouble, int offset, int length) {
        this.ensureCapacity(this.count + length);
        arrayDouble.copyInto(offset, this.elementData, this.count, length);
        this.count += length;
    }

    public void addAll(double[] array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(double[] array, int offset, int length) {
        this.ensureCapacity(this.count + length);
        System.arraycopy(array, offset, this.elementData, this.count, length);
        this.count += length;
    }

    public void addAll(int index, ArrayDouble arrayDouble) {
        this.addAll(index, arrayDouble, 0, arrayDouble.size());
    }

    public void addAll(int index, ArrayDouble arrayDouble, int offset, int length) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + " > size=" + this.count);
        }
        this.ensureCapacity(this.count + length);
        System.arraycopy(this.elementData, index, this.elementData, index + length, this.count - index);
        arrayDouble.copyInto(offset, this.elementData, index, length);
        this.count += length;
    }

    public void addAll(int index, double[] array) {
        this.addAll(index, array, 0, array.length);
    }

    public void addAll(int index, double[] array, int offset, int length) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + " > size=" + this.count);
        }
        this.ensureCapacity(this.count + length);
        System.arraycopy(this.elementData, index, this.elementData, index + length, this.count - index);
        System.arraycopy(array, offset, this.elementData, index, length);
        this.count += length;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.elementData.length);
        int i = 0;
        while (i < this.count) {
            stream.writeDouble(this.elementData[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.elementData = new double[stream.readInt()];
        int i = 0;
        while (i < this.count) {
            this.elementData[i] = stream.readDouble();
            ++i;
        }
    }
}

