/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.EnumerationChar;
import com.sap.engine.lib.util.PrimitiveTypeDataStructure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;

public class ArrayChar
extends PrimitiveTypeDataStructure {
    protected transient char[] elementData;
    protected int capacityIncrement;

    public ArrayChar(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new char[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public ArrayChar(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ArrayChar() {
        this(10);
    }

    public ArrayChar(char[] array, int offset, int length, int capacityIncrement) {
        this.elementData = new char[length];
        System.arraycopy(array, offset, this.elementData, 0, length);
        this.capacityIncrement = capacityIncrement;
        this.count = length;
    }

    public ArrayChar(char[] array) {
        this(array, 0, array.length, 0);
    }

    public ArrayChar(ArrayChar arrayChar, int offset, int length, int capacityIncrement) {
        this(length, capacityIncrement);
        arrayChar.copyInto(offset, this.elementData, 0, length);
        this.count = length;
    }

    public ArrayChar(ArrayChar arrayChar) {
        this.elementData = arrayChar.toArray();
        this.count = this.elementData.length;
    }

    public void copyInto(char[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.count);
    }

    public void copyInto(int index, char[] array, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        System.arraycopy(this.elementData, index, array, offset, length);
    }

    public void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.count < oldCapacity) {
            char[] newData = new char[this.count];
            System.arraycopy(this.elementData, 0, newData, 0, this.count);
            this.elementData = newData;
        }
    }

    protected void ensureCapacity(int minCapacity) {
        int capacity = this.elementData.length;
        if (minCapacity > capacity) {
            int n = capacity = this.capacityIncrement > 0 ? capacity + this.capacityIncrement : capacity << 1;
            if (capacity < minCapacity) {
                capacity = minCapacity;
            }
            char[] newData = new char[capacity];
            System.arraycopy(this.elementData, 0, newData, 0, this.count);
            this.elementData = newData;
        }
    }

    public void setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("Illegal newSize: " + newSize);
        }
        if (newSize > this.count) {
            this.ensureCapacity(newSize);
        }
        this.count = newSize;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public boolean contains(char elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public int indexOf(char elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(char elem, int index) {
        int i = index;
        while (i < this.count) {
            if (elem == this.elementData[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(char elem) {
        return this.lastIndexOf(elem, this.count - 1);
    }

    public int lastIndexOf(char elem, int index) {
        int i = index;
        while (i >= 0) {
            if (elem == this.elementData[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public char elementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        return this.elementData[index];
    }

    public char firstElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public char lastElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.count - 1];
    }

    public void setElementAt(char value, int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        this.elementData[index] = value;
    }

    public void removeElementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + 0);
        }
        int j = this.count - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.count;
    }

    public char removeLastElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[--this.count];
    }

    public void insertElementAt(char value, int index) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.count);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.count - index);
        this.elementData[index] = value;
        ++this.count;
    }

    public void addElement(char value) {
        this.ensureCapacity(this.count + 1);
        this.elementData[this.count++] = value;
    }

    public void removeAllElements() {
        this.count = 0;
    }

    public char get(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        return this.elementData[index];
    }

    public char set(int index, char element) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        char oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    public char remove(int index) {
        return this.removeAt(index);
    }

    public boolean remove(char value) {
        return this.removeElement(value);
    }

    public void add(int index, char element) {
        this.insertElementAt(element, index);
    }

    public char removeAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + 0);
        }
        char oldValue = this.elementData[index];
        int j = this.count - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.count;
        return oldValue;
    }

    public int hashCode() {
        int theCode = 0;
        int i = 0;
        while (i < this.count) {
            theCode += i;
            theCode ^= this.elementData[i];
            ++i;
        }
        return theCode;
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException(fromIndex + " >= " + toIndex);
        }
        if (toIndex > this.count) {
            throw new ArrayIndexOutOfBoundsException(toIndex + " > " + this.count);
        }
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, this.count - toIndex);
        this.count -= toIndex - fromIndex;
    }

    public void sort() {
        this.qsort(0, this.count);
    }

    public void sort(boolean descending) {
        if (descending) {
            this.qsortDesc(0, this.count);
            return;
        }
        this.qsort(0, this.count);
    }

    public void sort(int fromIndex, int toIndex) {
        this.rangeCheck(fromIndex, toIndex);
        this.qsort(fromIndex, toIndex - fromIndex);
    }

    public void sort(int fromIndex, int toIndex, boolean descending) {
        this.rangeCheck(fromIndex, toIndex);
        if (descending) {
            this.qsortDesc(fromIndex, toIndex - fromIndex);
        } else {
            this.qsort(fromIndex, toIndex - fromIndex);
        }
    }

    private void qsortDesc(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && this.elementData[j - 1] < this.elementData[j]) {
                    this.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >>> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len >>> 3;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        char v = this.elementData[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.elementData[b] >= v) {
                if (this.elementData[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.elementData[c] <= v) {
                if (this.elementData[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecSwap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecSwap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.qsortDesc(off, s);
        }
        if ((s = d - c) > 1) {
            this.qsortDesc(n - s, s);
        }
    }

    private void qsort(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && this.elementData[j - 1] > this.elementData[j]) {
                    this.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >>> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len >>> 3;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        char v = this.elementData[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.elementData[b] <= v) {
                if (this.elementData[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.elementData[c] >= v) {
                if (this.elementData[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecSwap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecSwap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.qsort(off, s);
        }
        if ((s = d - c) > 1) {
            this.qsort(n - s, s);
        }
    }

    private void swap(int a, int b) {
        char temp = this.elementData[a];
        this.elementData[a] = this.elementData[b];
        this.elementData[b] = temp;
    }

    private void vecSwap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private int med3(int a, int b, int c) {
        return this.elementData[a] < this.elementData[b] ? (this.elementData[b] < this.elementData[c] ? b : (this.elementData[a] < this.elementData[c] ? c : a)) : (this.elementData[b] > this.elementData[c] ? b : (this.elementData[a] > this.elementData[c] ? c : a));
    }

    public int binarySearch(char key) {
        int low = 0;
        int high = this.count - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            char midVal = this.elementData[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    /*
     * Unable to fully structure code
     */
    public int binarySearch(char key, boolean descending) {
        block6: {
            low = 0;
            high = this.count - 1;
            if (!descending) ** GOTO lbl24
            while (low <= high) {
                mid = low + high >>> 1;
                midVal = this.elementData[mid];
                if (midVal > key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal < key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                mid = low + high >>> 1;
                midVal = this.elementData[mid];
                if (midVal < key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
lbl24:
                // 3 sources

                ** while (low <= high)
            }
        }
        return -(low + 1);
    }

    public int binarySearch(char key, int low, int high) {
        this.rangeCheck(low, high + 1);
        while (low <= high) {
            int mid = low + high >>> 1;
            char midVal = this.elementData[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    /*
     * Unable to fully structure code
     */
    public int binarySearch(char key, int low, int high, boolean descending) {
        block6: {
            this.rangeCheck(low, high + 1);
            if (!descending) ** GOTO lbl23
            while (low <= high) {
                mid = low + high >>> 1;
                midVal = this.elementData[mid];
                if (midVal > key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal < key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                mid = low + high >>> 1;
                midVal = this.elementData[mid];
                if (midVal < key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
lbl23:
                // 3 sources

                ** while (low <= high)
            }
        }
        return -(low + 1);
    }

    private void rangeCheck(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this.count) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public void setAll(int index, ArrayChar arrayChar) {
        this.setAll(index, arrayChar, 0, arrayChar.size());
    }

    public void setAll(int index, ArrayChar arrayChar, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        arrayChar.copyInto(offset, this.elementData, index, length);
    }

    public void setAll(int index, char[] array) {
        this.setAll(index, array, 0, array.length);
    }

    public void setAll(int index, char[] array, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        System.arraycopy(array, offset, this.elementData, index, length);
    }

    public void addAll(ArrayChar arrayChar) {
        this.addAll(arrayChar, 0, arrayChar.size());
    }

    public void addAll(ArrayChar arrayChar, int offset, int length) {
        this.ensureCapacity(this.count + length);
        arrayChar.copyInto(offset, this.elementData, this.count, length);
        this.count += length;
    }

    public void addAll(char[] array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(char[] array, int offset, int length) {
        this.ensureCapacity(this.count + length);
        System.arraycopy(array, offset, this.elementData, this.count, length);
        this.count += length;
    }

    public void addAll(int index, ArrayChar arrayChar) {
        this.addAll(index, arrayChar, 0, arrayChar.size());
    }

    public void addAll(int index, ArrayChar arrayChar, int offset, int length) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + " > size=" + this.count);
        }
        this.ensureCapacity(this.count + length);
        System.arraycopy(this.elementData, index, this.elementData, index + length, this.count - index);
        arrayChar.copyInto(offset, this.elementData, index, length);
        this.count += length;
    }

    public void addAll(int index, char[] array) {
        this.addAll(index, array, 0, array.length);
    }

    public void addAll(int index, char[] array, int offset, int length) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + " > size=" + this.count);
        }
        this.ensureCapacity(this.count + length);
        System.arraycopy(this.elementData, index, this.elementData, index + length, this.count - index);
        System.arraycopy(array, offset, this.elementData, index, length);
        this.count += length;
    }

    public void clear() {
        this.removeAllElements();
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append("\n[ size = " + this.count + "; capacityIncrement = " + this.capacityIncrement + "; capacity = " + this.elementData.length + " ]\n the elements are: [ ");
        int i = 0;
        while (i < this.count - 1) {
            s.append(this.elementData[i] + ", ");
            ++i;
        }
        if (this.count != 0) {
            s.append(this.elementData[this.count - 1]);
        }
        s.append(" ]");
        return s.toString();
    }

    public boolean equals(Object arrayChar) {
        if (!(arrayChar instanceof ArrayChar)) {
            return false;
        }
        return ((ArrayChar)arrayChar).equals_(this);
    }

    protected boolean equals_(ArrayChar arrayChar) {
        if (this.count != arrayChar.count) {
            return false;
        }
        int i = 0;
        while (i < this.count) {
            if (this.elementData[i] != arrayChar.elementData[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public EnumerationChar elements() {
        return new EnumerationChar(){
            private int counter = 0;

            public boolean hasMoreElements() {
                return this.counter < ArrayChar.this.count;
            }

            public char nextElement() {
                return ArrayChar.this.elementData[this.counter++];
            }
        };
    }

    public Object clone() {
        ArrayChar v = (ArrayChar)super.clone();
        v.elementData = new char[this.count];
        System.arraycopy(this.elementData, 0, v.elementData, 0, this.count);
        return v;
    }

    public char[] toArray() {
        char[] result = new char[this.count];
        System.arraycopy(this.elementData, 0, result, 0, this.count);
        return result;
    }

    public void add(char value) {
        this.ensureCapacity(this.count + 1);
        this.elementData[this.count++] = value;
    }

    public boolean removeElement(char value) {
        int i = 0;
        while (i < this.count) {
            if (this.elementData[i] == value) {
                int j = this.count - i - 1;
                if (j > 0) {
                    System.arraycopy(this.elementData, i + 1, this.elementData, i, j);
                }
                --this.count;
                return true;
            }
            ++i;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.elementData.length);
        int i = 0;
        while (i < this.count) {
            stream.writeChar(this.elementData[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.elementData = new char[stream.readInt()];
        int i = 0;
        while (i < this.count) {
            this.elementData[i] = stream.readChar();
            ++i;
        }
    }
}

