/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.EnumerationBoolean;
import com.sap.engine.lib.util.PrimitiveTypeDataStructure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;

public class ArrayBoolean
extends PrimitiveTypeDataStructure {
    protected transient boolean[] elementData;
    protected int capacityIncrement;

    public ArrayBoolean(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new boolean[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public ArrayBoolean(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ArrayBoolean() {
        this(10);
    }

    public ArrayBoolean(boolean[] array, int offset, int length, int capacityIncrement) {
        this.elementData = new boolean[length];
        System.arraycopy(array, offset, this.elementData, 0, length);
        this.capacityIncrement = capacityIncrement;
        this.count = length;
    }

    public ArrayBoolean(boolean[] array) {
        this(array, 0, array.length, 0);
    }

    public ArrayBoolean(ArrayBoolean arrayBoolean, int offset, int length, int capacityIncrement) {
        this(length, capacityIncrement);
        arrayBoolean.copyInto(offset, this.elementData, 0, length);
        this.count = length;
    }

    public ArrayBoolean(ArrayBoolean arrayBoolean) {
        this.elementData = arrayBoolean.toArray();
        this.count = this.elementData.length;
    }

    public void copyInto(boolean[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.count);
    }

    public void copyInto(int index, boolean[] array, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        System.arraycopy(this.elementData, index, array, offset, length);
    }

    public void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.count < oldCapacity) {
            boolean[] newData = new boolean[this.count];
            System.arraycopy(this.elementData, 0, newData, 0, this.count);
            this.elementData = newData;
        }
    }

    protected void ensureCapacity(int minCapacity) {
        int capacity = this.elementData.length;
        if (minCapacity > capacity) {
            int n = capacity = this.capacityIncrement > 0 ? capacity + this.capacityIncrement : capacity << 1;
            if (capacity < minCapacity) {
                capacity = minCapacity;
            }
            boolean[] newData = new boolean[capacity];
            System.arraycopy(this.elementData, 0, newData, 0, this.count);
            this.elementData = newData;
        }
    }

    public void setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("Illegal newSize: " + newSize);
        }
        if (newSize > this.count) {
            this.ensureCapacity(newSize);
        }
        this.count = newSize;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public boolean contains(boolean elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public int indexOf(boolean elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(boolean elem, int index) {
        int i = index;
        while (i < this.count) {
            if (elem == this.elementData[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(boolean elem) {
        return this.lastIndexOf(elem, this.count - 1);
    }

    public int lastIndexOf(boolean elem, int index) {
        int i = index;
        while (i >= 0) {
            if (elem == this.elementData[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public boolean elementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        return this.elementData[index];
    }

    public boolean firstElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public boolean lastElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.count - 1];
    }

    public void setElementAt(boolean value, int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        this.elementData[index] = value;
    }

    public void removeElementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + 0);
        }
        int j = this.count - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.count;
    }

    public boolean removeLastElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[--this.count];
    }

    public void insertElementAt(boolean value, int index) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.count);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.count - index);
        this.elementData[index] = value;
        ++this.count;
    }

    public void addElement(boolean value) {
        this.ensureCapacity(this.count + 1);
        this.elementData[this.count++] = value;
    }

    public boolean removeElement(boolean value) {
        int i = 0;
        while (i < this.count) {
            if (this.elementData[i] == value) {
                int j = this.count - i - 1;
                if (j > 0) {
                    System.arraycopy(this.elementData, i + 1, this.elementData, i, j);
                }
                --this.count;
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeAllElements() {
        this.count = 0;
    }

    public Object clone() {
        ArrayBoolean v = (ArrayBoolean)super.clone();
        v.elementData = new boolean[this.count];
        System.arraycopy(this.elementData, 0, v.elementData, 0, this.count);
        return v;
    }

    public boolean[] toArray() {
        boolean[] result = new boolean[this.count];
        System.arraycopy(this.elementData, 0, result, 0, this.count);
        return result;
    }

    public boolean get(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        return this.elementData[index];
    }

    public boolean set(int index, boolean element) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        boolean oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    public void add(boolean value) {
        this.ensureCapacity(this.count + 1);
        this.elementData[this.count++] = value;
    }

    public boolean remove(int index) {
        return this.removeAt(index);
    }

    public boolean remove(boolean value) {
        return this.removeElement(value);
    }

    public void add(int index, boolean element) {
        this.insertElementAt(element, index);
    }

    public boolean removeAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + 0);
        }
        boolean oldValue = this.elementData[index];
        int j = this.count - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.count;
        return oldValue;
    }

    public void clear() {
        this.removeAllElements();
    }

    public int hashCode() {
        int theCode = 0;
        int i = 0;
        while (i < this.count) {
            theCode += i;
            if (this.elementData[i]) {
                theCode ^= 1;
            }
            ++i;
        }
        return theCode;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append("\n[ size = " + this.count + "; capacityIncrement = " + this.capacityIncrement + "; capacity = " + this.elementData.length + " ]\n the elements are: [ ");
        int i = 0;
        while (i < this.count - 1) {
            s.append(this.elementData[i] + ", ");
            ++i;
        }
        if (this.count != 0) {
            s.append(this.elementData[this.count - 1]);
        }
        s.append(" ]");
        return s.toString();
    }

    public boolean equals(Object arrayBoolean) {
        if (!(arrayBoolean instanceof ArrayBoolean)) {
            return false;
        }
        return ((ArrayBoolean)arrayBoolean).equals_(this);
    }

    protected boolean equals_(ArrayBoolean arrayBoolean) {
        if (this.count != arrayBoolean.count) {
            return false;
        }
        int i = 0;
        while (i < this.count) {
            if (this.elementData[i] != arrayBoolean.elementData[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public EnumerationBoolean elements() {
        return new EnumerationBoolean(){
            private int counter = 0;

            public boolean hasMoreElements() {
                return this.counter < ArrayBoolean.this.count;
            }

            public boolean nextElement() {
                return ArrayBoolean.this.elementData[this.counter++];
            }
        };
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException(fromIndex + " >= " + toIndex);
        }
        if (toIndex > this.count) {
            throw new ArrayIndexOutOfBoundsException(toIndex + " > " + this.count);
        }
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, this.count - toIndex);
        this.count -= toIndex - fromIndex;
    }

    public void setAll(int index, ArrayBoolean arrayBoolean) {
        this.setAll(index, arrayBoolean, 0, arrayBoolean.size());
    }

    public void setAll(int index, ArrayBoolean arrayBoolean, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        arrayBoolean.copyInto(offset, this.elementData, index, length);
    }

    public void setAll(int index, boolean[] array) {
        this.setAll(index, array, 0, array.length);
    }

    public void setAll(int index, boolean[] array, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        System.arraycopy(array, offset, this.elementData, index, length);
    }

    public void addAll(ArrayBoolean arrayBoolean) {
        this.addAll(arrayBoolean, 0, arrayBoolean.size());
    }

    public void addAll(ArrayBoolean arrayBoolean, int offset, int length) {
        this.ensureCapacity(this.count + length);
        arrayBoolean.copyInto(offset, this.elementData, this.count, length);
        this.count += length;
    }

    public void addAll(boolean[] array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(boolean[] array, int offset, int length) {
        this.ensureCapacity(this.count + length);
        System.arraycopy(array, offset, this.elementData, this.count, length);
        this.count += length;
    }

    public void addAll(int index, ArrayBoolean arrayBoolean) {
        this.addAll(index, arrayBoolean, 0, arrayBoolean.size());
    }

    public void addAll(int index, ArrayBoolean arrayBoolean, int offset, int length) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + " > size=" + this.count);
        }
        this.ensureCapacity(this.count + length);
        System.arraycopy(this.elementData, index, this.elementData, index + length, this.count - index);
        arrayBoolean.copyInto(offset, this.elementData, index, length);
        this.count += length;
    }

    public void addAll(int index, boolean[] array) {
        this.addAll(index, array, 0, array.length);
    }

    public void addAll(int index, boolean[] array, int offset, int length) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + " > size=" + this.count);
        }
        this.ensureCapacity(this.count + length);
        System.arraycopy(this.elementData, index, this.elementData, index + length, this.count - index);
        System.arraycopy(array, offset, this.elementData, index, length);
        this.count += length;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.elementData.length);
        int i = 0;
        while (i < this.count) {
            stream.writeBoolean(this.elementData[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.elementData = new boolean[stream.readInt()];
        int i = 0;
        while (i < this.count) {
            this.elementData[i] = stream.readBoolean();
            ++i;
        }
    }
}

