/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.DeepCloneable;
import com.sap.engine.lib.util.NotSupportedException;
import com.sap.engine.lib.util.PoolInstanceCreator;
import com.sap.engine.lib.util.PoolObject;
import com.sap.engine.lib.util.TreePerformer;
import com.sap.engine.lib.util.base.AVLItemAdapter;
import com.sap.engine.lib.util.base.BaseAVLTree;
import com.sap.engine.lib.util.base.BaseBinaryTree;
import com.sap.engine.lib.util.base.BinTreeItem;
import com.sap.engine.lib.util.base.Pointer;
import com.sap.engine.lib.util.iterators.ArrayEnumeration;
import com.sap.engine.lib.util.iterators.ForwardIterator;
import com.sap.engine.lib.util.iterators.RootIterator;
import com.sap.engine.lib.util.iterators.SnapShotEnumeration;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class AVLTree
extends BaseAVLTree
implements PoolInstanceCreator {
    static final long serialVersionUID = 3894269270715875068L;
    protected transient PoolObject pool;

    public void setPool(PoolObject pool) {
        this.pool = pool;
    }

    public PoolObject getPool() {
        return this.pool;
    }

    public Object newInstance() {
        return new Wrapper();
    }

    protected Wrapper getWrapper(Comparable key, Object value) {
        if (this.pool == null) {
            return new Wrapper(key, value);
        }
        Wrapper wrapper = (Wrapper)this.pool.getObject();
        wrapper.setKey(key);
        wrapper.value = value;
        return wrapper;
    }

    protected void releaseWrapper(Wrapper wrapper) {
        if (this.pool != null) {
            wrapper.setKey(null);
            wrapper.value = null;
            this.pool.releaseObject(wrapper);
        }
    }

    public Object put(Comparable key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Wrapper result = (Wrapper)this.putItem(this.getWrapper(key, value));
        return result == null ? null : result.value;
    }

    public Object get(Comparable key) {
        Wrapper result = (Wrapper)this.getItem(key);
        return result == null ? null : result.value;
    }

    public Object remove(Comparable key) {
        Wrapper wrapper = (Wrapper)this.removeItem(key);
        if (wrapper == null) {
            return null;
        }
        Object result = wrapper.value;
        this.releaseWrapper(wrapper);
        return result;
    }

    public ForwardIterator elements() {
        return new TreeIterator();
    }

    public ForwardIterator elements(boolean ascending) {
        return ascending ? new TreeIterator() : new TreeIteratorDown();
    }

    public ForwardIterator keys() {
        return new TreeKeysIterator();
    }

    public ForwardIterator keys(boolean ascending) {
        return ascending ? new TreeKeysIterator() : new TreeKeysIteratorDown();
    }

    public Object[] getAllElements() {
        Object[] result = new Object[this.count];
        this.getAllValuesUp(result, this.root, 0);
        return result;
    }

    public Object[] getAllElements(boolean ascending) {
        Object[] result = new Object[this.count];
        if (ascending) {
            this.getAllValuesUp(result, this.root, 0);
        } else {
            this.getAllValuesDown(result, this.root, 0);
        }
        return result;
    }

    public Comparable[] getAllKeys() {
        Comparable[] result = new Comparable[this.count];
        this.getAllKeysUp(result, this.root, 0);
        return result;
    }

    public Comparable[] getAllKeys(boolean ascending) {
        Comparable[] result = new Comparable[this.count];
        if (ascending) {
            this.getAllKeysUp(result, this.root, 0);
        } else {
            this.getAllKeysDown(result, this.root, 0);
        }
        return result;
    }

    public SnapShotEnumeration elementsEnumeration() {
        return new ArrayEnumeration(this.getAllElements());
    }

    public SnapShotEnumeration elementsEnumeration(boolean ascending) {
        return new ArrayEnumeration(this.getAllElements(ascending));
    }

    public SnapShotEnumeration keysEnumeration() {
        return new ArrayEnumeration(this.getAllKeys());
    }

    public SnapShotEnumeration keysEnumeration(boolean ascending) {
        return new ArrayEnumeration(this.getAllKeys(ascending));
    }

    public void performOnElements(TreePerformer performer) {
        this.performOnValuesUp(performer, this.root);
    }

    public void performOnElements(TreePerformer performer, boolean ascending) {
        if (ascending) {
            this.performOnValuesUp(performer, this.root);
        } else {
            this.performOnValuesDown(performer, this.root);
        }
    }

    public void performOnKeys(TreePerformer performer) {
        this.performOnKeysUp(performer, this.root);
    }

    public void performOnKeys(TreePerformer performer, boolean ascending) {
        if (ascending) {
            this.performOnKeysUp(performer, this.root);
        } else {
            this.performOnKeysDown(performer, this.root);
        }
    }

    public Object min() {
        Wrapper result = (Wrapper)this.minItem();
        return result == null ? null : result.value;
    }

    public Object max() {
        Wrapper result = (Wrapper)this.maxItem();
        return result == null ? null : result.value;
    }

    public Comparable minKey() {
        Wrapper result = (Wrapper)this.minItem();
        return result == null ? null : result.getKey();
    }

    public Comparable maxKey() {
        Wrapper result = (Wrapper)this.maxItem();
        return result == null ? null : result.getKey();
    }

    public Object deepClone() {
        AVLTree tree = (AVLTree)this.getNewInstance();
        this.deepClone(tree, this.root);
        return tree;
    }

    public RootIterator elementsIterator() {
        return new TreeIterator();
    }

    public Pointer[] toPointerArray() {
        throw new NotSupportedException("Not Imeplemented.There is no reason to impement this method.");
    }

    public Object[] toArray() {
        return this.getAllElements();
    }

    protected void deepClone(BaseBinaryTree tree, BinTreeItem current) {
        if (current == null) {
            return;
        }
        tree.putItem(this.getWrapper((Comparable)((DeepCloneable)((Object)current.getKey())).deepClone(), ((DeepCloneable)((Wrapper)current).value).deepClone()));
        this.clone(tree, current.getLeft());
        this.clone(tree, current.getRight());
    }

    protected void clone(BaseBinaryTree tree, BinTreeItem current) {
        if (current == null) {
            return;
        }
        tree.putItem(this.getWrapper(current.getKey(), ((Wrapper)current).value));
        this.clone(tree, current.getLeft());
        this.clone(tree, current.getRight());
    }

    protected boolean performOnKeysUp(TreePerformer performer, BinTreeItem current) {
        if (current == null) {
            return false;
        }
        if (this.performOnKeysUp(performer, current.getLeft())) {
            return true;
        }
        if (performer.perform(current.getKey())) {
            return true;
        }
        return this.performOnKeysUp(performer, current.getRight());
    }

    protected boolean performOnKeysDown(TreePerformer performer, BinTreeItem current) {
        if (current == null) {
            return false;
        }
        if (this.performOnKeysDown(performer, current.getRight())) {
            return true;
        }
        if (performer.perform(current.getKey())) {
            return true;
        }
        return this.performOnKeysDown(performer, current.getLeft());
    }

    protected boolean performOnValuesUp(TreePerformer performer, BinTreeItem current) {
        if (current == null) {
            return false;
        }
        if (this.performOnValuesUp(performer, current.getLeft())) {
            return true;
        }
        if (performer.perform(((Wrapper)current).value)) {
            return true;
        }
        return this.performOnValuesUp(performer, current.getRight());
    }

    protected boolean performOnValuesDown(TreePerformer performer, BinTreeItem current) {
        if (current == null) {
            return false;
        }
        if (this.performOnValuesDown(performer, current.getRight())) {
            return true;
        }
        if (performer.perform(((Wrapper)current).value)) {
            return true;
        }
        return this.performOnValuesDown(performer, current.getLeft());
    }

    protected int getAllValuesDown(Object[] result, BinTreeItem current, int deep) {
        if (current == null) {
            return deep;
        }
        deep = this.getAllValuesDown(result, current.getRight(), deep);
        result[deep++] = ((Wrapper)current).value;
        deep = this.getAllValuesDown(result, current.getLeft(), deep);
        return deep;
    }

    protected int getAllValuesUp(Object[] result, BinTreeItem current, int deep) {
        if (current == null) {
            return deep;
        }
        deep = this.getAllValuesUp(result, current.getLeft(), deep);
        result[deep++] = ((Wrapper)current).value;
        deep = this.getAllValuesUp(result, current.getRight(), deep);
        return deep;
    }

    protected int getAllKeysDown(Comparable[] result, BinTreeItem current, int deep) {
        if (current == null) {
            return deep;
        }
        deep = this.getAllKeysDown(result, current.getRight(), deep);
        result[deep++] = current.getKey();
        deep = this.getAllKeysDown(result, current.getLeft(), deep);
        return deep;
    }

    protected int getAllKeysUp(Comparable[] result, BinTreeItem current, int deep) {
        if (current == null) {
            return deep;
        }
        deep = this.getAllKeysUp(result, current.getLeft(), deep);
        result[deep++] = current.getKey();
        deep = this.getAllKeysUp(result, current.getRight(), deep);
        return deep;
    }

    protected static class Wrapper
    extends AVLItemAdapter {
        protected Object value;

        public Wrapper() {
        }

        public Wrapper(Comparable key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + " = " + this.value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Wrapper)) {
                return false;
            }
            Wrapper tmp = (Wrapper)o;
            return this.value.equals(tmp.value) && this.key.compareTo(tmp.key) == 0;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 37 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        private void writeObject(ObjectOutputStream oos) throws NotSerializableException {
            try {
                oos.defaultWriteObject();
            }
            catch (IOException ioex) {
                throw new NotSerializableException("Cannot serialize class " + this.getClass().getName() + ". Error is " + ioex.toString());
            }
        }

        private void readObject(ObjectInputStream oos) throws NotSerializableException {
            try {
                oos.defaultReadObject();
            }
            catch (IOException ioex) {
                throw new NotSerializableException("Cannot deserialize class " + this.getClass().getName() + ". Error is " + ioex.toString());
            }
            catch (ClassNotFoundException cnfe) {
                throw new NotSerializableException("Cannot deserialize class " + this.getClass().getName() + ". Error is " + cnfe.toString());
            }
        }
    }

    protected class TreeKeysIteratorDown
    extends BaseBinaryTree.TreeIteratorDown {
        protected TreeKeysIteratorDown() {
            super(AVLTree.this);
        }

        public Object next() {
            return ((Wrapper)super.next()).getKey();
        }
    }

    protected class TreeKeysIterator
    extends BaseBinaryTree.TreeIterator {
        protected TreeKeysIterator() {
            super(AVLTree.this);
        }

        public Object next() {
            return ((Wrapper)super.next()).getKey();
        }
    }

    protected class TreeIteratorDown
    extends BaseBinaryTree.TreeIteratorDown {
        protected TreeIteratorDown() {
            super(AVLTree.this);
        }

        public boolean isChangeable() {
            return true;
        }

        public Object change(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            Object result = ((Wrapper)this.stack.top()).value;
            ((Wrapper)this.stack.top()).value = o;
            return result;
        }

        public Object next() {
            return ((Wrapper)super.next()).value;
        }
    }

    protected class TreeIterator
    extends BaseBinaryTree.TreeIterator {
        protected TreeIterator() {
            super(AVLTree.this);
        }

        public boolean isChangeable() {
            return true;
        }

        public Object change(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            Object result = ((Wrapper)this.stack.top()).value;
            ((Wrapper)this.stack.top()).value = o;
            return result;
        }

        public Object next() {
            return ((Wrapper)super.next()).value;
        }
    }
}

