/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl.sampleData;

import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.BIMdxObjectsFactory;
import com.sap.ip.bi.sdk.dac.olap.query.IBIQueryFactory;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBIDescendantsLevel;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBIMemberList;
import com.sap.ip.bi.sdk.dac.olap.query.tsx.IBITuple;
import com.sap.ip.bi.sdk.dac.olap.query.tsx.IBITupleList;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIJoinType;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIJoinTypeEnum;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.util.impl.sampleData.FoodMart2000Sales;
import java.util.Arrays;
import java.util.List;

public class QueryObjects {
    private final IBIOlap olap;
    private final FoodMart2000Sales foodMart;
    private final IBIQueryFactory factory;
    private final BIMdxObjectsFactory mdxFactory;
    private IBIMemberList memberListBachelorsGraduate = null;
    private IBITupleList tupleListGenderMBachelorsGraduate = null;
    private IBIDescendantsLevel descendantsLevel = null;

    QueryObjects(IBIOlap olap, FoodMart2000Sales foodMart) {
        this.olap = olap;
        this.foodMart = foodMart;
        this.factory = olap.getQueryFactory();
        this.mdxFactory = BIMdxObjectsFactory.createInstance();
    }

    public IBIMemberList getMemberListBachelorsGraduate() {
        if (this.memberListBachelorsGraduate == null) {
            try {
                List<Object> members = Arrays.asList(this.foodMart.getEducationLevel().getMemberBachelorsDegree(), this.foodMart.getEducationLevel().getMemberGraduateDegree());
                IBIMemberList iBIMemberList = this.factory.getMemberSetFactory().createMemberList(members, (IBIJoinType)IBIJoinTypeEnum.INITIAL);
            }
            catch (BIOlapQueryException bIOlapQueryException) {
                // empty catch block
            }
        }
        return this.memberListBachelorsGraduate;
    }

    public IBITupleList getTupleListGenderMBachelorsGraduate() {
        if (this.tupleListGenderMBachelorsGraduate == null) {
            try {
                IBITuple tuple0 = this.factory.getTupleSetFactory().createTuple(Arrays.asList(this.foodMart.getGender().getMemberM(), this.foodMart.getEducationLevel().getMemberBachelorsDegree()));
                IBITuple tuple1 = this.factory.getTupleSetFactory().createTuple(Arrays.asList(this.foodMart.getGender().getMemberM(), this.foodMart.getEducationLevel().getMemberGraduateDegree()));
                this.tupleListGenderMBachelorsGraduate = this.factory.getTupleSetFactory().createTupleList(Arrays.asList(tuple0, tuple1), (IBIJoinType)IBIJoinTypeEnum.INITIAL);
            }
            catch (BIOlapQueryException bIOlapQueryException) {
                // empty catch block
            }
        }
        return this.tupleListGenderMBachelorsGraduate;
    }

    public IBIDescendantsLevel getDescendantsLevel() {
        if (this.descendantsLevel == null) {
            // empty if block
        }
        return this.descendantsLevel;
    }
}

