/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

public class ServerRTCounter {
    public static final int SERVER_ROUNDTRIPS = 0;
    public static final int RESULT_BYTES = 1;
    public static final int NATIVE_TIME = 2;
    public static final int TIME_KEEPER = 3;
    public static final int MMR_INSTANCE = 4;
    private static final int max = 4;
    private static final long[] counter = new long[5];
    private static long timer = System.currentTimeMillis();
    private static final ServerRTCounter instance = new ServerRTCounter();

    public static ServerRTCounter getInstance() {
        return instance;
    }

    public void incrementCounter() {
        this.incrementCounter(0);
    }

    public void incrementCounter(int counter) {
        ServerRTCounter.assertCounter(counter);
        int n = counter;
        ServerRTCounter.counter[n] = ServerRTCounter.counter[n] + 1L;
    }

    public void addToCounter(int counter, long value) {
        ServerRTCounter.assertCounter(counter);
        int n = counter;
        ServerRTCounter.counter[n] = ServerRTCounter.counter[n] + value;
    }

    public void addValue(long value) {
        this.addToCounter(0, value);
    }

    public void resetCounter() {
        this.resetCounter(0);
        this.resetCounter(1);
        this.resetCounter(2);
        this.resetCounter(4);
    }

    public void resetCounter(int counter) {
        ServerRTCounter.assertCounter(counter);
        ServerRTCounter.counter[counter] = 0L;
    }

    public static void reset() {
        int i = 0;
        while (i < counter.length) {
            ServerRTCounter.counter[i] = 0L;
            ++i;
        }
    }

    public long getCounter() {
        return this.getCounter(0);
    }

    public long getCounter(int counter) {
        ServerRTCounter.assertCounter(counter);
        return ServerRTCounter.counter[counter];
    }

    public void setTimer() {
        timer = System.currentTimeMillis();
    }

    public long getTimer() {
        return System.currentTimeMillis() - timer;
    }

    public void addToTimer(int timer) {
        long diff = this.getTimer();
        this.setTimer();
        this.addToCounter(timer, diff);
    }

    private static void assertCounter(int counter) {
        if (counter < 0 || counter > 4) {
            throw new RuntimeException("invalid counter " + counter);
        }
    }
}

