/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class P4Sync {
    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Usage: P4Sync <root> <from> <to>");
            System.out.println("e.g.: P4Sync S:\\ 350_SP_COR dev");
            return;
        }
        P4Sync p4Sync = new P4Sync();
        List lines = p4Sync.opened(args[1]);
        p4Sync.sync(lines, args[0], args[1], args[2]);
    }

    private List opened(String from) {
        ArrayList<String> lines = new ArrayList<String>();
        Iterator i = P4Sync.execute("P4 opened", true).iterator();
        while (i.hasNext()) {
            String line = (String)i.next();
            if (line.indexOf(from) < 0) continue;
            lines.add(line);
        }
        return lines;
    }

    private void sync(List lines, String root, String from, String to) {
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            String line = i.next().toString();
            String fileName = this.getFileName(line);
            if (this.isAdd(line)) {
                this.copy(fileName, root, from, to);
                this.add(fileName, from, to);
                continue;
            }
            if (this.isEdit(line)) {
                this.edit(fileName, from, to);
                this.copy(fileName, root, from, to);
                continue;
            }
            if (!this.isDelete(line)) continue;
            this.delete(fileName, from, to);
        }
    }

    private void add(String fileName, String from, String to) {
        String command = "P4 add " + this.replace(fileName, from, to);
        P4Sync.execute(command, false);
    }

    private void edit(String fileName, String from, String to) {
        String command = "P4 edit " + this.replace(fileName, from, to);
        P4Sync.execute(command, false);
    }

    private void delete(String fileName, String from, String to) {
        String command = "P4 delete " + this.replace(fileName, from, to);
        P4Sync.execute(command, false);
    }

    private void copy(String fileName, String root, String from, String to) {
        String fromDosFileName = this.getQualifiedFileName(fileName, root);
        String toDosFileName = this.replace(fromDosFileName, from, to);
        toDosFileName = toDosFileName.substring(0, toDosFileName.lastIndexOf(92));
        String command = "xcopy " + fromDosFileName + " " + toDosFileName + " /T /Y /R";
        P4Sync.execute(command, false);
        command = "xcopy " + fromDosFileName + " " + toDosFileName + " /E /Y /R";
        P4Sync.execute(command, false);
    }

    private void setReadOnly(String fileName, String root, String from, String to) {
        String toDosFileName = this.replace(this.getQualifiedFileName(fileName, root), from, to);
        String command = "attrib +R " + toDosFileName;
        P4Sync.execute(command, false);
    }

    private boolean isAdd(String line) {
        int pos = line.indexOf(35);
        if (line.indexOf(35) >= 0) {
            return line.substring(pos).indexOf("add") >= 0;
        }
        return false;
    }

    private boolean isEdit(String line) {
        int pos = line.indexOf(35);
        if (line.indexOf(35) >= 0) {
            return line.substring(pos).indexOf("edit") >= 0;
        }
        return false;
    }

    private boolean isDelete(String line) {
        int pos = line.indexOf(35);
        if (line.indexOf(35) >= 0) {
            return line.substring(pos).indexOf("delete") >= 0;
        }
        return false;
    }

    private String getFileName(String line) {
        int pos = line.indexOf(35);
        if (line.indexOf(35) >= 0) {
            return line.substring(0, pos);
        }
        return null;
    }

    private String getQualifiedFileName(String fileName, String root) {
        String qualifiedFileName = (root.charAt(root.length() - 1) != '\\' ? root + "\\" : root) + fileName.substring(fileName.indexOf("//") + 2).replace('/', '\\');
        return qualifiedFileName;
    }

    /*
     * WARNING - void declaration
     */
    public static List execute(String cmd, boolean getResult) {
        ArrayList<void> list = new ArrayList<void>();
        try {
            String str;
            Process proc = Runtime.getRuntime().exec(cmd);
            InputStream istr = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(istr));
            while ((str = br.readLine()) != null) {
                void var6_7;
                list.add(var6_7);
            }
            try {
                proc.waitFor();
            }
            catch (InterruptedException e) {
                System.err.println("Process was interrupted");
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(cmd);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String line = (String)i.next();
            System.out.println(line);
        }
        return list;
    }

    private String replace(String original, String find, String replace) {
        StringBuffer buf = null;
        int pos = original.indexOf(find);
        if (pos >= 0) {
            buf = new StringBuffer();
            buf.append(original.substring(0, pos));
            buf.append(replace);
            buf.append(original.substring(pos + find.length()));
        }
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }
}

