/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BIXmlTag {
    private final String tagName;
    private final String quoteSymbol;
    private final boolean spacing;
    private final String lineBreakSymbol;
    private final String indentationSymbol;
    private List attributesList = null;
    private Map attributesMap = null;
    private List tagsList = null;
    private String value = null;

    public BIXmlTag(String tagName) {
        this.tagName = tagName;
        this.quoteSymbol = "\"";
        this.spacing = false;
        this.lineBreakSymbol = "\n";
        this.indentationSymbol = "  ";
    }

    public BIXmlTag(String tagName, String quoteSymbol, boolean spacing, String lineBreakSymbol, String indentationSymbol) {
        this.tagName = tagName;
        this.quoteSymbol = quoteSymbol;
        this.spacing = spacing;
        this.lineBreakSymbol = lineBreakSymbol;
        this.indentationSymbol = indentationSymbol;
    }

    public void addAttribute(String key, String value) {
        this.assertAttributeContainerExists();
        if (!this.attributesMap.containsKey(key)) {
            this.attributesList.add(key);
        }
        this.attributesMap.put(key, value);
    }

    public void addTag(BIXmlTag xmlTag) {
        this.assertTagContainerExists();
        this.tagsList.add(xmlTag);
    }

    public void addTagValue(String tagValue) {
        this.value = tagValue;
    }

    public String toXml() {
        return this.render(false, 0);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentation) {
        return this.render(true, indentation);
    }

    private String render(boolean formatting, int indentation) {
        Iterator i;
        StringBuffer xml = new StringBuffer();
        this.createIndentations(formatting, indentation, xml);
        xml.append("<");
        xml.append(this.tagName);
        if (this.attributesList != null && this.attributesList.size() > 0) {
            i = this.attributesList.iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                xml.append(" ");
                xml.append(key);
                xml.append(this.spacing ? " = " : "=");
                xml.append(this.quoteSymbol);
                xml.append((String)this.attributesMap.get(key));
                xml.append(this.quoteSymbol);
            }
        }
        if (this.tagsList != null && this.tagsList.size() > 0) {
            xml.append(">");
            i = this.tagsList.iterator();
            while (i.hasNext()) {
                if (formatting) {
                    xml.append(this.lineBreakSymbol);
                }
                BIXmlTag xmlTag = (BIXmlTag)i.next();
                if (formatting) {
                    xml.append(xmlTag.render(true, indentation + 1));
                    continue;
                }
                xml.append(xmlTag.toXml());
            }
            if (formatting) {
                xml.append(this.lineBreakSymbol);
            }
            this.createIndentations(formatting, indentation, xml);
            xml.append("</");
            xml.append(this.tagName);
            xml.append(">");
        } else if (this.value != null) {
            xml.append(">");
            xml.append(this.value);
            xml.append("</");
            xml.append(this.tagName);
            xml.append(">");
        } else {
            xml.append("/>");
        }
        return xml.toString();
    }

    private void createIndentations(boolean formatting, int indentation, StringBuffer xml) {
        if (formatting && indentation > 0) {
            int i = 0;
            while (i < indentation) {
                xml.append(this.indentationSymbol);
                ++i;
            }
        }
    }

    private void assertAttributeContainerExists() {
        if (this.attributesList == null) {
            this.attributesList = new ArrayList();
            this.attributesMap = new HashMap();
        }
    }

    private void assertTagContainerExists() {
        if (this.tagsList == null) {
            this.tagsList = new ArrayList();
        }
    }
}

