/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

public class BITakeTime {
    private long time = 0L;
    private long timeDivisor = 1L;
    private String startMessage = null;
    private String stopMessage = null;
    private String successMessage = null;
    private String failMessage = null;

    public BITakeTime(String startMessage, String stopMessage, String successMessage, String failMessage, long timeDivisor) {
        this.init(startMessage, stopMessage, successMessage, failMessage, timeDivisor == 0L ? 1L : timeDivisor);
    }

    public BITakeTime(String startMessage, String stopMessage, String successMessage, String failMessage) {
        this.init(startMessage, stopMessage, successMessage, failMessage, 1L);
    }

    public BITakeTime() {
        this.init(null, null, null, null, 1L);
    }

    private void init(String startMessage, String stopMessage, String successMessage, String failMessage, long timeDivisor) {
        this.startMessage = startMessage;
        this.stopMessage = stopMessage;
        this.successMessage = successMessage;
        this.failMessage = failMessage;
        this.timeDivisor = timeDivisor;
        if (this.startMessage != null) {
            System.out.print(this.startMessage);
        } else {
            System.out.print("Processing...");
        }
        this.time = System.currentTimeMillis();
    }

    public void stop(boolean successCondition) {
        this.stopKernl(successCondition, true);
    }

    public void stop() {
        this.stopKernl(false, false);
    }

    public void stopKernl(boolean succeeded, boolean successConditionProvided) {
        double printTime = (double)(System.currentTimeMillis() - this.time) / (double)this.timeDivisor;
        String stopMessageOutput = null;
        stopMessageOutput = this.stopMessage != null ? " " + this.stopMessage + ": " + printTime + " ms." : " done after " + printTime + " ms.";
        if (successConditionProvided) {
            System.out.print(stopMessageOutput);
            if (succeeded) {
                if (this.successMessage != null) {
                    System.out.println(" " + this.successMessage);
                } else {
                    System.out.println(" -> Success!");
                }
            } else if (this.failMessage != null) {
                System.out.println(" " + this.failMessage);
            } else {
                System.out.println(" -> Failed!");
            }
        } else {
            System.out.println(stopMessageOutput);
        }
    }
}

