/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import com.sap.ip.bi.sdk.exception.BIException;
import com.sap.ip.bi.sdk.util.impl.BIStringTemplate;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public final class BIStringTemplate {
    private HashMap variables = new HashMap(20);
    private final String template;
    private String variablePrefix = null;
    private String variableSuffix = null;

    private BIStringTemplate(String template, String variablePrefix, String variableSuffix) {
        this.template = template;
        this.variablePrefix = variablePrefix;
        this.variableSuffix = variableSuffix;
    }

    public static BIStringTemplate createInstance(String template) {
        return new BIStringTemplate(template, null, null);
    }

    public static BIStringTemplate createInstance(String template, String variablePrefix, String variableSuffix) {
        return new BIStringTemplate(template, variablePrefix, variableSuffix);
    }

    public void setVariable(String variableName, String variableValue) throws BIException {
        if (variableName == null || variableName.length() == 0) {
            throw new BIException(Locale.getDefault(), "sdk.util_1004", new Object[]{variableName});
        }
        if (this.template.indexOf(variableName) < 0) {
            throw new BIException(Locale.getDefault(), "sdk.util_1003", new Object[]{variableName});
        }
        this.variables.put(variableName, variableValue);
    }

    public String getVariable(String variableName) throws BIException {
        if (this.template.indexOf(variableName) < 0) {
            throw new BIException(Locale.getDefault(), "sdk.util_1003", new Object[]{variableName});
        }
        if (!this.variables.containsKey(variableName)) {
            throw new BIException(Locale.getDefault(), "sdk.util_1002", new Object[]{variableName});
        }
        return (String)this.variables.get(variableName);
    }

    public String getReplacedString() throws BIException {
        StringBuffer workString = new StringBuffer(this.template);
        Iterator keys = this.variables.keySet().iterator();
        class IndexesListStructure
        implements Comparable {
            public int startIndex;
            public int endIndex;
            public int correction;
            public String variableValue;
            private final /* synthetic */ BIStringTemplate this$0;

            IndexesListStructure(BIStringTemplate this$0, int startIndex, int endIndex, int correction, String variableValue) {
                this.this$0 = this$0;
                this.startIndex = 0;
                this.endIndex = 0;
                this.correction = 0;
                this.variableValue = null;
                this.startIndex = startIndex;
                this.endIndex = endIndex;
                this.correction = correction;
                this.variableValue = variableValue;
            }

            public int compareTo(Object object) throws ClassCastException {
                IndexesListStructure compareObject = null;
                compareObject = (IndexesListStructure)object;
                return this.startIndex - compareObject.startIndex;
            }
        }
        ArrayList<IndexesListStructure> indexesList = new ArrayList<IndexesListStructure>(this.template.length() * 2);
        while (keys.hasNext()) {
            String variableName = (String)keys.next();
            int i = 0;
            do {
                if ((i = this.template.indexOf(variableName, i)) < 0) continue;
                String variableValue = (String)this.variables.get(variableName);
                indexesList.add(new IndexesListStructure(this, i, i + variableName.length(), variableValue.length() - variableName.length(), variableValue));
                i += variableName.length();
            } while (i >= 0 && i < this.template.length());
        }
        Collections.sort(indexesList);
        Iterator indexesListKeys = ((AbstractList)indexesList).iterator();
        int correction = 0;
        while (indexesListKeys.hasNext()) {
            IndexesListStructure structure = (IndexesListStructure)indexesListKeys.next();
            workString.replace(structure.startIndex + correction, structure.endIndex + correction, structure.variableValue);
            correction += structure.correction;
        }
        if (this.variablePrefix == null || this.variableSuffix == null) {
            return workString.toString();
        }
        if (workString.toString().indexOf(this.variablePrefix) < 0 && workString.toString().indexOf(this.variableSuffix) < 0) {
            return workString.toString();
        }
        throw new BIException(Locale.getDefault(), "sdk.util_1001");
    }
}

