/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class BIStringMatcher {
    protected final String pattern;
    protected final boolean caseSensitive;
    protected final boolean patternHasWildcards;
    protected final String[] tokens;
    protected static final boolean RETURN_DELIMS = true;
    protected static final char SQL_WILDCARD_MULTIPLE = '%';
    protected static final char SQL_WILDCARD_SINGLE = '_';
    protected static final char SQL_WILDCARD_ESCAPE = '\\';
    protected static final char FILE_WILDCARD_MULTIPLE = '*';
    protected static final char FILE_WILDCARD_SINGLE = '?';
    protected static final char FILE_WILDCARD_ESCAPE = '\\';
    protected static final char WILDCARD_MULTIPLE = '*';
    protected static final char WILDCARD_SINGLE = '?';
    protected static final char WILDCARD_ESCAPE = '\\';
    public static final boolean IGNORE_CASE = false;
    public static final boolean CASE_SENSITIVE = true;
    protected final char[] wildcard;
    protected final String wildcards;
    public static final char[] FILE_WILDCARDS = new char[]{'*', '?', '\\'};
    public static final String FILE_MATCH_ALL = "*";
    public static final char[] SQL_WILDCARDS = new char[]{'%', '_', '\\'};
    public static final String SQL_MATCH_ALL = "%";

    public BIStringMatcher(String pattern, char[] wildcard, boolean caseSensitive) {
        this.wildcard = wildcard.length != 3 || wildcard[0] == wildcard[1] || wildcard[0] == wildcard[2] || wildcard[1] == wildcard[2] ? new char[]{'*', '?', '\\'} : wildcard;
        this.caseSensitive = caseSensitive;
        this.wildcards = "" + wildcard[0] + wildcard[1] + wildcard[2];
        if (pattern == null) {
            this.pattern = null;
            this.patternHasWildcards = false;
            this.tokens = new String[0];
        } else {
            this.patternHasWildcards = BIStringMatcher.patternHasWildcards(pattern, this.wildcard_multiple(), this.wildcard_single(), this.wildcard_escape());
            if (!this.patternHasWildcards) {
                pattern = BIStringMatcher.unescapePattern(pattern, this.wildcard_multiple(), this.wildcard_single(), this.wildcard_escape());
            }
            this.pattern = caseSensitive ? pattern : pattern.toLowerCase();
            this.tokens = this.getTokens();
        }
    }

    public BIStringMatcher(String pattern, boolean caseSensitive) {
        this(pattern, new char[]{'*', '?', '\\'}, caseSensitive);
    }

    public BIStringMatcher(String pattern) {
        this(pattern, new char[]{'*', '?', '\\'}, false);
    }

    public char[] getWildCards() {
        return this.wildcard;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isCaseSentive() {
        return this.caseSensitive;
    }

    public boolean match(String text) {
        if (text == null || this.pattern == null) {
            return this.pattern == text;
        }
        if (this.patternHasWildcards) {
            if (this.isMatchAll()) {
                return true;
            }
            return this.matchInternal(this.caseSensitive ? text : text.toLowerCase(), 0);
        }
        if (this.caseSensitive) {
            return text.equals(this.pattern);
        }
        return text.equalsIgnoreCase(this.pattern);
    }

    private boolean matchInternal(String text, int tokenIndex) {
        if (text == null) {
            return false;
        }
        if (this.tokens.length <= tokenIndex) {
            return text.length() == 0;
        }
        String token = this.tokens[tokenIndex];
        if (token.length() == 1 && this.wildcard_escape() == token.charAt(0)) {
            if (this.tokens.length > tokenIndex + 1) {
                if ((token = this.tokens[++tokenIndex]).charAt(0) == text.charAt(0)) {
                    return this.matchInternal(text.substring(1), tokenIndex + 1);
                }
                return false;
            }
            return text.length() == 1 && this.wildcard_escape() == text.charAt(0);
        }
        if (token.length() == 1 && this.wildcard_multiple() == token.charAt(0)) {
            if (this.tokens.length > tokenIndex + 1) {
                token = this.tokens[++tokenIndex];
                while (token.length() == 1 && this.wildcard_multiple() == token.charAt(0) || token.length() == 1 && this.wildcard_single() == token.charAt(0)) {
                    if (token.length() == 1 && this.wildcard_single() == token.charAt(0)) {
                        if (text.length() >= 1) {
                            text = text.substring(1);
                        } else {
                            return false;
                        }
                    }
                    if (this.tokens.length <= tokenIndex + 1) {
                        return true;
                    }
                    token = this.tokens[++tokenIndex];
                }
                int index = 0;
                index = text.indexOf(token, index);
                while (index >= 0) {
                    if (this.tokens.length > tokenIndex + 1) {
                        if (!this.matchInternal(text.substring(index + token.length()), tokenIndex + 1)) continue;
                        return true;
                    }
                    return text.length() == index + token.length();
                }
                return false;
            }
            return true;
        }
        if (token.length() == 1 && this.wildcard_single() == token.charAt(0)) {
            if (text.length() == 1) {
                if (this.tokens.length == tokenIndex + 1) {
                    return true;
                }
                int i = tokenIndex + 1;
                while (i < this.tokens.length) {
                    if (token.length() != 1 || this.wildcard_multiple() != token.charAt(0)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (text.length() > 1) {
                return this.matchInternal(text.substring(1), tokenIndex + 1);
            }
            return false;
        }
        if (text.indexOf(token) != 0) {
            return false;
        }
        if (this.tokens.length > tokenIndex + 1) {
            return this.matchInternal(text.substring(token.length()), tokenIndex + 1);
        }
        return text.length() == token.length();
    }

    public String toString() {
        int index = 0;
        StringBuffer out = new StringBuffer().append('[');
        String sep = "";
        while (this.tokens.length > index) {
            out.append(sep).append('[').append(this.tokens[index++]).append(']');
            sep = ", ";
        }
        out.append("]['").append(this.wildcard_multiple()).append("','").append(this.wildcard_single()).append("','").append(this.wildcard_escape()).append("']");
        return out.toString();
    }

    private String[] getTokens() {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(this.pattern, this.wildcards, true);
        while (token.hasMoreElements()) {
            list.add(token.nextToken());
        }
        return list.toArray(new String[0]);
    }

    private char wildcard_multiple() {
        return this.wildcard[0];
    }

    private char wildcard_single() {
        return this.wildcard[1];
    }

    private char wildcard_escape() {
        return this.wildcard[2];
    }

    public static boolean patternHasWildcards(String pattern, char[] wildcards) {
        BIStringMatcher.assertWildCards(wildcards);
        return BIStringMatcher.patternHasWildcards(pattern, wildcards[0], wildcards[1], wildcards[2]);
    }

    public static boolean patternHasWildcards(String pattern, char multipleWildcard, char singleWildcard, char escape) {
        BIStringMatcher.assertWildcards(multipleWildcard, singleWildcard, escape);
        if (pattern == null) {
            return false;
        }
        char[] chars = pattern.toCharArray();
        boolean escaped = false;
        int i = 0;
        while (i < chars.length) {
            if (escaped) {
                escaped = false;
            } else if (chars[i] == escape) {
                escaped = true;
            } else {
                if (chars[i] == multipleWildcard) {
                    return true;
                }
                if (chars[i] == singleWildcard) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static String unescapePattern(String pattern, char multipleWildcard, char singleWildcard, char escape) {
        if (pattern == null) {
            return null;
        }
        BIStringMatcher.assertWildcards(multipleWildcard, singleWildcard, escape);
        char[] chars = pattern.toCharArray();
        StringBuffer unescaped = new StringBuffer();
        boolean escaped = false;
        int i = 0;
        while (i < chars.length) {
            if (escaped) {
                escaped = false;
                unescaped.append(chars[i]);
            } else if (chars[i] == escape) {
                escaped = true;
            } else {
                unescaped.append(chars[i]);
            }
            ++i;
        }
        return unescaped.toString();
    }

    private boolean isMatchAll() {
        return this.pattern != null && this.pattern.length() == 1 && this.pattern.charAt(0) == this.wildcard_multiple();
    }

    protected static void assertWildCards(char[] wildcards) {
        if (wildcards == null || wildcards.length != 3) {
            throw new RuntimeException();
        }
        BIStringMatcher.assertWildcards(wildcards[0], wildcards[1], wildcards[2]);
    }

    protected static void assertWildcards(char multipleWildcard, char singleWildcard, char escape) {
        if (multipleWildcard == singleWildcard || multipleWildcard == escape || singleWildcard == escape) {
            throw new RuntimeException();
        }
    }
}

