/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;

public class BISqlOdboType {
    private static final String ODBO = "ODBO";
    private static final String SQL = "java.sql.Types";
    private static final int OLEDB_TYPE_EMPTY = 0;
    private static final int OLEDB_TYPE_NULL = 1;
    private static final int OLEDB_TYPE_I2 = 2;
    private static final int OLEDB_TYPE_I4 = 3;
    private static final int OLEDB_TYPE_R4 = 4;
    private static final int OLEDB_TYPE_R8 = 5;
    private static final int OLEDB_TYPE_CY = 6;
    private static final int OLEDB_TYPE_DATE = 7;
    private static final int OLEDB_TYPE_BSTR = 8;
    private static final int OLEDB_TYPE_IDISPATCH = 9;
    private static final int OLEDB_TYPE_ERROR = 10;
    private static final int OLEDB_TYPE_BOOL = 11;
    private static final int OLEDB_TYPE_VARIANT = 12;
    private static final int OLEDB_TYPE_IUNKNOWN = 13;
    private static final int OLEDB_TYPE_DECIMAL = 14;
    private static final int OLEDB_TYPE_I1 = 16;
    private static final int OLEDB_TYPE_UI1 = 17;
    private static final int OLEDB_TYPE_UI2 = 18;
    private static final int OLEDB_TYPE_UI4 = 19;
    private static final int OLEDB_TYPE_ARRAY = 8192;
    private static final int OLEDB_TYPE_BYREF = 16384;
    private static final int OLEDB_TYPE_I8 = 20;
    private static final int OLEDB_TYPE_UI8 = 21;
    private static final int OLEDB_TYPE_GUID = 72;
    private static final int OLEDB_TYPE_VECTOR = 4096;
    private static final int OLEDB_TYPE_FILETIME = 64;
    private static final int OLEDB_TYPE_RESERVED = 32768;
    private static final int OLEDB_TYPE_BYTES = 128;
    private static final int OLEDB_TYPE_STR = 129;
    private static final int OLEDB_TYPE_WSTR = 130;
    private static final int OLEDB_TYPE_NUMERIC = 131;
    private static final int OLEDB_TYPE_UDT = 132;
    private static final int OLEDB_TYPE_DBDATE = 133;
    private static final int OLEDB_TYPE_DBTIME = 134;
    private static final int OLEDB_TYPE_DBTIMESTAMP = 135;
    private static final int OLEDB_TYPE_HCHAPTER = 136;
    private static final int OLEDB_TYPE_PROPVARIANT = 138;
    private static final int OLEDB_TYPE_VARNUMERIC = 139;
    private static final IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    private BISqlOdboType() {
    }

    public static int getSqlTypeFromOleDB(int oledbTypeIndicator) {
        switch (oledbTypeIndicator) {
            case 128: {
                return -3;
            }
            case 11: {
                return -7;
            }
            case 16: 
            case 17: {
                return -6;
            }
            case 2: 
            case 18: {
                return 5;
            }
            case 3: 
            case 19: {
                return 4;
            }
            case 20: 
            case 21: {
                return -5;
            }
            case 6: {
                return 4;
            }
            case 8: 
            case 129: 
            case 130: {
                return 12;
            }
            case 12: {
                return -1;
            }
            case 133: {
                return 91;
            }
            case 134: {
                return 92;
            }
            case 135: {
                return 93;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 8;
            }
            case 1: {
                return 0;
            }
            case 14: {
                return 3;
            }
            case 131: 
            case 139: {
                return 2;
            }
        }
        throw new BIRuntimeException(connectionInfo.getLocale(), "sdk.dac.connector_1002", new Object[]{ODBO, new Integer(oledbTypeIndicator)});
    }
}

