/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;

public class BISqlAbapNumber {
    private static final String MINUS = "-";
    private static final String EMPTY = "";
    private static final String ZERO = "0";
    private static final IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    private BISqlAbapNumber() {
    }

    public static String getNumberFromAbapNumber(String number) {
        if (number == null) {
            return null;
        }
        if (number.equals(EMPTY)) {
            return ZERO;
        }
        if (number.endsWith(MINUS)) {
            byte[] data = number.getBytes();
            byte last = data[data.length - 1];
            int i = data.length - 2;
            while (i >= 0) {
                data[i + 1] = data[i];
                --i;
            }
            data[0] = last;
            return new String(data);
        }
        return number;
    }

    public static final void main(String[] args) {
        if (!"-1234".equals(BISqlAbapNumber.getNumberFromAbapNumber("1234-"))) {
            throw new RuntimeException("couldn't convert '1234-'");
        }
        if (!"-1.23".equals(BISqlAbapNumber.getNumberFromAbapNumber("1.23-"))) {
            throw new RuntimeException("couldn't convert '1.23-'");
        }
        System.out.println("OK");
    }
}

