/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

public class BISqlAbapDate {
    private static final int ABAP_DATE_LEN = 8;
    private static final int ABAP_YEAR_START = 0;
    private static final int ABAP_YEAR_END = 4;
    private static final int ABAP_MON_START = 4;
    private static final int ABAP_MON_END = 6;
    private static final int ABAP_DAY_START = 6;
    private static final int ABAP_DAY_END = 8;
    private static final int ABAP_TIME_LEN = 6;
    private static final int ABAP_HOUR_START = 0;
    private static final int ABAP_HOUR_END = 2;
    private static final int ABAP_MIN_START = 2;
    private static final int ABAP_MIN_END = 4;
    private static final int ABAP_SEC_START = 4;
    private static final int ABAP_SEC_END = 6;

    public static String convertDate(String abapDate) {
        String sqlDate = null;
        if (abapDate != null && abapDate.length() == 8) {
            sqlDate = abapDate.substring(0, 4) + '-' + abapDate.substring(4, 6) + '-' + abapDate.substring(6, 8);
        }
        return sqlDate;
    }

    public static String convertTime(String abapTime) {
        String sqlTime = null;
        if (abapTime != null && abapTime.length() == 6) {
            sqlTime = abapTime.substring(0, 2) + ':' + abapTime.substring(2, 4) + ':' + abapTime.substring(4, 6);
        }
        return sqlTime;
    }

    public static void main(String[] args) {
        String date = BISqlAbapDate.convertDate("12345678");
        if (!"1234-56-78".equals(date)) {
            throw new RuntimeException("1234-56-78 expected, but " + date + " found");
        }
        String time = BISqlAbapDate.convertTime("123456");
        if (!"12:34:56".equals(time)) {
            throw new RuntimeException("12:34:56 expected, but " + time + " found");
        }
        System.out.println("conversion OK");
    }
}

