/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import java.util.HashMap;
import java.util.Map;

public class BINumberRange {
    private final int startValue;
    private Map domains;
    private String[] intToString;

    public BINumberRange(int startValue) {
        this.startValue = startValue;
        this.domains = new HashMap();
        this.intToString = new String[50];
    }

    private String getStringFromInt(int key) {
        if (key >= this.intToString.length) {
            String[] newArray = new String[key + 1];
            System.arraycopy(this.intToString, 0, newArray, 0, this.intToString.length);
            this.intToString = newArray;
        }
        if (this.intToString[key] == null) {
            this.intToString[key] = String.valueOf(key);
        }
        return this.intToString[key];
    }

    public int getNext(String key) {
        if (!this.domains.containsKey(key)) {
            this.domains.put(key, new NumberRange(this.startValue));
        }
        int number = ((NumberRange)this.domains.get(key)).getNext();
        return number;
    }

    public int getCurrent(String key) {
        int number = !this.domains.containsKey(key) ? -1 : ((NumberRange)this.domains.get(key)).getCurrent();
        return number;
    }

    public int getNext(int key) {
        return this.getNext(this.getStringFromInt(key));
    }

    public int getCurrent(int key) {
        return this.getCurrent(this.getStringFromInt(key));
    }

    public void reset() {
        this.domains = new HashMap();
        this.intToString = new String[50];
    }

    private static final class NumberRange {
        private int startValue;
        private int index;

        public NumberRange(int startValue) {
            this.index = startValue;
        }

        public int getNext() {
            return this.index++;
        }

        public int getCurrent() {
            if (this.index == this.startValue) {
                return -1;
            }
            return this.index;
        }
    }
}

