/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import com.sap.ip.bi.sdk.dac.connector.IBIConnection;
import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.olap.query.assoc.AssocPackage;
import com.sap.ip.bi.sdk.dac.olap.query.impl.factory.BIQueryFactory;
import com.sap.ip.bi.sdk.dac.olap.query.input.InputPackage;
import com.sap.ip.bi.sdk.dac.olap.query.main.MainPackage;
import com.sap.ip.bi.sdk.dac.olap.query.member.MemberPackage;
import com.sap.ip.bi.sdk.dac.olap.query.msx.MsxPackage;
import com.sap.ip.bi.sdk.dac.olap.query.tsx.TsxPackage;
import com.sap.ip.bi.sdk.dac.olap.query.var.VarPackage;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.samples.Helpers;
import com.sap.ip.bi.sdk.samples.servlet.MinimalServletContainer;
import com.sap.ip.bi.sdk.util.impl.BIMmrClassPrefetch;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.jmi.reflect.RefPackage;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.omg.cwm.analysis.olap.OlapPackage;
import org.omg.cwm.objectmodel.core.CorePackage;
import org.omg.cwm.objectmodel.instance.InstancePackage;
import org.omg.cwm.resource.relational.RelationalPackage;

public class BIMMRClassLoader
extends HttpServlet {
    private IBIOlap olap = null;
    private static final String CONTENT_TYPE = "text/html";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long time = System.currentTimeMillis();
        response.setContentType(CONTENT_TYPE);
        PrintWriter out = response.getWriter();
        out.println(Helpers.getDocTypeDefinition());
        out.println("<html>");
        out.println("<head><title>BIMMRClassLoader</title>");
        out.println(Helpers.getStyleSheetDefinition());
        out.println("</head><body>");
        try {
            IBIConnection connection = Helpers.connectToODBODatasource(out);
            this.olap = connection.getOlap();
            this.loadMMRModelbyQuery();
        }
        catch (Exception e) {
            throw new BIRuntimeException(Locale.getDefault(), e);
        }
        time = System.currentTimeMillis() - time;
        out.println("<p>Done.Take for:" + time + "ms.</p>");
        out.println("</body>");
        out.println("</html>");
    }

    public void loadMMRModelbyQuery() throws BIOlapQueryException {
        BIQueryFactory factory = (BIQueryFactory)this.olap.getQueryFactory();
        BIMmrClassPrefetch.load((RefPackage)factory.getCorePackage(), false);
        BIMmrClassPrefetch.load((RefPackage)factory.getInstancePackage(), false);
        BIMmrClassPrefetch.load(factory.getCorePackage().refPackage("org.omg.cwm.resource.Relational"), false);
        BIMmrClassPrefetch.load((RefPackage)factory.getOlapPackage(), false);
        BIMmrClassPrefetch.load(factory.getCorePackage().refPackage("com.sap.ip.bi.sdk.dac.olap.query.assoc"), false);
        BIMmrClassPrefetch.load((RefPackage)factory.getInputPackage(), false);
        BIMmrClassPrefetch.load((RefPackage)factory.getMainPackage(), false);
        BIMmrClassPrefetch.load((RefPackage)factory.getMemberPackage(), false);
        BIMmrClassPrefetch.load((RefPackage)factory.getMsxPackage(), false);
        BIMmrClassPrefetch.load((RefPackage)factory.getTsxPackage(), false);
        BIMmrClassPrefetch.load((RefPackage)factory.getVarPackage(), false);
    }

    public void loadMMRModel() throws BIResourceException {
        RefPackage outermostPackage = this.olap.getTopLevelPackage();
        CorePackage corePackage = (CorePackage)outermostPackage.refOutermostPackage().refPackage("org.omg.cwm.objectmodel.Core");
        InstancePackage instancePackage = (InstancePackage)outermostPackage.refOutermostPackage().refPackage("org.omg.cwm.objectmodel.Instance");
        OlapPackage olapPackage = (OlapPackage)outermostPackage.refOutermostPackage().refPackage("org.omg.cwm.analysis.Olap");
        RelationalPackage relationalPackage = (RelationalPackage)outermostPackage.refOutermostPackage().refPackage("org.omg.cwm.resource.Relational");
        MainPackage queryMainPackage = (MainPackage)outermostPackage.refOutermostPackage().refPackage("com.sap.ip.bi.sdk.dac.olap.query.main");
        InputPackage queryInputPackage = (InputPackage)outermostPackage.refOutermostPackage().refPackage("com.sap.ip.bi.sdk.dac.olap.query.input");
        MemberPackage queryMemberPackage = (MemberPackage)outermostPackage.refOutermostPackage().refPackage("com.sap.ip.bi.sdk.dac.olap.query.member");
        MsxPackage queryMsxPackage = (MsxPackage)outermostPackage.refOutermostPackage().refPackage("com.sap.ip.bi.sdk.dac.olap.query.msx");
        TsxPackage queryTsxPackage = (TsxPackage)outermostPackage.refOutermostPackage().refPackage("com.sap.ip.bi.sdk.dac.olap.query.tsx");
        VarPackage queryVarPackage = (VarPackage)outermostPackage.refOutermostPackage().refPackage("com.sap.ip.bi.sdk.dac.olap.query.var");
        AssocPackage queryAssocPackage = (AssocPackage)outermostPackage.refOutermostPackage().refPackage("com.sap.ip.bi.sdk.dac.olap.query.assoc");
        BIMmrClassPrefetch.load((RefPackage)corePackage, false);
        BIMmrClassPrefetch.load((RefPackage)instancePackage, false);
        BIMmrClassPrefetch.load((RefPackage)relationalPackage, false);
        BIMmrClassPrefetch.load((RefPackage)olapPackage, false);
        BIMmrClassPrefetch.load((RefPackage)queryAssocPackage, false);
        BIMmrClassPrefetch.load((RefPackage)queryInputPackage, false);
        BIMmrClassPrefetch.load((RefPackage)queryMainPackage, false);
        BIMmrClassPrefetch.load((RefPackage)queryMemberPackage, false);
        BIMmrClassPrefetch.load((RefPackage)queryMsxPackage, false);
        BIMmrClassPrefetch.load((RefPackage)queryTsxPackage, false);
        BIMmrClassPrefetch.load((RefPackage)queryVarPackage, false);
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            MinimalServletContainer.executeServlet((Object)new BIMMRClassLoader(), args[0]);
        } else {
            MinimalServletContainer.executeServlet((Object)new BIMMRClassLoader(), System.out);
        }
    }
}

