/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import com.sap.ip.bi.sdk.dac.result.IBIAxisCursor;
import com.sap.ip.bi.sdk.dac.result.IBICursorColumn;
import com.sap.ip.bi.sdk.dac.result.IBIDataSet;
import com.sap.ip.bi.sdk.dac.result.IBIDimensionCursor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class BIDataSetToHtml {
    private static final String DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">";
    private static final String CSS = "<style type=\"text/css\">\n<!--\nh3 { font: 14pt arial, helvetica, sans-serif; font-weight: bold; color: #003366}\nh4 { font: 12pt arial, helvetica, sans-serif; font-weight: bold; color: #003366}\nhr { color: #003366; size: 1pt; align: left;}\nbody { font: 10pt arial, helvetica, sans-serif; background-color:#ffffff; margin:20px}\ntable { border: 1px solid #909cae; border-collapse: collapse}\ntd.headCaption { border: 1px solid #909cae; font: 9pt arial, helvetica, sans-serif; font-weight: bold; background-color:#ffffff; margin:20px; text-align:center}\ntd.headCenter { border: 1px solid #909cae; font: 9pt arial, helvetica, sans-serif; background-color:#c4d9e9; margin:20px; text-align:center}\ntd.headLeft { border: 1px solid #909cae; font: 9pt arial, helvetica, sans-serif; background-color:#c4d9e9; margin:20px; text-align:left}\ntd.headEmpty { border: 1px solid #909cae; font: 9pt arial, helvetica, sans-serif; background-color:#ffffff; margin:20px; text-align:left}\ntd.odd { border: 1px solid #909cae; font: 9pt arial, helvetica, sans-serif; background-color:#d4e2ee; margin:20px; text-align:right}\ntd.even { border: 1px solid #909cae; font: 9pt arial, helvetica, sans-serif; background-color:#eff6fb; margin:20px; text-align:right}\ntd.single { border: 1px solid #909cae; font: 9pt arial, helvetica, sans-serif; background-color:#eff6fb; margin:20px; text-align:left}\n.code { font-family: Courier, mono}\n--></style>";
    private StringBuffer content = null;
    private String memberText = IBICursorColumn.MEMBER_CAPTION.toString();
    private String cellText = IBICursorColumn.FORMATTED_VALUE.toString();

    public BIDataSetToHtml() {
        this.init();
    }

    public BIDataSetToHtml(IBICursorColumn memberText, IBICursorColumn cellText) {
        this.memberText = memberText.toString();
        this.cellText = cellText.toString();
        this.init();
    }

    private void init() {
        this.content = new StringBuffer();
    }

    public String getContent() {
        return this.content.toString();
    }

    public void flush(String fileName) {
        PrintStream out = null;
        if (fileName != null && fileName.length() > 0) {
            try {
                out = new PrintStream(new FileOutputStream(fileName));
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.getMessage());
            }
        } else {
            out = System.out;
        }
        out.print(this.content.toString());
        out.flush();
        out.close();
    }

    public void renderHtmlPage(IBIDataSet dataSet) throws Exception {
        this.docType();
        this.html(true);
        this.head(true);
        this.title("Result Set");
        this.css();
        this.head(false);
        this.body(true);
        this.renderHtmlTable(dataSet);
        this.body(false);
        this.html(false);
    }

    public void renderHtmlTable(IBIDataSet dataSet) throws Exception {
        List axisCursors = dataSet.getAxisCursor();
        this.table(700, 1, 0, 0, true);
        if (axisCursors.size() >= 2) {
            this.renderHtmlTable2Axes(dataSet);
        } else if (axisCursors.size() >= 1) {
            this.renderHtmlTable1Axis(dataSet);
        } else {
            this.renderHtmlTable1Cell(dataSet);
        }
        this.table(700, 1, 0, 0, false);
    }

    private void renderHtmlTable1Cell(IBIDataSet dataSet) throws Exception {
        this.tr(true);
        this.td(dataSet.getString(this.cellText), "single");
        this.tr(false);
    }

    private void renderHtmlTable1Axis(IBIDataSet dataSet) throws Exception {
        IBIAxisCursor columnCursor = dataSet.getAxisCursor(0);
        Iterator i = columnCursor.getDimensionCursor().iterator();
        while (i.hasNext()) {
            IBIDimensionCursor columnDimensionCursor = (IBIDimensionCursor)i.next();
            this.tr(true);
            this.td(columnDimensionCursor.getName(), "headCaption");
            columnCursor.beforeFirst();
            while (columnCursor.next()) {
                this.td(columnDimensionCursor.getString(this.memberText), "headCenter");
            }
            this.tr(false);
        }
        this.tr(true);
        this.td("&nbsp;", "headEmpty");
        columnCursor.beforeFirst();
        while (columnCursor.next()) {
            this.td(dataSet.getString(this.cellText), "even");
        }
        this.tr(false);
    }

    private void renderHtmlTable2Axes(IBIDataSet dataSet) throws Exception {
        IBIAxisCursor columnCursor = dataSet.getAxisCursor(0);
        IBIAxisCursor rowCursor = dataSet.getAxisCursor(1);
        int columnDimensionCount = 0;
        Iterator iterator = columnCursor.getDimensionCursor().iterator();
        while (iterator.hasNext()) {
            IBIDimensionCursor columnDimensionCursor = (IBIDimensionCursor)iterator.next();
            ++columnDimensionCount;
        }
        int rowDimensionCount = 0;
        Iterator iterator2 = rowCursor.getDimensionCursor().iterator();
        while (iterator2.hasNext()) {
            IBIDimensionCursor rowDimensionCursor = (IBIDimensionCursor)iterator2.next();
            ++rowDimensionCount;
        }
        int i = 0;
        Iterator iterator3 = columnCursor.getDimensionCursor().iterator();
        while (iterator3.hasNext()) {
            int j;
            IBIDimensionCursor columnDimensionCursor = (IBIDimensionCursor)iterator3.next();
            this.tr(true);
            if (i < columnDimensionCount - 1) {
                j = 0;
                while (j < rowDimensionCount - 1) {
                    this.td("&nbsp;", "headEmpty");
                    ++j;
                }
                this.td(columnDimensionCursor.getName(), "headCaption");
            } else {
                j = 0;
                Iterator iterator22 = rowCursor.getDimensionCursor().iterator();
                while (iterator22.hasNext()) {
                    IBIDimensionCursor rowDimensionCursor = (IBIDimensionCursor)iterator22.next();
                    if (j < rowDimensionCount - 1) {
                        this.td(rowDimensionCursor.getName(), "headCaption");
                    } else {
                        this.td(rowDimensionCursor.getName() + "&nbsp;\\&nbsp;" + columnDimensionCursor.getName(), "headCaption");
                    }
                    ++j;
                }
            }
            columnCursor.beforeFirst();
            while (columnCursor.next()) {
                this.td(columnDimensionCursor.getString(this.memberText), "headCenter");
            }
            this.tr(false);
            ++i;
        }
        i = 0;
        rowCursor.beforeFirst();
        while (rowCursor.next()) {
            this.tr(true);
            iterator3 = rowCursor.getDimensionCursor().iterator();
            while (iterator3.hasNext()) {
                IBIDimensionCursor rowDimensionCursor = (IBIDimensionCursor)iterator3.next();
                this.td(rowDimensionCursor.getString(this.memberText), "headLeft");
            }
            columnCursor.beforeFirst();
            while (columnCursor.next()) {
                this.td(dataSet.getString(this.cellText), (i & 1) == 0 ? "even" : "odd");
            }
            this.tr(false);
            ++i;
        }
    }

    public void docType() throws Exception {
        this.content.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
    }

    public void html(boolean start) throws Exception {
        if (start) {
            this.content.append("<html>\n");
        } else {
            this.content.append("</html>\n");
        }
    }

    public void head(boolean start) throws Exception {
        if (start) {
            this.content.append("<head>\n");
        } else {
            this.content.append("</head>\n");
        }
    }

    public void title(String title) throws Exception {
        this.content.append("<title>" + title + "</title>\n");
    }

    public void css() throws Exception {
        this.content.append(CSS);
    }

    public void body(boolean start) throws Exception {
        if (start) {
            this.content.append("<body>\n");
        } else {
            this.content.append("</body>\n");
        }
    }

    public void table(boolean start) throws Exception {
        if (start) {
            this.content.append("<table>\n");
        } else {
            this.content.append("</table>\n");
        }
    }

    public void table(int width, int border, int cellpadding, int cellspacing, boolean start) throws Exception {
        if (start) {
            this.content.append("<table");
            this.content.append(" width=" + width);
            this.content.append(" border=" + border);
            this.content.append(" cellpadding=" + cellpadding);
            this.content.append(" cellspacing=" + cellspacing);
            this.content.append(">\n");
        } else {
            this.content.append("</table>\n");
        }
    }

    public void tr(boolean start) throws Exception {
        if (start) {
            this.content.append("<tr>");
        } else {
            this.content.append("</tr>\n");
        }
    }

    public void td(String data) throws Exception {
        this.td(data, null);
    }

    public void td(String data, String clazz) throws Exception {
        this.td(data, clazz, true);
        this.td(data, clazz, false);
    }

    public void td(String data, String clazz, boolean start) throws Exception {
        if (start) {
            this.content.append("<td");
            this.content.append(clazz != null ? " class=\"" + clazz + "\"" : "");
            this.content.append(">");
            this.content.append(data != null ? data : "");
        } else {
            this.content.append("</td>");
        }
    }
}

