/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.samples.jdbc;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.exception.BIException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.impl.BIResourceProperties;
import com.sap.ip.bi.sdk.util.impl.BIStringTemplate;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Properties;

public class Samples {
    private static final String DRIVER = "DriverName";
    private static final String URL = "URL";
    private static final String USER = "UserName";
    private static final String PASSWORD = "Password";
    private static final String CLIENT = "client";
    private static final String PREFIX = "prefix";
    private static final String DROP_TABLES = "drop-tables";
    private static final String DELETE_DATA = "delete-data";
    private static final String PRE = "<<";
    private static final String SUF = "<<";
    private static final String VARIABLE = "<<prefix<<";
    private static final int CUSTOMERS = 0;
    private static final int GEOCITY = 1;
    private static final int CARRIERS = 2;
    private static final int PLANFLI = 3;
    private static final int ACTFLI = 4;
    private static final int BOOKINGS = 5;
    private static final String[] tableNames = new String[]{"<<prefix<<CUSTOMERS", "<<prefix<<GEOCITY", "<<prefix<<CARRIERS", "<<prefix<<PLANFLI", "<<prefix<<ACTFLI", "<<prefix<<BOOKINGS", null};
    private static final String[] dropTable = new String[]{"DROP TABLE <<prefix<<CUSTOMERS", "DROP TABLE <<prefix<<GEOCITY", "DROP TABLE <<prefix<<CARRIERS", "DROP TABLE <<prefix<<PLANFLI", "DROP TABLE <<prefix<<ACTFLI", "DROP TABLE <<prefix<<BOOKINGS", null};
    private static final String[][] createTable = new String[][]{{"CREATE TABLE <<prefix<<CUSTOMERS (", "  MANDT VARCHAR(3) DEFAULT '000' NOT NULL,", "  ID VARCHAR(8) DEFAULT '00000000' NOT NULL,", "  NAME VARCHAR(25) DEFAULT ' ' NOT NULL,", "  POSTCODE VARCHAR(10) DEFAULT ' ' NOT NULL,", "  CITY VARCHAR(25) DEFAULT ' ' NOT NULL,", "  CUSTTYPE VARCHAR(1) DEFAULT ' ' NOT NULL,", "  DISCOUNT VARCHAR(3) DEFAULT '000' NOT NULL,", "  TELEPHONE VARCHAR(30) DEFAULT ' ' NOT NULL,", "  PRIMARY KEY(MANDT, ID))"}, {"CREATE TABLE <<prefix<<GEOCITY (", "  MANDT VARCHAR(3)  DEFAULT '000' NOT NULL,", "  CITY VARCHAR(20) DEFAULT ' ' NOT NULL,", "  LONGITUDE FLOAT DEFAULT 0.0E+0 NOT NULL,", "  LATITUDE  FLOAT DEFAULT 0.0E+0, ", "  PRIMARY KEY(MANDT, CITY))"}, {"CREATE TABLE <<prefix<<CARRIERS (", "  MANDT VARCHAR(3)  DEFAULT '000' NOT NULL,", "  CARRID VARCHAR(3) DEFAULT ' ' NOT NULL,", "  CARRNAME VARCHAR(20) DEFAULT ' ' NOT NULL,", "  CURRCODE VARCHAR(5) DEFAULT ' ' NOT NULL,", "  PRIMARY KEY(MANDT, CARRID))"}, {"CREATE TABLE <<prefix<<PLANFLI (", "  MANDT VARCHAR(3)  DEFAULT '000' NOT NULL,", "  CARRID VARCHAR(3) DEFAULT ' ' NOT NULL,", "  CONNID VARCHAR(4) DEFAULT '0000' NOT NULL,", "  CITYFROM VARCHAR(20) DEFAULT ' ' NOT NULL,", "  AIRPFROM VARCHAR(3) DEFAULT ' ' NOT NULL,", "  CITYTO VARCHAR(20) DEFAULT ' ' NOT NULL,", "  AIRPTO VARCHAR(3) DEFAULT ' ' NOT NULL,", "  FLTIME NUMERIC(10) DEFAULT 0 NOT NULL,", "  DEPTIME VARCHAR(6) DEFAULT '000000' NOT NULL,", "  ARRTIME VARCHAR(6) DEFAULT '000000' NOT NULL,", "  DISTANCE DECIMAL(9,4) DEFAULT 0.0 NOT NULL,", "  DISTID VARCHAR(3) DEFAULT ' ' NOT NULL,", "  PRIMARY KEY(MANDT, CARRID, CONNID))"}, {"CREATE TABLE <<prefix<<ACTFLI (", "  MANDT VARCHAR(3) DEFAULT '000' NOT NULL,", "  CARRID VARCHAR(3) DEFAULT ' ' NOT NULL,", "  CONNID VARCHAR(4) DEFAULT '0000' NOT NULL,", "  FLDATE VARCHAR(8) DEFAULT '00000000' NOT NULL,", "  PRICE  DECIMAL(15,2) DEFAULT 0.0 NOT NULL,", "  CURRENCY VARCHAR(5) DEFAULT ' ' NOT NULL,", "  PLANETYPE VARCHAR(10) DEFAULT ' ' NOT NULL,", "  SEATSMAX DECIMAL(10) DEFAULT 0 NOT NULL,", "  SEATSOCC DECIMAL(10) DEFAULT 0 NOT NULL,", "  PAYMENTSUM DECIMAL(17,2) DEFAULT 0.0 NOT NULL,", "  PRIMARY KEY(MANDT,CARRID, CONNID, FLDATE))"}, {"CREATE TABLE <<prefix<<BOOKINGS (", "  MANDT VARCHAR(3) DEFAULT '000' NOT NULL,", "  CARRID VARCHAR(3) DEFAULT ' ' NOT NULL,", "  CONNID VARCHAR(4) DEFAULT '0000' NOT NULL,", "  FLDATE VARCHAR(8) DEFAULT '00000000' NOT NULL,", "  BOOKID VARCHAR(8) DEFAULT '00000000' NOT NULL,", "  CUSTOMID VARCHAR(8) DEFAULT '00000000' NOT NULL,", "  CUSTTYPE VARCHAR(1) DEFAULT ' ' NOT NULL,", "  SMOKER VARCHAR(1) DEFAULT ' ' NOT NULL,", "  LUGGWEIGHT DECIMAL(8,4) DEFAULT 0.0 NOT NULL,", "  WUNIT VARCHAR(3) DEFAULT ' ' NOT NULL,", "  INVOICE VARCHAR(1) DEFAULT ' ' NOT NULL,", "  CLASS VARCHAR(1) DEFAULT ' ' NOT NULL,", "  FORCURAM DECIMAL(15,2) DEFAULT 0.0 NOT NULL,", "  FORCURKEY VARCHAR(5) DEFAULT  ' ' NOT NULL,", "  LOCCURAM DECIMAL(15,2) DEFAULT 0.0 NOT NULL,", "  ORDER_DATE VARCHAR(8) DEFAULT '00000000' NOT NULL,", "  PRIMARY KEY(MANDT,CARRID, CONNID, FLDATE, BOOKID))"}};
    private static final String[] deleteData = new String[]{"DELETE FROM <<prefix<<CUSTOMERS", "DELETE FROM <<prefix<<GEOCITY", "DELETE FROM <<prefix<<CARRIERS", "DELETE FROM <<prefix<<PLANFLI", "DELETE FROM <<prefix<<ACTFLI", "DELETE FROM <<prefix<<BOOKINGS"};
    private static final String[] insertData = new String[]{"INSERT INTO <<prefix<<CUSTOMERS (MANDT, ID, NAME, CITY, TELEPHONE) VALUES (?,?,?,?,?)", "INSERT INTO <<prefix<<GEOCITY (MANDT, CITY, LONGITUDE, LATITUDE) VALUES (?,?,?,?)", "INSERT INTO <<prefix<<CARRIERS (MANDT, CARRID, CARRNAME, CURRCODE) VALUES (?,?,?,?)", "INSERT INTO <<prefix<<PLANFLI (MANDT, CARRID, CONNID, CITYFROM, CITYTO, FLTIME, DEPTIME) VALUES (?,?,?,?,?,?,?)", "INSERT INTO <<prefix<<ACTFLI (MANDT, CARRID, CONNID, FLDATE, PRICE, CURRENCY, SEATSOCC) VALUES (?,?,?,?,?,?,?)", "INSERT INTO <<prefix<<BOOKINGS (MANDT, CARRID, CONNID, FLDATE, BOOKID, CUSTOMID, ORDER_DATE) VALUES (?,?,?,?,?,?,?)"};
    private static final Object[][][] tableData = new Object[][][]{{{"00000001", "Edwards", "Small Town", "654-321-1234"}, {"00000002", "Young", "Village", "333-444-2222"}, {"00000017", "Smith", "Big City", "717-161-5151"}, {"87654321", "Edison", "Market Place", "111-111-1111"}}, {{"Frankfurt", new Integer(10), new Integer(50)}, {"Madrid", new Integer(1), new Integer(35)}, {"Moscow", new Integer(30), new Integer(58)}, {"Paris", new Integer(5), new Integer(48)}}, {{"ABC", "ABC Airlines", "USD"}, {"AL ", "ALITALIA", "ITL"}, {"XYZ", "XYZ Flights", "DEM"}}, {{"ABC", "1000", "Frankfurt", "Paris", "1", "081000"}, {"ABC", "1234", "Paris", "Frankfurt", "1", "175500"}, {"XYZ", "0006", "Madrid", "Moscow", "5", "163000"}, {"XYZ", "0007", "Frankfurt", "Madrid", "3", "093500"}}, {{"ABC", "1000", "19991230", "200", "DEM", "110"}, {"ABC", "1234", "19991230", "500", "DEM", "010"}, {"ABC", "1234", "19991231", "300", "DEM", "020"}, {"XYZ", "0006", "19990606", "100", "USD", "175"}, {"XYZ", "0007", "19990505", "110", "USD", "133"}}, {{"ABC", "1000", "19991230", "001", "00000017", "19990101"}, {"ABC", "1234", "19991230", "002", "00000002", "19991229"}, {"ABC", "1234", "19991231", "005", "00000017", "19990101"}, {"XYZ", "0006", "19990606", "008", "00000001", "19990101"}, {"XYZ", "0007", "19990505", "007", "87654321", "19990101"}}};
    private static Connection jdbc = null;
    private static Properties props = null;
    private static String driver = null;
    private static String url = null;
    private static String prefix = null;
    private static String drop = null;
    private static String delete = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$samples$jdbc$Samples;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$samples$Helpers;

    private Samples() {
    }

    public static void setup() throws SQLException {
        Samples.setupProperties();
        Samples.connect();
        if (!Samples.alreadyDone()) {
            Samples.dropTables();
            Samples.createTables();
            Samples.deleteData();
            Samples.insertData();
        }
    }

    public static void main(String[] args) {
        try {
            Samples.setup();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new BIRuntimeException(IBIConnectionInfo.DEFAULT.getLocale(), "sdk_0000", new Object[]{ex.getMessage()});
        }
    }

    private static void connect() throws SQLException {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException("Class " + driver + " not found:" + ex.getMessage());
        }
        jdbc = DriverManager.getConnection(url, props);
    }

    private static void dropTables() throws SQLException {
        Samples.assertConnected();
        Statement stmt = jdbc.createStatement();
        if (Samples.dropExistingTables()) {
            int i = 0;
            while (dropTable[i] != null) {
                block7: {
                    try {
                        if (prefix != null) {
                            try {
                                BIStringTemplate template = BIStringTemplate.createInstance(dropTable[i], "<<", ">>");
                                template.setVariable(VARIABLE, prefix);
                                stmt.execute(template.getReplacedString());
                                break block7;
                            }
                            catch (BIException ex) {
                                throw new BIRuntimeException(Locale.getDefault(), "sdk_0000", (Throwable)((Object)ex));
                            }
                        }
                        stmt.execute(dropTable[i]);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    private static void createTables() throws SQLException {
        Samples.assertConnected();
        Statement stmt = jdbc.createStatement();
        int i = 0;
        while (i < createTable.length) {
            StringBuffer sql = new StringBuffer();
            int j = 0;
            while (j < createTable[i].length) {
                if (prefix != null) {
                    try {
                        BIStringTemplate template = BIStringTemplate.createInstance(createTable[i][j], "<<", ">>");
                        template.setVariable(VARIABLE, prefix);
                        sql.append(template.getReplacedString());
                    }
                    catch (BIException ex) {
                        sql.append(createTable[i][j]);
                    }
                } else {
                    sql.append(createTable[i][j]);
                }
                ++j;
            }
            stmt.execute(sql.toString());
            ++i;
        }
    }

    private static void insertData() throws SQLException {
        Samples.assertConnected();
        if (Samples.deleteExistingData() || Samples.dropExistingTables()) {
            int i = 0;
            while (i < insertData.length) {
                PreparedStatement stmt;
                if (prefix != null) {
                    try {
                        BIStringTemplate template = BIStringTemplate.createInstance(insertData[i], "<<", ">>");
                        template.setVariable(VARIABLE, prefix);
                        stmt = jdbc.prepareStatement(template.getReplacedString());
                    }
                    catch (BIException ex) {
                        stmt = jdbc.prepareStatement(insertData[i]);
                    }
                } else {
                    stmt = jdbc.prepareStatement(insertData[i]);
                }
                int j = 0;
                while (j < tableData[i].length) {
                    stmt.setString(1, props.getProperty(CLIENT));
                    int k = 0;
                    while (k < tableData[i][j].length) {
                        if (tableData[i][j][k] instanceof Integer) {
                            stmt.setInt(k + 2, (Integer)tableData[i][j][k]);
                        } else {
                            stmt.setString(k + 2, (String)tableData[i][j][k]);
                        }
                        ++k;
                    }
                    stmt.executeUpdate();
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void deleteData() throws SQLException {
        Samples.assertConnected();
        Statement stmt = jdbc.createStatement();
        if (Samples.deleteExistingData()) {
            int i = 0;
            while (i < deleteData.length) {
                if (prefix != null) {
                    try {
                        BIStringTemplate template = BIStringTemplate.createInstance(deleteData[i], "<<", ">>");
                        template.setVariable(VARIABLE, prefix);
                        stmt.execute(template.getReplacedString());
                    }
                    catch (BIException ex) {
                        stmt.execute(deleteData[i]);
                    }
                } else {
                    stmt.execute(deleteData[i]);
                }
                ++i;
            }
        }
    }

    private static boolean alreadyDone() throws SQLException {
        Samples.assertConnected();
        DatabaseMetaData meta = jdbc.getMetaData();
        int i = 0;
        while (i < tableNames.length) {
            String tabName;
            try {
                BIStringTemplate template = BIStringTemplate.createInstance(tableNames[i], "<<", ">>");
                template.setVariable(VARIABLE, prefix != null ? prefix : "");
                tabName = template.getReplacedString();
            }
            catch (BIException ex) {
                tabName = tableNames[i];
            }
            ResultSet r = meta.getTables(null, null, tabName, null);
            if (r.next()) {
                if (!tableNames[i].equalsIgnoreCase(r.getString("TABLE_NAME"))) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getJDBCTablePrefix() {
        Samples.assertPropertiesLoaded();
        return props.getProperty(PREFIX);
    }

    private static void setupProperties() {
        BIResourceProperties p = new BIResourceProperties(class$com$sap$ip$bi$sdk$samples$jdbc$Samples == null ? (class$com$sap$ip$bi$sdk$samples$jdbc$Samples = Samples.class$("com.sap.ip.bi.sdk.samples.jdbc.Samples")) : class$com$sap$ip$bi$sdk$samples$jdbc$Samples);
        p = new BIResourceProperties(class$com$sap$ip$bi$sdk$samples$Helpers == null ? (class$com$sap$ip$bi$sdk$samples$Helpers = Samples.class$("com.sap.ip.bi.sdk.samples.Helpers")) : class$com$sap$ip$bi$sdk$samples$Helpers, p, ".jdbc");
        props = p;
        driver = p.getProperty(DRIVER);
        url = p.getProperty(URL);
        prefix = p.getProperty(PREFIX);
        drop = p.getProperty(DROP_TABLES);
        delete = p.getProperty(DELETE_DATA);
        p.setProperty("user", p.getProperty(USER));
        p.setProperty("password", p.getProperty(PASSWORD));
    }

    private static void assertPropertiesLoaded() {
        if (props == null) {
            Samples.setupProperties();
        }
    }

    private static void assertConnected() {
        Samples.assertPropertiesLoaded();
        if (jdbc == null) {
            throw new BIRuntimeException(IBIConnectionInfo.DEFAULT.getLocale(), "sdk.dac.connector_1101");
        }
    }

    private static boolean dropExistingTables() {
        return Samples.booleanProperty(drop);
    }

    private static boolean deleteExistingData() {
        return Samples.booleanProperty(delete);
    }

    private static boolean booleanProperty(String prop) {
        return prop != null && (prop.equalsIgnoreCase("yes") || prop.equalsIgnoreCase("true"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

