/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.samples;

import com.sap.ip.bi.sdk.dac.connector.IBIConnection;
import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.olap.query.IBIMemberFactory;
import com.sap.ip.bi.sdk.dac.olap.query.impl.factory.BIQueryFactory;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIQuery;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.dac.result.IBIDataSet;
import com.sap.ip.bi.sdk.dac.result.IBIDimensionCursor;
import com.sap.ip.bi.sdk.dac.result.model.BIDataSetTableModel;
import com.sap.ip.bi.sdk.dac.result.model.BITableItem;
import com.sap.ip.bi.sdk.exception.BIException;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BISQLException;
import com.sap.ip.bi.sdk.samples.jdbc.Samples;
import com.sap.ip.bi.sdk.util.impl.BIResourceProperties;
import com.sapportals.connector.connection.IConnectionFactory;
import com.sapportals.connector.connection.IConnectionSpec;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.resource.spi.ManagedConnectionFactory;
import org.omg.cwm.analysis.olap.Cube;
import org.omg.cwm.analysis.olap.CubeDimensionAssociation;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.objectmodel.core.Attribute;

public class Helpers {
    private static final String DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">";
    private static final String CSS = "<style type=\"text/css\">\n<!--\nh3 { font: 14pt arial, helvetica, sans-serif; font-weight: bold; color: #003366}\nh4 { font: 12pt arial, helvetica, sans-serif; font-weight: bold; color: #003366}\nhr { color: #003366; size: 1pt; align: left;}\nbody { font: 10pt arial, helvetica, sans-serif; background-color:#ffffff; margin:20px}\ntable { border: 1px solid #909cae; border-collapse: collapse}\ntd.headCenter { border: 1px solid #909cae; font: 9pt arial, helvetica, sans-serif; background-color:#c4d9e9; margin:20px; text-align:center}\ntd.headLeft { border: 1px solid #909cae; font: 9pt arial, helvetica, sans-serif; background-color:#c4d9e9; margin:20px; text-align:left}\ntd.odd { border: 1px solid #909cae; font: 9pt arial, helvetica, sans-serif; background-color:#d4e2ee; margin:20px; text-align:center}\ntd.even { border: 1px solid #909cae; font: 9pt arial, helvetica, sans-serif; background-color:#eff6fb; margin:20px; text-align:center}\ntd.single { border: 1px solid #909cae; font: 9pt arial, helvetica, sans-serif; background-color:#eff6fb; margin:20px; text-align:left}\n.code { font-family: Courier, mono}\n--></style>";
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$samples$Helpers;

    private Helpers() {
    }

    public static IBIConnection connectToXMLADatasource(PrintWriter out) throws BIResourceException {
        IConnectionFactory cf = null;
        IConnectionSpec cs = null;
        IBIConnection connection = null;
        try {
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)Class.forName("com.sap.ip.bi.sdk.dac.connector.xmla.XmlaManagedConnectionFactory").newInstance();
            cf = (IConnectionFactory)mcf.createConnectionFactory();
            cs = cf.getConnectionSpec();
        }
        catch (Exception e) {
            throw new BIResourceException(Locale.getDefault(), "sdk.samples_1210", e);
        }
        BIResourceProperties props = new BIResourceProperties(class$com$sap$ip$bi$sdk$samples$Helpers == null ? (class$com$sap$ip$bi$sdk$samples$Helpers = Helpers.class$("com.sap.ip.bi.sdk.samples.Helpers")) : class$com$sap$ip$bi$sdk$samples$Helpers, ".xmla");
        Enumeration<?> propnames = props.propertyNames();
        while (propnames.hasMoreElements()) {
            String key = (String)propnames.nextElement();
            cs.setPropertyValue(key, (Object)props.getProperty(key));
        }
        try {
            connection = (IBIConnection)cf.getConnectionEx(cs);
        }
        catch (Exception e) {
            throw new BIResourceException(Locale.getDefault(), "sdk.samples_1100", e);
        }
        return connection;
    }

    public static SampleMetaDataBW getSampleMetaDataBW(IBIConnection connection) throws Exception {
        return new SampleMetaDataBW(connection);
    }

    public static IBIConnection connectToODBODatasource(PrintWriter out) throws BIResourceException {
        IConnectionFactory cf = null;
        IConnectionSpec cs = null;
        IBIConnection connection = null;
        try {
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)Class.forName("com.sap.ip.bi.sdk.dac.connector.odbo.OdboManagedConnectionFactory").newInstance();
            cf = (IConnectionFactory)mcf.createConnectionFactory();
            cs = cf.getConnectionSpec();
        }
        catch (Exception e) {
            throw new BIResourceException(Locale.getDefault(), "sdk.samples_1230", e);
        }
        BIResourceProperties props = new BIResourceProperties(class$com$sap$ip$bi$sdk$samples$Helpers == null ? (class$com$sap$ip$bi$sdk$samples$Helpers = Helpers.class$("com.sap.ip.bi.sdk.samples.Helpers")) : class$com$sap$ip$bi$sdk$samples$Helpers, ".odbo");
        Enumeration<?> propnames = props.propertyNames();
        while (propnames.hasMoreElements()) {
            String key = (String)propnames.nextElement();
            cs.setPropertyValue(key, (Object)props.getProperty(key));
        }
        try {
            connection = (IBIConnection)cf.getConnectionEx(cs);
        }
        catch (Exception e) {
            throw new BIResourceException(Locale.getDefault(), "sdk.samples_1110", e);
        }
        return connection;
    }

    public static IBIConnection connectToJDBCDatasource(PrintWriter out) throws BIResourceException {
        IConnectionFactory cf = null;
        IConnectionSpec cs = null;
        IBIConnection connection = null;
        try {
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)Class.forName("com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcManagedConnectionFactory").newInstance();
            cf = (IConnectionFactory)mcf.createConnectionFactory();
            cs = cf.getConnectionSpec();
        }
        catch (Exception e) {
            throw new BIResourceException(Locale.getDefault(), "sdk.samples_1200", e);
        }
        BIResourceProperties props = new BIResourceProperties(class$com$sap$ip$bi$sdk$samples$Helpers == null ? (class$com$sap$ip$bi$sdk$samples$Helpers = Helpers.class$("com.sap.ip.bi.sdk.samples.Helpers")) : class$com$sap$ip$bi$sdk$samples$Helpers, ".jdbc");
        Enumeration<?> propnames = props.propertyNames();
        while (propnames.hasMoreElements()) {
            String key = (String)propnames.nextElement();
            cs.setPropertyValue(key, (Object)props.getProperty(key));
        }
        try {
            connection = (IBIConnection)cf.getConnectionEx(cs);
        }
        catch (Exception e) {
            throw new BIResourceException(Locale.getDefault(), "sdk.samples_1120", e);
        }
        return connection;
    }

    public static void createJDBCSampleData() throws BIResourceException {
        try {
            Samples.setup();
        }
        catch (SQLException ex) {
            throw new BIResourceException(Locale.getDefault(), "sdk_0000", new Object[]{ex.getMessage()});
        }
    }

    public static String getJDBCTablePrefix() {
        return Samples.getJDBCTablePrefix();
    }

    public static IBIConnection connectToSAPQDatasource(PrintWriter out) throws BIResourceException {
        IConnectionFactory cf = null;
        IConnectionSpec cs = null;
        IBIConnection connection = null;
        try {
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)Class.forName("com.sap.ip.bi.sdk.dac.connector.sapq.SapqManagedConnectionFactory").newInstance();
            cf = (IConnectionFactory)mcf.createConnectionFactory();
            cs = cf.getConnectionSpec();
        }
        catch (Exception e) {
            throw new BIResourceException(Locale.getDefault(), "sdk.samples_1220", e);
        }
        BIResourceProperties props = new BIResourceProperties(class$com$sap$ip$bi$sdk$samples$Helpers == null ? (class$com$sap$ip$bi$sdk$samples$Helpers = Helpers.class$("com.sap.ip.bi.sdk.samples.Helpers")) : class$com$sap$ip$bi$sdk$samples$Helpers, ".sapq");
        Enumeration<?> propnames = props.propertyNames();
        while (propnames.hasMoreElements()) {
            String key = (String)propnames.nextElement();
            cs.setPropertyValue(key, (Object)props.getProperty(key));
        }
        try {
            connection = (IBIConnection)cf.getConnectionEx(cs);
        }
        catch (Exception e) {
            throw new BIResourceException(Locale.getDefault(), "sdk.samples_1130", e);
        }
        return connection;
    }

    public static String getDocTypeDefinition() {
        return DOCTYPE;
    }

    public static String getStyleSheetDefinition() {
        return CSS;
    }

    public static void renderQueryAndDataset(PrintWriter out, IBIQuery query) {
        out.println("<p><b>MDX Statement that was executed:</b><br> <span class=\"code\">" + (String)query.getNativeRepresentation() + "</span>" + "</p>");
        IBIDataSet dataset = query.execute();
        Helpers.renderDataset(out, dataset, true);
    }

    public static void renderDataset(PrintWriter out, IBIDataSet dataset, boolean isDisplayingHierarchy) {
        try {
            BIDataSetTableModel table = new BIDataSetTableModel(dataset, isDisplayingHierarchy);
            out.println("<p>Result set:</p>");
            out.println("<table width=700 border=1 cellpadding=0 cellspacing=0>");
            int row = table.getRowCount();
            int col = table.getColumnCount();
            int evenOdd = -1;
            int i = 0;
            while (i < row) {
                if (evenOdd > -1) {
                    ++evenOdd;
                }
                out.println("<tr>");
                int j = 0;
                while (j < col) {
                    BITableItem item = table.getValueAt(i, j);
                    String cellText = item.toString();
                    switch (item.getSection()) {
                        case 0: {
                            if (evenOdd == -1) {
                                evenOdd = 0;
                            }
                            out.println(Helpers.renderTd(cellText, (evenOdd & 1) == 0 ? "even" : "odd"));
                            break;
                        }
                        case 2: {
                            if (isDisplayingHierarchy && item.getItem() instanceof IBIDimensionCursor) {
                                boolean atLeastOneLevel = false;
                                StringBuffer dashes = new StringBuffer();
                                int k = 0;
                                while (k < item.getRelativeLevel()) {
                                    dashes.append("--");
                                    atLeastOneLevel = true;
                                    ++k;
                                }
                                if (atLeastOneLevel) {
                                    dashes.append("&nbsp;");
                                }
                                cellText = dashes.toString() + cellText;
                            }
                            out.println(Helpers.renderTd(cellText, "headLeft"));
                            break;
                        }
                        case 1: {
                            if (isDisplayingHierarchy && item.getItem() instanceof IBIDimensionCursor && item.getRelativeLevel() != i - item.getAccumulatedHeaderPositionCount()) {
                                cellText = "";
                            }
                            out.println(Helpers.renderTd(cellText, "headCenter"));
                            break;
                        }
                        case 3: {
                            out.println(Helpers.renderTd(cellText, "headCenter"));
                        }
                    }
                    ++j;
                }
                out.println("</tr>");
                ++i;
            }
            out.println("</table>");
        }
        catch (BISQLException e) {
            e.printStackTrace();
            out.println("<p>Error: " + e.getMessage() + "</p>");
        }
    }

    public static void renderResultset(PrintWriter out, ResultSet resultset) {
        try {
            ResultSetMetaData rsmd = resultset.getMetaData();
            out.println("<p>Result set:</p>");
            out.println("<table width=700 border=1 cellpadding=0 cellspacing=0>");
            out.println("<tr>");
            int cols = rsmd.getColumnCount();
            int i = 1;
            while (i <= cols) {
                out.println(Helpers.renderTd(rsmd.getColumnLabel(i), "headCenter"));
                ++i;
            }
            out.println("</tr>");
            int j = -1;
            while (resultset.next()) {
                ++j;
                out.println("<tr>");
                int i2 = 1;
                while (i2 <= cols) {
                    Object o = resultset.getObject(i2);
                    String content = null;
                    content = resultset.wasNull() ? "{null}" : o.toString();
                    out.println(Helpers.renderTd(content, (j & 1) == 0 ? "even" : "odd"));
                    ++i2;
                }
                out.println("</tr>");
            }
            out.println("</table>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            out.println("<p>Error: " + ex.getMessage() + "</p>");
        }
    }

    public static String renderTd(String data, String clazz) {
        return "<td" + (clazz != null ? " class=\"" + clazz + "\"" : "") + ">" + Helpers.escape(data) + "</td>";
    }

    public static String escape(String data) {
        String[][] map = new String[][]{{"\u00a3", "&#163;"}};
        String content = data;
        if (content == null || content != null && content.equals("")) {
            content = "&nbsp;";
        } else {
            int i = 0;
            while (i < map.length) {
                String[] pair = map[i];
                if (content.indexOf(pair[0].charAt(0)) >= 0) {
                    int position = content.indexOf(pair[0].charAt(0));
                    while (position >= 0) {
                        content = new StringBuffer(content).replace(position, position + 1, pair[1]).toString();
                        position = content.indexOf(pair[0].charAt(0));
                    }
                }
                ++i;
            }
        }
        return content;
    }

    public static IBIMember createMember(IBIMemberFactory memberFactory, Dimension dimension, String memberName, String memberUniqueName) throws BIOlapQueryException {
        HashMap<String, String> taggedValues = new HashMap<String, String>();
        taggedValues.put("MEMBER_NAME", memberName);
        taggedValues.put("MEMBER_UNIQUE_NAME", memberUniqueName);
        IBIMember member = memberFactory.createMember(dimension, memberName, null, taggedValues);
        return member;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SampleMetaDataBW {
        public Cube cube;
        public Dimension soldToPartyDimension;
        public Dimension salesOrgDimension;
        public Dimension divisionDimension;
        public Dimension measuresDimension;
        public Dimension distributionChannelDimension;
        public Dimension versionDimension;
        public Dimension valueTypeDimension;
        public IBIMember divisionHiTechMember;
        public IBIMember divisionElectronicParts;
        public IBIMember divisionServiceMember;
        public IBIMember measuresQuantityMember;
        public IBIMember measuresCostMember;
        public IBIMember measuresIncomingOrderValue;
        public IBIMember distributionChannelAll;
        public IBIMember distributionChannelDirectSales;
        public IBIMember valueTypeActualMember;
        public IBIMember versionCurrentMember;
        public Attribute countryAttribute;
        public Attribute industryAttribute;
        public Cube cube2;
        public Dimension salesOrgDimension2;
        public IBIMember salesOrgNewYork2;
        public IBIMember salesOrgSanFrancisco2;

        private SampleMetaDataBW(IBIConnection connection) throws Exception {
            IBIOlap olap = connection.getOlap();
            this.cube = olap.getObjectFinder().findCubeFirst((String)null, "$0D_SD_C03");
            this.cube2 = olap.getObjectFinder().findCubeFirst((String)null, "0D_SD_C03/0D_SD_C03_Q009");
            if (this.cube == null) {
                throw new BIException(Locale.getDefault(), "sdk.samples_1000", new Object[]{"$0D_SD_C03"});
            }
            if (this.cube2 == null) {
                throw new BIException(Locale.getDefault(), "sdk.samples_1000", new Object[]{"0D_SD_C03/0D_SD_C03_Q009"});
            }
            Iterator i = this.cube.getCubeDimensionAssociation().iterator();
            while (i.hasNext()) {
                CubeDimensionAssociation cda = (CubeDimensionAssociation)i.next();
                Dimension dim = cda.getDimension();
                if (dim.getName().equalsIgnoreCase("0D_DIV")) {
                    this.divisionDimension = dim;
                    continue;
                }
                if (dim.getName().equalsIgnoreCase("0D_SALE_ORG")) {
                    this.salesOrgDimension = dim;
                    continue;
                }
                if (dim.getName().equalsIgnoreCase("0D_SOLD_TO")) {
                    this.soldToPartyDimension = dim;
                    continue;
                }
                if (dim.getName().equalsIgnoreCase("0D_DIS_CHAN")) {
                    this.distributionChannelDimension = dim;
                    continue;
                }
                if (dim.getName().equalsIgnoreCase("Measures")) {
                    this.measuresDimension = dim;
                    continue;
                }
                if (dim.getName().equalsIgnoreCase("0D_VTYPE")) {
                    this.valueTypeDimension = dim;
                    continue;
                }
                if (!dim.getName().equalsIgnoreCase("0D_VERSION")) continue;
                this.versionDimension = dim;
            }
            BIQueryFactory queryFactory = (BIQueryFactory)olap.getQueryFactory();
            this.divisionHiTechMember = Helpers.createMember((IBIMemberFactory)queryFactory, this.divisionDimension, "High Tech", "[0D_DIV].[7]");
            this.divisionElectronicParts = Helpers.createMember((IBIMemberFactory)queryFactory, this.divisionDimension, "Electronic Parts", "[0D_DIV].[15]");
            this.divisionServiceMember = Helpers.createMember((IBIMemberFactory)queryFactory, this.divisionDimension, "Service", "[0D_DIV].[8]");
            this.valueTypeActualMember = Helpers.createMember((IBIMemberFactory)queryFactory, this.valueTypeDimension, "Actual", "[0D_VTYPE].[010]");
            this.versionCurrentMember = Helpers.createMember((IBIMemberFactory)queryFactory, this.versionDimension, "Current Version", "[0D_VERSION].[000]");
            this.distributionChannelAll = Helpers.createMember((IBIMemberFactory)queryFactory, this.distributionChannelDimension, "All Distribution channel", "[0D_DIS_CHAN].[All]");
            this.distributionChannelDirectSales = Helpers.createMember((IBIMemberFactory)queryFactory, this.distributionChannelDimension, "Direct Sales", "[0D_DIS_CHAN].[1]");
            this.measuresQuantityMember = Helpers.createMember((IBIMemberFactory)queryFactory, this.measuresDimension, "Quantity in base untis (SAP DEMO)", "[Measures].[0D_QUANT_B]");
            this.measuresCostMember = Helpers.createMember((IBIMemberFactory)queryFactory, this.measuresDimension, "Cost in statistics currency (SAP DEMO)", "[Measures].[0D_COSTVALS]");
            List plantFeatures = this.salesOrgDimension.getFeature();
            int j = 0;
            while (j < plantFeatures.size()) {
                Attribute attribute = (Attribute)plantFeatures.get(j);
                if (attribute.getName().equalsIgnoreCase("[10D_COUNTRY]")) {
                    this.countryAttribute = attribute;
                }
                ++j;
            }
            Iterator i2 = this.cube.getCubeDimensionAssociation().iterator();
            while (i2.hasNext()) {
                CubeDimensionAssociation cubeDimensionAssociation = (CubeDimensionAssociation)i2.next();
                Dimension dimension = cubeDimensionAssociation.getDimension();
                if (!dimension.getName().equalsIgnoreCase("0D_SALE_ORG")) continue;
                this.salesOrgDimension2 = dimension;
            }
            this.salesOrgNewYork2 = Helpers.createMember((IBIMemberFactory)queryFactory, this.salesOrgDimension2, "New York", "[0D_SALE_ORG].[1612]");
            this.salesOrgSanFrancisco2 = Helpers.createMember((IBIMemberFactory)queryFactory, this.salesOrgDimension2, "San Francisco", "[0D_SALE_ORG].[1614]");
        }
    }
}

