/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.relational.schema;

import com.sap.ip.bi.sdk.dac.connector.relational.schema.CatalogObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.ColumnObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.GenericSchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.SchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.SchemaType;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableObject;

public class DataTypeObject
extends GenericSchemaObject {
    private short dataType = 0;
    private String typeName = null;
    private int columnSize = 0;
    private int charOctetLength = 0;
    private int numPrecRadix = 0;
    private int decimalDigits = 0;

    public DataTypeObject(String catalogName, String schemaName, String tableName, String columnName, String typeName) {
        super(SchemaType.DATATYPE);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.typeName = typeName;
    }

    public DataTypeObject(CatalogObject catalog, String schemaName, String tableName, String columnName, String typeName) {
        super(SchemaType.DATATYPE);
        this.catalogName = catalog.catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.typeName = typeName;
    }

    public DataTypeObject(SchemaObject schema, String tableName, String columnName, String typeName) {
        super(SchemaType.DATATYPE);
        this.catalogName = schema.catalogName;
        this.schemaName = schema.schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.typeName = typeName;
    }

    public DataTypeObject(TableObject table, String columnName, String typeName) {
        super(SchemaType.DATATYPE);
        this.catalogName = table.catalogName;
        this.schemaName = table.schemaName;
        this.tableName = table.tableName;
        this.columnName = columnName;
        this.typeName = typeName;
    }

    public DataTypeObject(ColumnObject column) {
        super(SchemaType.DATATYPE);
        this.catalogName = column.catalogName;
        this.schemaName = column.schemaName;
        this.tableName = column.tableName;
        this.columnName = column.columnName;
        this.typeName = column.getTypeName();
        this.charOctetLength = column.getCharOctetLength();
        this.columnSize = column.getColumnSize();
        this.decimalDigits = column.getDecimalDigits();
        this.numPrecRadix = column.getNumPrecRadix();
        this.dataType = column.getDataType();
    }

    public DataTypeObject(ColumnObject column, String typeName) {
        super(SchemaType.DATATYPE);
        this.catalogName = column.catalogName;
        this.schemaName = column.schemaName;
        this.tableName = column.tableName;
        this.columnName = column.columnName;
        this.typeName = typeName;
        this.charOctetLength = column.getCharOctetLength();
        this.columnSize = column.getColumnSize();
        this.decimalDigits = column.getDecimalDigits();
        this.numPrecRadix = column.getNumPrecRadix();
        this.dataType = column.getDataType();
    }

    public int getCharOctetLength() {
        return this.charOctetLength;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public short getDataType() {
        return this.dataType;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public int getNumPrecRadix() {
        return this.numPrecRadix;
    }

    public String getColumnTypeName() {
        return this.toString() + this.addSuffix(this.typeName);
    }

    public void setCharOctetLength(int i) {
        this.charOctetLength = i;
    }

    public void setColumnSize(int i) {
        this.columnSize = i;
    }

    public void setDataType(short s) {
        this.dataType = s;
    }

    public void setDecimalDigits(int i) {
        this.decimalDigits = i;
    }

    public void setNumPrecRadix(int i) {
        this.numPrecRadix = i;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getQualifiedColumnName() {
        return super.columnName();
    }

    public String getQualifiedTableName() {
        return super.tableName();
    }

    public String getQualifiedSchemaName() {
        return super.schemaName();
    }

    public String getQualifiedCatalogName() {
        return super.catalogName();
    }

    public boolean isDeferred() {
        return false;
    }
}

