/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.relational.schema;

import com.sap.ip.bi.sdk.dac.connector.relational.schema.CatalogObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.GenericSchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.SchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.SchemaType;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableObject;

public class ColumnObject
extends GenericSchemaObject {
    private short dataType = 0;
    private String typeName = null;
    private int columnSize = 0;
    private int charOctetLength = 0;
    private int numPrecRadix = 0;
    private int decimalDigits = 0;
    private int nullable = 2;
    private boolean displayOnly = false;
    private boolean selectOnly = false;

    public ColumnObject(String catalogName, String schemaName, String tableName, String columnName) {
        super(SchemaType.COLUMN);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public ColumnObject(CatalogObject catalog, String schemaName, String tableName, String columnName) {
        super(SchemaType.COLUMN);
        this.catalogName = catalog.catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public ColumnObject(SchemaObject schema, String tableName, String columnName) {
        super(SchemaType.COLUMN);
        this.catalogName = schema.catalogName;
        this.schemaName = schema.schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public ColumnObject(TableObject table, String columnName) {
        super(SchemaType.COLUMN);
        this.catalogName = table.catalogName;
        this.schemaName = table.schemaName;
        this.tableName = table.tableName;
        this.columnName = columnName;
    }

    public int getCharOctetLength() {
        return this.charOctetLength;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public short getDataType() {
        return this.dataType;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public int getNumPrecRadix() {
        return this.numPrecRadix;
    }

    public int getNullable() {
        return this.nullable;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getColumnTypeName() {
        return this.toString() + this.addSuffix(this.typeName);
    }

    public void setCharOctetLength(int i) {
        this.charOctetLength = i < 0 ? 0 : i;
    }

    public void setColumnSize(int i) {
        this.columnSize = i < 0 ? 0 : i;
    }

    public void setDataType(short s) {
        this.dataType = s;
    }

    public void setDecimalDigits(int i) {
        this.decimalDigits = i < 0 ? 0 : i;
    }

    public void setNumPrecRadix(int i) {
        this.numPrecRadix = i < 0 ? 0 : i;
    }

    public void setNullable(int i) {
        this.nullable = i;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public boolean isDisplayOnly() {
        return this.displayOnly;
    }

    public void setDisplayOnly(boolean displayOnly) {
        this.displayOnly = displayOnly;
    }

    public boolean isSelectOnly() {
        return this.selectOnly;
    }

    public void setSelectOnly(boolean selectOnly) {
        this.selectOnly = selectOnly;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getQualifiedTableName() {
        return super.tableName();
    }

    public String getQualifiedSchemaName() {
        return super.schemaName();
    }

    public String getQualifiedCatalogName() {
        return super.catalogName();
    }

    public boolean isDeferred() {
        return false;
    }
}

