/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.olap.schema;

import com.sap.ip.bi.sdk.dac.connector.olap.schema.SchemaType;
import com.sap.ip.bi.sdk.exception.BIResourceException;

public class OlapSchemaObject
implements Comparable {
    private static int globalPosition = 0;
    private int position = 0;
    protected final SchemaType schemaObjectType;
    protected String catalogName = null;
    protected String schemaName = null;
    protected String cubeName = null;
    protected String dimensionName = null;
    protected String dimensionUName = null;
    protected String hierarchyName = null;
    protected String hierarchyUName = null;
    protected String levelName = null;
    protected String levelUName = null;
    protected String memberName = null;
    protected String memberUName = null;
    protected String measureUName = null;
    protected String propertyName = null;
    protected String variableName = null;
    protected String mofId = null;
    private static final String SCHEMA_EMPTY_NAME = "";
    private static final char SCHEMA_SEP = '#';
    private static final char SCHEMA_ESCAPE = '\\';

    public OlapSchemaObject(SchemaType schemaObjectType) {
        this.schemaObjectType = schemaObjectType;
        this.position = globalPosition++;
    }

    public OlapSchemaObject(String catalogName) {
        this.schemaObjectType = SchemaType.CATALOG;
        this.catalogName = catalogName;
        this.position = globalPosition++;
    }

    public OlapSchemaObject(String catalogName, String schemaName) {
        this.schemaObjectType = SchemaType.SCHEMA;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.position = globalPosition++;
    }

    public OlapSchemaObject(SchemaType schemaType, String catalogName, String schemaName, String objectName) {
        this.schemaObjectType = SchemaType.CUBE;
        this.cubeName = objectName;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.position = globalPosition++;
    }

    public OlapSchemaObject(SchemaType schemaType, String catalogName, String schemaName, String parentName, String objectName) {
        if (schemaType.equals(SchemaType.DIMENSION)) {
            this.dimensionUName = objectName;
            this.cubeName = parentName;
        } else if (schemaType.equals(SchemaType.MEASURE)) {
            this.measureUName = objectName;
            this.cubeName = parentName;
        } else if (schemaType.equals(SchemaType.SAPVARIABLE)) {
            this.variableName = objectName;
            this.cubeName = parentName;
        } else {
            schemaType = SchemaType.UNDEFINED;
        }
        this.schemaObjectType = schemaType;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.position = globalPosition++;
    }

    public OlapSchemaObject(SchemaType schemaType, String catalogName, String schemaName, String cubeName, String parentName, String objectName) {
        if (schemaType.equals(SchemaType.HIERARCHY)) {
            this.dimensionUName = parentName;
            this.hierarchyUName = objectName;
        } else {
            schemaType = SchemaType.UNDEFINED;
        }
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.cubeName = cubeName;
        this.schemaObjectType = schemaType;
        this.position = globalPosition++;
    }

    public OlapSchemaObject(SchemaType schemaType, String catalogName, String schemaName, String cubeName, String dimensionUName, String parentName, String objectName) {
        if (schemaType.equals(SchemaType.LEVEL)) {
            this.hierarchyUName = parentName;
            this.levelUName = objectName;
        } else {
            schemaType = SchemaType.UNDEFINED;
        }
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.cubeName = cubeName;
        this.dimensionUName = dimensionUName;
        this.schemaObjectType = schemaType;
        this.position = globalPosition++;
    }

    public OlapSchemaObject(SchemaType schemaType, String catalogName, String schemaName, String cubeName, String dimensionUName, String hierarchyUName, String levelUName, String memberUName, String propertyName, String propertyType) {
        if (!schemaType.equals(SchemaType.ATTRIBUTE)) {
            schemaType = SchemaType.UNDEFINED;
        }
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.cubeName = cubeName;
        this.dimensionUName = dimensionUName;
        this.hierarchyUName = hierarchyUName;
        this.levelUName = levelUName;
        this.memberUName = memberUName;
        this.schemaObjectType = schemaType;
        this.propertyName = propertyName;
        this.position = globalPosition++;
    }

    public String getMofId() {
        return this.mofId;
    }

    public void setMofId(String mofId) {
        this.mofId = mofId;
    }

    public String toString() {
        if (this.schemaObjectType == SchemaType.CATALOG) {
            return this.catalogName();
        }
        if (this.schemaObjectType == SchemaType.SCHEMA) {
            return this.schemaName();
        }
        if (this.schemaObjectType == SchemaType.CUBE) {
            return this.cubeName();
        }
        if (this.schemaObjectType == SchemaType.CUBEDIMENSIONASSOCIATION) {
            return this.cubeDimensionAssocName();
        }
        if (this.schemaObjectType == SchemaType.DIMENSION) {
            return this.dimensionName();
        }
        if (this.schemaObjectType == SchemaType.HIERARCHY) {
            return this.hierarchyName();
        }
        if (this.schemaObjectType == SchemaType.LEVEL) {
            return this.levelName();
        }
        if (this.schemaObjectType == SchemaType.ATTRIBUTE) {
            return this.attributeName();
        }
        if (this.schemaObjectType == SchemaType.MEMBER) {
            return this.memberName();
        }
        if (this.schemaObjectType == SchemaType.HIERARCHYLEVELASSOCIATION) {
            return this.hierarchyLevelAssocName();
        }
        if (this.schemaObjectType == SchemaType.LEVELMEMBERASSOCIATION) {
            return this.levelMemberAssocName();
        }
        if (this.schemaObjectType == SchemaType.MEASURE) {
            return this.measureName();
        }
        if (this.schemaObjectType == SchemaType.SAPVARIABLE) {
            return this.sapVariableName();
        }
        throw new RuntimeException();
    }

    public SchemaType getSchemaType() throws BIResourceException {
        return this.schemaObjectType;
    }

    public boolean isCatalog() {
        return this.schemaObjectType == SchemaType.CATALOG;
    }

    public boolean isSchema() {
        return this.schemaObjectType == SchemaType.SCHEMA;
    }

    public boolean isCube() {
        return this.schemaObjectType == SchemaType.CUBE;
    }

    public boolean isDimension() {
        return this.schemaObjectType == SchemaType.DIMENSION;
    }

    public boolean isHierarchy() {
        return this.schemaObjectType == SchemaType.HIERARCHY;
    }

    public boolean isLevel() {
        return this.schemaObjectType == SchemaType.LEVEL;
    }

    public boolean isAttribute() {
        return this.schemaObjectType == SchemaType.ATTRIBUTE;
    }

    public boolean isMember() {
        return this.schemaObjectType == SchemaType.MEMBER;
    }

    public boolean isMeasure() {
        return this.schemaObjectType == SchemaType.MEASURE;
    }

    public boolean equals(OlapSchemaObject other) {
        if (other == null || this.schemaObjectType != other.schemaObjectType) {
            return false;
        }
        if (this.schemaObjectType == SchemaType.CATALOG) {
            return this.equalsCatalog(other);
        }
        if (this.schemaObjectType == SchemaType.SCHEMA) {
            return this.equalsSchema(other);
        }
        if (this.schemaObjectType == SchemaType.DIMENSION) {
            return this.equalsDimension(other);
        }
        if (this.schemaObjectType == SchemaType.CUBE) {
            return this.equalsCube(other);
        }
        if (this.schemaObjectType == SchemaType.HIERARCHY) {
            return this.equalsHierarchy(other);
        }
        if (this.schemaObjectType == SchemaType.LEVEL) {
            return this.equalsLevel(other);
        }
        if (this.schemaObjectType == SchemaType.MEMBER) {
            return this.equalsMember(other);
        }
        if (this.schemaObjectType == SchemaType.MEASURE) {
            return this.equalsMeasure(other);
        }
        if (this.schemaObjectType == SchemaType.ATTRIBUTE) {
            return this.equalsAttribute(other);
        }
        if (this.schemaObjectType == SchemaType.CUBEDIMENSIONASSOCIATION) {
            return this.equalsCubeDimensionAssoc(other);
        }
        if (this.schemaObjectType == SchemaType.LEVELMEMBERASSOCIATION) {
            return this.equalsLevelMemberAssoc(other);
        }
        if (this.schemaObjectType == SchemaType.HIERARCHYLEVELASSOCIATION) {
            return this.equalsHierarchyLevelAssoc(other);
        }
        return false;
    }

    private boolean equalsHierarchyLevelAssoc(OlapSchemaObject other) {
        return this.equalsHierarchy(other) && this.equalsLevel(other) && this.sameName(this.hierarchyName, other.hierarchyName);
    }

    private boolean equalsLevelMemberAssoc(OlapSchemaObject other) {
        return this.equalsLevel(other) && this.equalsMember(other) && this.sameName(this.cubeName, other.cubeName);
    }

    private boolean equalsCubeDimensionAssoc(OlapSchemaObject other) {
        return this.equalsDimension(other) && this.equalsCube(other) && this.sameName(this.cubeName, other.cubeName);
    }

    private boolean equalsMeasure(OlapSchemaObject other) {
        return this.equalsCube(other) && this.sameName(this.measureUName, other.measureUName);
    }

    private boolean equalsMember(OlapSchemaObject other) {
        return this.equalsDimension(other) && this.sameName(this.memberUName, other.memberUName);
    }

    private boolean equalsLevel(OlapSchemaObject other) {
        return this.equalsDimension(other) && this.sameName(this.levelUName, other.levelUName);
    }

    private boolean equalsHierarchy(OlapSchemaObject other) {
        return this.equalsDimension(other) && this.sameName(this.hierarchyUName, other.hierarchyUName);
    }

    private boolean equalsCube(OlapSchemaObject other) {
        return this.equalsSchema(other) && this.sameName(this.cubeName, other.cubeName);
    }

    private boolean equalsDimension(OlapSchemaObject other) {
        return this.equalsSchema(other) && this.sameName(this.dimensionUName, other.dimensionUName);
    }

    private boolean equalsAttribute(OlapSchemaObject other) {
        return this.equalsDimension(other) && this.equalsHierarchy(other) && this.equalsLevel(other) && this.sameName(this.propertyName, other.propertyName);
    }

    public int getPosition() {
        return this.position;
    }

    public int compareTo(Object other) {
        if (!(other instanceof OlapSchemaObject) || other == null) {
            throw new ClassCastException();
        }
        return this.getPosition() - ((OlapSchemaObject)other).getPosition();
    }

    private boolean equalsCatalog(OlapSchemaObject other) {
        return this.sameName(this.catalogName, other.catalogName);
    }

    private boolean equalsSchema(OlapSchemaObject other) {
        return this.equalsCatalog(other) && this.sameName(this.schemaName, other.schemaName);
    }

    private boolean sameName(String thisName, String otherName) {
        return thisName == null && otherName == null || thisName != null && thisName.equals(otherName);
    }

    protected String addSuffix(String suffix) {
        return '#' + this.escape(suffix);
    }

    private String escape(String name) {
        if (name == null) {
            return null;
        }
        char[] data = name.toCharArray();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            if (data[i] == '\\' || data[i] == '#') {
                buf.append('#');
            }
            buf.append(data[i]);
            ++i;
        }
        return buf.toString();
    }

    protected String catalogName() {
        return this.schemaName(this.catalogName);
    }

    protected String schemaName() {
        return this.schemaName(this.catalogName, this.schemaName);
    }

    protected String cubeName() {
        return this.schemaName(this.catalogName, this.schemaName, this.cubeName);
    }

    protected String dimensionName() {
        return this.schemaName(this.catalogName, this.schemaName, this.cubeName, this.dimensionUName);
    }

    protected String sapVariableName() {
        return this.schemaName(this.catalogName, this.schemaName, this.cubeName, this.variableName + "Variable");
    }

    protected String measureName() {
        return this.schemaName(this.catalogName, this.schemaName, this.cubeName, this.measureUName);
    }

    protected String attributeName() {
        return this.schemaName(this.schemaName(this.catalogName, this.schemaName, this.cubeName, this.dimensionUName), this.hierarchyUName, this.levelUName, this.propertyName);
    }

    protected String levelMemberAssocName() {
        return this.schemaName(this.catalogName, this.schemaName, this.dimensionUName, this.levelUName, this.memberUName);
    }

    protected String hierarchyLevelAssocName() {
        return this.schemaName(this.catalogName, this.schemaName, this.dimensionUName, this.hierarchyName, this.levelUName);
    }

    protected String memberName() {
        return this.schemaName(this.catalogName, this.schemaName, this.dimensionUName, this.memberUName);
    }

    protected String levelName() {
        return this.schemaName(this.dimensionName(), this.hierarchyUName, this.levelUName);
    }

    protected String hierarchyName() {
        return this.schemaName(this.dimensionName(), this.hierarchyUName);
    }

    protected String cubeDimensionAssocName() {
        return this.schemaName(this.catalogName, this.schemaName, this.cubeName, this.dimensionUName);
    }

    public String schemaName(String catalog) {
        if (catalog == null) {
            return SCHEMA_EMPTY_NAME;
        }
        return this.escape(catalog).toString();
    }

    public String schemaName(String catalog, String schema) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.schemaName(catalog)).append('#');
        if (schema == null) {
            buf.append(SCHEMA_EMPTY_NAME);
        } else {
            buf.append(schema);
        }
        return buf.toString();
    }

    public String schemaName(String catalog, String schema, String cube) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.schemaName(catalog, schema)).append('#');
        if (cube == null) {
            buf.append(SCHEMA_EMPTY_NAME);
        } else {
            buf.append(cube);
        }
        return buf.toString();
    }

    public String schemaName(String catalog, String schema, String cube, String cda) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.schemaName(catalog, schema, cube)).append('#');
        if (cda == null) {
            buf.append(SCHEMA_EMPTY_NAME);
        } else {
            buf.append(cda);
        }
        return buf.toString();
    }

    private String schemaName(String catalog, String schema, String cube, String cda, String dimension) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.schemaName(catalog, schema, cube, cda)).append('#');
        if (dimension == null) {
            buf.append(SCHEMA_EMPTY_NAME);
        } else {
            buf.append(dimension);
        }
        return buf.toString();
    }
}

