/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.olap;

import com.sap.ip.bi.sdk.dac.connector.impl.BIMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.olap.BIOlapDataSourceType;
import com.sap.ip.bi.sdk.dac.connector.olap.BISAPVariableConstants;
import com.sap.ip.bi.sdk.dac.connector.olap.MetadataNameConverter;
import com.sap.ip.bi.sdk.dac.connector.olap.OlapMetaStore;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.AttributeObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.BISAPVariableObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.CubeObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.DimensionObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.LevelBasedHierarchyObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.LevelObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.MeasureObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.OlapSchemaObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.SchemaObject;
import com.sap.ip.bi.sdk.dac.olap.query.assoc.AssocPackage;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIAnyDataValue;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBISapVariableSelectionTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapHierarchyVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapMemberVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapNumericVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariable;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BIMonitor;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.bi.sdk.util.impl.ServerRTCounter;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.Association;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.Instantiator;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.jmi.reflect.RefPackage;
import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;
import org.omg.cwm.analysis.olap.Cube;
import org.omg.cwm.analysis.olap.CubeDimensionAssociation;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.analysis.olap.HierarchyLevelAssociation;
import org.omg.cwm.analysis.olap.Level;
import org.omg.cwm.analysis.olap.LevelBasedHierarchy;
import org.omg.cwm.analysis.olap.Measure;
import org.omg.cwm.analysis.olap.Schema;
import org.omg.cwm.objectmodel.core.Attribute;
import org.omg.cwm.objectmodel.core.CorePackage;
import org.omg.cwm.objectmodel.core.ModelElement;
import org.omg.cwm.objectmodel.core.TaggedValue;
import org.omg.cwm.objectmodel.core.VisibilityKindEnum;

public abstract class OlapMDRConnection
extends BIMDRConnection {
    private BIOlapDataSourceType dataSourceType = null;
    protected IBIConnectionInfo connectionInfo = null;
    private ServerRTCounter rtcounter = ServerRTCounter.getInstance();
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection = OlapMDRConnection.class$("com.sap.ip.bi.sdk.dac.connector.olap.CommonConnection")) : class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    private IBIMonitor monitor = null;
    private static final String SCHEMA_EMPTY_NAME = "";
    private static final char SCHEMA_SEP = '#';
    private static final char SCHEMA_ESCAPE = '\\';
    public static final String ASSOC_CLASSIFIER_FEATURE = "org.omg.cwm.objectmodel.Core.ClassifierFeature";
    public static final String ASSOC_ELEMENT_OWNERSHIP = "org.omg.cwm.objectmodel.Core.ElementOwnership";
    public static final String ASSOC_CATALOG_SCHEMA = "org.omg.cwm.analysis.olap.CatalogOwnsSchemas";
    public static final String ASSOC_SCHEMA_CUBE = "org.omg.cwm.analysis.olap.SchemaOwnsCubes";
    public static final String ASSOC_CUBE_CUBEDIMENSIONASSOCIATION = "org.omg.cwm.analysis.olap.CubeOwnsCubeDimensionAssociations";
    public static final String ASSOC_CUBEDIMENSIONASSOCIATION_DIMENSION = "org.omg.cwm.analysis.olap.CubeDimensionAssociationsReferenceDimension";
    public static final String ASSOC_SCHEMA_DIMENSION = "org.omg.cwm.analysis.olap.SchemaOwnsDimensions";
    public static final String ASSOC_DIMENSION_HIERARCHY = "org.omg.cwm.analysis.olap.DimensionOwnsHierarchies";
    public static final String ASSOC_DIMENSION_MEMBERSELECTION = "org.omg.cwm.analysis.olap.DimensionOwnsMemberSelections";
    public static final String ASSOC_DIMENSION_MEMBER = "org.omg.cwm.analysis.olap.DimensionOwnsMembers";
    public static final String ASSOC_LEVELBASEDHIERARCHY_HIERARCHYLEVELASSOCIATION = "org.omg.cwm.analysis.olap.LevelBasedHierarchyOwnsHierarchyLevelAssociations";
    public static final String ASSOC_LEVEL_LEVELMEMBERASSOCIATION = "org.omg.cwm.analysis.olap.LevelOwnsLevelMemberAssociations";
    public static final String ASSOC_HIERARCHYLEVELASSOCIATION_LEVEL = "org.omg.cwm.analysis.olap.HierarchyLevelAssocsReferenceLevel";
    public static final String ASSOC_LEVELMEMBERASSOCIATION_MEMBER = "org.omg.cwm.analysis.olap.LevelMemberAssociationReferenceMember";
    public static final String ASSOC_CUBEDIMENSIONASSOCIATION_CALCHIERARCHY = "org.omg.cwm.analysis.olap.CubeDimensionAssociationsReferenceCalcHierarchy";
    public static final String ASSOC_TAGGEDELEMENT = "org.omg.cwm.objectmodel.Core.TaggedElement";
    public static final String ASSOC_CUBE_SAPVARIABLE = "com.sap.ip.bi.sdk.dac.olap.query.assoc.IBICubeOwnsSapVariable";
    public static final String PACKAGE_QUERY = "com.sap.ip.bi.sdk.dac.olap.query";
    public static final String CATALOG_CLASSNAME = "org.omg.cwm.analysis.olap.Catalog";
    public static final String SCHEMA_CLASSNAME = "org.omg.cwm.analysis.olap.Schema";
    public static final String CUBE_CLASSNAME = "org.omg.cwm.analysis.olap.Cube";
    public static final String DIMENSION_CLASSNAME = "org.omg.cwm.analysis.olap.Dimension";
    public static final String CUBEDIMENSIONASSOC_CLASSNAME = "org.omg.cwm.analysis.olap.CubeDimensionAssociation";
    public static final String HERARCHY_CLASSNAME = "org.omg.cwm.analysis.olap.Hierarchy";
    public static final String LEVELBASEDHERARCHY_CLASSNAME = "org.omg.cwm.analysis.olap.LevelBasedHierarchy";
    public static final String LEVEL_CLASSNAME = "org.omg.cwm.analysis.olap.Level";
    public static final String MEMBER_CLASSNAME = "org.omg.cwm.analysis.olap.Member";
    public static final String HIERARCHYLEVELASSOC_CLASSNAME = "org.omg.cwm.analysis.olap.HierarchyLevelAssociation";
    public static final String LEVELMEMBERASSOC_CLASSNAME = "org.omg.cwm.analysis.olap.LevelMemberAssociation";
    public static String MEASURE_CLASSNAME = "org.omg.cwm.analysis.olap.Measure";
    public static String ATTRIBUTE_CLASSNAME = "org.omg.cwm.objectmodel.core.Attribute";
    public static String IBISAPMEMBERVARIABLE_CLASSNAME = "com.sap.ip.bi.sdk.dac.olap.query.var.IBISapMemberVariable";
    public static String MEMBERVARIABLE_HIERARCHY = "com.sap.ip.bi.sdk.dac.olap.query.assoc.IBISapMemberVariableReferenceHierarchy";
    public static String MEMBERVARIABLE_DEFAULTHIGH = "com.sap.ip.bi.sdk.dac.olap.query.assoc.IBISapMemberVariableReferenceDefaultHigh";
    public static String MEMBERVARIABLE_DEFAULTLOW = "com.sap.ip.bi.sdk.dac.olap.query.assoc.IBISapMemberVariableReferenceDefaultLow";
    public static String HIERARCHYVARIABLE_DIMENSION = "com.sap.ip.bi.sdk.dac.olap.query.assoc.IBISapHierarchyVariableReferenceDimension";
    public static String HIERARCHYVARIABLE_DEFAULTVALUE = "com.sap.ip.bi.sdk.dac.olap.query.assoc.IBISapHierarchyVariableReferenceDefaultValue";
    public static String NUMERICVARIABLE_DEFAULTHIGH = "com.sap.ip.bi.sdk.dac.olap.query.assoc.IBISapNumericVariableReferenceDefaultHigh";
    public static String NUMERICVARIABLE_DEFAULTLOW = "com.sap.ip.bi.sdk.dac.olap.query.assoc.IBISapNumericVariableReferenceDefaultLow";
    protected final boolean AUTOCOMMIT = true;
    protected final boolean NOCOMMIT = false;
    protected RefPackage outerMost = null;
    protected CorePackage corePack = null;
    protected AssocPackage assocPackage = null;
    private static List packageNames = new ArrayList();
    private static List modelPaths;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$Schema;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$Cube;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$Dimension;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$CubeDimensionAssociation;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$LevelBasedHierarchy;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$Level;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$HierarchyLevelAssociation;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$Measure;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapVariable;
    static /* synthetic */ Class class$org$omg$cwm$objectmodel$core$Attribute;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapMemberVariable;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapHierarchyVariable;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapNumericVariable;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$olap$query$member$IBIAnyDataValue;

    public OlapMDRConnection(IBIConnectionInfo connectionInfo, BIOlapDataSourceType dataSourceType) throws BIResourceException {
        super(connectionInfo, packageNames, modelPaths);
        this.connectionInfo = connectionInfo;
        this.dataSourceType = dataSourceType;
        this.monitor = BIMonitor.createMonitor(IBIMonitor.Request.METADATA);
        loc.entering("OlapMDRConnection()");
        this.outerMost = this.connect();
        this.corePack = (CorePackage)this.outerMost.refPackage("org.omg.cwm.objectmodel.Core");
        AssocPackage assocPackage = (AssocPackage)this.outerMost.refOutermostPackage().refPackage("com.sap.ip.bi.sdk.dac.olap.query.assoc");
        loc.exiting();
    }

    public OlapMDRConnection(IBIConnectionInfo connectionInfo, BIOlapDataSourceType dataSourceType, List packageNames, List modelPaths) throws BIResourceException {
        super(connectionInfo, packageNames, modelPaths);
        this.monitor = BIMonitor.createMonitor(IBIMonitor.Request.METADATA);
        this.dataSourceType = dataSourceType;
        loc.entering("OlapMDRConnection(List packageNames, List modelPaths)");
        this.outerMost = this.connect();
        this.corePack = (CorePackage)this.outerMost.refPackage("org.omg.cwm.objectmodel.Core");
        loc.exiting();
    }

    protected Locale getLocale() {
        return this.connectionInfo == null ? Locale.getDefault() : this.connectionInfo.getLocale();
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (this.mdr != null) {
            return this.mdr.getLocalTransaction();
        }
        throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.mmr_1001");
    }

    public List getSchema() throws BIResourceException {
        loc.entering("getSchema()");
        this.assertLoadSchemas();
        ArrayList<Schema> schemaList = new ArrayList<Schema>();
        Iterator i = this.getMetaStore().getSchema().values().iterator();
        while (i.hasNext()) {
            SchemaObject s = (SchemaObject)i.next();
            Schema schema = (Schema)this.createM1Instance(s, class$org$omg$cwm$analysis$olap$Schema == null ? OlapMDRConnection.class$(SCHEMA_CLASSNAME) : class$org$omg$cwm$analysis$olap$Schema, false);
            schemaList.add(schema);
        }
        this.submitM1Instance();
        loc.exiting();
        return schemaList;
    }

    private ModelElement createModelElementSchema(SchemaObject schemaObj) throws BIResourceException {
        loc.entering("createModelElementSchema(SchemaObject schemaObj)");
        Schema schema = (Schema)this.getMetaStore().getInstance(schemaObj);
        if (schema == null) {
            ArrayList<String> args = new ArrayList<String>(2);
            String lSchemaName = schemaObj.getCatalogName();
            args.add(lSchemaName);
            args.add((String)VisibilityKindEnum.VK_PUBLIC);
            schema = (Schema)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), SCHEMA_CLASSNAME, args, true);
            this.rtcounter.incrementCounter(4);
            ((IMMRObject)schema).set___State(StateEnum.STATE_UNCHANGED);
            schemaObj.setMofId(schema.refMofId());
            this.createTaggedValueSchema(schema, schemaObj);
            this.submitM1Instance();
            this.getMetaStore().putInstance(schemaObj, schema);
        }
        loc.exiting();
        return schema;
    }

    public List getCube() throws BIResourceException {
        loc.entering("getCube()");
        this.getSchema();
        this.assertLoadCubes();
        ArrayList<Cube> cubeList = new ArrayList<Cube>();
        Iterator i = this.getMetaStore().getCube().values().iterator();
        while (i.hasNext()) {
            CubeObject c = (CubeObject)i.next();
            Cube cube = (Cube)this.createM1Instance(c, class$org$omg$cwm$analysis$olap$Cube == null ? OlapMDRConnection.class$(CUBE_CLASSNAME) : class$org$omg$cwm$analysis$olap$Cube, false);
            cubeList.add(cube);
        }
        loc.exiting();
        return cubeList;
    }

    protected List getCube(SchemaObject schemaObj) throws BIResourceException {
        loc.entering("getCube(SchemaObject schemaObj)");
        this.assertLoadCubes(schemaObj);
        ArrayList<Cube> cubeList = new ArrayList<Cube>();
        Iterator i = this.getMetaStore().getCube(schemaObj).iterator();
        while (i.hasNext()) {
            CubeObject c = (CubeObject)i.next();
            Cube cube = (Cube)this.createM1Instance(c, class$org$omg$cwm$analysis$olap$Cube == null ? OlapMDRConnection.class$(CUBE_CLASSNAME) : class$org$omg$cwm$analysis$olap$Cube, false);
            cubeList.add(cube);
        }
        this.submitM1Instance();
        loc.exiting();
        return cubeList;
    }

    private ModelElement createModelElementCube(CubeObject cubeObj) throws BIResourceException {
        loc.entering("createModelElementCube(CubeObject cubeObj)");
        Cube cube = (Cube)this.getMetaStore().getInstance(cubeObj);
        if (cube == null) {
            ArrayList<Object> args = new ArrayList<Object>(4);
            args.add(cubeObj.getCubeName());
            args.add(VisibilityKindEnum.VK_PUBLIC);
            args.add(Boolean.FALSE);
            args.add(Boolean.FALSE);
            cube = (Cube)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), CUBE_CLASSNAME, args, true);
            ((IMMRObject)cube).set___State(StateEnum.STATE_UNCHANGED);
            this.rtcounter.incrementCounter(4);
            cubeObj.setMofId(cube.refMofId());
            cube.setVirtual(Boolean.getBoolean(cubeObj.getCubeType()));
            this.createTaggedValueCube(cube, cubeObj);
            this.getMetaStore().putInstance(cubeObj, cube);
            this.submitM1Instance();
        }
        loc.exiting();
        return cube;
    }

    private ModelElement createModelElementCubeDimensionAssociation(DimensionObject dimensionObj) throws BIResourceException {
        loc.entering("createModelElementCubeDimensionAssociation(DimensionObject dimensionObj)");
        Dimension dimension = (Dimension)this.getMetaStore().getInstance(dimensionObj);
        if (dimension != null) {
            ArrayList<Object> args = new ArrayList<Object>(3);
            args.add(dimensionObj.getCubeName() + dimensionObj.getDimensionUniqueName());
            args.add(VisibilityKindEnum.VK_PUBLIC);
            args.add(Boolean.FALSE);
            CubeDimensionAssociation cda = (CubeDimensionAssociation)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), CUBEDIMENSIONASSOC_CLASSNAME, args, true);
            this.rtcounter.incrementCounter(4);
            cda.setName(dimensionObj.getCubeName() + dimensionObj.getDimensionUniqueName());
            ((IMMRObject)cda).set___State(StateEnum.STATE_UNCHANGED);
            this.submitM1Instance();
            this.getMetaStore().putInstanceByMofId(cda.refMofId(), cda);
            loc.exiting();
            return cda;
        }
        loc.exiting();
        return null;
    }

    private List getDimension(Cube cube) throws BIResourceException {
        loc.entering("getDimension(Cube cube)");
        if (cube == null) {
            throw new BIResourceException(this.getLocale(), "sdk.dac.connector_2009", new Object[]{"Cube"});
        }
        CubeObject cubeObj = (CubeObject)this.getMetaStore().getObjectByMofId(cube.refMofId());
        if (cubeObj == null) {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_2017", new Object[]{cube.refMofId()});
        }
        loc.exiting();
        return this.getDimension(cubeObj);
    }

    protected List getDimension(CubeObject cubeObj) throws BIResourceException {
        loc.entering("getDimension(CubeObject cubeObj)");
        this.assertDimensionsLoaded(cubeObj);
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>();
        Iterator i = this.getMetaStore().getDimension(cubeObj).iterator();
        while (i.hasNext()) {
            DimensionObject dimObj = (DimensionObject)i.next();
            Dimension dimension = (Dimension)this.createM1Instance(dimObj, class$org$omg$cwm$analysis$olap$Dimension == null ? OlapMDRConnection.class$(DIMENSION_CLASSNAME) : class$org$omg$cwm$analysis$olap$Dimension, false);
            CubeDimensionAssociation cda = (CubeDimensionAssociation)this.createM1Instance(dimObj, class$org$omg$cwm$analysis$olap$CubeDimensionAssociation == null ? OlapMDRConnection.class$(CUBEDIMENSIONASSOC_CLASSNAME) : class$org$omg$cwm$analysis$olap$CubeDimensionAssociation, false);
            dimObj.setCubeDimensionAssocMofId(cda.refMofId());
            dimensionList.add(dimension);
        }
        loc.exiting();
        return dimensionList;
    }

    private ModelElement createModelElementDimension(DimensionObject dimensionObj) throws BIResourceException {
        loc.entering("createModelElementDimension(DimensionObject dimensionObj)");
        Dimension dimension = (Dimension)this.getMetaStore().getInstance(dimensionObj);
        if (dimension == null) {
            ArrayList<Object> args = new ArrayList<Object>(7);
            args.add(dimensionObj.getDimensionName());
            args.add(VisibilityKindEnum.VK_PUBLIC);
            args.add(Boolean.FALSE);
            args.add(Boolean.FALSE);
            args.add(Boolean.FALSE);
            dimension = (Dimension)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), DIMENSION_CLASSNAME, args, true);
            this.rtcounter.incrementCounter(4);
            ((IMMRObject)dimension).set___State(StateEnum.STATE_UNCHANGED);
            dimensionObj.setMofId(dimension.refMofId());
            String dt = dimensionObj.getDimensionType();
            if (dt != null) {
                dimension.setTime(dt.equals("1"));
                dimension.setMeasure(dt.equals("2"));
            }
            this.createTaggedValueDimension(dimension, dimensionObj);
            this.submitM1Instance();
            this.getMetaStore().putInstance(dimensionObj, dimension);
        }
        loc.exiting();
        return dimension;
    }

    private List getLevelBasedHierarchy(Dimension dimension) throws BIResourceException {
        loc.entering("getLevelBasedHierarchy(Dimension dimension)");
        if (dimension == null) {
            throw new BIResourceException(this.getLocale(), "sdk.dac.connector_2009", new Object[]{"Dimension"});
        }
        DimensionObject dimensionObj = (DimensionObject)this.getMetaStore().getObjectByMofId(dimension.refMofId());
        if (dimensionObj == null) {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_2017", new Object[]{dimension.refMofId()});
        }
        loc.exiting();
        return this.getLevelBasedHierarchy(dimensionObj);
    }

    protected List getLevelBasedHierarchy(DimensionObject dimensionObj) throws BIResourceException {
        loc.entering("getLevelBasedHierarchy(DimensionObject dimensionObj)");
        this.assertLoadLevelBasedHierarchies(dimensionObj);
        ArrayList<LevelBasedHierarchy> levelBasedHerarchyList = new ArrayList<LevelBasedHierarchy>();
        Iterator i = this.getMetaStore().getHierarchy(dimensionObj).iterator();
        while (i.hasNext()) {
            LevelBasedHierarchyObject s = (LevelBasedHierarchyObject)i.next();
            LevelBasedHierarchy levelBasedHerarchy = (LevelBasedHierarchy)this.createM1Instance(s, class$org$omg$cwm$analysis$olap$LevelBasedHierarchy == null ? OlapMDRConnection.class$(LEVELBASEDHERARCHY_CLASSNAME) : class$org$omg$cwm$analysis$olap$LevelBasedHierarchy, false);
            levelBasedHerarchyList.add(levelBasedHerarchy);
        }
        this.submitM1Instance();
        loc.exiting();
        return levelBasedHerarchyList;
    }

    private ModelElement createModelElementLevelBasedHierarchy(LevelBasedHierarchyObject levelBasedHierarchyObj) throws BIResourceException {
        loc.entering("createModelElementLevelBasedHierarchy(LevelBasedHierarchyObject levelBasedHierarchyObj)");
        LevelBasedHierarchy levelBasedHierarchy = (LevelBasedHierarchy)this.getMetaStore().getInstance(levelBasedHierarchyObj);
        if (levelBasedHierarchy == null) {
            ArrayList<Object> args = new ArrayList<Object>(5);
            String hierarchyName = levelBasedHierarchyObj.getHierarchyName();
            if (hierarchyName == null) {
                args.add(MetadataNameConverter.dimensionUniqueNametoDimensionName(levelBasedHierarchyObj.getDimensionUniqueName()));
            } else {
                args.add(hierarchyName);
            }
            args.add(VisibilityKindEnum.VK_PUBLIC);
            args.add(Boolean.FALSE);
            levelBasedHierarchy = (LevelBasedHierarchy)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), LEVELBASEDHERARCHY_CLASSNAME, args, true);
            this.rtcounter.incrementCounter(4);
            ((IMMRObject)levelBasedHierarchy).set___State(StateEnum.STATE_UNCHANGED);
            levelBasedHierarchyObj.setMofId(levelBasedHierarchy.refMofId());
            this.createTaggedValueLevelBasedHierarchy(levelBasedHierarchy, levelBasedHierarchyObj);
            this.submitM1Instance();
            this.getMetaStore().putInstance(levelBasedHierarchyObj, levelBasedHierarchy);
        }
        loc.exiting();
        return levelBasedHierarchy;
    }

    protected List getLevel(LevelBasedHierarchy levelBasedHierarchy) throws BIResourceException {
        loc.entering("getLevel(LevelBasedHierarchy levelBasedHierarchy)");
        if (levelBasedHierarchy == null) {
            throw new BIResourceException(this.getLocale(), "sdk.dac.connector_2009", new Object[]{"LevelBasedHierarchy"});
        }
        LevelBasedHierarchyObject levelBasedHierarchyObj = (LevelBasedHierarchyObject)this.getMetaStore().getObjectByMofId(levelBasedHierarchy.refMofId());
        if (levelBasedHierarchyObj == null) {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_2017", new Object[]{levelBasedHierarchy.refMofId()});
        }
        loc.exiting();
        return this.getLevel(levelBasedHierarchyObj);
    }

    protected List getLevel(LevelBasedHierarchyObject levelBasedHierarchyObj) throws BIResourceException {
        loc.entering("getLevel(LevelBasedHierarchyObject levelBasedHierarchyObj)");
        this.assertLevelsLoaded(levelBasedHierarchyObj);
        ArrayList<Level> levelList = new ArrayList<Level>();
        Iterator i = this.getMetaStore().getLevel(levelBasedHierarchyObj).iterator();
        while (i.hasNext()) {
            LevelObject levelObj = (LevelObject)i.next();
            Level level = (Level)this.createM1Instance(levelObj, class$org$omg$cwm$analysis$olap$Level == null ? OlapMDRConnection.class$(LEVEL_CLASSNAME) : class$org$omg$cwm$analysis$olap$Level, false);
            HierarchyLevelAssociation hla = (HierarchyLevelAssociation)this.createM1Instance(levelObj, class$org$omg$cwm$analysis$olap$HierarchyLevelAssociation == null ? OlapMDRConnection.class$(HIERARCHYLEVELASSOC_CLASSNAME) : class$org$omg$cwm$analysis$olap$HierarchyLevelAssociation, false);
            levelObj.setHierarchyLevelAssocMofId(hla.refMofId());
            levelList.add(level);
        }
        loc.exiting();
        return levelList;
    }

    private ModelElement createModelElementLevel(LevelObject levelObj) throws BIResourceException {
        loc.entering("createModelElementLevel(LevelObject levelObj)");
        Level level = (Level)this.getMetaStore().getInstance(levelObj);
        if (level == null) {
            ArrayList<Object> args = new ArrayList<Object>(5);
            args.add(levelObj.getLevelName());
            args.add(VisibilityKindEnum.VK_PUBLIC);
            args.add(Boolean.FALSE);
            level = (Level)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), LEVEL_CLASSNAME, args, true);
            ((IMMRObject)level).set___State(StateEnum.STATE_UNCHANGED);
            levelObj.setMofId(level.refMofId());
            this.rtcounter.incrementCounter(4);
            this.createTaggedValueLevel(level, levelObj);
            this.submitM1Instance();
            this.getMetaStore().putInstance(levelObj, level);
        }
        loc.exiting();
        return level;
    }

    private ModelElement createModelElementHierarchyLevelAssociation(LevelObject levelObj) throws BIResourceException {
        loc.entering("createModelElementHierarchyLevelAssociation(LevelObject levelObj)");
        Level level = (Level)this.getMetaStore().getInstance(levelObj);
        if (level != null) {
            ArrayList<Object> args = new ArrayList<Object>(3);
            args.add(levelObj.getHierarchyUniqueName() + levelObj.getLevelUniqueName());
            args.add(VisibilityKindEnum.VK_PUBLIC);
            args.add(Boolean.FALSE);
            HierarchyLevelAssociation hla = (HierarchyLevelAssociation)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), HIERARCHYLEVELASSOC_CLASSNAME, args, true);
            this.rtcounter.incrementCounter(4);
            hla.setName(levelObj.getHierarchyUniqueName() + levelObj.getLevelName());
            ((IMMRObject)hla).set___State(StateEnum.STATE_UNCHANGED);
            this.submitM1Instance();
            this.getMetaStore().putInstanceByMofId(hla.refMofId(), hla);
            loc.exiting();
            return hla;
        }
        loc.exiting();
        return null;
    }

    private List getMeasure(Cube cube) throws BIResourceException {
        loc.entering("getMeasure(Cube cube)");
        if (cube == null) {
            throw new BIResourceException(this.getLocale(), "sdk.dac.connector_2009", new Object[]{"Cube"});
        }
        CubeObject cubeObj = (CubeObject)this.getMetaStore().getObjectByMofId(cube.refMofId());
        if (cubeObj == null) {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_2017", new Object[]{cube.refMofId()});
        }
        loc.exiting();
        return this.getMeasure(cubeObj);
    }

    private List getMeasure(CubeObject cubeObj) throws BIResourceException {
        loc.entering("getMeasure(CubeObject cubeObj)");
        this.assertLoadMeasures(cubeObj);
        ArrayList<Measure> measureList = new ArrayList<Measure>();
        Iterator i = this.getMetaStore().getMeasure().values().iterator();
        while (i.hasNext()) {
            MeasureObject s = (MeasureObject)i.next();
            Measure measure = (Measure)this.createM1Instance(s, class$org$omg$cwm$analysis$olap$Measure == null ? OlapMDRConnection.class$("org.omg.cwm.analysis.olap.Measure") : class$org$omg$cwm$analysis$olap$Measure, false);
            measureList.add(measure);
        }
        loc.exiting();
        return measureList;
    }

    private List getSAPVariable(CubeObject cubeObj) throws BIResourceException {
        loc.entering("getSAPVariable(CubeObject cubeObj)");
        this.assertLoadSAPVariables(cubeObj);
        ArrayList<IBISapVariable> variableList = new ArrayList<IBISapVariable>();
        Iterator i = this.getMetaStore().getSAPVariable().values().iterator();
        while (i.hasNext()) {
            BISAPVariableObject s = (BISAPVariableObject)i.next();
            IBISapVariable variable = (IBISapVariable)this.createM1Instance(s, class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapVariable == null ? OlapMDRConnection.class$("com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariable") : class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapVariable, false);
            variableList.add(variable);
        }
        loc.exiting();
        return variableList;
    }

    private ModelElement createModelElementMeasure(MeasureObject measureObj) throws BIResourceException {
        loc.entering("createMeasure(MeasureObject measureObj)");
        Measure measure = (Measure)this.getMetaStore().getInstance(measureObj);
        if (measure == null) {
            ArrayList<String> args = new ArrayList<String>(8);
            args.add(measureObj.getMeasureName());
            args.add((String)VisibilityKindEnum.VK_PUBLIC);
            args.add(null);
            args.add(null);
            args.add(null);
            args.add(null);
            args.add(null);
            args.add(null);
            measure = (Measure)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), MEASURE_CLASSNAME, args, true);
            this.rtcounter.incrementCounter(4);
            ((IMMRObject)measure).set___State(StateEnum.STATE_UNCHANGED);
            measureObj.setMofId(measure.refMofId());
            this.createTaggedValueMeasure(measure, measureObj);
            this.submitM1Instance();
            this.getMetaStore().putInstance(measureObj, measure);
        }
        loc.exiting();
        return measure;
    }

    private List getAttribute(DimensionObject dimObj) throws BIResourceException {
        loc.entering("getAttribute(DimensionObject dimObj)");
        this.assertLoadAttributes(dimObj);
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        Iterator i = this.getMetaStore().getAttribute(dimObj).iterator();
        while (i.hasNext()) {
            AttributeObject attrObj = (AttributeObject)i.next();
            Attribute attribute = (Attribute)this.createM1Instance(attrObj, class$org$omg$cwm$objectmodel$core$Attribute == null ? OlapMDRConnection.class$("org.omg.cwm.objectmodel.core.Attribute") : class$org$omg$cwm$objectmodel$core$Attribute, false);
            attributeList.add(attribute);
        }
        this.submitM1Instance();
        loc.exiting();
        return attributeList;
    }

    private ModelElement createModelElementAttribute(AttributeObject attributeObj) throws BIResourceException {
        loc.entering("createModelElementAttribute(AttributeObject attributeObj)");
        Attribute attribute = (Attribute)this.getMetaStore().getInstance(attributeObj);
        if (attribute == null) {
            ArrayList<String> args = new ArrayList<String>(8);
            args.add(attributeObj.getPropertyName());
            args.add((String)VisibilityKindEnum.VK_PUBLIC);
            args.add(null);
            args.add(null);
            args.add(null);
            args.add(null);
            args.add(null);
            args.add(null);
            attribute = (Attribute)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), ATTRIBUTE_CLASSNAME, args, true);
            ((IMMRObject)attribute).set___State(StateEnum.STATE_UNCHANGED);
            attributeObj.setMofId(attribute.refMofId());
            this.createTaggedValueAttribute(attribute, attributeObj);
            this.getMetaStore().putInstance(attributeObj, attribute);
        }
        loc.exiting();
        return attribute;
    }

    private ModelElement createModelElementSAPVariable(BISAPVariableObject variableObj) throws BIResourceException {
        IBISapVariable variable = (IBISapVariable)this.getMetaStore().getInstance(variableObj);
        if (variable == null) {
            if (variableObj.getVariableType() == BISAPVariableConstants.SAPVariableType.SAP_VAR_TYPE_MEMBER) {
                ArrayList<String> args = new ArrayList<String>(14);
                args.add(variableObj.getVariableName());
                args.add((String)VisibilityKindEnum.VK_PUBLIC);
                args.add(null);
                args.add(null);
                args.add(null);
                args.add(null);
                args.add(null);
                args.add(null);
                args.add(variableObj.getVariableGUID());
                args.add(variableObj.getVariableCaption());
                args.add(variableObj.getDescription());
                this.addSelectionType(variableObj, args);
                this.addEntryType(variableObj, args);
                IBISapMemberVariable memberVariable = (IBISapMemberVariable)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), (class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapMemberVariable == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapMemberVariable = OlapMDRConnection.class$("com.sap.ip.bi.sdk.dac.olap.query.var.IBISapMemberVariable")) : class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapMemberVariable).getName(), args, true);
                this.rtcounter.incrementCounter(4);
                ((IMMRObject)memberVariable).set___State(StateEnum.STATE_UNCHANGED);
                variableObj.setMofId(memberVariable.refMofId());
                this.createTaggedValueSAPVariable((IBISapVariable)memberVariable, variableObj);
                this.getMetaStore().putInstance(variableObj, memberVariable);
                return memberVariable;
            }
            if (variableObj.getVariableType() == BISAPVariableConstants.SAPVariableType.SAP_VAR_TYPE_HIERARCHY) {
                ArrayList<String> args = new ArrayList<String>(13);
                args.add(variableObj.getVariableName());
                args.add((String)VisibilityKindEnum.VK_PUBLIC);
                args.add(null);
                args.add(null);
                args.add(null);
                args.add(null);
                args.add(null);
                args.add(null);
                args.add(variableObj.getVariableCaption());
                args.add(variableObj.getDescription());
                this.addSelectionType(variableObj, args);
                this.addEntryType(variableObj, args);
                IBISapHierarchyVariable hierarchyVariable = (IBISapHierarchyVariable)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), (class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapHierarchyVariable == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapHierarchyVariable = OlapMDRConnection.class$("com.sap.ip.bi.sdk.dac.olap.query.var.IBISapHierarchyVariable")) : class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapHierarchyVariable).getName(), args, true);
                this.rtcounter.incrementCounter(4);
                hierarchyVariable.setId(variableObj.getVariableGUID());
                ((IMMRObject)hierarchyVariable).set___State(StateEnum.STATE_UNCHANGED);
                variableObj.setMofId(hierarchyVariable.refMofId());
                this.createTaggedValueSAPVariable((IBISapVariable)hierarchyVariable, variableObj);
                this.getMetaStore().putInstance(variableObj, hierarchyVariable);
                return hierarchyVariable;
            }
            if (variableObj.getVariableType() == BISAPVariableConstants.SAPVariableType.SAP_VAR_TYPE_NUMERIC) {
                ArrayList<String> args = new ArrayList<String>(14);
                args.add(variableObj.getVariableName());
                args.add((String)VisibilityKindEnum.VK_PUBLIC);
                args.add(null);
                args.add(null);
                args.add(null);
                args.add(null);
                args.add(null);
                args.add(null);
                args.add(variableObj.getVariableCaption());
                args.add(variableObj.getDescription());
                this.addSelectionType(variableObj, args);
                this.addEntryType(variableObj, args);
                IBISapNumericVariable numericVariable = (IBISapNumericVariable)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), (class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapNumericVariable == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapNumericVariable = OlapMDRConnection.class$("com.sap.ip.bi.sdk.dac.olap.query.var.IBISapNumericVariable")) : class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapNumericVariable).getName(), args, true);
                this.rtcounter.incrementCounter(4);
                numericVariable.setId(variableObj.getVariableGUID());
                ((IMMRObject)numericVariable).set___State(StateEnum.STATE_UNCHANGED);
                variableObj.setMofId(numericVariable.refMofId());
                this.createTaggedValueSAPVariable((IBISapVariable)numericVariable, variableObj);
                this.getMetaStore().putInstance(variableObj, numericVariable);
                return numericVariable;
            }
        }
        loc.exiting();
        return null;
    }

    protected abstract LevelBasedHierarchy findHierarchyFirst(BISAPVariableObject var1) throws BIResourceException;

    protected abstract Dimension findDimensionFirst(BISAPVariableObject var1) throws BIResourceException;

    protected abstract IBIMember findMemberHigh(BISAPVariableObject var1) throws BIResourceException;

    protected abstract IBIMember findMemberLow(BISAPVariableObject var1) throws BIResourceException;

    private void addSelectionType(BISAPVariableObject variableObj, List args) {
        if (variableObj.getVariableSelectionType() == BISAPVariableConstants.SAPVariableSelectionType.SAP_VAR_SEL_TYPE_INTERVAL) {
            args.add(IBISapVariableSelectionTypeEnum.INTERVAL);
        } else if (variableObj.getVariableSelectionType() == BISAPVariableConstants.SAPVariableSelectionType.SAP_VAR_SEL_TYPE_VALUE) {
            args.add(IBISapVariableSelectionTypeEnum.SINGLEVALUE);
        } else if (variableObj.getVariableSelectionType() == BISAPVariableConstants.SAPVariableSelectionType.SAP_VAR_SEL_TYPE_COMPLEX) {
            args.add(IBISapVariableSelectionTypeEnum.COMPLEX);
        }
    }

    private void addEntryType(BISAPVariableObject variableObj, List args) {
        if (variableObj.getVariableEntryType() == BISAPVariableConstants.SAPVariableEntryType.SAP_VAR_INPUT_TYPE_OPTIONAL) {
            args.add(Boolean.TRUE);
            args.add(Boolean.FALSE);
        } else if (variableObj.getVariableEntryType() == BISAPVariableConstants.SAPVariableEntryType.SAP_VAR_INPUT_TYPE_MANDATORY) {
            args.add(Boolean.TRUE);
            args.add(Boolean.TRUE);
        } else if (variableObj.getVariableEntryType() == BISAPVariableConstants.SAPVariableEntryType.SAP_VAR_INPUT_TYPE_MANDATORY_NOT_INITIAL) {
            args.add(Boolean.FALSE);
            args.add(Boolean.TRUE);
        } else {
            args.add(Boolean.FALSE);
            args.add(Boolean.FALSE);
        }
    }

    public void submitM1Instance() throws BIResourceException {
        try {
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelElement createM1Instance(OlapSchemaObject olapSchemaObject, Class instance, boolean autoCommit) throws BIResourceException {
        ModelElement modelElement;
        loc.entering("createM1Instance()");
        try {
            try {
                modelElement = this.createM1InstanceInternal(olapSchemaObject, instance);
                Object var6_6 = null;
            }
            catch (ResourceException e) {
                throw new BIResourceException(this.getLocale(), "sdk.dac.connector.mmr_2000", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            loc.exiting();
            throw throwable;
        }
        loc.exiting();
        return modelElement;
    }

    private ModelElement createM1InstanceInternal(OlapSchemaObject olapSchemaObject, Class instance) throws BIResourceException {
        if (instance.equals(class$org$omg$cwm$analysis$olap$Schema == null ? (class$org$omg$cwm$analysis$olap$Schema = OlapMDRConnection.class$(SCHEMA_CLASSNAME)) : class$org$omg$cwm$analysis$olap$Schema)) {
            return this.createModelElementSchema((SchemaObject)olapSchemaObject);
        }
        if (instance.equals(class$org$omg$cwm$analysis$olap$Cube == null ? (class$org$omg$cwm$analysis$olap$Cube = OlapMDRConnection.class$(CUBE_CLASSNAME)) : class$org$omg$cwm$analysis$olap$Cube)) {
            return this.createModelElementCube((CubeObject)olapSchemaObject);
        }
        if (instance.equals(class$org$omg$cwm$analysis$olap$CubeDimensionAssociation == null ? (class$org$omg$cwm$analysis$olap$CubeDimensionAssociation = OlapMDRConnection.class$(CUBEDIMENSIONASSOC_CLASSNAME)) : class$org$omg$cwm$analysis$olap$CubeDimensionAssociation)) {
            return this.createModelElementCubeDimensionAssociation((DimensionObject)olapSchemaObject);
        }
        if (instance.equals(class$org$omg$cwm$analysis$olap$Dimension == null ? (class$org$omg$cwm$analysis$olap$Dimension = OlapMDRConnection.class$(DIMENSION_CLASSNAME)) : class$org$omg$cwm$analysis$olap$Dimension)) {
            return this.createModelElementDimension((DimensionObject)olapSchemaObject);
        }
        if (instance.equals(class$org$omg$cwm$analysis$olap$LevelBasedHierarchy == null ? (class$org$omg$cwm$analysis$olap$LevelBasedHierarchy = OlapMDRConnection.class$(LEVELBASEDHERARCHY_CLASSNAME)) : class$org$omg$cwm$analysis$olap$LevelBasedHierarchy)) {
            return this.createModelElementLevelBasedHierarchy((LevelBasedHierarchyObject)olapSchemaObject);
        }
        if (instance.equals(class$org$omg$cwm$analysis$olap$Level == null ? (class$org$omg$cwm$analysis$olap$Level = OlapMDRConnection.class$(LEVEL_CLASSNAME)) : class$org$omg$cwm$analysis$olap$Level)) {
            return this.createModelElementLevel((LevelObject)olapSchemaObject);
        }
        if (instance.equals(class$org$omg$cwm$analysis$olap$HierarchyLevelAssociation == null ? (class$org$omg$cwm$analysis$olap$HierarchyLevelAssociation = OlapMDRConnection.class$(HIERARCHYLEVELASSOC_CLASSNAME)) : class$org$omg$cwm$analysis$olap$HierarchyLevelAssociation)) {
            return this.createModelElementHierarchyLevelAssociation((LevelObject)olapSchemaObject);
        }
        if (instance.equals(class$org$omg$cwm$analysis$olap$Measure == null ? (class$org$omg$cwm$analysis$olap$Measure = OlapMDRConnection.class$("org.omg.cwm.analysis.olap.Measure")) : class$org$omg$cwm$analysis$olap$Measure)) {
            return this.createModelElementMeasure((MeasureObject)olapSchemaObject);
        }
        if (instance.equals(class$org$omg$cwm$objectmodel$core$Attribute == null ? (class$org$omg$cwm$objectmodel$core$Attribute = OlapMDRConnection.class$("org.omg.cwm.objectmodel.core.Attribute")) : class$org$omg$cwm$objectmodel$core$Attribute)) {
            return this.createModelElementAttribute((AttributeObject)olapSchemaObject);
        }
        if (instance.equals(class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapVariable == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapVariable = OlapMDRConnection.class$("com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariable")) : class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapVariable)) {
            return this.createModelElementSAPVariable((BISAPVariableObject)olapSchemaObject);
        }
        throw new BIResourceException(this.getLocale(), "sdk_1000", new Object[]{instance.getName()});
    }

    public AssociationsOfObject selectM1Assoc(IConnection connection, String associationId, String mofId) {
        loc.entering("selectM1Assoc()");
        loc.debugT("associationId" + associationId + "   mofId::" + mofId);
        if (!this.assertConnection(connection)) {
            return null;
        }
        if (associationId == null) {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1004");
        }
        OlapSchemaObject object = this.getMetaStore().getObjectByMofId(mofId);
        if (associationId.equals(ASSOC_TAGGEDELEMENT)) {
            loc.exiting();
            return this.selectTaggedValueAssoc(associationId, mofId);
        }
        if (associationId.equals(ASSOC_CUBE_SAPVARIABLE)) {
            return this.selectCubeOwnsSapVariableAssoc(associationId, mofId);
        }
        if (object instanceof SchemaObject) {
            loc.exiting();
            return this.selectSchemaAssoc(connection, associationId, (SchemaObject)object);
        }
        if (object instanceof CubeObject) {
            loc.exiting();
            return this.selectCubeAssoc(connection, associationId, (CubeObject)object);
        }
        if (object instanceof DimensionObject) {
            loc.exiting();
            return this.selectDimensionAssoc(connection, associationId, (DimensionObject)object);
        }
        if (object instanceof LevelBasedHierarchyObject) {
            loc.exiting();
            return this.selectLevelBasedHierarchyAssoc(connection, associationId, (LevelBasedHierarchyObject)object);
        }
        if (object instanceof LevelObject) {
            loc.exiting();
            return this.selectLevelAssoc(connection, associationId, (LevelObject)object);
        }
        if (object instanceof MeasureObject) {
            loc.exiting();
            return this.selectMeasureAssoc(connection, associationId, (MeasureObject)object);
        }
        if (object instanceof BISAPVariableObject) {
            loc.exiting();
            return this.selectSAPVariableAssoc(connection, associationId, (BISAPVariableObject)object);
        }
        if (associationId.equalsIgnoreCase(ASSOC_CUBEDIMENSIONASSOCIATION_DIMENSION)) {
            loc.exiting();
            return this.selectCubeDimensionAssociationAssoc(connection, associationId, mofId);
        }
        if (associationId.equalsIgnoreCase(ASSOC_CUBE_CUBEDIMENSIONASSOCIATION)) {
            loc.exiting();
            return this.selectCubeDimensionAssociationAssoc(connection, associationId, mofId);
        }
        if (associationId.equalsIgnoreCase(ASSOC_HIERARCHYLEVELASSOCIATION_LEVEL)) {
            loc.exiting();
            return this.selectHierarchyLevelAssociationAssoc(connection, associationId, mofId);
        }
        if (associationId.equalsIgnoreCase(ASSOC_LEVELBASEDHIERARCHY_HIERARCHYLEVELASSOCIATION)) {
            loc.exiting();
            return this.selectHierarchyLevelAssociationAssoc(connection, associationId, mofId);
        }
        if (associationId.equals(ASSOC_SCHEMA_DIMENSION)) {
            loc.exiting();
            return null;
        }
        if (associationId.equals(ASSOC_DIMENSION_MEMBERSELECTION) & !(object instanceof Dimension)) {
            loc.exiting();
            return null;
        }
        if (associationId.equals(ASSOC_DIMENSION_MEMBER)) {
            loc.exiting();
            return null;
        }
        if (associationId.startsWith(PACKAGE_QUERY)) {
            loc.exiting();
            return null;
        }
        if (object == null) {
            loc.exiting();
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_2009", new Object[]{mofId});
        }
        loc.exiting();
        throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_2010", new Object[]{object.getClass().toString(), mofId});
    }

    public Collection insertM1(IConnection connection, Collection objects) {
        return null;
    }

    public List queryM1(IConnection connection, List qualifiedNameOfType, QueryFilters filters) {
        return null;
    }

    public Collection selectM1(IConnection connection, Collection mofIdsOrObjects, boolean forUpdate) {
        loc.entering("selectM1()");
        ArrayList<Object> selected = new ArrayList<Object>();
        Iterator iter = mofIdsOrObjects.iterator();
        while (iter.hasNext()) {
            String mofId;
            Object item = iter.next();
            Object stored = null;
            if (item instanceof String) {
                mofId = (String)item;
                stored = this.getMetaStore().getInstanceByMofId(mofId);
            } else {
                ModelElement elem = (ModelElement)item;
                mofId = elem.refMofId();
                stored = (ModelElement)this.getMetaStore().getInstanceByMofId(mofId);
            }
            if (stored == null) continue;
            selected.add(stored);
        }
        loc.exiting();
        return selected.size() > 0 ? selected : null;
    }

    private AssociationsOfObject selectSchemaAssoc(IConnection connection, String associationId, SchemaObject schema) {
        loc.entering("selectSchemaAssoc()");
        String schemaMofID = schema.getMofId();
        AssociationsOfObject assocObj = new AssociationsOfObject(schemaMofID);
        if (associationId.equalsIgnoreCase(ASSOC_SCHEMA_CUBE)) {
            try {
                this.assertSchemaCubeAssocLoaded(schema);
                this.getCube(schema);
            }
            catch (BIResourceException ex) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_SCHEMA_CUBE}, (Throwable)((Object)ex));
            }
            Iterator cubObjs = this.getMetaStore().getCube(schema).iterator();
            while (cubObjs.hasNext()) {
                CubeObject cubeObj = (CubeObject)cubObjs.next();
                String cubeMofId = cubeObj.getMofId();
                assocObj.getMofIdsBackward().add(new Association(schemaMofID, cubeMofId, associationId));
            }
        } else if (associationId.equalsIgnoreCase(ASSOC_SCHEMA_DIMENSION)) {
            try {
                this.assertSchemaDimensionAssocLoaded(schema);
                List cubes = this.getCube(schema);
                Iterator i = cubes.iterator();
                while (i.hasNext()) {
                    this.getDimension((Cube)i.next());
                }
            }
            catch (BIResourceException ex) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_SCHEMA_DIMENSION}, (Throwable)((Object)ex));
            }
            Iterator dimObjs = this.getMetaStore().getDimension(schema).iterator();
            while (dimObjs.hasNext()) {
                DimensionObject dimObj = (DimensionObject)dimObjs.next();
                assocObj.getMofIdsBackward().add(new Association(schemaMofID, dimObj.getMofId(), associationId));
            }
        } else {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
        }
        loc.exiting();
        return assocObj;
    }

    private AssociationsOfObject selectCubeAssoc(IConnection connection, String associationId, CubeObject cube) {
        loc.entering("selectCubeAssoc()");
        if (associationId.equalsIgnoreCase(ASSOC_CLASSIFIER_FEATURE)) {
            String cubeMofID = cube.getMofId();
            Set measureObjs = Collections.EMPTY_SET;
            AssociationsOfObject assocObj = new AssociationsOfObject(cubeMofID);
            try {
                this.assertClassifierFeatureAssocLoaded(cube);
                measureObjs = this.getMetaStore().getMeasure(cube);
                this.getMeasure(cube);
            }
            catch (BIResourceException ex) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_CLASSIFIER_FEATURE}, (Throwable)((Object)ex));
            }
            Iterator i = measureObjs.iterator();
            while (i.hasNext()) {
                MeasureObject measureObj = (MeasureObject)i.next();
                assocObj.getMofIdsForward().add(new Association(cubeMofID, measureObj.getMofId(), associationId));
                this.rtcounter.incrementCounter(4);
            }
            loc.exiting();
            return assocObj;
        }
        if (associationId.equalsIgnoreCase(ASSOC_CUBE_CUBEDIMENSIONASSOCIATION)) {
            String cubeMofID = cube.getMofId();
            Set dimObjs = Collections.EMPTY_SET;
            AssociationsOfObject assocObj = new AssociationsOfObject(cubeMofID);
            try {
                this.assertLoadCubeDimensionAssoc(cube);
                dimObjs = this.getMetaStore().getDimension(cube);
                this.getDimension(cube);
            }
            catch (BIResourceException ex) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_CUBE_CUBEDIMENSIONASSOCIATION}, (Throwable)((Object)ex));
            }
            Iterator i = dimObjs.iterator();
            while (i.hasNext()) {
                DimensionObject dimObj = (DimensionObject)i.next();
                assocObj.getMofIdsForward().add(new Association(cubeMofID, dimObj.getCubeDimensionAssocMofId(), associationId));
                this.rtcounter.incrementCounter(4);
            }
            loc.exiting();
            return assocObj;
        }
        if (associationId.equalsIgnoreCase(ASSOC_SCHEMA_CUBE)) {
            String cubeMofID = cube.getMofId();
            try {
                this.assertSchemaCubeAssocLoaded(cube);
            }
            catch (BIResourceException ex) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_SCHEMA_CUBE}, (Throwable)((Object)ex));
            }
            SchemaObject schemaObj = this.getMetaStore().getSchema(cube);
            if (schemaObj == null || schemaObj.getMofId() == null) {
                try {
                    this.getSchema();
                }
                catch (BIResourceException ex) {
                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_DIMENSION_MEMBERSELECTION}, (Throwable)((Object)ex));
                }
                schemaObj = this.getMetaStore().getSchema(cube);
            }
            AssociationsOfObject assocObj = new AssociationsOfObject(cubeMofID);
            assocObj.getMofIdsForward().add(new Association(cubeMofID, schemaObj.getMofId(), associationId));
            loc.exiting();
            return assocObj;
        }
        loc.exiting();
        throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
    }

    private AssociationsOfObject selectDimensionAssoc(IConnection connection, String associationId, DimensionObject dimension) {
        loc.entering("selectDimensionAssoc()");
        String dimensionMofID = dimension.getMofId();
        AssociationsOfObject assocObj = new AssociationsOfObject(dimensionMofID);
        if (associationId.equalsIgnoreCase(ASSOC_CLASSIFIER_FEATURE)) {
            Set attrObjs = Collections.EMPTY_SET;
            try {
                this.assertClassifierFeatureAssocLoaded(dimension);
                attrObjs = this.getMetaStore().getAttribute(dimension);
                this.getAttribute(dimension);
            }
            catch (BIResourceException ex) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_CLASSIFIER_FEATURE}, (Throwable)((Object)ex));
            }
            Iterator i = attrObjs.iterator();
            while (i.hasNext()) {
                AttributeObject attrObj = (AttributeObject)i.next();
                assocObj.getMofIdsForward().add(new Association(dimensionMofID, attrObj.getMofId(), associationId));
                this.rtcounter.incrementCounter(4);
            }
            loc.exiting();
            return assocObj;
        }
        if (associationId.equalsIgnoreCase(ASSOC_SCHEMA_DIMENSION)) {
            try {
                this.assertSchemaDimensionAssocLoaded(dimension);
            }
            catch (BIResourceException ex) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_SCHEMA_DIMENSION}, (Throwable)((Object)ex));
            }
            SchemaObject schemaObj = this.getMetaStore().getSchema(dimension);
            if (schemaObj == null || schemaObj.getMofId() == null) {
                try {
                    this.getSchema();
                }
                catch (BIResourceException ex) {
                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_DIMENSION_MEMBERSELECTION}, (Throwable)((Object)ex));
                }
                schemaObj = this.getMetaStore().getSchema(dimension);
            }
            assocObj.getMofIdsForward().add(new Association(dimensionMofID, schemaObj.getMofId(), associationId));
            this.rtcounter.incrementCounter(4);
        } else if (associationId.equalsIgnoreCase(ASSOC_CUBEDIMENSIONASSOCIATION_DIMENSION)) {
            assocObj.getMofIdsForward().add(new Association(dimensionMofID, dimension.getCubeDimensionAssocMofId(), associationId));
            this.rtcounter.incrementCounter(4);
        } else if (associationId.equalsIgnoreCase(ASSOC_DIMENSION_HIERARCHY)) {
            try {
                this.assertDimensionHierarchyAssocLoaded(dimension);
                this.getLevelBasedHierarchy(dimension);
            }
            catch (BIResourceException ex) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_DIMENSION_HIERARCHY}, (Throwable)((Object)ex));
            }
            Iterator hieObjs = this.getMetaStore().getHierarchy(dimension).iterator();
            while (hieObjs.hasNext()) {
                LevelBasedHierarchyObject hieObj = (LevelBasedHierarchyObject)hieObjs.next();
                assocObj.getMofIdsForward().add(new Association(dimensionMofID, hieObj.getMofId(), associationId));
                this.rtcounter.incrementCounter(4);
            }
        } else if (associationId.equalsIgnoreCase(ASSOC_DIMENSION_MEMBERSELECTION)) {
            boolean hierarchyHasLevel = true;
            try {
                List levels;
                this.assertDimensionHierarchyAssocLoaded(dimension);
                List hies = this.getLevelBasedHierarchy(dimension);
                Iterator i = hies.iterator();
                while (i.hasNext()) {
                    levels = this.getLevel((LevelBasedHierarchy)i.next());
                    if (levels != null && levels.size() != 0) continue;
                    hierarchyHasLevel = false;
                }
                if (!hierarchyHasLevel) {
                    this.assertLevelsLoaded(dimension);
                    levels = this.getLevel(dimension);
                }
            }
            catch (BIResourceException ex) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_DIMENSION_MEMBERSELECTION}, (Throwable)((Object)ex));
            }
            Iterator levelObjs = this.getMetaStore().getLevel(dimension).iterator();
            while (levelObjs.hasNext()) {
                LevelObject levelObj = (LevelObject)levelObjs.next();
                assocObj.getMofIdsForward().add(new Association(dimensionMofID, levelObj.getMofId(), associationId));
                this.rtcounter.incrementCounter(4);
            }
        } else {
            if (associationId.equals(ASSOC_TAGGEDELEMENT)) {
                loc.exiting();
                return null;
            }
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
        }
        loc.exiting();
        return assocObj;
    }

    protected List getLevel(DimensionObject dimensionObj) throws BIResourceException {
        loc.entering("getLevel(DimensionObject dimensionObj)");
        this.assertLevelsLoaded(dimensionObj);
        ArrayList<Level> levelList = new ArrayList<Level>();
        Iterator i = this.getMetaStore().getLevel(dimensionObj).iterator();
        while (i.hasNext()) {
            LevelObject levelObj = (LevelObject)i.next();
            Level level = (Level)this.createM1Instance(levelObj, class$org$omg$cwm$analysis$olap$Level == null ? OlapMDRConnection.class$(LEVEL_CLASSNAME) : class$org$omg$cwm$analysis$olap$Level, false);
            HierarchyLevelAssociation hla = (HierarchyLevelAssociation)this.createM1Instance(levelObj, class$org$omg$cwm$analysis$olap$HierarchyLevelAssociation == null ? OlapMDRConnection.class$(HIERARCHYLEVELASSOC_CLASSNAME) : class$org$omg$cwm$analysis$olap$HierarchyLevelAssociation, false);
            levelObj.setHierarchyLevelAssocMofId(hla.refMofId());
            levelList.add(level);
        }
        loc.exiting();
        return levelList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AssociationsOfObject selectCubeDimensionAssociationAssoc(IConnection connection, String associationId, String cdaMofId) {
        loc.entering("selectCubeDimensionAssociationAssoc()");
        String dimensionMofId = null;
        DimensionObject dim = null;
        Iterator dims = this.getMetaStore().getDimension().values().iterator();
        while (dims.hasNext()) {
            dim = (DimensionObject)dims.next();
            String dimCdaMofId = dim.getCubeDimensionAssocMofId();
            if (dimCdaMofId == null || !dimCdaMofId.equals(cdaMofId)) continue;
            dimensionMofId = dim.getMofId();
            break;
        }
        AssociationsOfObject assocObj = new AssociationsOfObject(cdaMofId);
        if (associationId.equalsIgnoreCase(ASSOC_CUBEDIMENSIONASSOCIATION_DIMENSION)) {
            if (dimensionMofId == null) return null;
            assocObj.getMofIdsBackward().add(new Association(cdaMofId, dimensionMofId, associationId));
            this.rtcounter.incrementCounter(4);
        } else if (associationId.equalsIgnoreCase(ASSOC_CUBE_CUBEDIMENSIONASSOCIATION)) {
            CubeObject cubeObj = this.getMetaStore().getCube(dim);
            String cubeMofId = null;
            if (cubeObj != null) {
                cubeMofId = this.getMetaStore().getCube(dim).getMofId();
            }
            if (cubeMofId == null) {
                try {
                    this.getCube();
                }
                catch (BIResourceException ex) {
                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_DIMENSION_MEMBERSELECTION}, (Throwable)((Object)ex));
                }
                cubeMofId = this.getMetaStore().getCube(dim).getMofId();
            }
            assocObj.getMofIdsBackward().add(new Association(cdaMofId, cubeMofId, associationId));
            this.rtcounter.incrementCounter(4);
        } else {
            if (!associationId.equalsIgnoreCase(ASSOC_CUBEDIMENSIONASSOCIATION_CALCHIERARCHY)) throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
            loc.exiting();
            return null;
        }
        loc.exiting();
        return assocObj;
    }

    private AssociationsOfObject selectLevelBasedHierarchyAssoc(IConnection connection, String associationId, LevelBasedHierarchyObject hierarchy) {
        loc.entering("selectLevelBasedHierarchyAssoc()");
        String hieMofID = hierarchy.getMofId();
        AssociationsOfObject assocObj = new AssociationsOfObject(hieMofID);
        if (associationId.equalsIgnoreCase(ASSOC_DIMENSION_HIERARCHY)) {
            try {
                this.assertDimensionHierarchyAssocLoaded(hierarchy);
            }
            catch (BIResourceException ex) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_DIMENSION_HIERARCHY}, (Throwable)((Object)ex));
            }
            DimensionObject dimensionObj = this.getMetaStore().getDimension(hierarchy);
            if (dimensionObj == null || dimensionObj.getMofId() == null) {
                try {
                    CubeObject cube = new CubeObject(hierarchy.getCatalogName(), hierarchy.getSchemaName(), hierarchy.getCubeName());
                    this.getDimension(cube);
                }
                catch (BIResourceException ex) {
                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_DIMENSION_MEMBERSELECTION}, (Throwable)((Object)ex));
                }
                dimensionObj = this.getMetaStore().getDimension(hierarchy);
            }
            assocObj.getMofIdsBackward().add(new Association(hieMofID, dimensionObj.getMofId(), associationId));
            this.rtcounter.incrementCounter(4);
        } else if (associationId.equalsIgnoreCase(ASSOC_LEVELBASEDHIERARCHY_HIERARCHYLEVELASSOCIATION)) {
            try {
                this.assertLoadHierarchyLevelAssoc(hierarchy);
                this.getLevel(hierarchy);
            }
            catch (BIResourceException ex) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_LEVELBASEDHIERARCHY_HIERARCHYLEVELASSOCIATION}, (Throwable)((Object)ex));
            }
            Iterator levelObjs = this.getMetaStore().getLevel(hierarchy).iterator();
            while (levelObjs.hasNext()) {
                LevelObject levelObj = (LevelObject)levelObjs.next();
                assocObj.getMofIdsForward().add(new Association(hieMofID, levelObj.getHierarchyLevelAssocMofId(), associationId));
                this.rtcounter.incrementCounter(4);
            }
        } else {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
        }
        loc.exiting();
        return assocObj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AssociationsOfObject selectHierarchyLevelAssociationAssoc(IConnection connection, String associationId, String hlaMofId) {
        loc.entering("selectHierarchyLevelAssociationAssoc()");
        String levelMofId = null;
        LevelObject level = null;
        Iterator levels = this.getMetaStore().getLevel().values().iterator();
        while (levels.hasNext()) {
            level = (LevelObject)levels.next();
            if (level.getHierarchyLevelAssocMofId() == null || !level.getHierarchyLevelAssocMofId().equals(hlaMofId)) continue;
            levelMofId = level.getMofId();
            break;
        }
        AssociationsOfObject assocObj = new AssociationsOfObject(hlaMofId);
        if (associationId.equalsIgnoreCase(ASSOC_HIERARCHYLEVELASSOCIATION_LEVEL)) {
            if (levelMofId == null) {
                loc.exiting();
                return null;
            }
            assocObj.getMofIdsBackward().add(new Association(hlaMofId, levelMofId, associationId));
            this.rtcounter.incrementCounter(4);
        } else {
            if (!associationId.equalsIgnoreCase(ASSOC_LEVELBASEDHIERARCHY_HIERARCHYLEVELASSOCIATION)) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
            }
            LevelBasedHierarchyObject hieObj = this.getMetaStore().getHierarchy(level);
            String hieMofId = null;
            if (hieObj != null) {
                hieMofId = this.getMetaStore().getHierarchy(level).getMofId();
            }
            if (hieMofId == null) {
                DimensionObject dim = new DimensionObject(level.getCatalogName(), level.getSchemaName(), level.getCubeName(), level.getDimensionUniqueName());
                try {
                    this.getLevelBasedHierarchy(dim);
                }
                catch (BIResourceException ex) {
                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_DIMENSION_MEMBERSELECTION}, (Throwable)((Object)ex));
                }
                hieMofId = this.getMetaStore().getHierarchy(level).getMofId();
            }
            assocObj.getMofIdsBackward().add(new Association(hlaMofId, hieMofId, associationId));
            this.rtcounter.incrementCounter(4);
        }
        loc.exiting();
        return assocObj;
    }

    private AssociationsOfObject selectLevelAssoc(IConnection connection, String associationId, LevelObject level) {
        loc.entering("selectLevelAssoc()");
        String levelMofID = level.getMofId();
        AssociationsOfObject assocObj = new AssociationsOfObject(levelMofID);
        if (associationId.equalsIgnoreCase(ASSOC_DIMENSION_MEMBERSELECTION)) {
            try {
                this.assertDimensionMemberSelectionAssocLoaded(level);
            }
            catch (BIResourceException ex) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_DIMENSION_MEMBERSELECTION}, (Throwable)((Object)ex));
            }
            DimensionObject dimensionObj = this.getMetaStore().getDimension(level);
            if (dimensionObj == null || dimensionObj.getMofId() == null) {
                CubeObject cube = new CubeObject(level.getCatalogName(), level.getSchemaName(), level.getCubeName());
                try {
                    this.getDimension(cube);
                }
                catch (BIResourceException ex) {
                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_DIMENSION_MEMBERSELECTION}, (Throwable)((Object)ex));
                }
                dimensionObj = this.getMetaStore().getDimension(level);
            }
            assocObj.getMofIdsBackward().add(new Association(levelMofID, dimensionObj.getMofId(), associationId));
            this.rtcounter.incrementCounter(4);
        } else if (associationId.equalsIgnoreCase(ASSOC_HIERARCHYLEVELASSOCIATION_LEVEL)) {
            String hlaMofId = level.getHierarchyLevelAssocMofId();
            assocObj.getMofIdsForward().add(new Association(levelMofID, level.getHierarchyLevelAssocMofId(), associationId));
            this.rtcounter.incrementCounter(4);
        } else {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
        }
        loc.exiting();
        return assocObj;
    }

    private AssociationsOfObject selectMeasureAssoc(IConnection connection, String associationId, MeasureObject measure) {
        loc.entering("selectMeasureAssoc()");
        if (associationId.equalsIgnoreCase(ASSOC_CLASSIFIER_FEATURE)) {
            String measureMofID = measure.getMofId();
            try {
                this.assertClassifierFeatureAssocLoaded(measure);
            }
            catch (BIResourceException ex) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_CLASSIFIER_FEATURE}, (Throwable)((Object)ex));
            }
            CubeObject cubeObj = this.getMetaStore().getCube(measure);
            AssociationsOfObject assocObj = new AssociationsOfObject(measureMofID);
            assocObj.getMofIdsBackward().add(new Association(measureMofID, cubeObj.getMofId(), associationId));
            this.rtcounter.incrementCounter(4);
            loc.exiting();
            return assocObj;
        }
        throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
    }

    private AssociationsOfObject selectSAPVariableAssoc(IConnection connection, String associationId, BISAPVariableObject variable) {
        String variableMofID = variable.getMofId();
        AssociationsOfObject assocObj = new AssociationsOfObject(variableMofID);
        if (variable.getVariableType() == BISAPVariableConstants.SAPVariableType.SAP_VAR_TYPE_MEMBER) {
            if (associationId.equalsIgnoreCase(MEMBERVARIABLE_HIERARCHY)) {
                LevelBasedHierarchy hie = null;
                try {
                    hie = this.findHierarchyFirst(variable);
                }
                catch (BIResourceException e) {
                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.olap_1001", new Object[]{"Hierarchy"});
                }
                if (hie != null) {
                    assocObj.getMofIdsForward().add(new Association(variableMofID, hie.refMofId(), associationId));
                }
                return assocObj;
            }
            if (associationId.equalsIgnoreCase(MEMBERVARIABLE_DEFAULTHIGH)) {
                IBIMember member = null;
                try {
                    member = this.findMemberHigh(variable);
                }
                catch (BIResourceException e) {
                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.olap_1001", new Object[]{"Member"});
                }
                if (member != null) {
                    assocObj.getMofIdsForward().add(new Association(variableMofID, member.refMofId(), associationId));
                }
                return assocObj;
            }
            if (associationId.equalsIgnoreCase(MEMBERVARIABLE_DEFAULTLOW)) {
                IBIMember member = null;
                try {
                    member = this.findMemberLow(variable);
                }
                catch (BIResourceException e) {
                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.olap_1001", new Object[]{"Member"});
                }
                if (member != null) {
                    assocObj.getMofIdsForward().add(new Association(variableMofID, member.refMofId(), associationId));
                }
                return assocObj;
            }
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
        }
        if (variable.getVariableType() == BISAPVariableConstants.SAPVariableType.SAP_VAR_TYPE_HIERARCHY) {
            if (associationId.equalsIgnoreCase(HIERARCHYVARIABLE_DIMENSION)) {
                Dimension dimension = null;
                try {
                    dimension = this.findDimensionFirst(variable);
                }
                catch (BIResourceException e) {
                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.olap_1001", new Object[]{"Dimension"});
                }
                if (dimension != null) {
                    assocObj.getMofIdsForward().add(new Association(variableMofID, dimension.refMofId(), associationId));
                }
                return assocObj;
            }
            if (associationId.equalsIgnoreCase(HIERARCHYVARIABLE_DEFAULTVALUE)) {
                LevelBasedHierarchy hierarchy = null;
                try {
                    hierarchy = this.findHierarchyFirst(variable);
                }
                catch (BIResourceException e) {
                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.olap_1001", new Object[]{"Dimension"});
                }
                if (hierarchy != null) {
                    assocObj.getMofIdsForward().add(new Association(variableMofID, hierarchy.refMofId(), associationId));
                }
                return assocObj;
            }
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
        }
        if (variable.getVariableType() == BISAPVariableConstants.SAPVariableType.SAP_VAR_TYPE_NUMERIC) {
            if (associationId.equalsIgnoreCase(NUMERICVARIABLE_DEFAULTHIGH)) {
                ArrayList<Object> valueArgs = new ArrayList<Object>(3);
                valueArgs = new ArrayList(3);
                valueArgs.add(variable.getDefaultHighCap());
                valueArgs.add(VisibilityKindEnum.VK_PUBLIC);
                valueArgs.add(variable.getDefaultHigh());
                IBIAnyDataValue defaultHigh = (IBIAnyDataValue)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), (class$com$sap$ip$bi$sdk$dac$olap$query$member$IBIAnyDataValue == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$member$IBIAnyDataValue = OlapMDRConnection.class$("com.sap.ip.bi.sdk.dac.olap.query.member.IBIAnyDataValue")) : class$com$sap$ip$bi$sdk$dac$olap$query$member$IBIAnyDataValue).getName(), valueArgs, true);
                if (defaultHigh != null) {
                    assocObj.getMofIdsForward().add(new Association(variableMofID, defaultHigh.refMofId(), associationId));
                }
                return assocObj;
            }
            if (associationId.equalsIgnoreCase(NUMERICVARIABLE_DEFAULTLOW)) {
                ArrayList<Object> valueArgs = new ArrayList<Object>(3);
                valueArgs.add(variable.getDefaultLowCap());
                valueArgs.add(VisibilityKindEnum.VK_PUBLIC);
                valueArgs.add(variable.getDefaultLow());
                IBIAnyDataValue defaultLow = (IBIAnyDataValue)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), (class$com$sap$ip$bi$sdk$dac$olap$query$member$IBIAnyDataValue == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$member$IBIAnyDataValue = OlapMDRConnection.class$("com.sap.ip.bi.sdk.dac.olap.query.member.IBIAnyDataValue")) : class$com$sap$ip$bi$sdk$dac$olap$query$member$IBIAnyDataValue).getName(), valueArgs, true);
                if (defaultLow != null) {
                    assocObj.getMofIdsBackward().add(new Association(variableMofID, defaultLow.refMofId(), associationId));
                }
                return assocObj;
            }
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
        }
        throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1004", new Object[]{associationId});
    }

    private AssociationsOfObject selectTaggedValueAssoc(String associationId, String mofId) {
        AssociationsOfObject assocObj = new AssociationsOfObject(mofId);
        List tvs = this.getMetaStore().getTaggedValue(mofId);
        Iterator i = tvs.iterator();
        while (i.hasNext()) {
            TaggedValue tv = (TaggedValue)i.next();
            assocObj.getMofIdsForward().add(new Association(mofId, tv.refMofId(), associationId));
        }
        return assocObj;
    }

    private AssociationsOfObject selectCubeOwnsSapVariableAssoc(String associationId, String mofId) {
        AssociationsOfObject assocObj = new AssociationsOfObject(mofId);
        CubeObject cube = (CubeObject)this.getMetaStore().getObjectByMofId(mofId);
        try {
            this.assertCubeOwnsSapVariableAssocLoaded(cube);
            this.getSAPVariable(cube);
        }
        catch (BIResourceException ex) {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_3002", new Object[]{ASSOC_CLASSIFIER_FEATURE}, (Throwable)((Object)ex));
        }
        Set variables = this.getMetaStore().getSAPVariable(cube);
        Iterator i = variables.iterator();
        while (i.hasNext()) {
            BISAPVariableObject variable = (BISAPVariableObject)i.next();
            assocObj.getMofIdsForward().add(new Association(mofId, variable.getMofId(), associationId));
        }
        return assocObj;
    }

    protected TaggedValue createTaggedValue(ModelElement modelElement, String tag, String value) throws BIResourceException {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(null);
        args.add(null);
        TaggedValue tv = (TaggedValue)Instantiator.getInstantiator().createInstance(this.mdr.getRepository(), "org.omg.cwm.objectmodel.core.TaggedValue", args, true);
        ((IMMRObject)tv).set___State(StateEnum.STATE_UNCHANGED);
        this.rtcounter.incrementCounter(4);
        tv.setTag(tag);
        tv.setValue(value);
        this.submitM1Instance();
        this.getMetaStore().putInstanceByMofId(tv.refMofId(), tv);
        this.getMetaStore().AddTaggedValue(modelElement.refMofId(), tv);
        return tv;
    }

    public Collection getTaggedValue(ModelElement element) throws BIResourceException {
        Collection tags = this.corePack.getTaggedElement().getTaggedValue(element);
        return tags;
    }

    public Collection getSapVariable(Cube cube) throws BIResourceException {
        List tags = this.assocPackage.getIBICubeOwnsSapVariable().getSapVariable(cube);
        return tags;
    }

    public RefPackage getOuterMostPackage() {
        return this.outerMost;
    }

    public abstract OlapMetaStore getMetaStore();

    public abstract void assertLoadSAPVariables(CubeObject var1) throws BIResourceException;

    public abstract void assertLoadSchemas() throws BIResourceException;

    public abstract void assertLoadCubes() throws BIResourceException;

    public abstract void assertLoadCubes(SchemaObject var1) throws BIResourceException;

    public abstract void assertDimensionsLoaded(SchemaObject var1) throws BIResourceException;

    public abstract void assertDimensionsLoaded(CubeObject var1) throws BIResourceException;

    public abstract void assertDimensionsLoaded() throws BIResourceException;

    public abstract void assertLoadLevelBasedHierarchies(DimensionObject var1) throws BIResourceException;

    public abstract void assertLevelsLoaded(DimensionObject var1) throws BIResourceException;

    public abstract void assertLevelsLoaded(LevelBasedHierarchyObject var1) throws BIResourceException;

    public abstract void assertLoadMeasures(CubeObject var1) throws BIResourceException;

    public abstract void assertLoadAttributes(DimensionObject var1) throws BIResourceException;

    public abstract void assertSchemaCubeAssocLoaded(OlapSchemaObject var1) throws BIResourceException;

    public abstract void assertLoadCubeDimensionAssoc(OlapSchemaObject var1) throws BIResourceException;

    public abstract void assertSchemaDimensionAssocLoaded(OlapSchemaObject var1) throws BIResourceException;

    public abstract void assertDimensionHierarchyAssocLoaded(OlapSchemaObject var1) throws BIResourceException;

    public abstract void assertDimensionMemberSelectionAssocLoaded(OlapSchemaObject var1) throws BIResourceException;

    public abstract void assertLoadHierarchyLevelAssoc(OlapSchemaObject var1) throws BIResourceException;

    public abstract void assertClassifierFeatureAssocLoaded(OlapSchemaObject var1) throws BIResourceException;

    public abstract void assertCubeOwnsSapVariableAssocLoaded(OlapSchemaObject var1) throws BIResourceException;

    public abstract List assertFindSchema(String var1) throws BIResourceException;

    public abstract List assertFindCube(String var1, String var2) throws BIResourceException;

    public abstract List assertFindDimension(String var1, String var2, String var3) throws BIResourceException;

    public abstract List assertFindMeasure(String var1, String var2, String var3) throws BIResourceException;

    public abstract List assertFindSAPVariable(String var1, String var2, String var3) throws BIResourceException;

    public abstract List assertFindHierarchy(String var1, String var2, String var3, String var4) throws BIResourceException;

    public abstract List assertFindLevel(String var1, String var2, String var3, String var4, String var5) throws BIResourceException;

    public abstract void createTaggedValueLevelBasedHierarchy(LevelBasedHierarchy var1, LevelBasedHierarchyObject var2) throws BIResourceException;

    public abstract void createTaggedValueCube(Cube var1, CubeObject var2) throws BIResourceException;

    public abstract void createTaggedValueDimension(Dimension var1, DimensionObject var2) throws BIResourceException;

    public abstract void createTaggedValueLevel(Level var1, LevelObject var2) throws BIResourceException;

    public abstract void createTaggedValueMeasure(Measure var1, MeasureObject var2) throws BIResourceException;

    public abstract void createTaggedValueSchema(Schema var1, SchemaObject var2) throws BIResourceException;

    public abstract void createTaggedValueAttribute(Attribute var1, AttributeObject var2) throws BIResourceException;

    public abstract void createTaggedValueSAPVariable(IBISapVariable var1, BISAPVariableObject var2) throws BIResourceException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        packageNames.add("org.omg.cwm.analysis.Olap");
        packageNames.add("org.omg.cwm.objectmodel.Core");
        packageNames.add("com.sap.ip.bi.sdk.dac.olap.query.var");
        modelPaths = new Vector();
    }
}

