/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.olap;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.olap.BIOlapDataSourceType;
import com.sap.ip.bi.sdk.dac.connector.olap.BIOlapQualifiedNameList;
import com.sap.ip.bi.sdk.dac.connector.olap.BISAPVariableConstants;
import com.sap.ip.bi.sdk.dac.connector.olap.BIVariant;
import com.sap.ip.bi.sdk.dac.connector.olap.MetadataNameConverter;
import com.sap.ip.bi.sdk.dac.connector.olap.OlapMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.olap.OlapMetaStore;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.AttributeObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.BISAPVariableObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.CubeObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.DimensionObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.LevelBasedHierarchyObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.LevelObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.MeasureObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.OlapSchemaObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.SchemaObject;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariable;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.ResourceException;
import com.sap.ip.mmr.search.QueryFilter;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.omg.cwm.analysis.olap.Cube;
import org.omg.cwm.analysis.olap.CubeDimensionAssociation;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.analysis.olap.HierarchyLevelAssociation;
import org.omg.cwm.analysis.olap.Level;
import org.omg.cwm.analysis.olap.LevelBasedHierarchy;
import org.omg.cwm.analysis.olap.Measure;
import org.omg.cwm.analysis.olap.Schema;
import org.omg.cwm.objectmodel.core.Attribute;
import org.omg.cwm.objectmodel.core.ModelElement;

public abstract class CommonMDRConnection
extends OlapMDRConnection {
    private BIOlapDataSourceType dataSourceType = null;
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection = CommonMDRConnection.class$("com.sap.ip.bi.sdk.dac.connector.olap.CommonConnection")) : class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    private IBIMonitor monitor;
    private static final String QUALIFIED_SCHEMA_NAME = "org.omg.cwm.analysis.olap.Schema";
    private static final String QUALIFIED_CUBE_NAME = "org.omg.cwm.analysis.olap.Cube";
    private static final String QUALIFIED_DIMENSION_NAME = "org.omg.cwm.analysis.olap.Dimension";
    private static final String QUALIFIED_HIERARCHY_NAME = "org.omg.cwm.analysis.olap.LevelBasedHierarchy";
    private static final String QUALIFIED_LEVEL_NAME = "org.omg.cwm.analysis.olap.Level";
    private static final String QUALIFIED_MEASURE_NAME = "org.omg.cwm.analysis.olap.Measure";
    private static final String QUALIFIED_SAPVARIABLE_NAME = "com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariable";
    protected OlapMetaStore metaStore = new OlapMetaStore();
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$olap$CommonConnection;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$Schema;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$Cube;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$Dimension;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$CubeDimensionAssociation;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$LevelBasedHierarchy;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$Level;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$HierarchyLevelAssociation;
    static /* synthetic */ Class class$org$omg$cwm$analysis$olap$Measure;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapVariable;

    public CommonMDRConnection(IBIConnectionInfo connectionInfo, BIOlapDataSourceType dataSourceType) throws BIResourceException {
        super(connectionInfo, dataSourceType);
        this.dataSourceType = dataSourceType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void assertSchemaCubeAssocLoaded(OlapSchemaObject obj) throws BIResourceException {
        loc.entering("assertSchemaCubeAssocLoaded(OlapSchemaObject obj)");
        String catalogName = null;
        String schemaName = null;
        String cubeName = null;
        if (obj != null) {
            if (obj instanceof SchemaObject) {
                this.assertLoadCubes((SchemaObject)obj);
                return;
            } else {
                if (!(obj instanceof CubeObject)) throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1021");
                catalogName = ((CubeObject)obj).getCatalogName();
                schemaName = ((CubeObject)obj).getSchemaName();
                cubeName = ((CubeObject)obj).getCubeName();
                SchemaObject schemaObject = new SchemaObject(catalogName, schemaName);
                this.assertLoadCubes(schemaObject);
            }
            return;
        } else {
            if (this.metaStore.getCube().isEmpty()) return;
            loc.exiting();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void assertSchemaDimensionAssocLoaded(OlapSchemaObject obj) throws BIResourceException {
        loc.entering("assertSchemaDimensionAssocLoaded(OlapSchemaObject obj)");
        this.assertLoadSchemas();
        String catalogName = null;
        String schemaName = null;
        Object cubeName = null;
        Object dimensionUName = null;
        if (obj != null) {
            if (obj instanceof SchemaObject) {
                this.assertDimensionsLoaded((SchemaObject)obj);
            } else {
                if (!(obj instanceof DimensionObject)) throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1021");
                catalogName = ((DimensionObject)obj).getCatalogName();
                SchemaObject schemaObject = new SchemaObject(catalogName, schemaName = ((DimensionObject)obj).getSchemaName());
                if (!this.metaStore.containsSchema(schemaObject)) {
                    this.metaStore.addSchema(schemaObject);
                }
                this.assertDimensionsLoaded(schemaObject);
            }
        } else if (!this.metaStore.getDimension().isEmpty()) {
            loc.exiting();
            return;
        }
        loc.exiting();
    }

    public void assertDimensionsLoaded(SchemaObject schema) throws BIResourceException {
        loc.entering("assertDimensionsLoaded(SchemaObject schema)");
        this.assertLoadCubes(schema);
        Iterator cubeSet = this.metaStore.getCube(schema).iterator();
        while (cubeSet.hasNext()) {
            CubeObject cubeObj = (CubeObject)cubeSet.next();
            this.assertDimensionsLoaded(cubeObj);
        }
        loc.exiting();
    }

    public void assertDimensionsLoaded() throws BIResourceException {
        loc.entering("assertDimensionsLoaded()");
        this.assertLoadCubes();
        Iterator cubeSet = this.metaStore.getCube().values().iterator();
        while (cubeSet.hasNext()) {
            CubeObject cubeObj = (CubeObject)cubeSet.next();
            this.assertDimensionsLoaded(cubeObj);
        }
        loc.exiting();
    }

    public void assertDimensionsLoaded(CubeObject cube) throws BIResourceException {
        this.assertLoadCubeDimensionAssoc(cube);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void assertDimensionHierarchyAssocLoaded(OlapSchemaObject obj) throws BIResourceException {
        loc.entering("assertDimensionHierarchyAssocLoaded(OlapSchemaObject obj)");
        String catalogName = null;
        String schemaName = null;
        String cubeName = null;
        String dimensionUName = null;
        if (obj != null) {
            if (obj instanceof DimensionObject) {
                this.assertLoadLevelBasedHierarchies((DimensionObject)obj);
            } else {
                if (!(obj instanceof LevelBasedHierarchyObject)) throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1021");
                catalogName = ((LevelBasedHierarchyObject)obj).getCatalogName();
                schemaName = ((LevelBasedHierarchyObject)obj).getSchemaName();
                cubeName = ((LevelBasedHierarchyObject)obj).getCubeName();
                dimensionUName = ((LevelBasedHierarchyObject)obj).getDimensionUniqueName();
                DimensionObject dimensionObject = new DimensionObject(catalogName, schemaName, cubeName, dimensionUName);
                this.assertLoadLevelBasedHierarchies(dimensionObject);
            }
        } else if (!this.metaStore.getDimension().isEmpty()) {
            loc.exiting();
            return;
        }
        loc.exiting();
    }

    public void assertLevelsLoaded(DimensionObject dimension) throws BIResourceException {
        loc.entering("assertLevelsLoaded(DimensionObject dimension)");
        this.assertLoadLevelBasedHierarchies(dimension);
        Iterator hierarchySet = this.metaStore.getHierarchy(dimension).iterator();
        while (hierarchySet.hasNext()) {
            LevelBasedHierarchyObject hierarchyObj = (LevelBasedHierarchyObject)hierarchySet.next();
            this.assertLevelsLoaded(hierarchyObj);
        }
        loc.exiting();
    }

    public void assertLevelsLoaded(LevelBasedHierarchyObject hierarchy) throws BIResourceException {
        this.assertLoadHierarchyLevelAssoc(hierarchy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void assertClassifierFeatureAssocLoaded(OlapSchemaObject obj) throws BIResourceException {
        loc.entering("assertClassifierFeatureAssocLoaded(OlapSchemaObject obj)");
        this.assertLoadSchemas();
        String catalogName = null;
        String schemaName = null;
        String cubeName = null;
        Object dimensionUName = null;
        if (obj != null) {
            if (obj instanceof CubeObject) {
                this.assertLoadMeasures((CubeObject)obj);
                if (this.dataSourceType != null && this.dataSourceType.equals(BIOlapDataSourceType.SAP_BW)) {
                    this.assertLoadSAPVariables((CubeObject)obj);
                }
            } else if (obj instanceof MeasureObject) {
                catalogName = ((MeasureObject)obj).getCatalogName();
                CubeObject cubeObject = new CubeObject(catalogName, schemaName = ((MeasureObject)obj).getSchemaName(), cubeName = ((MeasureObject)obj).getCubeName());
                if (!this.metaStore.containsCube(cubeObject)) {
                    this.metaStore.addCube(cubeObject);
                }
                this.assertLoadMeasures(cubeObject);
            } else if (obj instanceof DimensionObject) {
                this.assertLoadAttributes((DimensionObject)obj);
            } else {
                if (!(obj instanceof BISAPVariableObject)) throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1021");
                catalogName = ((BISAPVariableObject)obj).getCatalogName();
                CubeObject cubeObject = new CubeObject(catalogName, schemaName = ((BISAPVariableObject)obj).getSchemaName(), cubeName = ((BISAPVariableObject)obj).getCubeName());
                if (!this.metaStore.containsCube(cubeObject)) {
                    this.metaStore.addCube(cubeObject);
                }
                this.assertLoadSAPVariables(cubeObject);
            }
        } else if (!this.metaStore.getDimension().isEmpty()) {
            loc.exiting();
            return;
        }
        loc.exiting();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void assertCubeOwnsSapVariableAssocLoaded(OlapSchemaObject obj) throws BIResourceException {
        this.assertLoadSchemas();
        String catalogName = null;
        String schemaName = null;
        String cubeName = null;
        if (obj == null) return;
        if (obj instanceof CubeObject) {
            if (this.dataSourceType == null || !this.dataSourceType.equals(BIOlapDataSourceType.SAP_BW)) return;
            this.assertLoadSAPVariables((CubeObject)obj);
            return;
        } else {
            if (!(obj instanceof BISAPVariableObject)) throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1021");
            catalogName = ((BISAPVariableObject)obj).getCatalogName();
            CubeObject cubeObject = new CubeObject(catalogName, schemaName = ((BISAPVariableObject)obj).getSchemaName(), cubeName = ((BISAPVariableObject)obj).getCubeName());
            if (!this.metaStore.containsCube(cubeObject)) {
                this.metaStore.addCube(cubeObject);
            }
            this.assertLoadSAPVariables(cubeObject);
        }
    }

    public void assertCubeDimensionAssocCalcHierarchyAssocLoaded(OlapSchemaObject obj) throws BIResourceException {
    }

    public OlapMetaStore getMetaStore() {
        return this.metaStore;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void assertDimensionMemberSelectionAssocLoaded(OlapSchemaObject obj) throws BIResourceException {
        loc.entering("assertDimensionMemberSelectionAssocLoaded(OlapSchemaObject obj)");
        String catalogName = null;
        String schemaName = null;
        String cubeName = null;
        String dimensionUName = null;
        if (obj != null) {
            if (obj instanceof DimensionObject) {
                this.assertLevelsLoaded((DimensionObject)obj);
            } else {
                if (!(obj instanceof LevelObject)) throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector_1021");
                catalogName = ((LevelObject)obj).getCatalogName();
                schemaName = ((LevelObject)obj).getSchemaName();
                cubeName = ((LevelObject)obj).getCubeName();
                dimensionUName = ((LevelObject)obj).getDimensionUniqueName();
                DimensionObject dimensionObject = new DimensionObject(catalogName, schemaName, cubeName, dimensionUName);
                this.assertLevelsLoaded(dimensionObject);
            }
        } else if (!this.metaStore.getDimension().isEmpty()) {
            loc.exiting();
            return;
        }
        loc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List queryM1(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) {
        List list;
        boolean instanceCreated;
        block30: {
            List list2;
            block29: {
                List list3;
                block28: {
                    List list4;
                    block27: {
                        List list5;
                        block26: {
                            List list6;
                            block25: {
                                List list7;
                                block24: {
                                    List list8;
                                    block23: {
                                        loc.entering("queryM1()");
                                        Object type = null;
                                        instanceCreated = false;
                                        Object qName0 = qualifiedNameOfType.get(0);
                                        try {
                                            try {
                                                if (!this.assertConnection(connection)) {
                                                    loc.exiting();
                                                    list8 = null;
                                                    Object var11_17 = null;
                                                    if (!instanceCreated) return list8;
                                                    break block23;
                                                }
                                                if (QUALIFIED_SCHEMA_NAME.equals(qName0)) {
                                                    list7 = this.queryM1Schema(filters, instanceCreated);
                                                    break block24;
                                                }
                                                if (QUALIFIED_CUBE_NAME.equals(qName0)) {
                                                    list6 = this.queryM1Cube(filters, instanceCreated);
                                                    break block25;
                                                }
                                                if (QUALIFIED_DIMENSION_NAME.equals(qName0)) {
                                                    list5 = this.queryM1Dimension(filters, instanceCreated);
                                                    break block26;
                                                }
                                                if (QUALIFIED_HIERARCHY_NAME.equals(qName0)) {
                                                    list4 = this.queryM1Hierarchy(filters, instanceCreated);
                                                    break block27;
                                                }
                                                if (QUALIFIED_LEVEL_NAME.equals(qName0)) {
                                                    list3 = this.queryM1Level(filters, instanceCreated);
                                                    break block28;
                                                }
                                                if (QUALIFIED_MEASURE_NAME.equals(qName0)) {
                                                    list2 = this.queryM1Measure(filters, instanceCreated);
                                                    break block29;
                                                }
                                                if (!QUALIFIED_SAPVARIABLE_NAME.equals(qName0)) {
                                                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.olap_1003", new Object[]{qName0});
                                                }
                                                list = this.queryM1SAPVariable(filters, instanceCreated);
                                                break block30;
                                            }
                                            catch (BIResourceException ex) {
                                                loc.exiting();
                                                List list9 = null;
                                                Object var11_25 = null;
                                                if (!instanceCreated) return list9;
                                                try {
                                                    this.submitM1Instance();
                                                    loc.exiting();
                                                    return list9;
                                                }
                                                catch (BIResourceException ex2) {
                                                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.mmr_2000", new Object[]{ex2.getMessage()}, (Throwable)((Object)ex2));
                                                }
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var11_26 = null;
                                            if (!instanceCreated) throw throwable;
                                            try {}
                                            catch (BIResourceException ex2) {
                                                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.mmr_2000", new Object[]{ex2.getMessage()}, (Throwable)((Object)ex2));
                                            }
                                            this.submitM1Instance();
                                            loc.exiting();
                                            throw throwable;
                                        }
                                    }
                                    try {}
                                    catch (BIResourceException ex2) {
                                        throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.mmr_2000", new Object[]{ex2.getMessage()}, (Throwable)((Object)ex2));
                                    }
                                    this.submitM1Instance();
                                    loc.exiting();
                                    return list8;
                                }
                                Object var11_18 = null;
                                if (!instanceCreated) return list7;
                                try {}
                                catch (BIResourceException ex2) {
                                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.mmr_2000", new Object[]{ex2.getMessage()}, (Throwable)((Object)ex2));
                                }
                                this.submitM1Instance();
                                loc.exiting();
                                return list7;
                            }
                            Object var11_19 = null;
                            if (!instanceCreated) return list6;
                            try {}
                            catch (BIResourceException ex2) {
                                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.mmr_2000", new Object[]{ex2.getMessage()}, (Throwable)((Object)ex2));
                            }
                            this.submitM1Instance();
                            loc.exiting();
                            return list6;
                        }
                        Object var11_20 = null;
                        if (!instanceCreated) return list5;
                        try {}
                        catch (BIResourceException ex2) {
                            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.mmr_2000", new Object[]{ex2.getMessage()}, (Throwable)((Object)ex2));
                        }
                        this.submitM1Instance();
                        loc.exiting();
                        return list5;
                    }
                    Object var11_21 = null;
                    if (!instanceCreated) return list4;
                    try {}
                    catch (BIResourceException ex2) {
                        throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.mmr_2000", new Object[]{ex2.getMessage()}, (Throwable)((Object)ex2));
                    }
                    this.submitM1Instance();
                    loc.exiting();
                    return list4;
                }
                Object var11_22 = null;
                if (!instanceCreated) return list3;
                try {}
                catch (BIResourceException ex2) {
                    throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.mmr_2000", new Object[]{ex2.getMessage()}, (Throwable)((Object)ex2));
                }
                this.submitM1Instance();
                loc.exiting();
                return list3;
            }
            Object var11_23 = null;
            if (!instanceCreated) return list2;
            try {}
            catch (BIResourceException ex2) {
                throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.mmr_2000", new Object[]{ex2.getMessage()}, (Throwable)((Object)ex2));
            }
            this.submitM1Instance();
            loc.exiting();
            return list2;
        }
        Object var11_24 = null;
        if (!instanceCreated) return list;
        try {}
        catch (BIResourceException ex2) {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.mmr_2000", new Object[]{ex2.getMessage()}, (Throwable)((Object)ex2));
        }
        this.submitM1Instance();
        loc.exiting();
        return list;
    }

    private List queryM1Schema(QueryFilters filters, boolean instanceCreated) throws BIResourceException {
        loc.entering("queryM1Schema()");
        if (filters == null) {
            loc.exiting();
            return this.getSchema();
        }
        String schemaName = null;
        Iterator i = filters.iterator();
        while (i.hasNext()) {
            QueryFilter f = (QueryFilter)i.next();
            if (f == null || !"SCHEMA_NAME".equals(f.getAttribute())) continue;
            schemaName = f.getValue();
        }
        List schemaObjs = this.assertFindSchema(schemaName);
        if (schemaObjs == null || schemaObjs.size() <= 0) {
            loc.exiting();
            return null;
        }
        ArrayList<String> schemaMofids = new ArrayList<String>();
        Iterator i2 = schemaObjs.iterator();
        while (i2.hasNext()) {
            SchemaObject t = (SchemaObject)i2.next();
            if (t == null) continue;
            if (t.getMofId() != null) {
                schemaMofids.add(t.getMofId());
                continue;
            }
            this.createM1Instance(t, class$org$omg$cwm$analysis$olap$Schema == null ? CommonMDRConnection.class$(QUALIFIED_SCHEMA_NAME) : class$org$omg$cwm$analysis$olap$Schema, false);
            instanceCreated = true;
            schemaMofids.add(t.getMofId());
        }
        loc.exiting();
        return schemaMofids;
    }

    private List queryM1Cube(QueryFilters filters, boolean instanceCreated) throws BIResourceException {
        loc.entering("queryM1Cube()");
        if (filters == null) {
            loc.exiting();
            return this.getCube();
        }
        String catalogName = null;
        String schemaName = null;
        String cubeName = null;
        Iterator i = filters.iterator();
        while (i.hasNext()) {
            QueryFilter f = (QueryFilter)i.next();
            if (f == null) continue;
            if ("CATALOG_NAME".equals(f.getAttribute())) {
                catalogName = f.getValue();
                continue;
            }
            if ("SCHEMA_NAME".equals(f.getAttribute())) {
                schemaName = f.getValue();
                continue;
            }
            if (!"CUBE_NAME".equals(f.getAttribute())) continue;
            cubeName = f.getValue();
        }
        List cubeObjs = this.assertFindCube(schemaName, cubeName);
        if (cubeObjs == null || cubeObjs.size() <= 0) {
            loc.exiting();
            return null;
        }
        ArrayList<String> cubeMofids = new ArrayList<String>();
        Iterator i2 = cubeObjs.iterator();
        while (i2.hasNext()) {
            CubeObject t = (CubeObject)i2.next();
            if (t == null) continue;
            if (t.getMofId() != null) {
                cubeMofids.add(t.getMofId());
                continue;
            }
            this.createM1Instance(t, class$org$omg$cwm$analysis$olap$Cube == null ? CommonMDRConnection.class$(QUALIFIED_CUBE_NAME) : class$org$omg$cwm$analysis$olap$Cube, false);
            instanceCreated = true;
            cubeMofids.add(t.getMofId());
        }
        loc.exiting();
        return cubeMofids;
    }

    private List queryM1Dimension(QueryFilters filters, boolean instanceCreated) throws BIResourceException {
        loc.entering("queryM1Dimension()");
        if (filters == null) {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.olap_1002");
        }
        String catalogName = null;
        String schemaName = null;
        String cubeName = null;
        String dimensionName = null;
        String dimensionUName = null;
        Iterator i = filters.iterator();
        while (i.hasNext()) {
            QueryFilter f = (QueryFilter)i.next();
            if (f == null) continue;
            if ("CATALOG_NAME".equals(f.getAttribute())) {
                catalogName = f.getValue();
                continue;
            }
            if ("SCHEMA_NAME".equals(f.getAttribute())) {
                schemaName = f.getValue();
                continue;
            }
            if ("CUBE_NAME".equals(f.getAttribute())) {
                cubeName = f.getValue();
                continue;
            }
            if ("DIMENSION_NAME".equals(f.getAttribute())) {
                dimensionName = f.getValue();
                continue;
            }
            if (!"DIMENSION_UNIQUE_NAME".equals(f.getAttribute())) continue;
            dimensionUName = f.getValue();
        }
        List dimensionObjs = this.assertFindDimension(schemaName, cubeName, dimensionName);
        if (dimensionObjs == null || dimensionObjs.size() <= 0) {
            loc.exiting();
            return null;
        }
        ArrayList<String> dimensionMofids = new ArrayList<String>();
        Iterator i2 = dimensionObjs.iterator();
        while (i2.hasNext()) {
            DimensionObject dimObj = (DimensionObject)i2.next();
            if (dimObj == null) continue;
            if (dimObj.getMofId() != null) {
                dimensionMofids.add(dimObj.getMofId());
                continue;
            }
            this.createM1Instance(dimObj, class$org$omg$cwm$analysis$olap$Dimension == null ? CommonMDRConnection.class$(QUALIFIED_DIMENSION_NAME) : class$org$omg$cwm$analysis$olap$Dimension, false);
            CubeDimensionAssociation cda = (CubeDimensionAssociation)this.createM1Instance(dimObj, class$org$omg$cwm$analysis$olap$CubeDimensionAssociation == null ? CommonMDRConnection.class$("org.omg.cwm.analysis.olap.CubeDimensionAssociation") : class$org$omg$cwm$analysis$olap$CubeDimensionAssociation, false);
            dimObj.setCubeDimensionAssocMofId(cda.refMofId());
            instanceCreated = true;
            dimensionMofids.add(dimObj.getMofId());
        }
        loc.exiting();
        return dimensionMofids;
    }

    public List queryM1Hierarchy(QueryFilters filters, boolean instanceCreated) throws BIResourceException {
        loc.entering("queryM1Hierarchy()");
        String schemaName = null;
        String cubeName = null;
        String dimensionName = null;
        String hierarchyName = null;
        Iterator i = filters.iterator();
        while (i.hasNext()) {
            QueryFilter f = (QueryFilter)i.next();
            if (f == null) continue;
            if ("SCHEMA_NAME".equals(f.getAttribute())) {
                schemaName = f.getValue();
                continue;
            }
            if ("CUBE_NAME".equals(f.getAttribute())) {
                cubeName = f.getValue();
                continue;
            }
            if ("DIMENSION_NAME".equals(f.getAttribute())) {
                dimensionName = f.getValue();
                continue;
            }
            if (!"HIERARCHY_NAME".equals(f.getAttribute())) continue;
            hierarchyName = f.getValue();
        }
        List hierarchyObjs = this.assertFindHierarchy(schemaName, cubeName, dimensionName, hierarchyName);
        if (hierarchyObjs == null || hierarchyObjs.size() <= 0) {
            loc.exiting();
            return null;
        }
        ArrayList<String> hierarchyMofids = new ArrayList<String>();
        Iterator i2 = hierarchyObjs.iterator();
        while (i2.hasNext()) {
            LevelBasedHierarchyObject t = (LevelBasedHierarchyObject)i2.next();
            if (t == null) continue;
            if (t.getMofId() != null) {
                hierarchyMofids.add(t.getMofId());
                continue;
            }
            this.createM1Instance(t, class$org$omg$cwm$analysis$olap$LevelBasedHierarchy == null ? CommonMDRConnection.class$(QUALIFIED_HIERARCHY_NAME) : class$org$omg$cwm$analysis$olap$LevelBasedHierarchy, false);
            instanceCreated = true;
            hierarchyMofids.add(t.getMofId());
        }
        loc.exiting();
        return hierarchyMofids;
    }

    private List queryM1Level(QueryFilters filters, boolean instanceCreated) throws BIResourceException {
        loc.entering("queryM1Level()");
        if (filters == null) {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.olap_1002");
        }
        String schemaName = null;
        String cubeName = null;
        String dimensionName = null;
        String hierarchyName = null;
        String levelName = null;
        Iterator i = filters.iterator();
        while (i.hasNext()) {
            QueryFilter f = (QueryFilter)i.next();
            if (f == null) continue;
            if ("SCHEMA_NAME".equals(f.getAttribute())) {
                schemaName = f.getValue();
                continue;
            }
            if ("CUBE_NAME".equals(f.getAttribute())) {
                cubeName = f.getValue();
                continue;
            }
            if ("DIMENSION_NAME".equals(f.getAttribute())) {
                dimensionName = f.getValue();
                continue;
            }
            if ("HIERARCHY_NAME".equals(f.getAttribute())) {
                hierarchyName = f.getValue();
                continue;
            }
            if (!"LEVEL_NAME".equals(f.getAttribute())) continue;
            levelName = f.getValue();
        }
        List levelObjs = this.assertFindLevel(schemaName, cubeName, dimensionName, hierarchyName, levelName);
        if (levelObjs == null || levelObjs.size() <= 0) {
            loc.exiting();
            return null;
        }
        ArrayList<String> levelMofids = new ArrayList<String>();
        Iterator i2 = levelObjs.iterator();
        while (i2.hasNext()) {
            LevelObject levelObj = (LevelObject)i2.next();
            if (levelObj == null) continue;
            if (levelObj.getMofId() != null) {
                levelMofids.add(levelObj.getMofId());
                continue;
            }
            this.createM1Instance(levelObj, class$org$omg$cwm$analysis$olap$Level == null ? CommonMDRConnection.class$(QUALIFIED_LEVEL_NAME) : class$org$omg$cwm$analysis$olap$Level, false);
            HierarchyLevelAssociation hla = (HierarchyLevelAssociation)this.createM1Instance(levelObj, class$org$omg$cwm$analysis$olap$HierarchyLevelAssociation == null ? CommonMDRConnection.class$("org.omg.cwm.analysis.olap.HierarchyLevelAssociation") : class$org$omg$cwm$analysis$olap$HierarchyLevelAssociation, false);
            levelObj.setHierarchyLevelAssocMofId(hla.refMofId());
            instanceCreated = true;
            levelMofids.add(levelObj.getMofId());
        }
        loc.exiting();
        return levelMofids;
    }

    private List queryM1Measure(QueryFilters filters, boolean instanceCreated) throws BIResourceException {
        loc.entering("queryM1Measure()");
        if (filters == null) {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.olap_1002");
        }
        Object catalogName = null;
        String schemaName = null;
        String cubeName = null;
        String measureName = null;
        Object measureUName = null;
        Iterator i = filters.iterator();
        while (i.hasNext()) {
            QueryFilter f = (QueryFilter)i.next();
            if (f == null) continue;
            if ("SCHEMA_NAME".equals(f.getAttribute())) {
                schemaName = f.getValue();
                continue;
            }
            if ("CUBE_NAME".equals(f.getAttribute())) {
                cubeName = f.getValue();
                continue;
            }
            if (!"MEASURE_NAME".equals(f.getAttribute())) continue;
            measureName = f.getValue();
        }
        List measureObjs = this.assertFindMeasure(schemaName, cubeName, measureName);
        if (measureObjs == null || measureObjs.size() <= 0) {
            loc.exiting();
            return null;
        }
        ArrayList<String> measureMofids = new ArrayList<String>();
        Iterator i2 = measureObjs.iterator();
        while (i2.hasNext()) {
            MeasureObject t = (MeasureObject)i2.next();
            if (t == null) continue;
            if (t.getMofId() != null) {
                measureMofids.add(t.getMofId());
                continue;
            }
            this.createM1Instance(t, class$org$omg$cwm$analysis$olap$Measure == null ? CommonMDRConnection.class$(QUALIFIED_MEASURE_NAME) : class$org$omg$cwm$analysis$olap$Measure, false);
            instanceCreated = true;
            measureMofids.add(t.getMofId());
        }
        loc.exiting();
        return measureMofids;
    }

    private List queryM1SAPVariable(QueryFilters filters, boolean instanceCreated) throws BIResourceException {
        loc.entering("queryM1SAPVariable()");
        if (filters == null) {
            throw new BIRuntimeException(this.getLocale(), "sdk.dac.connector.olap_1002");
        }
        Object catalogName = null;
        String schemaName = null;
        String cubeName = null;
        String variableName = null;
        Iterator i = filters.iterator();
        while (i.hasNext()) {
            QueryFilter f = (QueryFilter)i.next();
            if (f == null) continue;
            if ("SCHEMA_NAME".equals(f.getAttribute())) {
                schemaName = f.getValue();
                continue;
            }
            if ("CUBE_NAME".equals(f.getAttribute())) {
                cubeName = f.getValue();
                continue;
            }
            if (!BISAPVariableConstants.VARIABLE_NAME.equals(f.getAttribute())) continue;
            variableName = f.getValue();
        }
        List variableObjs = this.assertFindSAPVariable(schemaName, cubeName, variableName);
        if (variableObjs == null || variableObjs.size() <= 0) {
            loc.exiting();
            return null;
        }
        ArrayList<String> variableMofids = new ArrayList<String>();
        Iterator i2 = variableObjs.iterator();
        while (i2.hasNext()) {
            BISAPVariableObject t = (BISAPVariableObject)i2.next();
            if (t == null) continue;
            if (t.getMofId() != null) {
                variableMofids.add(t.getMofId());
                continue;
            }
            this.createM1Instance(t, class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapVariable == null ? CommonMDRConnection.class$(QUALIFIED_SAPVARIABLE_NAME) : class$com$sap$ip$bi$sdk$dac$olap$query$var$IBISapVariable, false);
            instanceCreated = true;
            variableMofids.add(t.getMofId());
        }
        loc.exiting();
        return variableMofids;
    }

    public void createTaggedValueLevelBasedHierarchy(LevelBasedHierarchy levelBasedHierarchy, LevelBasedHierarchyObject levelBasedHierarchyObj) throws BIResourceException {
        this.createTaggedValue((ModelElement)levelBasedHierarchy, "CATALOG_NAME", levelBasedHierarchyObj.getCatalogName());
        this.createTaggedValue((ModelElement)levelBasedHierarchy, "SCHEMA_NAME", levelBasedHierarchyObj.getSchemaName());
        this.createTaggedValue((ModelElement)levelBasedHierarchy, "CUBE_NAME", levelBasedHierarchyObj.getCubeName());
        this.createTaggedValue((ModelElement)levelBasedHierarchy, "DIMENSION_UNIQUE_NAME", levelBasedHierarchyObj.getDimensionUniqueName());
        this.createTaggedValue((ModelElement)levelBasedHierarchy, "DIMENSION_TYPE", levelBasedHierarchyObj.getDimensionType());
        this.createTaggedValue((ModelElement)levelBasedHierarchy, "HIERARCHY_NAME", levelBasedHierarchyObj.getHierarchyName());
        this.createTaggedValue((ModelElement)levelBasedHierarchy, "HIERARCHY_UNIQUE_NAME", levelBasedHierarchyObj.getHierarchyUniqueName());
        this.createTaggedValue((ModelElement)levelBasedHierarchy, "HIERARCHY_GUID", levelBasedHierarchyObj.getHierarchyGuid());
        this.createTaggedValue((ModelElement)levelBasedHierarchy, "HIERARCHY_CAPTION", levelBasedHierarchyObj.getHierarchyCaption());
        this.createTaggedValue((ModelElement)levelBasedHierarchy, "HIERARCHY_CARDINALITY", levelBasedHierarchyObj.getHierarchyCardinality());
        this.createTaggedValue((ModelElement)levelBasedHierarchy, "DEFAULT_MEMBER", levelBasedHierarchyObj.getDefaultMember());
        this.createTaggedValue((ModelElement)levelBasedHierarchy, "ALL_MEMBER", levelBasedHierarchyObj.getAllMember());
        this.createTaggedValue((ModelElement)levelBasedHierarchy, "DESCRIPTION", levelBasedHierarchyObj.getDescription());
    }

    public void createTaggedValueCube(Cube cube, CubeObject cubeObj) throws BIResourceException {
        this.createTaggedValue((ModelElement)cube, "CATALOG_NAME", cubeObj.getCatalogName());
        this.createTaggedValue((ModelElement)cube, "SCHEMA_NAME", cubeObj.getSchemaName());
        this.createTaggedValue((ModelElement)cube, "CUBE_NAME", cubeObj.getCubeName());
        this.createTaggedValue((ModelElement)cube, "CUBE_TYPE", cubeObj.getCubeType());
        this.createTaggedValue((ModelElement)cube, "CUBE_GUID", cubeObj.getCubeGuid());
        this.createTaggedValue((ModelElement)cube, "CREATED_ON", cubeObj.getCreatedOn());
        this.createTaggedValue((ModelElement)cube, "LAST_SCHEMA_UPDATE", cubeObj.getLastSchemaUpdate());
        this.createTaggedValue((ModelElement)cube, "SCHEMA_UPDATED_BY", cubeObj.getSchemaUpdatedBy());
        this.createTaggedValue((ModelElement)cube, "LAST_DATA_UPDATE", cubeObj.getLastDataUpdate());
        this.createTaggedValue((ModelElement)cube, "DATA_UPDATED_BY", cubeObj.getDataUpdatedBy());
        this.createTaggedValue((ModelElement)cube, "DESCRIPTION", cubeObj.getDescription());
    }

    public void createTaggedValueDimension(Dimension dimension, DimensionObject dimensionObj) throws BIResourceException {
        this.createTaggedValue((ModelElement)dimension, "CATALOG_NAME", dimensionObj.getCatalogName());
        this.createTaggedValue((ModelElement)dimension, "SCHEMA_NAME", dimensionObj.getSchemaName());
        this.createTaggedValue((ModelElement)dimension, "CUBE_NAME", dimensionObj.getCubeName());
        this.createTaggedValue((ModelElement)dimension, "DIMENSION_NAME", dimensionObj.getDimensionName());
        this.createTaggedValue((ModelElement)dimension, "DIMENSION_CARDINALITY", dimensionObj.getDimensionCardinality());
        this.createTaggedValue((ModelElement)dimension, "DIMENSION_GUID", dimensionObj.getDimensionGuid());
        this.createTaggedValue((ModelElement)dimension, "DIMENSION_ORDINAL", dimensionObj.getDimensionOrdinal());
        this.createTaggedValue((ModelElement)dimension, "DIMENSION_TYPE", dimensionObj.getDimensionType());
        this.createTaggedValue((ModelElement)dimension, "DIMENSION_CAPTION", dimensionObj.getDimensionCaption());
        this.createTaggedValue((ModelElement)dimension, "DIMENSION_UNIQUE_NAME", dimensionObj.getDimensionUniqueName());
        this.createTaggedValue((ModelElement)dimension, "DEFAULT_HIERARCHY", dimensionObj.getDefaultHierarchy());
        this.createTaggedValue((ModelElement)dimension, "DESCRIPTION", dimensionObj.getDescription());
    }

    public void createTaggedValueLevel(Level level, LevelObject levelObj) throws BIResourceException {
        this.createTaggedValue((ModelElement)level, "CATALOG_NAME", levelObj.getCatalogName());
        this.createTaggedValue((ModelElement)level, "SCHEMA_NAME", levelObj.getSchemaName());
        this.createTaggedValue((ModelElement)level, "CUBE_NAME", levelObj.getCubeName());
        this.createTaggedValue((ModelElement)level, "DIMENSION_UNIQUE_NAME", levelObj.getDimensionUniqueName());
        this.createTaggedValue((ModelElement)level, "HIERARCHY_UNIQUE_NAME", levelObj.getHierarchyUniqueName());
        this.createTaggedValue((ModelElement)level, "LEVEL_NAME", levelObj.getLevelName());
        this.createTaggedValue((ModelElement)level, "LEVEL_UNIQUE_NAME", levelObj.getLevelUniqueName());
        this.createTaggedValue((ModelElement)level, "LEVEL_GUID", levelObj.getLevelGuid());
        this.createTaggedValue((ModelElement)level, "LEVEL_CAPTION", levelObj.getLevelCaption());
        this.createTaggedValue((ModelElement)level, "LEVEL_NUMBER", String.valueOf(levelObj.getLevelNumber()));
        this.createTaggedValue((ModelElement)level, "LEVEL_CARDINALITY", levelObj.getLevelCadinality());
        this.createTaggedValue((ModelElement)level, "LEVEL_TYPE", levelObj.getLevelType());
        this.createTaggedValue((ModelElement)level, "DESCRIPTION", levelObj.getDescription());
    }

    public void createTaggedValueMeasure(Measure measure, MeasureObject measureObj) throws BIResourceException {
        this.createTaggedValue((ModelElement)measure, "CATALOG_NAME", measureObj.getCatalogName());
        this.createTaggedValue((ModelElement)measure, "SCHEMA_NAME", measureObj.getSchemaName());
        this.createTaggedValue((ModelElement)measure, "CUBE_NAME", measureObj.getCubeName());
        this.createTaggedValue((ModelElement)measure, "MEASURE_NAME", measureObj.getMeasureName());
        this.createTaggedValue((ModelElement)measure, "MEASURE_UNIQUE_NAME", measureObj.getMeasureUniqueName());
        this.createTaggedValue((ModelElement)measure, "MEASURE_CAPTION", measureObj.getMeasureCaption());
        this.createTaggedValue((ModelElement)measure, "MEASURE_GUID", measureObj.getMeasureGuid());
        this.createTaggedValue((ModelElement)measure, "MEASURE_AGGREGATOR", measureObj.getMeasureAggregator());
        this.createTaggedValue((ModelElement)measure, "DATA_TYPE", measureObj.getDataType());
        this.createTaggedValue((ModelElement)measure, "NUMERIC_PRECISION", measureObj.getNumericPrecision());
        this.createTaggedValue((ModelElement)measure, "NUMERIC_SCALE", measureObj.getNumericScale());
        this.createTaggedValue((ModelElement)measure, "MEASURE_UNITS", measureObj.getMeasureUnits());
        this.createTaggedValue((ModelElement)measure, "DESCRIPTION", measureObj.getDescription());
    }

    public void createTaggedValueSchema(Schema schema, SchemaObject schemaObj) throws BIResourceException {
        this.createTaggedValue((ModelElement)schema, "CATALOG_NAME", schemaObj.getCatalogName());
        this.createTaggedValue((ModelElement)schema, "SCHEMA_NAME", schemaObj.getSchemaName());
        this.createTaggedValue((ModelElement)schema, "DESCRIPTION", schemaObj.getDescription());
    }

    public void createTaggedValueAttribute(Attribute attribute, AttributeObject attributeObj) throws BIResourceException {
        this.createTaggedValue((ModelElement)attribute, "PROPERTY_TYPE", attributeObj.getPropertyType());
        this.createTaggedValue((ModelElement)attribute, "CATALOG_NAME", attributeObj.getCatalogName());
        this.createTaggedValue((ModelElement)attribute, "SCHEMA_NAME", attributeObj.getSchemaName());
        this.createTaggedValue((ModelElement)attribute, "CUBE_NAME", attributeObj.getCubeName());
        this.createTaggedValue((ModelElement)attribute, "DIMENSION_UNIQUE_NAME", attributeObj.getDimensionUniqueName());
        this.createTaggedValue((ModelElement)attribute, "HIERARCHY_UNIQUE_NAME", attributeObj.getHierarchyUniqueName());
        this.createTaggedValue((ModelElement)attribute, "LEVEL_UNIQUE_NAME", attributeObj.getLevelUniqueName());
        this.createTaggedValue((ModelElement)attribute, "MEMBER_UNIQUE_NAME", attributeObj.getMemberUniqueName());
        this.createTaggedValue((ModelElement)attribute, "PROPERTY_NAME", attributeObj.getPropertyName());
        this.createTaggedValue((ModelElement)attribute, "PROPERTY_CAPTION", attributeObj.getPropertyCaption());
        this.createTaggedValue((ModelElement)attribute, "DATA_TYPE", attributeObj.getDataType());
        this.createTaggedValue((ModelElement)attribute, "CHARACTER_MAXIMUM_LENGTH", attributeObj.getCharacterMaximumLength());
        this.createTaggedValue((ModelElement)attribute, "CHARACTER_OCTET_LENGTH", attributeObj.getCharacterOctetLength());
        this.createTaggedValue((ModelElement)attribute, "NUMERIC_PRECISION", attributeObj.getNumericPrecision());
        this.createTaggedValue((ModelElement)attribute, "NUMERIC_SCALE", attributeObj.getNumericScale());
        this.createTaggedValue((ModelElement)attribute, "DESCRIPTION", attributeObj.getDescription());
    }

    public void createTaggedValueSAPVariable(IBISapVariable variable, BISAPVariableObject variableObj) throws BIResourceException {
        this.createTaggedValue((ModelElement)variable, "CATALOG_NAME", variableObj.getCatalogName());
        this.createTaggedValue((ModelElement)variable, "SCHEMA_NAME", variableObj.getSchemaName());
        this.createTaggedValue((ModelElement)variable, "CUBE_NAME", variableObj.getCubeName());
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.VARIABLE_NAME, variableObj.getVariableName());
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.VARIABLE_CAPTION, variableObj.getVariableCaption());
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.VARIABLE_UID, variableObj.getVariableGUID());
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.VARIABLE_ORDINAL, String.valueOf(variableObj.getVariableOrdinal()));
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.VARIABLE_TYPE, String.valueOf(variableObj.getVariableType()));
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.DATA_TYPE, String.valueOf(variableObj.getDataType()));
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.CHARACTER_MAXIMUM_LENGTH, String.valueOf(variableObj.getCharacterMaximumLength()));
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.VARIABLE_PROCESSING_TYPE, String.valueOf(variableObj.getVariableProcessingType()));
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.VARIABLE_SELECTION_TYPE, String.valueOf(variableObj.getVariableSelectionType()));
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.VARIABLE_ENTRY_TYPE, String.valueOf(variableObj.getVariableEntryType()));
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.REFERENCE_DIMENSION, variableObj.getReferenceDimension());
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.REFERENCE_HIERARCHY, variableObj.getReferenceHierarchy());
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.DEFAULT_LOW, variableObj.getDefaultLow() == null ? null : variableObj.getDefaultLow().toString());
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.DEFAULT_LOW_CAP, String.valueOf(variableObj.getDefaultLowCap()));
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.DEFAULT_HIGH, variableObj.getDefaultHigh() == null ? null : variableObj.getDefaultHigh().toString());
        this.createTaggedValue((ModelElement)variable, BISAPVariableConstants.DEFAULT_HIGH_CAP, variableObj.getDefaultHighCap());
        this.createTaggedValue((ModelElement)variable, "DESCRIPTION", variableObj.getDescription());
    }

    protected String dimensionNameToDimensionUniqueName(String dimensionName) {
        return "[" + dimensionName + "]";
    }

    public List findHierarchy(BISAPVariableObject variableObj) throws BIResourceException {
        IConnection c = this.getConnection();
        if (c != null) {
            try {
                QueryFilters filters = new QueryFilters();
                String schemaName = MetadataNameConverter.schemaNameFromSchemaAndCatalogName(variableObj.getCatalogName(), variableObj.getSchemaName());
                String cubeName = variableObj.getCubeName();
                String dimensionName = MetadataNameConverter.dimensionUniqueNametoDimensionName(variableObj.getReferenceDimension());
                String hierarchyName = MetadataNameConverter.hierarchyUniqueNametoHierarchyName(variableObj.getReferenceHierarchy());
                if (schemaName != null) {
                    filters.add(new QueryFilter("SCHEMA_NAME", 0, schemaName));
                }
                if (cubeName != null) {
                    filters.add(new QueryFilter("CUBE_NAME", 0, cubeName));
                }
                if (dimensionName != null) {
                    filters.add(new QueryFilter("DIMENSION_NAME", 0, dimensionName));
                }
                if (hierarchyName != null) {
                    filters.add(new QueryFilter("HIERARCHY_NAME", 0, hierarchyName));
                }
                return this.mdr.queryM1(BIOlapQualifiedNameList.QUALIFIED_HIERARCHY_NAME, filters, false);
            }
            catch (ResourceException ex) {
                loc.errorT("sdk.dac.connector.olap_1001", new Object[]{"Hierarchy"});
                throw new BIResourceException(this.connectionInfo == null ? Locale.getDefault() : this.connectionInfo.getLocale(), "sdk.dac.connector.olap_1001", new Object[]{"Hierarchy"}, ex);
            }
        }
        loc.exiting();
        throw new BIResourceException(this.connectionInfo == null ? Locale.getDefault() : this.connectionInfo.getLocale());
    }

    public LevelBasedHierarchy findHierarchyFirst(BISAPVariableObject variableObj) throws BIResourceException {
        if (variableObj.getVariableType() == BISAPVariableConstants.SAPVariableType.SAP_VAR_TYPE_MEMBER) {
            return this.findHierarchyFirst(variableObj.getCatalogName(), variableObj.getSchemaName(), variableObj.getCubeName(), variableObj.getReferenceDimension(), variableObj.getReferenceHierarchy());
        }
        if (variableObj.getVariableType() == BISAPVariableConstants.SAPVariableType.SAP_VAR_TYPE_HIERARCHY) {
            return this.findHierarchyFirst(variableObj.getCatalogName(), variableObj.getSchemaName(), variableObj.getCubeName(), variableObj.getReferenceDimension(), variableObj.getDefaultLow().getString());
        }
        throw new BIResourceException(this.connectionInfo == null ? Locale.getDefault() : this.connectionInfo.getLocale());
    }

    protected abstract LevelBasedHierarchy findHierarchyFirst(String var1, String var2, String var3, String var4, String var5) throws BIResourceException;

    public IBIMember findMemberHigh(BISAPVariableObject variableObj) throws BIResourceException {
        return this.findMember(variableObj.getCatalogName(), variableObj.getSchemaName(), variableObj.getCubeName(), variableObj.getReferenceDimension(), variableObj.getReferenceHierarchy(), variableObj.getDefaultHighCap(), variableObj.getDefaultHigh());
    }

    public IBIMember findMemberLow(BISAPVariableObject variableObj) throws BIResourceException {
        return this.findMember(variableObj.getCatalogName(), variableObj.getSchemaName(), variableObj.getCubeName(), variableObj.getReferenceDimension(), variableObj.getReferenceHierarchy(), variableObj.getDefaultLowCap(), variableObj.getDefaultLow());
    }

    protected abstract IBIMember findMember(String var1, String var2, String var3, String var4, String var5, String var6, BIVariant var7) throws BIResourceException;

    public Dimension findDimensionFirst(BISAPVariableObject variableObj) throws BIResourceException {
        return this.findDimensionFirst(variableObj.getCatalogName(), variableObj.getSchemaName(), variableObj.getCubeName(), variableObj.getReferenceDimension());
    }

    protected abstract Dimension findDimensionFirst(String var1, String var2, String var3, String var4) throws BIResourceException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

