/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.olap;

import com.sap.ip.bi.sdk.dac.connector.olap.IBIVariant;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;

public class BIVariant
implements IBIVariant {
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$olap$BIVariant == null ? (class$com$sap$ip$bi$sdk$dac$connector$olap$BIVariant = BIVariant.class$("com.sap.ip.bi.sdk.dac.connector.olap.BIVariant")) : class$com$sap$ip$bi$sdk$dac$connector$olap$BIVariant).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    private int type;
    private short shortVal;
    private int intVal;
    private long longVal;
    private float floatVal;
    private double doubleVal;
    private boolean booleanVal;
    private char charVal;
    private String stringVal;
    private java.sql.Date dateVal;
    private Time timeVal;
    private Timestamp timestampVal;
    private Object objectVal;
    private byte[] byteArrayVal;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$olap$BIVariant;

    public BIVariant() {
        this.type = 0;
    }

    public BIVariant(Object obj1, Object obj2) {
        this.type = 1;
    }

    public BIVariant(BIVariant variant) {
        this.type = variant.getType();
        switch (variant.getType()) {
            case 3: {
                this.shortVal = variant.getShort();
                break;
            }
            case 4: {
                this.intVal = variant.getInt();
                break;
            }
            case 5: {
                this.longVal = variant.getLong();
                break;
            }
            case 6: {
                this.floatVal = variant.getFloat();
                break;
            }
            case 7: {
                this.doubleVal = variant.getDouble();
                break;
            }
            case 8: {
                this.booleanVal = variant.getBoolean();
                break;
            }
            case 17: {
                this.charVal = variant.getChar();
                break;
            }
            case 16: {
                this.stringVal = variant.getString();
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case 13: {
                this.dateVal = variant.getDate();
                break;
            }
            case 14: {
                this.timeVal = variant.getTime();
                break;
            }
            case 15: {
                this.timestampVal = variant.getTimestamp();
                break;
            }
            case 18: {
                this.objectVal = variant.getObject();
                break;
            }
            case 19: {
                this.byteArrayVal = variant.getByteArray();
                break;
            }
            default: {
                throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1006");
            }
        }
    }

    public String getAsString() {
        switch (this.type) {
            case 3: {
                return Short.toString(this.shortVal);
            }
            case 4: {
                return Integer.toString(this.intVal);
            }
            case 5: {
                return Long.toString(this.longVal);
            }
            case 6: {
                return Float.toString(this.floatVal);
            }
            case 7: {
                return Double.toString(this.doubleVal);
            }
            case 8: {
                return new Boolean(this.booleanVal).toString();
            }
            case 17: {
                return "" + this.charVal;
            }
            case 16: {
                if (this.stringVal == null) {
                    return "";
                }
                return this.stringVal;
            }
            case 13: {
                return this.dateVal.toString();
            }
            case 14: {
                return this.timeVal.toString();
            }
            case 15: {
                return this.timestampVal.toString();
            }
            case 19: {
                if (this.byteArrayVal == null) {
                    return "";
                }
                return new String(this.byteArrayVal);
            }
            case 18: {
                if (this.objectVal == null) {
                    return "";
                }
                return this.objectVal.toString();
            }
        }
        return "";
    }

    public BIVariant(short shortValue) {
        this.shortVal = shortValue;
        this.type = 3;
    }

    public BIVariant(int intValue) {
        this.intVal = intValue;
        this.type = 4;
    }

    public BIVariant(long longValue) {
        this.longVal = longValue;
        this.type = 5;
    }

    public BIVariant(float floatValue) {
        this.floatVal = floatValue;
        this.type = 6;
    }

    public BIVariant(double doubleValue) {
        this.doubleVal = doubleValue;
        this.type = 7;
    }

    public BIVariant(boolean booleanValue) {
        this.booleanVal = booleanValue;
        this.type = 8;
    }

    public BIVariant(char charValue) {
        this.charVal = charValue;
        this.type = 17;
    }

    public BIVariant(String stringValue) {
        this.stringVal = stringValue;
        this.type = 16;
    }

    public BIVariant(java.sql.Date dateValue) {
        this.dateVal = dateValue;
        this.type = 13;
    }

    public BIVariant(Time timeValue) {
        this.timeVal = timeValue;
        this.type = 14;
    }

    public BIVariant(Timestamp timestampValue) {
        this.timestampVal = timestampValue;
        this.type = 15;
    }

    public BIVariant(Object objectValue) {
        this.objectVal = objectValue;
        this.type = objectValue == null ? 1 : 18;
    }

    public BIVariant(byte[] byteArray) {
        this.byteArrayVal = byteArray;
        this.type = 19;
    }

    public int getType() {
        return this.type;
    }

    public final String getTypeName() {
        switch (this.type) {
            case 3: {
                return "SHORT";
            }
            case 4: {
                return "INT";
            }
            case 5: {
                return "LONG";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "DOUBLE";
            }
            case 8: {
                return "BOOLEAN";
            }
            case 17: {
                return "CHAR";
            }
            case 16: {
                return "STRING";
            }
            case 13: {
                return "DATE";
            }
            case 14: {
                return "TIME";
            }
            case 15: {
                return "TIMESTAMP";
            }
            case 18: {
                return "OBJECT";
            }
            case 19: {
                return "BYTE_ARRAY";
            }
            case 0: {
                return "UNASSIGNED";
            }
            case 1: {
                return "NULL";
            }
        }
        return "UNKNOWN";
    }

    public final String getXsdTypeName() {
        switch (this.type) {
            case 3: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case 5: {
                return "long";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "boolean";
            }
            case 17: {
                return "string";
            }
            case 16: {
                return "string";
            }
            case 13: {
                return "date";
            }
            case 14: {
                return "time";
            }
            case 15: {
                return "string";
            }
            case 18: {
                return "string";
            }
            case 19: {
                return "string";
            }
            case 0: {
                return "string";
            }
            case 1: {
                return "string";
            }
        }
        return "string";
    }

    public final short getShort() {
        if (this.type != 3) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1007", new Object[]{"short"});
        }
        return this.shortVal;
    }

    public final int getInt() {
        if (this.type != 4) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1007", new Object[]{"int"});
        }
        return this.intVal;
    }

    public final long getLong() {
        if (this.type != 5) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1007", new Object[]{"long"});
        }
        return this.longVal;
    }

    public final float getFloat() {
        if (this.type != 6) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1007", new Object[]{"float"});
        }
        return this.floatVal;
    }

    public final double getDouble() {
        if (this.type != 7) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1007", new Object[]{"double"});
        }
        return this.doubleVal;
    }

    public final boolean getBoolean() {
        if (this.type != 8) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1007", new Object[]{"boolean"});
        }
        return this.booleanVal;
    }

    public final char getChar() {
        if (this.type != 17) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1007", new Object[]{"char"});
        }
        return this.charVal;
    }

    public final String getString() {
        if (this.type != 16) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1007", new Object[]{"String"});
        }
        return this.stringVal;
    }

    public final java.sql.Date getDate() {
        if (this.type != 13) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1007", new Object[]{"Date"});
        }
        return this.dateVal;
    }

    public final Time getTime() {
        if (this.type != 14) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1007", new Object[]{"Time"});
        }
        return this.timeVal;
    }

    public final Timestamp getTimestamp() {
        if (this.type != 15) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1007", new Object[]{"Timestamp"});
        }
        return this.timestampVal;
    }

    public final Object getObject() {
        if (this.type != 18) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1007", new Object[]{"Object"});
        }
        return this.objectVal;
    }

    public final byte[] getByteArray() {
        if (this.type != 19) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk.dac.connector.olap_1007", new Object[]{"ByteArray"});
        }
        return this.byteArrayVal;
    }

    public final int getByteArrayLength() {
        return this.intVal;
    }

    public Object getAsObject() {
        switch (this.type) {
            case 3: {
                return new Short(this.shortVal);
            }
            case 4: {
                return new Integer(this.intVal);
            }
            case 5: {
                return new Long(this.longVal);
            }
            case 6: {
                return new Float(this.floatVal);
            }
            case 7: {
                return new Double(this.doubleVal);
            }
            case 8: {
                return new Boolean(this.booleanVal);
            }
            case 17: {
                return new Character(this.charVal);
            }
            case 0: 
            case 16: {
                if (this.stringVal == null) {
                    return "";
                }
                return this.stringVal;
            }
            case 13: {
                return new java.sql.Date(this.dateVal.getTime());
            }
            case 14: {
                return new Time(this.timeVal.getTime());
            }
            case 15: {
                return new Timestamp(((Date)this.timestampVal).getTime());
            }
            case 19: {
                if (this.byteArrayVal == null) {
                    return null;
                }
                return this.byteArrayVal;
            }
            case 18: {
                this.getObject();
                if (this.objectVal == null) {
                    return null;
                }
                return this.objectVal;
            }
        }
        return null;
    }

    public final String toString() {
        switch (this.type) {
            case 3: {
                return Short.toString(this.shortVal);
            }
            case 4: {
                return Integer.toString(this.intVal, 10);
            }
            case 5: {
                return Long.toString(this.longVal, 10);
            }
            case 6: {
                return Float.toString(this.floatVal);
            }
            case 7: {
                return Double.toString(this.doubleVal);
            }
            case 8: {
                return this.booleanVal ? "true" : "false";
            }
            case 17: {
                return "" + this.charVal;
            }
            case 16: {
                if (this.stringVal == null) {
                    return "";
                }
                return this.stringVal;
            }
            case 13: {
                return this.dateVal.toString();
            }
            case 14: {
                return this.timeVal.toString();
            }
            case 15: {
                return this.timestampVal.toString();
            }
            case 19: {
                if (this.byteArrayVal == null) {
                    return "";
                }
                return new String(this.byteArrayVal, 0, this.intVal);
            }
            case 18: {
                this.getObject();
                if (this.objectVal == null) {
                    return "";
                }
                return this.objectVal.toString();
            }
        }
        return "";
    }

    public final boolean equals(BIVariant value) {
        if (this.type != value.getType()) {
            return false;
        }
        switch (this.type) {
            case 3: {
                return this.shortVal == value.getShort();
            }
            case 4: {
                return this.intVal == value.getInt();
            }
            case 5: {
                return this.longVal == value.getLong();
            }
            case 6: {
                return this.floatVal == value.getFloat();
            }
            case 7: {
                return this.doubleVal == value.getDouble();
            }
            case 8: {
                return this.booleanVal == value.getBoolean();
            }
            case 15: {
                if (this.timestampVal.getNanos() != value.getTimestamp().getNanos()) {
                    return false;
                }
                return ((Date)this.timestampVal).getTime() == ((Date)value.getTimestamp()).getTime();
            }
            case 13: {
                return this.dateVal.getTime() == value.getDate().getTime();
            }
            case 14: {
                return this.timeVal.getTime() == value.getTime().getTime();
            }
            case 17: {
                return this.charVal == value.charVal;
            }
            case 16: {
                if (this.stringVal == value.getString()) {
                    return true;
                }
                return this.stringVal.equals(value.getString());
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

