/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.connector;

import com.sap.exception.BaseExceptionInfo;
import com.sap.exception.IBaseException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.TimeZone;

public class ConnectorRuntimeException
extends RuntimeException
implements IBaseException {
    private BaseExceptionInfo exceptionInfo;
    private boolean createdByDeprecatedConstructor = false;

    public ConnectorRuntimeException(String message, Exception linkedException) {
        super(message);
        this.createdByDeprecatedConstructor = true;
        this.exceptionInfo = new BaseExceptionInfo(Location.getLocation((String)"com.sap.portal.connectors"), (Throwable)this, (Throwable)linkedException);
    }

    public ConnectorRuntimeException(Location loc, ResourceAccessor accessor, String key, Object[] parameters, Throwable rootCause) {
        super(accessor.getMessageText(null, key));
        this.exceptionInfo = new BaseExceptionInfo(loc, accessor, key, parameters, (Throwable)this, rootCause);
        if (rootCause instanceof Exception) {
            this.setLinkedException((Exception)rootCause);
        }
    }

    public ConnectorRuntimeException(String message) {
        super(message);
        this.createdByDeprecatedConstructor = true;
        this.exceptionInfo = new BaseExceptionInfo(Location.getLocation((String)"com.sap.portal.connectors"), (Throwable)this);
    }

    public Exception getLinkedException() {
        Throwable throwable = this.getCause();
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return null;
    }

    public void setLinkedException(Exception linkedException) {
        if (this.getCause() == null) {
            this.initCause(linkedException);
        }
    }

    public Throwable initCause(Throwable cause) {
        return this.exceptionInfo.initCause(cause);
    }

    public Throwable getCause() {
        return this.exceptionInfo.getCause();
    }

    public LocalizableText getLocalizableMessage() {
        if (this.createdByDeprecatedConstructor) {
            return new LocalizableTextFormatter(null, super.getMessage());
        }
        return this.exceptionInfo.getLocalizableMessage();
    }

    public String getLocalizedMessage(Locale locale) {
        if (this.createdByDeprecatedConstructor) {
            return super.getMessage();
        }
        return this.exceptionInfo.getLocalizedMessage(locale);
    }

    public String getLocalizedMessage(TimeZone timeZone) {
        if (this.createdByDeprecatedConstructor) {
            return super.getMessage();
        }
        return this.exceptionInfo.getLocalizedMessage(timeZone);
    }

    public String getLocalizedMessage(Locale locale, TimeZone timeZone) {
        if (this.createdByDeprecatedConstructor) {
            return super.getMessage();
        }
        return this.exceptionInfo.getLocalizedMessage(locale, timeZone);
    }

    public String getNestedLocalizedMessage() {
        if (this.createdByDeprecatedConstructor) {
            Exception linked = this.getLinkedException();
            if (linked == null) {
                return null;
            }
            return linked.getLocalizedMessage();
        }
        return this.exceptionInfo.getNestedLocalizedMessage();
    }

    public String getNestedLocalizedMessage(Locale locale) {
        if (this.createdByDeprecatedConstructor) {
            Exception linked = this.getLinkedException();
            if (linked == null) {
                return null;
            }
            return linked.getLocalizedMessage();
        }
        return this.exceptionInfo.getNestedLocalizedMessage(locale);
    }

    public String getNestedLocalizedMessage(TimeZone timeZone) {
        if (this.createdByDeprecatedConstructor) {
            Exception linked = this.getLinkedException();
            if (linked == null) {
                return null;
            }
            return linked.getLocalizedMessage();
        }
        return this.exceptionInfo.getNestedLocalizedMessage(timeZone);
    }

    public String getNestedLocalizedMessage(Locale locale, TimeZone timeZone) {
        if (this.createdByDeprecatedConstructor) {
            Exception linked = this.getLinkedException();
            if (linked == null) {
                return null;
            }
            return linked.getLocalizedMessage();
        }
        return this.exceptionInfo.getNestedLocalizedMessage(locale, timeZone);
    }

    public void finallyLocalize() {
        this.exceptionInfo.finallyLocalize();
    }

    public void finallyLocalize(Locale locale) {
        this.exceptionInfo.finallyLocalize(locale);
    }

    public void finallyLocalize(TimeZone timeZone) {
        this.exceptionInfo.finallyLocalize(timeZone);
    }

    public void finallyLocalize(Locale locale, TimeZone timeZone) {
        this.exceptionInfo.finallyLocalize(locale, timeZone);
    }

    public String getSystemStackTraceString() {
        StringWriter s = new StringWriter();
        super.printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    public String getStackTraceString() {
        return this.exceptionInfo.getStackTraceString();
    }

    public String getNestedStackTraceString() {
        return this.exceptionInfo.getNestedStackTraceString();
    }

    public void setLogSettings(Category category, int severity, Location location) {
        this.exceptionInfo.setLogSettings(category, severity, location);
    }

    public void log() {
        this.exceptionInfo.log();
    }
}

