/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.proxy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.PropRequestFilter;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.proxy.Rule;
import org.w3c.www.protocol.http.proxy.RuleNode;
import org.w3c.www.protocol.http.proxy.RuleParser;
import org.w3c.www.protocol.http.proxy.RuleParserException;

public class ProxyDispatcher
implements PropertyMonitoring,
PropRequestFilter {
    protected long lastParsingTime = -1L;
    protected static final String disabled = "disabled";
    protected boolean check_rules = false;
    protected boolean debug = false;
    protected RuleNode rules = null;
    protected ObservableProperties props = null;
    public static final String CHECK_RULES_LAST_MODIFIED_P = "org.w3c.www.protocol.http.proxy.rules.check.lastmodified";
    public static final String DEBUG_P = "org.w3c.www.protocol.http.proxy.debug";
    public static final String RULE_P = "org.w3c.www.protocol.http.proxy.rules";

    public void sync() {
    }

    public boolean propertyChanged(String string) {
        if (string.equals(RULE_P)) {
            try {
                this.parseRules();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        } else if (string.equals(DEBUG_P)) {
            this.debug = this.props.getBoolean(DEBUG_P, false);
        } else if (string.equals(CHECK_RULES_LAST_MODIFIED_P)) {
            this.check_rules = this.props.getBoolean(CHECK_RULES_LAST_MODIFIED_P, false);
        }
        return true;
    }

    protected void parseRules(InputStream inputStream) throws RuleParserException, IOException {
        RuleNode ruleNode;
        RuleParser ruleParser = new RuleParser(inputStream);
        this.rules = ruleNode = ruleParser.parse();
        this.lastParsingTime = System.currentTimeMillis();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseRules() {
        block12: {
            if (this.debug) {
                System.out.println("PARSING RULES...");
            }
            String string = this.props.getString(RULE_P, null);
            InputStream inputStream = null;
            try {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
            }
            catch (Exception exception) {
                try {
                    inputStream = new BufferedInputStream(new FileInputStream(new File(string)));
                }
                catch (Exception exception2) {
                    System.err.println("* ProxyDispatcher: unable to open rule file \"" + string + "\"");
                    this.rules = null;
                    return;
                }
            }
            try {
                try {
                    this.parseRules(inputStream);
                }
                catch (Exception exception) {
                    System.err.println("Error parsing rules from: " + string);
                    exception.printStackTrace();
                    this.rules = null;
                }
                Object var4_6 = null;
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            inputStream.close();
        }
        if (!this.debug) return;
        System.out.println("DONE.");
    }

    public Reply outgoingFilter(Request request, Reply reply) {
        return null;
    }

    protected boolean needsParsing() {
        if (this.rules == null) {
            return true;
        }
        if (!this.check_rules) {
            return false;
        }
        long l = -1L;
        String string = this.props.getString(RULE_P, null);
        try {
            URL uRL = new URL(string);
            if (uRL.getProtocol().equalsIgnoreCase("file")) {
                File file = new File(uRL.getFile());
                l = file.lastModified();
            } else {
                URLConnection uRLConnection = uRL.openConnection();
                l = uRLConnection.getLastModified();
            }
        }
        catch (Exception exception) {
            File file = new File(string);
            l = file.lastModified();
        }
        System.out.println("rulesStamp : " + l);
        return this.lastParsingTime < l;
    }

    public void initialize(HttpManager httpManager) {
        this.props = httpManager.getProperties();
        this.props.registerObserver(this);
        this.parseRules();
        this.debug = this.props.getBoolean(DEBUG_P, false);
        if (this.debug) {
            System.out.println("[" + this.getClass().getName() + ": debuging on.");
        }
        this.check_rules = this.props.getBoolean(CHECK_RULES_LAST_MODIFIED_P, false);
        httpManager.setFilter(this);
    }

    public Reply ingoingFilter(Request request) {
        URL uRL;
        String string;
        Rule rule;
        if (this.needsParsing()) {
            this.parseRules();
        }
        if (this.rules != null && (rule = this.rules.lookupRule(string = (uRL = request.getURL()).getHost())) != null) {
            if (this.debug) {
                String string2 = rule.getRuleArgs();
                string2 = string2 == null ? "" : " " + string2;
                System.out.println("[" + this.getClass().getName() + "]: applying rule <" + rule.getRuleName() + string2 + "> to " + request.getURL());
            }
            return rule.apply(request);
        }
        return null;
    }

    public boolean exceptionFilter(Request request, HttpException httpException) {
        if (request.hasProxy()) {
            Object var3_3 = null;
            HttpManager httpManager = HttpManager.getManager();
            request.setProxy(null);
            if (this.debug) {
                System.out.println("[" + this.getClass().getName() + "]: direct fetch " + "for " + request.getURL());
            }
            return true;
        }
        return false;
    }
}

