/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.Socket;
import org.w3c.www.http.ChunkedInputStream;
import org.w3c.www.http.ContentLengthInputStream;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpMimeType;
import org.w3c.www.http.HttpReplyMessage;
import org.w3c.www.http.HttpStreamObserver;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeType;
import org.w3c.www.protocol.http.Request;

public class Reply
extends HttpReplyMessage {
    protected boolean definesInput = false;
    protected InputStream input = null;
    Socket a;
    HttpStreamObserver c = null;
    MimeParser b = null;
    protected static HttpMimeType DEFAULT_TYPE = null;

    protected void setStreamObserver(HttpStreamObserver httpStreamObserver) {
        this.c = httpStreamObserver;
    }

    public void setStream(InputStream inputStream) {
        this.input = inputStream;
        this.definesInput = true;
    }

    public void setContent(String string) {
        if (!this.hasHeader(HttpEntityMessage.H_CONTENT_TYPE)) {
            this.setHeaderValue(HttpEntityMessage.H_CONTENT_TYPE, (HeaderValue)DEFAULT_TYPE);
        }
        this.setContentLength(string.length());
        this.setStream(new StringBufferInputStream(string));
    }

    protected void matchesRequest(Request request) {
        String string = request.getMethod();
        if (string.equals("HEAD") || string.equals("OPTIONS")) {
            this.setStream(null);
        }
    }

    public boolean keepsAlive() {
        if (this.major >= 1) {
            if (this.minor >= 1) {
                return this.getContentLength() >= 0 || this.hasTransferEncoding("chunked");
            }
            return this.hasConnection("keep-alive") || this.hasProxyConnection("keep-alive");
        }
        return false;
    }

    public boolean hasInputStream() throws IOException {
        return this.getInputStream() != null;
    }

    public Socket getSocket() {
        return this.a;
    }

    public InputStream getInputStream() throws IOException {
        if (this.definesInput) {
            return this.input;
        }
        switch (this.getStatus()) {
            case 204: 
            case 304: {
                return null;
            }
        }
        if (this.hasTransferEncoding("chunked")) {
            this.definesInput = true;
            this.input = new ChunkedInputStream(this.c, this.b.getInputStream());
            return this.input;
        }
        int n = this.getContentLength();
        if (n >= 0) {
            this.input = new ContentLengthInputStream(this.c, this.b.getInputStream(), n);
            this.definesInput = true;
            return this.input;
        }
        if (this.c != null) {
            this.c.notifyFailure(this.b.getInputStream());
        }
        return this.b.getInputStream();
    }

    Reply(short s, short s2, int n) {
        this.major = s;
        this.minor = s2;
        this.setStatus(n);
    }

    Reply(MimeParser mimeParser) {
        super(mimeParser);
        this.b = mimeParser;
    }

    static {
        DEFAULT_TYPE = HttpFactory.makeMimeType(MimeType.TEXT_HTML);
    }
}

