/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import iaik.security.ssl.SSLContext;
import iaik.security.ssl.SSLSocket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Enumeration;
import org.w3c.www.http.HeaderDescription;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpRequestMessage;
import org.w3c.www.mime.MimeType;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    private boolean b = java.net.HttpURLConnection.getFollowRedirects();
    protected SSLContext sslContext = null;
    private InputStream a = null;
    protected ByteArrayOutputStream output = null;
    protected Reply reply = null;
    protected Request request = null;

    public boolean usingProxy() {
        return HttpManager.getManager().usingProxy();
    }

    public void setSSLContext(SSLContext sSLContext) {
        if (sSLContext == null) {
            throw new IllegalArgumentException("Context may not be null!");
        }
        this.sslContext = sSLContext;
        if (this.request != null) {
            this.request.setSSLContext(this.sslContext);
        }
    }

    public void setRequestProperty(String string, String string2) {
        this.checkRequest();
        this.request.setValue(string, string2);
    }

    public void setRequestMethod(String string) throws ProtocolException {
        super.setRequestMethod(string);
        if (this.request != null) {
            this.request.setMethod(string);
        }
    }

    public void setInstanceFollowRedirects(boolean bl) {
        this.b = bl;
    }

    public void setInputStream(int n, InputStream inputStream) throws IOException {
        if (!this.connected && !this.doOutput) {
            this.setDoOutput(true);
        } else if (this.connected) {
            this.error("Already connected, too late for setInputStream.");
        }
        this.a = inputStream;
        if (this.request == null) {
            throw new IOException("setInputStream only may be called after calling setDoOutput!");
        }
        this.request.setContentLength(n);
    }

    public static void setGlobalRequestProperty(String string, String string2) {
        HttpManager.getManager().setGlobalHeader(string, string2);
    }

    public void setDoOutput(boolean bl) {
        this.debug("DoOutput !!");
        super.setDoOutput(bl);
        this.checkRequest();
        if (this.request.getContentType() == null) {
            this.request.setContentType(MimeType.APPLICATION_X_WWW_FORM_URLENCODED);
        }
    }

    public SSLSocket getSSLSocket() throws IOException {
        if (this.reply == null) {
            throw new IOException("Not yet connected or connection failed!");
        }
        return (SSLSocket)this.reply.getSocket();
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public String getResponseMessage() throws IOException {
        if (this.responseMessage == null) {
            this.getResponseCode();
        }
        return this.responseMessage;
    }

    public int getResponseCode() throws IOException {
        this.debug("getResponseCode");
        this.checkReply();
        this.responseMessage = this.reply.getReason();
        return this.reply.getStatus();
    }

    public String getRequestProperty(String string) {
        this.checkRequest();
        return this.request.getValue(string);
    }

    public OutputStream getOutputStream() throws IOException {
        this.debug("getOutputStream");
        if (!this.connected && !this.doOutput) {
            this.setDoOutput(true);
        } else if (this.connected) {
            this.error("Already connected, too late for getOutputStream.");
        }
        this.output = new ByteArrayOutputStream();
        return this.output;
    }

    public long getLastModified() {
        this.debug("getLastModified");
        this.checkReply();
        return this.reply.getLastModified();
    }

    public boolean getInstanceFollowRedirects() {
        return this.b;
    }

    public InputStream getInputStream() throws IOException {
        this.debug("getInputStream");
        this.a();
        return this.reply.getInputStream();
    }

    public String getHeaderFieldKey(int n) {
        this.debug("getHeaderFieldKey(" + n + ")");
        Enumeration enumeration = this.reply.enumerateHeaderDescriptions(false);
        HeaderDescription headerDescription = null;
        while (--n >= 0) {
            if (enumeration.hasMoreElements()) {
                headerDescription = (HeaderDescription)enumeration.nextElement();
                continue;
            }
            return null;
        }
        if (headerDescription != null) {
            return headerDescription.getName();
        }
        return null;
    }

    public String getHeaderField(String string) {
        this.debug("getHeaderField");
        this.checkReply();
        return this.reply.getValue(string);
    }

    public String getHeaderField(int n) {
        String string = this.getHeaderFieldKey(n);
        if (string != null) {
            return this.reply.getValue(string);
        }
        return null;
    }

    public long getExpiration() {
        this.debug("getExpiration");
        this.checkReply();
        return this.reply.getExpires();
    }

    public static String getDefaultRequestProperty(String string) {
        return HttpManager.getManager().getGlobalHeader(string);
    }

    public long getDate() {
        this.debug("getDate");
        this.checkReply();
        return this.reply.getDate();
    }

    public String getContentType() {
        this.debug("getContentType");
        this.checkReply();
        MimeType mimeType = this.reply.getContentType();
        if (mimeType != null) {
            return mimeType.toString();
        }
        return null;
    }

    public int getContentLength() {
        this.debug("getContentLength");
        this.checkReply();
        return this.reply.getContentLength();
    }

    protected void error(String string) {
        this.debug("ERROR \"" + string + "\"");
        throw new RuntimeException(string);
    }

    public synchronized void disconnect() {
        if (this.request != null) {
            this.request.interruptRequest();
        }
    }

    protected final void debug(String string) {
    }

    public void connect() throws IOException {
        Object object;
        this.debug("connect");
        if (this.connected) {
            return;
        }
        this.checkRequest();
        if (this.doOutput) {
            Object object2;
            if (this.a == null) {
                object2 = this.output.toByteArray();
                object = new ByteArrayInputStream((byte[])object2);
                this.request.setOutputStream((InputStream)object);
                if (!this.request.hasHeader(HttpEntityMessage.H_CONTENT_LENGTH)) {
                    this.request.setContentLength(((byte[])object2).length);
                }
            } else {
                this.request.setOutputStream(this.a);
            }
            if (!this.request.hasHeader(HttpEntityMessage.H_CONTENT_TYPE)) {
                object2 = this.request.getMethod().equals("POST") ? MimeType.APPLICATION_X_WWW_FORM_URLENCODED : MimeType.TEXT_PLAIN;
                this.request.setContentType((MimeType)object2);
            }
        }
        int n = 0;
        while (n < 5) {
            if (n == 1) {
                this.request.setOutputStream(null);
                this.request.setContentLength(-1);
                this.request.setMethod("GET");
            }
            this.reply = this.request.getManager().runRequest(this.request);
            if (this.reply.getStatus() / 100 != 3 || !this.getInstanceFollowRedirects() || (object = this.reply.getLocation()) == null) break;
            URL uRL = this.request.getURL();
            try {
                this.url = new URL(uRL, (String)object);
                this.request.setURL(this.url);
                this.request.setHeaderValue(HttpRequestMessage.H_HOST, null);
            }
            catch (MalformedURLException malformedURLException) {
                break;
            }
            if (n < 4) {
                this.reply.getInputStream().close();
            }
            ++n;
        }
        this.connected = true;
    }

    protected final synchronized void checkRequest() {
        if (this.request == null) {
            this.request = HttpManager.getManager(this.url).createRequest(this.url);
            this.request.setMethod(this.method);
            if (this.ifModifiedSince > 0L) {
                this.request.setIfModifiedSince(this.ifModifiedSince * 1000L);
            }
            if (!this.useCaches) {
                this.request.addPragma("no-cache");
                this.request.setNoCache();
            }
            this.request.setURL(this.url);
            this.request.setSSLContext(this.sslContext);
        }
    }

    private void a() throws IOException {
        if (this.reply == null && this.connected) {
            this.error("Was connected but didn't get any reply !");
        } else if (!this.connected) {
            this.connect();
        }
    }

    protected final void checkReply() {
        try {
            this.a();
        }
        catch (IOException iOException) {
            this.error("Error while silently connecting: " + iOException.toString());
        }
    }

    protected HttpURLConnection(URL uRL) {
        super(uRL);
    }
}

