/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.w3c.com.fourthpass.a;
import org.w3c.util.LRUList;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.util.SyncLRUList;
import org.w3c.www.http.HttpMessage;
import org.w3c.www.http.HttpRequestMessage;
import org.w3c.www.mime.MimeParserFactory;
import org.w3c.www.protocol.http.DebugFilter;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpServer;
import org.w3c.www.protocol.http.PropRequestFilter;
import org.w3c.www.protocol.http.PropRequestFilterException;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.RequestFilter;
import org.w3c.www.protocol.http.b;
import org.w3c.www.protocol.http.c;
import org.w3c.www.protocol.http.cookies.CookieFilter;
import org.w3c.www.protocol.http.d;
import org.w3c.www.protocol.http.e;
import org.w3c.www.protocol.http.g;

public class HttpManager
implements PropertyMonitoring {
    MimeParserFactory d = null;
    protected boolean lenient = true;
    protected int conn_max = 5;
    protected int conn_count = 0;
    protected int timeout = 300000;
    g c = null;
    protected LRUList connectionsLru = null;
    protected Request template = new Request(this);
    protected Hashtable servers = new Hashtable();
    ObservableProperties a = null;
    protected Class serverclass = null;
    private static c[] b = new c[4];
    public static final String DEFAULT_USER_AGENT = "Jigsaw/2.1.2";
    public static final String DEFAULT_ACCEPT = "*/*";
    public static final String PROXY_PORT_P = "proxyPort";
    public static final String PROXY_HOST_P = "proxyHost";
    public static final String PROXY_SET_P = "proxySet";
    public static final String LENIENT_P = "org.w3c.www.protocol.http.lenient";
    public static final String ACCEPT_ENCODING_P = "org.w3c.www.protocol.http.acceptEncoding";
    public static final String ACCEPT_LANGUAGE_P = "org.w3c.www.protocol.http.acceptLanguage";
    public static final String ACCEPT_P = "org.w3c.www.protocol.http.accept";
    public static final String USER_AGENT_P = "org.w3c.www.protocol.http.userAgent";
    public static final String ONLY_IF_CACHED_P = "org.w3c.www.protocol.http.cacheControl.onlyIfCached";
    public static final String MIN_FRESH_P = "org.w3c.www.protocol.http.cacheControl.minFresh";
    public static final String MAX_STALE_P = "org.w3c.www.protocol.http.cacheControl.maxStale";
    public static final String TIMEOUT_P = "org.w3c.www.protocol.http.connections.timeout";
    public static final String CONN_MAX_P = "org.w3c.www.protocol.http.connections.max";
    public static final String FILTERS_PROP_P = "org.w3c.www.protocol.http.filters";
    public static final String SERVER_CLASS_P = "org.w3c.www.protocol.http.server";
    private static final String f = "org.w3c.www.protocol.http.HttpBasicServer";
    private static final boolean e = false;

    protected synchronized void waitForConnection(HttpServer httpServer) throws InterruptedException {
        this.wait();
    }

    public boolean usingProxy() {
        return this.template.hasProxy();
    }

    protected boolean updateProxy(URL uRL) {
        String string = uRL == null ? null : uRL.getProtocol().toLowerCase();
        boolean bl = false;
        String string2 = null;
        boolean bl2 = false;
        int n = -1;
        if (string != null) {
            bl2 = string.toLowerCase().startsWith("https");
        }
        if (bl2) {
            string2 = this.a.getString("https.proxyHost", null);
            n = this.a.getInteger("https.proxyPort", -1);
            if (string2 != null) {
                bl = true;
            }
        } else {
            bl = this.a.getBoolean(PROXY_SET_P, false);
            if (bl) {
                string2 = this.a.getString(PROXY_HOST_P, null);
                n = this.a.getInteger(PROXY_PORT_P, -1);
            }
        }
        if (bl) {
            URL uRL2 = null;
            try {
                uRL2 = new URL("http", string2, n, "/");
            }
            catch (Exception exception) {
                boolean bl3 = false;
                return bl3;
            }
            if (uRL2 != null && uRL2.getHost() != null) {
                this.template.setProxy(uRL2);
            }
        } else {
            this.template.setProxy(null);
        }
        return true;
    }

    protected synchronized boolean tooManyConnections() {
        return this.conn_count >= this.conn_max;
    }

    public void sync() {
        this.c.a();
    }

    public synchronized void setTimeout(int n) {
        this.timeout = n;
        Enumeration enumeration = this.servers.elements();
        while (enumeration.hasMoreElements()) {
            ((HttpServer)enumeration.nextElement()).setTimeout(n);
        }
    }

    public void setRequestTimeout(int n) {
    }

    public void setProxy(URL uRL) {
        this.template.setProxy(uRL);
    }

    public synchronized void setMaxConnections(int n) {
        this.conn_max = n;
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public void setGlobalHeader(String string, String string2) {
        this.template.setValue(string, string2);
    }

    public void setFilter(URL[] uRLArray, URL[] uRLArray2, RequestFilter requestFilter) {
        int n;
        if (uRLArray != null) {
            n = 0;
            while (n < uRLArray.length) {
                this.c.a(uRLArray[n], true, requestFilter);
                ++n;
            }
        }
        if (uRLArray2 != null) {
            n = 0;
            while (n < uRLArray2.length) {
                this.c.a(uRLArray2[n], false, requestFilter);
                ++n;
            }
        }
    }

    public void setFilter(RequestFilter requestFilter) {
        this.c.a(requestFilter);
    }

    public void setAllowUserInteraction(boolean bl) {
        this.template.setAllowUserInteraction(bl);
    }

    /*
     * Unable to fully structure code
     */
    public Reply runRequest(Request var1_1) throws HttpException {
        var2_2 = null;
        var3_3 = 0;
        var4_4 = this.c.a(var1_1);
        if (var4_4 != null) {
            var5_5 = 0;
            while (var5_5 < var4_4.length) {
                var2_2 = var4_4[var3_3].ingoingFilter(var1_1);
                if (var2_2 != null) break;
                ++var3_3;
                ++var5_5;
            }
        }
        var5_6 = var1_1.getURL();
        var6_7 = var5_6.getProtocol();
        if (var2_2 == null) {
            var7_8 = null;
            do {
                var8_9 = false;
                try {
                    block12: {
                        try {
                            var11_11 = var1_1.getProxy();
                            var7_8 = var11_11 != null ? this.lookupServer(var11_11.getHost(), var11_11.getPort(), var5_6.getHost(), var5_6.getPort(), var6_7) : this.lookupServer(var5_6.getHost(), var5_6.getPort(), null, -1, null);
                            var1_1.setServer((HttpServer)var7_8);
                            var2_2 = var7_8.runRequest(var1_1);
                            break block12;
                        }
                        catch (HttpException var11_12) {
                            var12_13 = 0;
                            ** while (var12_13 < var3_3)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var8_9 = var8_9 != false || var4_4[var12_13].exceptionFilter(var1_1, var11_12) != false;
                            ++var12_13;
                            continue;
                        }
lbl31:
                        // 1 sources

                        if (!var8_9) {
                            throw var11_12;
                        }
                    }
                    var10_10 = null;
                    var1_1.unsetServer();
                }
                catch (Throwable var9_14) {
                    var10_10 = null;
                    var1_1.unsetServer();
                    throw var9_14;
                }
            } while (var8_9);
        }
        if (var4_4 != null) {
            while (--var3_3 >= 0) {
                var7_8 = var4_4[var3_3].outgoingFilter(var1_1, var2_2);
                if (var7_8 == null) continue;
                var2_2 = var7_8;
                break;
            }
        }
        return var2_2;
    }

    public boolean propertyChanged(String string) {
        Request request = this.template;
        if (string.equals(FILTERS_PROP_P)) {
            return true;
        }
        if (string.equals(TIMEOUT_P)) {
            this.setTimeout(this.a.getInteger(TIMEOUT_P, this.timeout));
            return true;
        }
        if (string.equals(CONN_MAX_P)) {
            this.setMaxConnections(this.a.getInteger(CONN_MAX_P, this.conn_max));
            return true;
        }
        if (string.equals(MAX_STALE_P)) {
            int n = this.a.getInteger(MAX_STALE_P, -1);
            if (n >= 0) {
                request.setMaxStale(n);
            }
            return true;
        }
        if (string.equals(MIN_FRESH_P)) {
            int n = this.a.getInteger(MIN_FRESH_P, -1);
            if (n >= 0) {
                request.setMinFresh(n);
            }
            return true;
        }
        if (string.equals(LENIENT_P)) {
            this.lenient = this.a.getBoolean(ONLY_IF_CACHED_P, this.lenient);
            return true;
        }
        if (string.equals(ONLY_IF_CACHED_P)) {
            request.setOnlyIfCached(this.a.getBoolean(ONLY_IF_CACHED_P, false));
            return true;
        }
        if (string.equals(USER_AGENT_P)) {
            request.setValue("user-agent", this.a.getString(USER_AGENT_P, DEFAULT_USER_AGENT));
            return true;
        }
        if (string.equals(ACCEPT_P)) {
            request.setValue("accept", this.a.getString(ACCEPT_P, DEFAULT_ACCEPT));
            return true;
        }
        if (string.equals(ACCEPT_LANGUAGE_P)) {
            String string2 = this.a.getString(ACCEPT_LANGUAGE_P, null);
            if (string2 != null) {
                request.setValue("accept-language", string2);
            }
            return true;
        }
        if (string.equals(ACCEPT_ENCODING_P)) {
            String string3 = this.a.getString(ACCEPT_ENCODING_P, null);
            if (string3 != null) {
                request.setValue("accept-encoding", string3);
            }
            return true;
        }
        if (string.equals(PROXY_SET_P) || string.equals(PROXY_HOST_P) || string.equals(PROXY_PORT_P) || string.equals("https.proxyHost") || string.equals("https.proxyPort") || string.equals("https.nonProxyHosts")) {
            return this.updateProxy(request.getURL());
        }
        return true;
    }

    public void notifyUse(e e2) {
        this.connectionsLru.remove(e2);
    }

    public synchronized void notifyIdle(e e2) {
        this.connectionsLru.toHead(e2);
        d d2 = e2.getServer().getState();
        d2.b(e2);
        this.notifyAll();
    }

    protected synchronized void notifyConnection(e e2) {
        if (++this.conn_count > this.conn_max) {
            this.closeAnyConnection();
        }
    }

    protected boolean negotiateConnection(HttpServer httpServer) {
        d d2 = httpServer.getState();
        if (!this.tooManyConnections()) {
            return true;
        }
        if (d2.d()) {
            return this.closeAnyConnection();
        }
        if (this.servers.size() > this.conn_max) {
            return this.closeAnyConnection();
        }
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            HttpManager httpManager = HttpManager.getManager();
            httpManager.setGlobalHeader("User-Agent", "Jigsaw/1.0a");
            httpManager.setGlobalHeader("Accept", "*/*;q=1.0");
            httpManager.setGlobalHeader("Accept-Encoding", "gzip");
            CookieFilter cookieFilter = new CookieFilter();
            cookieFilter.initialize(httpManager);
            DebugFilter debugFilter = new DebugFilter();
            debugFilter.initialize(httpManager);
            Request request = httpManager.createRequest();
            request.setURL(new URL(stringArray[0]));
            request.setMethod("GET");
            Reply reply = httpManager.runRequest(request);
            System.out.println("last-modified: " + reply.getLastModified());
            System.out.println("length       : " + reply.getContentLength());
            InputStream inputStream = reply.getInputStream();
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = inputStream.read(byArray)) > 0) {
                System.out.print(new String(byArray, 0, n));
            }
            System.out.println("-");
            inputStream.close();
            httpManager.sync();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(1);
    }

    protected synchronized HttpServer lookupServer(String string, int n, String string2, int n2, String string3) throws HttpException {
        HttpServer httpServer;
        String string4;
        int n3 = n == -1 ? 80 : n;
        String string5 = string4 = n3 == 80 ? string.toLowerCase() : String.valueOf(string.toLowerCase()) + ":" + n3;
        if (string3 != null && string3.toLowerCase().startsWith("https")) {
            string4 = String.valueOf(string4) + "::" + string2 + ":" + n2;
        }
        if ((httpServer = (HttpServer)this.servers.get(string4)) != null) {
            return httpServer;
        }
        try {
            httpServer = (HttpServer)this.serverclass.newInstance();
        }
        catch (Exception exception) {
            String string6 = "Unable to create an instance of \"" + this.serverclass.getName() + "\", invalid config, check the " + SERVER_CLASS_P + " property.";
            throw new HttpException(exception, string6);
        }
        httpServer.initialize(this, new d(httpServer), string, n3, this.timeout);
        this.servers.put(string4, httpServer);
        return httpServer;
    }

    protected boolean isNonProxyHost(String string, String string2) {
        boolean bl;
        if (string != null && string2 != null) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " |", false);
            bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.startsWith("*")) {
                    String string4 = string3.substring(1);
                    if (!string.endsWith(string4)) continue;
                    bl = true;
                } else {
                    if (!string.equals(string3)) continue;
                    bl = true;
                }
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    protected final synchronized void incrConnCount(HttpServer httpServer) {
        if (++this.conn_count > this.conn_max) {
            this.closeAnyConnection();
        }
    }

    public final String getServerKey(Request request) {
        URL uRL = request.getProxy();
        URL uRL2 = request.getURL();
        Object var4_4 = null;
        if (uRL != null) {
            return uRL.getPort() == 80 ? uRL.getHost().toLowerCase() : String.valueOf(uRL.getHost().toLowerCase()) + ":" + uRL.getPort();
        }
        return uRL2.getPort() == 80 ? uRL2.getHost().toLowerCase() : String.valueOf(uRL2.getHost().toLowerCase()) + ":" + uRL2.getPort();
    }

    public MimeParserFactory getReplyFactory() {
        return this.d;
    }

    public final ObservableProperties getProperties() {
        return this.a;
    }

    public static synchronized HttpManager getManager(Properties properties, URL uRL) {
        Object object;
        String string = uRL == null ? null : uRL.getProtocol().toLowerCase();
        int n = 0;
        while (n < b.length) {
            if (b[n] != null && b[n].a(properties) && b[n].a(string)) {
                return b[n].a();
            }
            ++n;
        }
        ObservableProperties observableProperties = null;
        observableProperties = properties instanceof ObservableProperties ? (ObservableProperties)properties : new ObservableProperties(properties);
        HttpManager httpManager = new HttpManager();
        httpManager.a = observableProperties;
        String[] stringArray = observableProperties.getStringArray(FILTERS_PROP_P, null);
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    object = org.w3c.com.fourthpass.a.a(stringArray[n2]);
                    PropRequestFilter propRequestFilter = null;
                    propRequestFilter = (PropRequestFilter)((Class)object).newInstance();
                    propRequestFilter.initialize(httpManager);
                }
                catch (PropRequestFilterException propRequestFilterException) {
                    System.out.println("Couldn't initialize filter \"" + stringArray[n2] + "\" init failed: " + propRequestFilterException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println("Error initializing prop filters:");
                    System.err.println("Coulnd't initialize [" + stringArray[n2] + "]: " + exception.getMessage());
                    exception.printStackTrace();
                    System.exit(1);
                }
                ++n2;
            }
        }
        httpManager.d = new b();
        String string2 = observableProperties.getString(SERVER_CLASS_P, f);
        try {
            httpManager.serverclass = org.w3c.com.fourthpass.a.a(string2);
        }
        catch (Exception exception) {
            System.err.println("Unable to initialize HttpManager: ");
            System.err.println("Class \"" + string2 + "\" not found, from property " + SERVER_CLASS_P);
            exception.printStackTrace();
            System.exit(1);
        }
        object = httpManager.template;
        httpManager.updateProxy(uRL);
        ((HttpMessage)object).setOnlyIfCached(observableProperties.getBoolean(ONLY_IF_CACHED_P, false));
        int n3 = observableProperties.getInteger(MAX_STALE_P, -1);
        if (n3 >= 0) {
            ((HttpRequestMessage)object).setMaxStale(n3);
        }
        if ((n3 = observableProperties.getInteger(MIN_FRESH_P, -1)) >= 0) {
            ((HttpRequestMessage)object).setMinFresh(n3);
        }
        httpManager.lenient = observableProperties.getBoolean(LENIENT_P, true);
        ((HttpMessage)object).setValue("user-agent", observableProperties.getString(USER_AGENT_P, DEFAULT_USER_AGENT));
        ((HttpMessage)object).setValue("accept", observableProperties.getString(ACCEPT_P, DEFAULT_ACCEPT));
        String string3 = observableProperties.getString(ACCEPT_LANGUAGE_P, null);
        if (string3 != null) {
            ((HttpMessage)object).setValue("accept-language", string3);
        }
        if ((string3 = observableProperties.getString(ACCEPT_ENCODING_P, null)) != null) {
            ((HttpMessage)object).setValue("accept-encoding", string3);
        }
        httpManager.conn_max = observableProperties.getInteger(CONN_MAX_P, 5);
        httpManager.timeout = observableProperties.getInteger(TIMEOUT_P, httpManager.timeout);
        observableProperties.registerObserver(httpManager);
        int n4 = 0;
        while (n4 < b.length) {
            if (b[n4] == null) {
                HttpManager.b[n4] = new c(httpManager, properties, string);
                return httpManager;
            }
            ++n4;
        }
        c[] cArray = new c[b.length << 1];
        System.arraycopy(b, 0, cArray, 0, b.length);
        cArray[HttpManager.b.length] = new c(httpManager, properties);
        b = cArray;
        return httpManager;
    }

    public static synchronized HttpManager getManager(Properties properties) {
        return HttpManager.getManager(properties, null);
    }

    public static HttpManager getManager(URL uRL) {
        return HttpManager.getManager(System.getProperties(), uRL);
    }

    public static HttpManager getManager() {
        return HttpManager.getManager(null);
    }

    public String getGlobalHeader(String string) {
        return this.template.getValue(string);
    }

    public RequestFilter getGlobalFilter(Class clazz) {
        return this.c.a(clazz);
    }

    protected e getConnection(HttpServer httpServer) {
        d d2 = httpServer.getState();
        return d2.a();
    }

    protected void deleteConnection(e e2) {
        d d2 = e2.getServer().getState();
        d2.a(e2);
        HttpManager httpManager = this;
        synchronized (httpManager) {
            --this.conn_count;
            this.notifyAll();
        }
    }

    protected final synchronized void decrConnCount(HttpServer httpServer) {
        --this.conn_count;
    }

    public Request createRequest(URL uRL) {
        Request request = (Request)this.template.getClone();
        if (request.getProxy() != null && uRL != null) {
            request.setURL(uRL);
            String string = uRL.getProtocol().toLowerCase();
            boolean bl = false;
            if (string != null) {
                bl = string.toLowerCase().startsWith("https");
            }
            if (bl) {
                String string2 = this.a.getString("https.nonProxyHosts", null);
                if (this.isNonProxyHost(uRL.getHost(), string2)) {
                    request.setProxy(null);
                }
            }
        }
        return request;
    }

    public Request createRequest() {
        return this.createRequest(null);
    }

    protected boolean closeAnyConnection() {
        boolean bl = false;
        int n = Math.max(this.conn_max / 3, 1);
        int n2 = 0;
        while (n2 < n) {
            e e2 = (e)this.connectionsLru.removeTail();
            if (e2 == null) break;
            e2.close();
            this.deleteConnection(e2);
            bl = true;
            ++n2;
        }
        return bl;
    }

    public static void clearCache() {
        int n = 0;
        while (n < b.length) {
            HttpManager.b[n] = null;
            ++n;
        }
    }

    protected HttpManager() {
        this.c = new g();
        this.connectionsLru = new SyncLRUList();
    }
}

