/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mime;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.com.fourthpass.a;
import org.w3c.www.http.HttpAccept;
import org.w3c.www.http.HttpAcceptCharset;
import org.w3c.www.http.HttpAcceptLanguage;
import org.w3c.www.http.HttpRequestMessage;
import org.w3c.www.mime.MimeHeaderHolder;
import org.w3c.www.mime.MimeParserException;
import org.w3c.www.mime.MimeParserFactory;

public class MimeParser {
    boolean a = false;
    protected MimeParserFactory factory = null;
    protected int bsize = 0;
    protected byte[] buffer = new byte[128];
    protected InputStream input = null;
    protected int ch = -1;

    public void unread(int n) {
        if (this.a) {
            throw new RuntimeException("cannot unread more then once !");
        }
        this.ch = n;
        this.a = true;
    }

    protected void skipSpaces() throws IOException, MimeParserException {
        while (this.ch == 32 || this.ch == 9) {
            this.ch = this.input.read();
        }
    }

    public int read() throws IOException {
        if (this.a) {
            this.a = false;
        } else {
            this.ch = this.input.read();
        }
        return this.ch;
    }

    protected String parseToken(boolean bl) throws IOException, MimeParserException {
        this.bsize = 0;
        while (true) {
            switch (this.ch) {
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 40: 
                case 41: 
                case 44: 
                case 47: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 91: 
                case 92: 
                case 93: 
                case 123: 
                case 125: {
                    return new String(this.buffer, 0, 0, this.bsize);
                }
            }
            this.append((char)(bl ? (int)Character.toLowerCase((char)this.ch) : this.ch));
            this.ch = this.input.read();
        }
    }

    protected void parse822Headers(MimeHeaderHolder mimeHeaderHolder) throws IOException, MimeParserException {
        while (!(this.ch == 13 ? (this.ch = this.input.read()) == 10 : this.ch == 10)) {
            String string = this.parse822HeaderName();
            this.skipSpaces();
            this.parse822HeaderBody();
            mimeHeaderHolder.notifyHeader(string, this.buffer, 0, this.bsize);
        }
        return;
    }

    protected String parse822HeaderName() throws IOException, MimeParserException {
        this.bsize = 0;
        while (this.ch >= 32 && this.ch != 58) {
            this.append((char)this.ch);
            this.ch = this.input.read();
        }
        this.expect(58);
        if (this.bsize <= 0) {
            throw new MimeParserException("expected a header name.");
        }
        return new String(this.buffer, 0, 0, this.bsize);
    }

    /*
     * Unable to fully structure code
     */
    protected void parse822HeaderBody() throws IOException, MimeParserException {
        this.bsize = 0;
        this.skipSpaces();
        block8: while (true) {
            switch (this.ch) {
                case 13: {
                    this.ch = this.input.read();
                    if (this.ch != 10) {
                        this.append(13);
                        continue block8;
                    }
                }
                case 10: {
                    this.ch = this.input.read();
                    switch (this.ch) {
                        case 9: 
                        case 32: {
                            do {
                                this.ch = this.input.read();
                            } while (this.ch == 32 || this.ch == 9);
                            this.append(this.ch);
                            ** GOTO lbl23
                        }
                        default: {
                            return;
                        }
                    }
                }
                default: {
                    this.append((char)this.ch);
lbl23:
                    // 2 sources

                    this.ch = this.input.read();
                    continue block8;
                }
                case -1: 
            }
            break;
        }
    }

    public MimeHeaderHolder parse(boolean bl) throws IOException, MimeParserException {
        MimeHeaderHolder mimeHeaderHolder = this.factory.createHeaderHolder(this);
        this.ch = this.input.read();
        this.a = true;
        if (!mimeHeaderHolder.notifyBeginParsing(this)) {
            if (!this.a) {
                this.ch = this.input.read();
            }
            if (bl) {
                try {
                    this.parse822Headers(mimeHeaderHolder);
                }
                catch (MimeParserException mimeParserException) {}
            } else {
                this.parse822Headers(mimeHeaderHolder);
            }
        }
        mimeHeaderHolder.notifyEndParsing(this);
        return mimeHeaderHolder;
    }

    public MimeHeaderHolder parse() throws IOException, MimeParserException {
        return this.parse(true);
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            MimeParserFactory mimeParserFactory = null;
            mimeParserFactory = (MimeParserFactory)org.w3c.com.fourthpass.a.a(string).newInstance();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
            MimeParser mimeParser = new MimeParser(bufferedInputStream, mimeParserFactory);
            HttpRequestMessage httpRequestMessage = (HttpRequestMessage)mimeParser.parse();
            HttpAccept[] httpAcceptArray = httpRequestMessage.getAccept();
            int n = 0;
            while (n < httpAcceptArray.length) {
                System.out.println("accept: " + httpAcceptArray[n].getMimeType());
                ++n;
            }
            HttpAcceptLanguage[] httpAcceptLanguageArray = httpRequestMessage.getAcceptLanguage();
            int n2 = 0;
            while (n2 < httpAcceptLanguageArray.length) {
                System.out.println("accept-lang: " + httpAcceptLanguageArray[n2].getLanguage());
                ++n2;
            }
            HttpAcceptCharset[] httpAcceptCharsetArray = httpRequestMessage.getAcceptCharset();
            int n3 = 0;
            while (n3 < httpAcceptCharsetArray.length) {
                System.out.println("accept-charset: " + httpAcceptCharsetArray[n3].getCharset());
                ++n3;
            }
            httpRequestMessage.emit(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("MimeParser <factory> <file>");
        }
    }

    public InputStream getInputStream() {
        return this.input;
    }

    protected void expect(int n) throws IOException, MimeParserException {
        if (n != this.ch) {
            String string = new Character((char)n).toString();
            String string2 = new Character((char)this.ch).toString();
            throw new MimeParserException("expecting " + string + "(" + n + ")" + " got " + string2 + "(" + this.ch + ")\n" + "context: " + new String(this.buffer, 0, 0, this.bsize) + "\n");
        }
        this.ch = this.input.read();
    }

    protected final void append(int n) {
        if (this.bsize + 1 >= this.buffer.length) {
            byte[] byArray = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
            this.buffer = byArray;
        }
        this.buffer[this.bsize++] = (byte)n;
    }

    public MimeParser(InputStream inputStream, MimeParserFactory mimeParserFactory) {
        this.input = inputStream;
        this.factory = mimeParserFactory;
    }
}

