/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.HttpWarningList;
import org.w3c.www.http.b;
import org.w3c.www.http.c;

public class HttpWarning
extends BasicValue {
    protected String text = null;
    protected String agent = null;
    protected int status = -1;
    protected HttpWarningList list = null;
    public static final int PERSISTENT_MISCELLANEOUS = 199;
    public static final int TRANSFORMATION_APPLIED = 214;
    public static final int MISCELLANEOUS = 199;
    public static final int HEURISTIC_EXPIRATION = 113;
    public static final int DISCONNECTED_OPERATION = 112;
    public static final int REVALIDATION_FAILED = 111;
    public static final int STALE = 110;

    protected void updateByteValue() {
        c c2 = new c();
        c2.b(this.status);
        c2.a(' ');
        c2.a(this.agent);
        c2.a(' ');
        c2.b(this.text);
        this.raw = c2.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }

    public void setText(String string) {
        if (string != null && !string.equals(this.text)) {
            this.invalidateByteValue();
        }
        this.text = string;
    }

    public void setStatus(int n) {
        if (this.status != n) {
            this.invalidateByteValue();
        }
        this.status = n;
    }

    public void setAgent(String string) {
        if (string != null && !string.equals(this.agent)) {
            this.invalidateByteValue();
        }
        this.agent = string;
    }

    protected void parse() throws HttpParserException {
        b b2 = new b(this.roff, this.rlen);
        b b3 = new b();
        if (HttpParser.nextItem(this.raw, b2) < 0) {
            this.error("Invalid warning, no status code.");
        }
        b3.g = b2.a;
        b3.i = b2.h;
        this.status = HttpParser.parseInt(this.raw, b3);
        b2.a();
        if (HttpParser.nextItem(this.raw, b2) < 0) {
            this.error("Invalid warning, no agent field.");
        }
        this.agent = new String(this.raw, 0, b2.a, b2.h - b2.a);
        b2.a();
        if (HttpParser.nextItem(this.raw, b2) < 0) {
            this.error("Invalid warning, no text message.");
        }
        b3.g = b2.a;
        b3.i = b2.h;
        HttpParser.unquote(this.raw, b3);
        this.text = new String(this.raw, 0, b3.a, b3.h - b3.a);
    }

    protected void invalidateByteValue() {
        super.invalidateByteValue();
        if (this.list != null) {
            this.list.invalidateByteValue();
        }
    }

    public Object getValue() {
        this.validate();
        return this;
    }

    public String getText() {
        this.validate();
        return this.text;
    }

    public int getStatus() {
        this.validate();
        return this.status;
    }

    public String getAgent() {
        this.validate();
        return this.agent;
    }

    HttpWarning(boolean bl, int n, String string, String string2) {
        this.isValid = bl;
        this.setStatus(n);
        this.setAgent(string);
        this.setText(string2);
    }

    HttpWarning(HttpWarningList httpWarningList, byte[] byArray, int n, int n2) {
        this.list = httpWarningList;
        this.raw = byArray;
        this.roff = n;
        this.rlen = n2;
        this.isValid = false;
    }

    public HttpWarning() {
        this.isValid = false;
    }
}

