/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpAccept;
import org.w3c.www.http.HttpAcceptCharset;
import org.w3c.www.http.HttpAcceptCharsetList;
import org.w3c.www.http.HttpAcceptEncoding;
import org.w3c.www.http.HttpAcceptEncodingList;
import org.w3c.www.http.HttpAcceptLanguage;
import org.w3c.www.http.HttpAcceptList;
import org.w3c.www.http.HttpCacheControl;
import org.w3c.www.http.HttpCredential;
import org.w3c.www.http.HttpDate;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.http.HttpEntityTagList;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpInteger;
import org.w3c.www.http.HttpMessage;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.HttpRange;
import org.w3c.www.http.HttpRangeList;
import org.w3c.www.http.HttpString;
import org.w3c.www.http.b;
import org.w3c.www.http.c;
import org.w3c.www.mime.MimeParser;

public class HttpRequestMessage
extends HttpEntityMessage {
    String a = null;
    protected String sProxy = null;
    protected URL proxy = null;
    protected URL url = null;
    protected String method = "GET";
    public static int H_USER_AGENT;
    public static int H_TE;
    public static int H_REFERER;
    public static int H_RANGE;
    public static int H_PROXY_AUTHORIZATION;
    public static int H_MAX_FORWARDS;
    public static int H_IF_UNMODIFIED_SINCE;
    public static int H_IF_RANGE;
    public static int H_IF_NONE_MATCH;
    public static int H_IF_MATCH;
    public static int H_IF_MODIFIED_SINCE;
    public static int H_HOST;
    public static int H_FROM;
    public static int H_EXPECT;
    public static int H_AUTHORIZATION;
    public static int H_ACCEPT_LANGUAGE;
    public static int H_ACCEPT_ENCODING;
    public static int H_ACCEPT_CHARSET;
    public static int H_ACCEPT;

    protected void startEmit(OutputStream outputStream, int n) throws IOException {
        Object object;
        if ((n & 1) != 1) {
            return;
        }
        if (this.major >= 1 && !this.hasHeader(H_HOST)) {
            object = this.url.getPort() == 80 && this.url.getProtocol().equals("http") || this.url.getPort() == 443 && this.url.getProtocol().equals("https") || this.url.getPort() == -1 ? this.url.getHost() : String.valueOf(this.url.getHost()) + ":" + this.url.getPort();
            this.setHeaderValue(H_HOST, (HeaderValue)HttpFactory.makeString((String)object));
        }
        object = new c();
        ((c)object).a(this.method);
        ((c)object).a(' ');
        if (this.proxy != null) {
            if (this.url.getProtocol().toLowerCase().startsWith("https")) {
                ((c)object).a(this.url.getFile());
            } else {
                ((c)object).a(this.url.toExternalForm());
            }
        } else {
            ((c)object).a(this.url.getFile());
        }
        ((c)object).a(' ');
        ((c)object).a(this.getVersion());
        ((c)object).a('\r');
        ((c)object).a('\n');
        ((c)object).emit(outputStream);
    }

    public void setUserAgent(String string) {
        this.setHeaderValue(H_USER_AGENT, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    protected void setTarget(String string) {
        this.a = string;
    }

    public void setTE(HttpAcceptEncoding[] httpAcceptEncodingArray) {
        this.setHeaderValue(H_TE, (HeaderValue)(httpAcceptEncodingArray == null ? null : new HttpAcceptEncodingList(httpAcceptEncodingArray)));
    }

    public void setReferer(String string) {
        this.setHeaderValue(H_REFERER, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public void setRange(HttpRange[] httpRangeArray) {
        this.setHeaderValue(H_RANGE, (HeaderValue)(httpRangeArray == null ? null : new HttpRangeList(httpRangeArray)));
    }

    public void setProxyAuthorization(HttpCredential httpCredential) {
        this.setHeaderValue(H_PROXY_AUTHORIZATION, (HeaderValue)httpCredential);
    }

    public void setProxy(URL uRL) {
        this.proxy = uRL;
        this.sProxy = uRL == null ? null : uRL.toExternalForm();
    }

    public void setMinFresh(int n) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            if (n == -1) {
                return;
            }
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setMinFresh(n);
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public void setMaxStale(int n) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            if (n == -1) {
                return;
            }
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setMaxStale(n);
    }

    public void setMaxForwards(int n) {
        if (n == -1) {
            this.setHeaderValue(H_MAX_FORWARDS, null);
        } else {
            this.setHeaderValue(H_MAX_FORWARDS, (HeaderValue)new HttpInteger(true, n));
        }
    }

    public void setIfUnmodifiedSince(long l) {
        if (l == -1L) {
            this.setHeaderValue(H_IF_UNMODIFIED_SINCE, null);
        } else {
            this.setHeaderValue(H_IF_UNMODIFIED_SINCE, (HeaderValue)new HttpDate(true, l));
        }
    }

    public void setIfRange(HttpEntityTag httpEntityTag) {
        this.setHeaderValue(H_IF_RANGE, (HeaderValue)httpEntityTag);
    }

    public void setIfNoneMatch(HttpEntityTag[] httpEntityTagArray) {
        this.setHeaderValue(H_IF_NONE_MATCH, (HeaderValue)(httpEntityTagArray == null ? null : new HttpEntityTagList(httpEntityTagArray)));
    }

    public void setIfModifiedSince(long l) {
        this.setHeaderValue(H_IF_MODIFIED_SINCE, (HeaderValue)(l == -1L ? null : new HttpDate(true, l)));
    }

    public void setIfMatch(HttpEntityTag[] httpEntityTagArray) {
        this.setHeaderValue(H_IF_MATCH, (HeaderValue)(httpEntityTagArray != null ? new HttpEntityTagList(httpEntityTagArray) : null));
    }

    public void setHost(String string) {
        this.setHeaderValue(H_HOST, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public void setFrom(String string) {
        this.setHeaderValue(H_FROM, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public void setExpect(String string) {
        this.setHeaderValue(H_EXPECT, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public void setAuthorization(HttpCredential httpCredential) {
        this.setHeaderValue(H_AUTHORIZATION, (HeaderValue)httpCredential);
    }

    public void setAcceptLanguage(HttpAcceptCharset[] httpAcceptCharsetArray) {
        this.setHeaderValue(H_ACCEPT_LANGUAGE, (HeaderValue)(httpAcceptCharsetArray == null ? null : new HttpAcceptCharsetList(httpAcceptCharsetArray)));
    }

    public void setAcceptEncoding(HttpAcceptEncoding[] httpAcceptEncodingArray) {
        this.setHeaderValue(H_ACCEPT_ENCODING, (HeaderValue)(httpAcceptEncodingArray == null ? null : new HttpAcceptEncodingList(httpAcceptEncodingArray)));
    }

    public void setAcceptCharset(HttpAcceptCharset[] httpAcceptCharsetArray) {
        this.setHeaderValue(H_ACCEPT_CHARSET, (HeaderValue)(httpAcceptCharsetArray == null ? null : new HttpAcceptCharsetList(httpAcceptCharsetArray)));
    }

    public void setAccept(HttpAccept[] httpAcceptArray) {
        this.setHeaderValue(H_ACCEPT, (HeaderValue)(httpAcceptArray == null ? null : new HttpAcceptList(httpAcceptArray)));
    }

    public boolean notifyBeginParsing(MimeParser mimeParser) throws IOException, HttpParserException {
        c c2 = new c();
        int n = mimeParser.read();
        while (n == 13 || n == 10) {
            n = mimeParser.read();
        }
        block6: while (true) {
            switch (n) {
                case -1: {
                    throw new HttpParserException("End Of File");
                }
                case 13: {
                    n = mimeParser.read();
                    if (n == 10) break block6;
                    mimeParser.unread(n);
                    break block6;
                }
                default: {
                    c2.a(n);
                    n = mimeParser.read();
                    continue block6;
                }
                case 10: 
            }
            break;
        }
        byte[] byArray = c2.getByteCopy();
        b b2 = new b();
        b2.g = 0;
        b2.i = byArray.length;
        b2.c = (byte)32;
        if (HttpParser.nextItem(byArray, b2) < 0) {
            throw new RuntimeException("Bad request, no method !");
        }
        this.setMethod(b2.a(byArray));
        if (HttpParser.nextItem(byArray, b2) < 0) {
            throw new RuntimeException("Bad request, no URL !");
        }
        this.setTarget(b2.a(byArray));
        HttpParser.skipSpaces(byArray, b2);
        if (b2.g + 5 < b2.i) {
            b2.g += 5;
            b2.c = (byte)46;
            this.major = (short)HttpParser.parseInt(byArray, b2);
            b2.a();
            this.minor = (short)HttpParser.parseInt(byArray, b2);
            return false;
        }
        this.major = 0;
        this.minor = (short)9;
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            HttpRequestMessage httpRequestMessage = new HttpRequestMessage();
            httpRequestMessage.setURL(new URL("http://www.w3.org/"));
            httpRequestMessage.setHost("http://www.w3.org");
            httpRequestMessage.setFrom("abaird@w3.org");
            httpRequestMessage.setReferer("http://abaird.w3.org/");
            HttpCacheControl httpCacheControl = new HttpCacheControl(true);
            httpCacheControl.setMaxAge(10);
            httpCacheControl.setNoStore(true);
            httpRequestMessage.setCacheControl(httpCacheControl);
            httpRequestMessage.emit(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean hasProxy() {
        return this.proxy != null;
    }

    public boolean hasAuthorization() {
        return this.hasHeader(H_AUTHORIZATION);
    }

    public String getUserAgent() {
        HeaderValue headerValue = this.getHeaderValue(H_USER_AGENT);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public URL getURL() {
        return this.url;
    }

    protected String getTarget() {
        return this.a;
    }

    public HttpAcceptEncoding[] getTE() {
        HeaderValue headerValue = this.getHeaderValue(H_TE);
        return headerValue != null ? (HttpAcceptEncoding[])headerValue.getValue() : null;
    }

    public String getReferer() {
        HeaderValue headerValue = this.getHeaderValue(H_REFERER);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public HttpRange[] getRange() {
        HeaderValue headerValue = this.getHeaderValue(H_RANGE);
        return headerValue != null ? (HttpRange[])headerValue.getValue() : null;
    }

    public HttpCredential getProxyAuthorization() {
        HeaderValue headerValue = this.getHeaderValue(H_PROXY_AUTHORIZATION);
        return headerValue != null ? (HttpCredential)headerValue.getValue() : null;
    }

    public URL getProxy() {
        return this.proxy;
    }

    public int getMinFresh() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? -1 : httpCacheControl.getMinFresh();
    }

    public String getMethod() {
        return this.method;
    }

    public int getMaxStale() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? -1 : httpCacheControl.getMaxStale();
    }

    public int getMaxForwards() {
        HeaderValue headerValue = this.getHeaderValue(H_MAX_FORWARDS);
        return headerValue != null ? (Integer)headerValue.getValue() : -1;
    }

    public long getIfUnmodifiedSince() {
        HeaderValue headerValue = this.getHeaderValue(H_IF_UNMODIFIED_SINCE);
        return headerValue != null ? (Long)headerValue.getValue() : -1L;
    }

    public HttpEntityTag getIfRange() {
        HeaderValue headerValue = this.getHeaderValue(H_IF_RANGE);
        return headerValue != null ? (HttpEntityTag)headerValue : null;
    }

    public HttpEntityTag[] getIfNoneMatch() {
        HeaderValue headerValue = this.getHeaderValue(H_IF_NONE_MATCH);
        return headerValue != null ? (HttpEntityTag[])headerValue.getValue() : null;
    }

    public long getIfModifiedSince() {
        HeaderValue headerValue = this.getHeaderValue(H_IF_MODIFIED_SINCE);
        return headerValue != null ? (Long)headerValue.getValue() : -1L;
    }

    public HttpEntityTag[] getIfMatch() {
        HeaderValue headerValue = this.getHeaderValue(H_IF_MATCH);
        return headerValue != null ? (HttpEntityTag[])headerValue.getValue() : null;
    }

    public String getHost() {
        HeaderValue headerValue = this.getHeaderValue(H_HOST);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public String getFrom() {
        HeaderValue headerValue = this.getHeaderValue(H_FROM);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public String getExpect() {
        HeaderValue headerValue = this.getHeaderValue(H_EXPECT);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public HttpCredential getAuthorization() {
        HeaderValue headerValue = this.getHeaderValue(H_AUTHORIZATION);
        return headerValue != null ? (HttpCredential)headerValue.getValue() : null;
    }

    public HttpAcceptLanguage[] getAcceptLanguage() {
        HeaderValue headerValue = this.getHeaderValue(H_ACCEPT_LANGUAGE);
        return headerValue != null ? (HttpAcceptLanguage[])headerValue.getValue() : null;
    }

    public HttpAcceptEncoding[] getAcceptEncoding() {
        HeaderValue headerValue = this.getHeaderValue(H_ACCEPT_ENCODING);
        return headerValue != null ? (HttpAcceptEncoding[])headerValue.getValue() : null;
    }

    public HttpAcceptCharset[] getAcceptCharset() {
        HeaderValue headerValue = this.getHeaderValue(H_ACCEPT_CHARSET);
        return headerValue != null ? (HttpAcceptCharset[])headerValue.getValue() : null;
    }

    public HttpAccept[] getAccept() {
        HeaderValue headerValue = this.getHeaderValue(H_ACCEPT);
        return headerValue != null ? (HttpAccept[])headerValue.getValue() : null;
    }

    public void dump(OutputStream outputStream) {
        try {
            this.startEmit(outputStream, 1);
        }
        catch (Exception exception) {}
        super.dump(outputStream);
    }

    public HttpRequestMessage(MimeParser mimeParser) {
        super(mimeParser);
    }

    public HttpRequestMessage() {
    }

    static {
        H_ACCEPT = 31;
        H_ACCEPT_CHARSET = 32;
        H_ACCEPT_ENCODING = 33;
        H_ACCEPT_LANGUAGE = 34;
        H_AUTHORIZATION = 35;
        H_EXPECT = 36;
        H_FROM = 37;
        H_HOST = 38;
        H_IF_MODIFIED_SINCE = 39;
        H_IF_MATCH = 40;
        H_IF_NONE_MATCH = 41;
        H_IF_RANGE = 42;
        H_IF_UNMODIFIED_SINCE = 43;
        H_MAX_FORWARDS = 44;
        H_PROXY_AUTHORIZATION = 45;
        H_RANGE = 46;
        H_REFERER = 47;
        H_TE = 48;
        H_USER_AGENT = 49;
        HttpMessage.registerHeader("Accept", "org.w3c.www.http.HttpAcceptList", H_ACCEPT);
        HttpMessage.registerHeader("Accept-Charset", "org.w3c.www.http.HttpAcceptCharsetList", H_ACCEPT_CHARSET);
        HttpMessage.registerHeader("Accept-Encoding", "org.w3c.www.http.HttpAcceptEncodingList", H_ACCEPT_ENCODING);
        HttpMessage.registerHeader("Accept-Language", "org.w3c.www.http.HttpAcceptLanguageList", H_ACCEPT_LANGUAGE);
        HttpMessage.registerHeader("Authorization", "org.w3c.www.http.HttpCredential", H_AUTHORIZATION);
        HttpMessage.registerHeader("From", "org.w3c.www.http.HttpString", H_FROM);
        HttpMessage.registerHeader("Host", "org.w3c.www.http.HttpString", H_HOST);
        HttpMessage.registerHeader("If-Modified-Since", "org.w3c.www.http.HttpDate", H_IF_MODIFIED_SINCE);
        HttpMessage.registerHeader("If-Match", "org.w3c.www.http.HttpEntityTagList", H_IF_MATCH);
        HttpMessage.registerHeader("If-None-Match", "org.w3c.www.http.HttpEntityTagList", H_IF_NONE_MATCH);
        HttpMessage.registerHeader("If-Range", "org.w3c.www.http.HttpEntityTag", H_IF_RANGE);
        HttpMessage.registerHeader("If-Unmodified-Since", "org.w3c.www.http.HttpDate", H_IF_UNMODIFIED_SINCE);
        HttpMessage.registerHeader("Max-Forwards", "org.w3c.www.http.HttpInteger", H_MAX_FORWARDS);
        HttpMessage.registerHeader("Proxy-Authorization", "org.w3c.www.http.HttpCredential", H_PROXY_AUTHORIZATION);
        HttpMessage.registerHeader("Range", "org.w3c.www.http.HttpRangeList", H_RANGE);
        HttpMessage.registerHeader("Referer", "org.w3c.www.http.HttpString", H_REFERER);
        HttpMessage.registerHeader("User-Agent", "org.w3c.www.http.HttpString", H_USER_AGENT);
        HttpMessage.registerHeader("Expect", "org.w3c.www.http.HttpString", H_EXPECT);
        HttpMessage.registerHeader("TE", "org.w3c.www.http.HttpAcceptEncodingList", H_TE);
    }
}

