/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.w3c.www.http.HTTP;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpCacheControl;
import org.w3c.www.http.HttpChallenge;
import org.w3c.www.http.HttpDate;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpInteger;
import org.w3c.www.http.HttpMessage;
import org.w3c.www.http.HttpParamList;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.HttpString;
import org.w3c.www.http.HttpTokenList;
import org.w3c.www.http.HttpWarning;
import org.w3c.www.http.HttpWarningList;
import org.w3c.www.http.b;
import org.w3c.www.http.c;
import org.w3c.www.mime.MimeParser;

public class HttpReplyMessage
extends HttpEntityMessage {
    protected String reason = null;
    protected int status = -1;
    public static int H_AUTHENTICATION_INFO;
    public static int H_WWW_AUTHENTICATE;
    public static int H_WARNING;
    public static int H_VARY;
    public static int H_SERVER;
    public static int H_RETRY_AFTER;
    public static int H_PUBLIC;
    public static int H_PROXY_AUTHENTICATE;
    public static int H_LOCATION;
    public static int H_AGE;
    public static int H_ACCEPT_RANGES;

    protected void startEmit(OutputStream outputStream, int n) throws IOException {
        if ((n & 1) != 1) {
            return;
        }
        if (this.major < 1) {
            return;
        }
        c c2 = new c();
        c2.a(HTTP.byteArrayVersion);
        c2.a(' ');
        c2.b(this.status);
        c2.a(' ');
        c2.a(this.reason != null ? this.reason : "Unknown Status Code");
        c2.a('\r');
        c2.a('\n');
        c2.emit(outputStream);
    }

    public void setWarning(HttpWarning[] httpWarningArray) {
        this.setHeaderValue(H_WARNING, (HeaderValue)(httpWarningArray == null ? null : new HttpWarningList(httpWarningArray)));
    }

    public void setWWWAuthenticate(HttpChallenge httpChallenge) {
        this.setHeaderValue(H_WWW_AUTHENTICATE, (HeaderValue)httpChallenge);
    }

    public void setVary(String[] stringArray) {
        this.setHeaderValue(H_VARY, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setStatus(int n) {
        if (n != this.status || this.reason == null) {
            this.reason = this.getStandardReason(n);
        }
        this.status = n;
    }

    public void setServer(String string) {
        this.setHeaderValue(H_SERVER, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public void setRetryAfter(long l) {
        if (l == -1L) {
            this.setHeaderValue(H_RETRY_AFTER, null);
        } else {
            HttpDate httpDate = new HttpDate(true, l);
            this.setHeaderValue(H_RETRY_AFTER, (HeaderValue)new HttpString(true, httpDate.toExternalForm()));
        }
    }

    public void setRetryAfter(int n) {
        this.setHeaderValue(H_RETRY_AFTER, (HeaderValue)(n == -1 ? null : new HttpString(true, new Integer(n).toString())));
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public void setPublic(String[] stringArray) {
        this.setHeaderValue(H_PUBLIC, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setPublic(boolean bl) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (!bl || httpCacheControl != null) {
            return;
        }
        httpCacheControl = new HttpCacheControl(true);
        this.setCacheControl(httpCacheControl);
        httpCacheControl.setPublic(bl);
    }

    public void setProxyRevalidate(boolean bl) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (!bl || httpCacheControl != null) {
            return;
        }
        httpCacheControl = new HttpCacheControl(true);
        this.setCacheControl(httpCacheControl);
        httpCacheControl.setProxyRevalidate(bl);
    }

    public void setProxyAuthenticate(HttpChallenge httpChallenge) {
        this.setHeaderValue(H_PROXY_AUTHENTICATE, (HeaderValue)httpChallenge);
    }

    public void setMustRevalidate(boolean bl) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (!bl || httpCacheControl != null) {
            return;
        }
        httpCacheControl = new HttpCacheControl(true);
        this.setCacheControl(httpCacheControl);
        httpCacheControl.setMustRevalidate(bl);
    }

    public void setLocation(URL uRL) {
        this.setHeaderValue(H_LOCATION, (HeaderValue)(uRL == null ? null : new HttpString(true, uRL.toExternalForm())));
    }

    public void setLocation(String string) {
        this.setHeaderValue(H_LOCATION, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public void setAuthenticationInfo(HttpParamList httpParamList) {
        this.setHeaderValue(H_AUTHENTICATION_INFO, (HeaderValue)httpParamList);
    }

    public void setAge(int n) {
        this.setHeaderValue(H_AGE, (HeaderValue)(n == -1 ? null : new HttpInteger(true, n)));
    }

    public void setAcceptRanges(String[] stringArray) {
        this.setHeaderValue(H_ACCEPT_RANGES, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public boolean notifyBeginParsing(MimeParser mimeParser) throws IOException, HttpParserException {
        if (this.major <= 0) {
            return true;
        }
        c c2 = new c();
        int n = mimeParser.read();
        int n2 = 0;
        while (n == 13 || n == 10) {
            n = mimeParser.read();
        }
        block6: while (true) {
            switch (n) {
                case -1: {
                    throw new HttpParserException("End Of File");
                }
                case 13: {
                    n = mimeParser.read();
                    if (n == 10) break block6;
                    mimeParser.unread(n);
                    break block6;
                }
                default: {
                    c2.a(n);
                    if (++n2 > 16384) {
                        throw new HttpParserException("Invalid HTTP");
                    }
                    n = mimeParser.read();
                    continue block6;
                }
                case 10: 
            }
            break;
        }
        byte[] byArray = c2.getByteCopy();
        b b2 = new b();
        b2.g = 0;
        b2.i = byArray.length;
        b2.c = (byte)32;
        if (HttpParser.nextItem(byArray, b2) < 0) {
            this.major = 0;
            this.minor = (short)9;
            this.status = 200;
            return true;
        }
        if (byArray.length >= 4 && byArray[4] == 47) {
            b b3 = new b();
            b3.g = b2.a + 5;
            b3.i = b2.h;
            this.major = (short)HttpParser.parseInt(byArray, b3);
            b3.a();
            ++b3.g;
            this.minor = (short)HttpParser.parseInt(byArray, b3);
        } else {
            this.major = 1;
            this.minor = 0;
        }
        b2.a();
        this.status = HttpParser.parseInt(byArray, b2);
        b2.a();
        HttpParser.skipSpaces(byArray, b2);
        this.reason = new String(byArray, 0, b2.g, byArray.length - b2.g);
        return false;
    }

    public HttpWarning[] getWarning() {
        HeaderValue headerValue = this.getHeaderValue(H_WARNING);
        return headerValue != null ? (HttpWarning[])headerValue.getValue() : null;
    }

    public HttpChallenge getWWWAuthenticate() {
        HeaderValue headerValue = this.getHeaderValue(H_WWW_AUTHENTICATE);
        return headerValue != null ? (HttpChallenge)headerValue.getValue() : null;
    }

    public String[] getVary() {
        HeaderValue headerValue = this.getHeaderValue(H_VARY);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStandardReason(int n) {
        int n2 = n / 100;
        int n3 = n % 100;
        switch (n2) {
            case 1: {
                if (n3 < 0 || n3 >= HTTP.msg_100.length) break;
                return HTTP.msg_100[n3];
            }
            case 2: {
                if (n3 < 0 || n3 >= HTTP.msg_200.length) break;
                return HTTP.msg_200[n3];
            }
            case 3: {
                if (n3 < 0 || n3 >= HTTP.msg_300.length) break;
                return HTTP.msg_300[n3];
            }
            case 4: {
                if (n3 < 0 || n3 >= HTTP.msg_400.length) break;
                return HTTP.msg_400[n3];
            }
            case 5: {
                if (n3 < 0 || n3 >= HTTP.msg_500.length) break;
                return HTTP.msg_500[n3];
            }
        }
        return null;
    }

    public String getServer() {
        HeaderValue headerValue = this.getHeaderValue(H_SERVER);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public String getReason() {
        return this.reason;
    }

    public String[] getPublic() {
        HeaderValue headerValue = this.getHeaderValue(H_PUBLIC);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public HttpChallenge getProxyAuthenticate() {
        HeaderValue headerValue = this.getHeaderValue(H_PROXY_AUTHENTICATE);
        return headerValue == null ? null : (HttpChallenge)headerValue.getValue();
    }

    public String[] getPrivate() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? null : httpCacheControl.getPrivate();
    }

    public String getLocation() {
        HeaderValue headerValue = this.getHeaderValue(H_LOCATION);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public HttpParamList getAuthenticationInfo() {
        HeaderValue headerValue = this.getHeaderValue(H_AUTHENTICATION_INFO);
        return headerValue != null ? (HttpParamList)headerValue.getValue() : null;
    }

    public int getAge() {
        HeaderValue headerValue = this.getHeaderValue(H_AGE);
        return headerValue != null ? (Integer)headerValue.getValue() : -1;
    }

    public String[] getAcceptRanges() {
        HeaderValue headerValue = this.getHeaderValue(H_ACCEPT_RANGES);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public void dump(OutputStream outputStream) {
        try {
            this.startEmit(outputStream, 1);
        }
        catch (Exception exception) {}
        super.dump(outputStream);
    }

    public boolean checkPublic() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? false : httpCacheControl.checkPublic();
    }

    public boolean checkProxyRevalidate() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? false : httpCacheControl.checkProxyRevalidate();
    }

    public boolean checkMustRevalidate() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? false : httpCacheControl.checkMustRevalidate();
    }

    public void addWarning(HttpWarning httpWarning) {
        HttpWarningList httpWarningList = (HttpWarningList)this.getHeaderValue(H_WARNING);
        if (httpWarningList == null) {
            httpWarningList = new HttpWarningList(httpWarning);
            this.setHeaderValue(H_WARNING, (HeaderValue)httpWarningList);
        } else {
            httpWarningList.addWarning(httpWarning);
        }
    }

    public void addAuthenticationInfo(String string, String string2) {
        HttpParamList httpParamList = this.getAuthenticationInfo();
        if (httpParamList == null) {
            httpParamList = new HttpParamList(true);
            this.setAuthenticationInfo(httpParamList);
        }
        httpParamList.setParameter(string, string2);
    }

    public HttpReplyMessage(MimeParser mimeParser) {
        super(mimeParser);
    }

    public HttpReplyMessage() {
    }

    static {
        H_ACCEPT_RANGES = 50;
        H_AGE = 51;
        H_LOCATION = 52;
        H_PROXY_AUTHENTICATE = 53;
        H_PUBLIC = 54;
        H_RETRY_AFTER = 55;
        H_SERVER = 56;
        H_VARY = 57;
        H_WARNING = 58;
        H_WWW_AUTHENTICATE = 59;
        H_AUTHENTICATION_INFO = 60;
        HttpMessage.registerHeader("Accept-Ranges", "org.w3c.www.http.HttpTokenList", H_ACCEPT_RANGES);
        HttpMessage.registerHeader("Age", "org.w3c.www.http.HttpInteger", H_AGE);
        HttpMessage.registerHeader("Location", "org.w3c.www.http.HttpString", H_LOCATION);
        HttpMessage.registerHeader("Proxy-Authenticate", "org.w3c.www.http.HttpChallenge", H_PROXY_AUTHENTICATE);
        HttpMessage.registerHeader("Public", "org.w3c.www.http.HttpTokenList", H_PUBLIC);
        HttpMessage.registerHeader("Retry-After", "org.w3c.www.http.HttpString", H_RETRY_AFTER);
        HttpMessage.registerHeader("Server", "org.w3c.www.http.HttpString", H_SERVER);
        HttpMessage.registerHeader("Trailer", "org.w3c.www.http.HttpTokenList", HttpMessage.H_TRAILER);
        HttpMessage.registerHeader("Vary", "org.w3c.www.http.HttpTokenList", H_VARY);
        HttpMessage.registerHeader("Warning", "org.w3c.www.http.HttpWarningList", H_WARNING);
        HttpMessage.registerHeader("WWW-Authenticate", "org.w3c.www.http.HttpChallenge", H_WWW_AUTHENTICATE);
        HttpMessage.registerHeader("Authentication-Info", "org.w3c.www.http.HttpParamList", H_AUTHENTICATION_INFO);
    }
}

