/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.util.ArrayDictionary;
import org.w3c.util.EmptyEnumeration;
import org.w3c.www.http.HTTP;
import org.w3c.www.http.HeaderDescription;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpBag;
import org.w3c.www.http.HttpCacheControl;
import org.w3c.www.http.HttpCookieList;
import org.w3c.www.http.HttpDate;
import org.w3c.www.http.HttpExt;
import org.w3c.www.http.HttpExtException;
import org.w3c.www.http.HttpExtList;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.HttpSetCookieList;
import org.w3c.www.http.HttpString;
import org.w3c.www.http.HttpTokenList;
import org.w3c.www.http.a;
import org.w3c.www.mime.MimeHeaderHolder;
import org.w3c.www.mime.MimeParser;

public class HttpMessage
implements HTTP,
Cloneable,
MimeHeaderHolder {
    protected static HeaderDescription[] descriptors;
    protected HeaderValue[] values = new HeaderValue[MAX_HEADERS];
    private int a = 10;
    protected ArrayDictionary state = null;
    protected long emitdate = -1L;
    protected short minor = 1;
    protected short major = 1;
    protected Dictionary headers = null;
    protected static Hashtable factory;
    public static int MAX_HEADERS;
    public static int H_COPT_EXT;
    public static int H_CMAN_EXT;
    public static int H_OPT_EXT;
    public static int H_MAN_EXT;
    public static int H_TRAILER;
    public static int H_COOKIE;
    public static int H_SET_COOKIE;
    public static int H_PROTOCOL_QUERY;
    public static int H_PROTOCOL_INFO;
    public static int H_PROTOCOL_REQUEST;
    public static int H_PROTOCOL;
    public static int H_VIA;
    public static int H_UPGRADE;
    public static int H_TRANSFER_ENCODING;
    public static int H_PRAGMA;
    public static int H_DATE;
    public static int H_PROXY_CONNECTION;
    public static int H_CONNECTION;
    public static int H_CACHE_CONTROL;
    public static final int EMIT_ALL = 7;
    public static final int EMIT_FOOTERS = 8;
    public static final int EMIT_BODY = 4;
    public static final int EMIT_HEADERS = 1;

    protected void startEmit(OutputStream outputStream, int n) throws IOException {
    }

    public void setVia(String[] stringArray) {
        this.setHeaderValue(H_VIA, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setValue(String string, String string2) {
        String string3 = string.toLowerCase();
        HeaderDescription headerDescription = null;
        if (string2 == null) {
            headerDescription = (HeaderDescription)factory.get(string3);
            if (headerDescription != null) {
                if (headerDescription.b >= 0) {
                    this.values[headerDescription.b] = null;
                } else if (this.headers != null) {
                    this.headers.remove(string3);
                }
            }
            return;
        }
        HeaderValue headerValue = this.getHeaderValue(string3);
        if (headerValue == null) {
            if (headerDescription == null) {
                headerDescription = (HeaderDescription)factory.get(string3);
            }
            if (headerDescription == null) {
                HttpMessage.registerHeader(string, "org.w3c.www.http.HttpString");
                headerValue = new HttpString();
            } else {
                headerValue = headerDescription.getHolder();
            }
        }
        byte[] byArray = new byte[string2.length()];
        string2.getBytes(0, byArray.length, byArray, 0);
        headerValue.setBytes(byArray, 0, byArray.length);
        this.setHeaderValue(string3, headerValue);
    }

    public void setUpgrade(String[] stringArray) {
        this.setHeaderValue(H_UPGRADE, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setTransferEncoding(String[] stringArray) {
        this.setHeaderValue(H_TRANSFER_ENCODING, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setTrailer(String[] stringArray) {
        this.setHeaderValue(H_TRAILER, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setState(String string, Object object) {
        if (object != null) {
            if (this.state == null) {
                this.state = new ArrayDictionary(4, 4);
            }
            this.state.put(string, object);
        } else if (this.state != null) {
            this.state.remove(string);
        }
    }

    public void setSetCookie(HttpSetCookieList httpSetCookieList) {
        this.setHeaderValue(H_SET_COOKIE, (HeaderValue)httpSetCookieList);
    }

    public void setSMaxAge(int n) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setSMaxAge(n);
    }

    public void setProxyConnection(String[] stringArray) {
        this.setHeaderValue(H_PROXY_CONNECTION, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setProtocolRequest(HttpBag httpBag) {
        this.setHeaderValue(H_PROTOCOL_REQUEST, (HeaderValue)httpBag);
    }

    public void setProtocolQuery(HttpBag httpBag) {
        this.setHeaderValue(H_PROTOCOL_QUERY, (HeaderValue)httpBag);
    }

    public void setProtocolInfo(HttpBag httpBag) {
        this.setHeaderValue(H_PROTOCOL_INFO, (HeaderValue)httpBag);
    }

    public void setProtocol(HttpBag httpBag) {
        this.setHeaderValue(H_PROTOCOL, (HeaderValue)httpBag);
    }

    public void setPragma(String[] stringArray) {
        this.setHeaderValue(H_PRAGMA, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setOnlyIfCached(boolean bl) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            if (!bl) {
                return;
            }
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setOnlyIfCached(bl);
    }

    public void setNoStore(boolean bl) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            if (!bl) {
                return;
            }
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setNoStore(bl);
    }

    public void setNoCache(String[] stringArray) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            if (stringArray == null) {
                return;
            }
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setNoCache(stringArray);
    }

    public void setNoCache() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setNoCache();
    }

    protected void setNamespaces(HttpExtList httpExtList) {
        HttpExt[] httpExtArray = httpExtList.getHttpExts();
        int n = 0;
        while (n < httpExtArray.length) {
            if (httpExtArray[n].isGenerated()) {
                throw new HttpExtException("This extension Object is already associated to an HttpMessage: " + httpExtArray[n].getName());
            }
            if (httpExtArray[n].needsHeaders()) {
                httpExtArray[n].setNamespace(this.generateExtNamespace());
            }
            ++n;
        }
    }

    public void setMaxAge(int n) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            if (n == -1) {
                return;
            }
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.setMaxAge(n);
    }

    public void setHttpOptExtDecl(HttpExtList httpExtList) {
        httpExtList.setManOptFlag(2);
        this.setNamespaces(httpExtList);
        this.setHeaderValue(H_OPT_EXT, (HeaderValue)httpExtList);
    }

    public void setHttpManExtDecl(HttpExtList httpExtList) {
        httpExtList.setManOptFlag(0);
        this.setNamespaces(httpExtList);
        this.setHeaderValue(H_MAN_EXT, (HeaderValue)httpExtList);
    }

    public void setHttpExtDecl(HttpExtList httpExtList) {
        this.setNamespaces(httpExtList);
        switch (httpExtList.getManOptFlag()) {
            case 0: {
                this.setHeaderValue(H_MAN_EXT, (HeaderValue)httpExtList);
                break;
            }
            case 1: {
                this.setHeaderValue(H_CMAN_EXT, (HeaderValue)httpExtList);
                break;
            }
            case 2: {
                this.setHeaderValue(H_OPT_EXT, (HeaderValue)httpExtList);
                break;
            }
            case 3: {
                this.setHeaderValue(H_COPT_EXT, (HeaderValue)httpExtList);
                break;
            }
            default: {
                this.setHeaderValue(H_MAN_EXT, (HeaderValue)httpExtList);
            }
        }
    }

    public void setHttpCOptExtDecl(HttpExtList httpExtList) {
        httpExtList.setManOptFlag(3);
        this.setNamespaces(httpExtList);
        this.setHeaderValue(H_COPT_EXT, (HeaderValue)httpExtList);
    }

    public void setHttpCManExtDecl(HttpExtList httpExtList) {
        httpExtList.setManOptFlag(1);
        this.setNamespaces(httpExtList);
        this.setHeaderValue(H_CMAN_EXT, (HeaderValue)httpExtList);
    }

    public void setHopByHopExtensionAcknowledgmentHeader() {
        this.setValue("C-Ext", "");
    }

    public void setHeaderValue(HeaderDescription headerDescription, HeaderValue headerValue) {
        if (headerDescription.b >= 0) {
            this.values[headerDescription.b] = headerValue;
        } else {
            if (this.headers == null) {
                this.headers = new ArrayDictionary(5, 5);
            }
            this.headers.put(headerDescription.getName(), headerValue);
        }
    }

    public void setHeaderValue(String string, HeaderValue headerValue) {
        String string2 = string.toLowerCase();
        HeaderDescription headerDescription = (HeaderDescription)factory.get(string2);
        if (headerDescription != null && headerDescription.b >= 0) {
            this.values[headerDescription.b] = headerValue;
        } else {
            if (this.headers == null) {
                this.headers = new ArrayDictionary(5, 5);
            }
            this.headers.put(string2, headerValue);
        }
    }

    public final void setHeaderValue(int n, HeaderValue headerValue) {
        this.values[n] = headerValue;
    }

    public synchronized void setExtensionHeader(HttpExt httpExt, String string, String string2) {
        if (httpExt.isGenerated()) {
            throw new HttpExtException("This extension Object is already associated to an HttpMessage: " + httpExt.getName());
        }
        String string3 = httpExt.getNamespace();
        if (string3 == null) {
            string3 = this.generateExtNamespace();
            httpExt.setNamespace(string3);
        }
        this.setValue(String.valueOf(string3) + "-" + string, string2);
    }

    public void setEnd2EndExtensionAcknowledgmentHeader() {
        this.setValue("Ext", "");
    }

    public void setDate(long l) {
        this.setHeaderValue(H_DATE, (HeaderValue)(l == -1L ? null : new HttpDate(true, l)));
    }

    public void setCookie(HttpCookieList httpCookieList) {
        this.setHeaderValue(H_COOKIE, (HeaderValue)httpCookieList);
    }

    public void setConnection(String[] stringArray) {
        this.setHeaderValue(H_CONNECTION, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setCacheControl(HttpCacheControl httpCacheControl) {
        this.setHeaderValue(H_CACHE_CONTROL, (HeaderValue)httpCacheControl);
    }

    public void removeHeader(String string) {
        String string2 = string.toLowerCase();
        HeaderDescription headerDescription = (HeaderDescription)factory.get(string2);
        if (headerDescription != null) {
            if (headerDescription.b >= 0) {
                this.values[headerDescription.b] = null;
            } else if (this.headers != null) {
                this.headers.remove(string2);
            }
        }
    }

    public final void removeHeader(int n) {
        if (n >= 0 && n < MAX_HEADERS) {
            this.values[n] = null;
        }
    }

    protected static final void registerHeader(String string, String string2, int n) {
        HeaderDescription headerDescription;
        HttpMessage.descriptors[n] = headerDescription = new HeaderDescription(string, string2, n);
        factory.put(headerDescription.getName(), headerDescription);
    }

    protected static final void registerHeader(String string, String string2) {
        HeaderDescription headerDescription = new HeaderDescription(string, string2);
        factory.put(headerDescription.getName(), headerDescription);
    }

    public static final void registerExtHeader(String string, String string2) {
        HttpMessage.registerHeader(string, string2);
    }

    public void notifyHeader(String string, byte[] byArray, int n, int n2) {
        String string2 = string.toLowerCase();
        HeaderValue headerValue = this.getHeaderValue(string2);
        if (headerValue == null) {
            HeaderDescription headerDescription = (HeaderDescription)factory.get(string2);
            if (headerDescription == null) {
                headerValue = new HttpString();
                if (this.headers == null) {
                    this.headers = new ArrayDictionary(5, 5);
                }
                HttpMessage.registerHeader(string, "org.w3c.www.http.HttpString");
                this.headers.put(string2, headerValue);
            } else {
                headerValue = headerDescription.getHolder();
                if (headerDescription.b >= 0) {
                    this.values[headerDescription.b] = headerValue;
                } else {
                    if (this.headers == null) {
                        this.headers = new ArrayDictionary(5, 5);
                    }
                    this.headers.put(string2, headerValue);
                }
            }
        }
        headerValue.addBytes(byArray, n, n2);
    }

    public void notifyEndParsing(MimeParser mimeParser) throws IOException, HttpParserException {
    }

    public boolean notifyBeginParsing(MimeParser mimeParser) throws IOException, HttpParserException {
        return false;
    }

    public boolean hasTransferEncoding(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_TRANSFER_ENCODING);
        return httpTokenList != null ? httpTokenList.hasToken(string, false) : false;
    }

    public boolean hasState(String string) {
        return this.state != null && this.state.get(string) != null;
    }

    public boolean hasProxyConnection(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_PROXY_CONNECTION);
        return httpTokenList == null ? false : httpTokenList.hasToken(string, false);
    }

    public boolean hasPragma(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_PRAGMA);
        return httpTokenList != null ? httpTokenList.hasToken(string, false) : false;
    }

    public boolean hasHeader(String string) {
        return this.getHeaderValue(string) != null;
    }

    public boolean hasHeader(int n) {
        return this.values[n] != null;
    }

    public boolean hasConnection(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_CONNECTION);
        return httpTokenList == null ? false : httpTokenList.hasToken(string, false);
    }

    public String[] getVia() {
        HeaderValue headerValue = this.getHeaderValue(H_VIA);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public String getVersion() {
        switch (this.major) {
            case 0: {
                switch (this.minor) {
                    case 9: {
                        return "HTTP/0.9";
                    }
                    default: {
                        return "HTTP/" + this.major + "." + this.minor;
                    }
                }
            }
            case 1: {
                switch (this.minor) {
                    case 0: {
                        return "HTTP/1.0";
                    }
                    case 1: {
                        return "HTTP/1.1";
                    }
                }
                return "HTTP/" + this.major + "." + this.minor;
            }
        }
        return "HTTP/" + this.major + "." + this.minor;
    }

    public String getValue(HeaderDescription headerDescription) {
        HeaderValue headerValue = this.getHeaderValue(headerDescription);
        return headerValue == null ? null : headerValue.toString();
    }

    public String getValue(String string) {
        HeaderValue headerValue = this.getHeaderValue(string);
        return headerValue != null ? headerValue.toExternalForm() : null;
    }

    public String[] getUpgrade() {
        HeaderValue headerValue = this.getHeaderValue(H_UPGRADE);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public String[] getTransferEncoding() {
        HeaderValue headerValue = this.getHeaderValue(H_TRANSFER_ENCODING);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public String[] getTrailer() {
        HeaderValue headerValue = this.getHeaderValue(H_TRAILER);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public Enumeration getStateNames() {
        return this.state != null ? this.state.elements() : new EmptyEnumeration();
    }

    public Object getState(String string) {
        return this.state == null ? null : this.state.get(string);
    }

    public HttpSetCookieList getSetCookie() {
        HeaderValue headerValue = this.getHeaderValue(H_SET_COOKIE);
        return headerValue != null ? (HttpSetCookieList)headerValue.getValue() : null;
    }

    public int getSMaxAge() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? -1 : httpCacheControl.getSMaxAge();
    }

    public String[] getProxyConnection() {
        HeaderValue headerValue = this.getHeaderValue(H_PROXY_CONNECTION);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public HttpBag getProtocolRequest() {
        HeaderValue headerValue = this.getHeaderValue(H_PROTOCOL_REQUEST);
        return headerValue != null ? (HttpBag)headerValue.getValue() : null;
    }

    public HttpBag getProtocolQuery() {
        HeaderValue headerValue = this.getHeaderValue(H_PROTOCOL_QUERY);
        return headerValue != null ? (HttpBag)headerValue.getValue() : null;
    }

    public HttpBag getProtocolInfo() {
        HeaderValue headerValue = this.getHeaderValue(H_PROTOCOL_INFO);
        return headerValue != null ? (HttpBag)headerValue.getValue() : null;
    }

    public HttpBag getProtocol() {
        HeaderValue headerValue = this.getHeaderValue(H_PROTOCOL);
        return headerValue != null ? (HttpBag)headerValue.getValue() : null;
    }

    public String[] getPragma() {
        HeaderValue headerValue = this.getHeaderValue(H_PRAGMA);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public String getOptExtHeader(String string, String string2) {
        return this.a(this.getHttpOptExtDecl(), string, string2);
    }

    public String[] getNoCache() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? null : httpCacheControl.getNoCache();
    }

    public short getMinorVersion() {
        return this.minor;
    }

    public int getMaxAge() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? -1 : httpCacheControl.getMaxAge();
    }

    public String getManExtHeader(String string, String string2) {
        return this.a(this.getHttpManExtDecl(), string, string2);
    }

    public short getMajorVersion() {
        return this.major;
    }

    public HttpExtList getHttpOptExtDecl() {
        HeaderValue headerValue = this.getHeaderValue(H_OPT_EXT);
        HttpExtList httpExtList = null;
        if (headerValue != null && (httpExtList = (HttpExtList)headerValue.getValue()) != null) {
            httpExtList.setManOptFlag(2);
        }
        return httpExtList;
    }

    public HttpExtList getHttpManExtDecl() {
        HeaderValue headerValue = this.getHeaderValue(H_MAN_EXT);
        HttpExtList httpExtList = null;
        if (headerValue != null && (httpExtList = (HttpExtList)headerValue.getValue()) != null) {
            httpExtList.setManOptFlag(0);
        }
        return httpExtList;
    }

    public HttpExtList getHttpCOptExtDecl() {
        HeaderValue headerValue = this.getHeaderValue(H_COPT_EXT);
        HttpExtList httpExtList = null;
        if (headerValue != null && (httpExtList = (HttpExtList)headerValue.getValue()) != null) {
            httpExtList.setManOptFlag(3);
        }
        return httpExtList;
    }

    public HttpExtList getHttpCManExtDecl() {
        HeaderValue headerValue = this.getHeaderValue(H_CMAN_EXT);
        HttpExtList httpExtList = null;
        if (headerValue != null && (httpExtList = (HttpExtList)headerValue.getValue()) != null) {
            httpExtList.setManOptFlag(1);
        }
        return httpExtList;
    }

    public HeaderValue getHeaderValue(HeaderDescription headerDescription) {
        if (headerDescription.b >= 0) {
            return this.values[headerDescription.b];
        }
        return this.headers != null ? (HeaderValue)this.headers.get(headerDescription.getName()) : null;
    }

    public HeaderValue getHeaderValue(String string, HeaderValue headerValue) {
        HeaderValue headerValue2 = null;
        HeaderDescription headerDescription = (HeaderDescription)factory.get(string);
        if (headerDescription != null && headerDescription.b >= 0) {
            headerValue2 = this.values[headerDescription.b];
        } else if (this.headers != null) {
            headerValue2 = (HeaderValue)this.headers.get(string);
        }
        return headerValue2 == null ? headerValue : headerValue2;
    }

    public final HeaderValue getHeaderValue(String string) {
        return this.getHeaderValue(string.toLowerCase(), null);
    }

    public final HeaderValue getHeaderValue(int n) {
        return this.values[n];
    }

    public Dictionary getExtensionHeaders(HttpExt httpExt) {
        ArrayDictionary arrayDictionary = new ArrayDictionary(5, 5);
        if (this.headers != null) {
            Enumeration enumeration = this.headers.keys();
            String string = httpExt.getNamespace();
            if (string == null) {
                return arrayDictionary;
            }
            string = String.valueOf(string) + "-";
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(string)) continue;
                String string3 = string2.substring(3);
                arrayDictionary.put(string3, this.headers.get(string2));
            }
        }
        return arrayDictionary;
    }

    public HttpExtList getExtList(String string) {
        HttpExt httpExt;
        HttpExtList httpExtList = this.getHttpManExtDecl();
        HttpExt httpExt2 = httpExt = httpExtList != null ? httpExtList.getHttpExt(string) : null;
        if (httpExt == null) {
            httpExtList = this.getHttpCManExtDecl();
            HttpExt httpExt3 = httpExt = httpExtList != null ? httpExtList.getHttpExt(string) : null;
            if (httpExt == null) {
                httpExtList = this.getHttpOptExtDecl();
                HttpExt httpExt4 = httpExt = httpExtList != null ? httpExtList.getHttpExt(string) : null;
                if (httpExt == null) {
                    httpExtList = this.getHttpCOptExtDecl();
                    HttpExt httpExt5 = httpExt = httpExtList != null ? httpExtList.getHttpExt(string) : null;
                    if (httpExt == null) {
                        httpExtList = null;
                    }
                }
            }
        }
        return httpExtList;
    }

    private String a(HttpExtList httpExtList, String string, String string2) {
        if (httpExtList == null) {
            return null;
        }
        HttpExt httpExt = httpExtList.getHttpExt(string);
        if (httpExt != null) {
            String string3 = String.valueOf(httpExt.getNamespace()) + "-" + string2;
            return this.getValue(string3);
        }
        return null;
    }

    public String getExtHeader(String string, String string2) {
        String string3 = this.getManExtHeader(string, string2);
        if (string3 == null && (string3 = this.getCManExtHeader(string, string2)) == null && (string3 = this.getOptExtHeader(string, string2)) == null) {
            string3 = this.getCOptExtHeader(string, string2);
        }
        return string3;
    }

    public long getEmitDate() {
        return this.emitdate;
    }

    public long getDate() {
        HeaderValue headerValue = this.getHeaderValue(H_DATE);
        return headerValue != null ? (Long)headerValue.getValue() : -1L;
    }

    public HttpCookieList getCookie() {
        HeaderValue headerValue = this.getHeaderValue(H_COOKIE);
        return headerValue != null ? (HttpCookieList)headerValue.getValue() : null;
    }

    public String[] getConnection() {
        HeaderValue headerValue = this.getHeaderValue(H_CONNECTION);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public HttpMessage getClone() {
        try {
            HttpMessage httpMessage = (HttpMessage)this.clone();
            httpMessage.values = new HeaderValue[MAX_HEADERS];
            System.arraycopy(this.values, 0, httpMessage.values, 0, MAX_HEADERS);
            if (httpMessage.headers != null) {
                httpMessage.headers = (ArrayDictionary)((ArrayDictionary)this.headers).clone();
            }
            if (httpMessage.state != null) {
                httpMessage.state = (ArrayDictionary)this.state.clone();
            }
            return httpMessage;
        }
        catch (Exception exception) {
            throw new RuntimeException("Clone not supported !");
        }
    }

    public HttpCacheControl getCacheControl() {
        HeaderValue headerValue = this.getHeaderValue(H_CACHE_CONTROL);
        return headerValue != null ? (HttpCacheControl)headerValue.getValue() : null;
    }

    public String getCOptExtHeader(String string, String string2) {
        return this.a(this.getHttpCOptExtDecl(), string, string2);
    }

    public String getCManExtHeader(String string, String string2) {
        return this.a(this.getHttpCManExtDecl(), string, string2);
    }

    protected synchronized String generateExtNamespace() {
        return String.valueOf(this.a++);
    }

    public Enumeration enumerateHeaderDescriptions(boolean bl) {
        return new a(this, bl);
    }

    public Enumeration enumerateHeaderDescriptions() {
        return new a(this, false);
    }

    protected void endEmit(OutputStream outputStream, int n) throws IOException {
    }

    protected void emitHeaders(OutputStream outputStream, int n) throws IOException {
        String string;
        Object object;
        Object object2;
        Object object3;
        int n2;
        Object[] objectArray;
        if ((n & 1) != 1) {
            return;
        }
        this.emitdate = System.currentTimeMillis();
        if (!this.hasHeader(H_DATE)) {
            this.setHeaderValue(H_DATE, (HeaderValue)new HttpDate(true, this.emitdate));
        }
        String[] stringArray = this.getConnection();
        HttpTokenList httpTokenList = null;
        httpTokenList = stringArray != null ? new HttpTokenList(stringArray) : new HttpTokenList(new String[0]);
        HttpExtList httpExtList = this.getHttpCManExtDecl();
        if (httpExtList != null) {
            httpTokenList.addToken("C-Man", false);
            objectArray = httpExtList.getHttpExts();
            n2 = 0;
            while (n2 < objectArray.length) {
                object3 = objectArray[n2];
                object2 = this.getExtensionHeaders((HttpExt)object3);
                object = ((Dictionary)object2).keys();
                while (object.hasMoreElements()) {
                    string = ((HttpExt)object3).getRealHeader((String)object.nextElement());
                    if (string != null && string.toLowerCase().equals("https-proxy-authorization")) continue;
                    httpTokenList.addToken(string, false);
                }
                ++n2;
            }
        }
        if ((httpExtList = this.getHttpCOptExtDecl()) != null) {
            httpTokenList.addToken("C-Opt", false);
            objectArray = httpExtList.getHttpExts();
            n2 = 0;
            while (n2 < objectArray.length) {
                object3 = objectArray[n2];
                object2 = this.getExtensionHeaders((HttpExt)object3);
                object = ((Dictionary)object2).keys();
                while (object.hasMoreElements()) {
                    string = ((HttpExt)object3).getRealHeader((String)object.nextElement());
                    if (string != null && string.toLowerCase().equals("https-proxy-authorization")) continue;
                    httpTokenList.addToken(string, false);
                }
                ++n2;
            }
        }
        if (this.hasHeader("C-Ext")) {
            httpTokenList.addToken("C-Ext", false);
        }
        if ((objectArray = (String[])httpTokenList.getValue()) != null && objectArray.length > 0) {
            this.setHeaderValue(H_CONNECTION, (HeaderValue)httpTokenList);
        }
        if (this.hasHeader("Ext")) {
            this.addNoCache("Ext");
        }
        n2 = 0;
        while (n2 < MAX_HEADERS) {
            object3 = descriptors[n2];
            if (object3 == null || (object2 = ((HeaderDescription)object3).getName()) == null || !((String)object2).toLowerCase().equals("https-proxy-authorization")) {
                object2 = this.values[n2];
                if (object2 instanceof HttpSetCookieList) {
                    object = (HttpSetCookieList)object2;
                    int n3 = ((HttpSetCookieList)object).length();
                    if (n3 == 0) {
                        outputStream.write(((HeaderDescription)object3).getTitle());
                        outputStream.write(58);
                        outputStream.write(32);
                        object2.emit(outputStream);
                        outputStream.write(13);
                        outputStream.write(10);
                    } else {
                        int n4 = 0;
                        while (n4 < n3) {
                            outputStream.write(((HeaderDescription)object3).getTitle());
                            outputStream.write(58);
                            outputStream.write(32);
                            ((HttpSetCookieList)object).emitCookie(outputStream, n4);
                            outputStream.write(13);
                            outputStream.write(10);
                            ++n4;
                        }
                    }
                } else if (object2 != null) {
                    outputStream.write(((HeaderDescription)object3).getTitle());
                    outputStream.write(58);
                    outputStream.write(32);
                    object2.emit(outputStream);
                    outputStream.write(13);
                    outputStream.write(10);
                }
            }
            ++n2;
        }
        if (this.headers != null) {
            object3 = this.headers.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (object2 != null && ((String)object2).toLowerCase().equals("https-proxy-authorization")) continue;
                object = (HeaderDescription)factory.get(object2);
                HeaderValue headerValue = (HeaderValue)this.headers.get(object2);
                if (headerValue == null) continue;
                outputStream.write(((HeaderDescription)object).getTitle());
                outputStream.write(58);
                outputStream.write(32);
                headerValue.emit(outputStream);
                outputStream.write(13);
                outputStream.write(10);
            }
        }
        outputStream.write(13);
        outputStream.write(10);
    }

    public void emit(OutputStream outputStream, int n) throws IOException {
        this.startEmit(outputStream, n);
        this.emitHeaders(outputStream, n);
        this.endEmit(outputStream, n);
    }

    public void emit(OutputStream outputStream) throws IOException {
        this.startEmit(outputStream, 7);
        if (this.major > 0) {
            this.emitHeaders(outputStream, 7);
        }
        this.endEmit(outputStream, 7);
    }

    public void dump(OutputStream outputStream) {
        try {
            this.emitHeaders(outputStream, 1);
        }
        catch (Exception exception) {}
    }

    public void delState(String string) {
        if (this.state != null) {
            this.state.remove(string);
        }
    }

    public boolean checkOnlyIfCached() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? false : httpCacheControl.checkOnlyIfCached();
    }

    public boolean checkNoStore() {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        return httpCacheControl == null ? false : httpCacheControl.checkNoStore();
    }

    public void addVia(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_VIA);
        if (httpTokenList == null) {
            String[] stringArray = new String[]{string};
            this.setVia(stringArray);
        } else {
            httpTokenList.addToken(string, true);
        }
    }

    public void addTransferEncoding(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_TRANSFER_ENCODING);
        if (httpTokenList == null) {
            String[] stringArray = new String[]{string.toLowerCase()};
            this.setHeaderValue(H_TRANSFER_ENCODING, (HeaderValue)new HttpTokenList(stringArray));
        } else {
            httpTokenList.addToken(string, false);
        }
    }

    public void addProxyConnection(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_PROXY_CONNECTION);
        if (httpTokenList == null) {
            String[] stringArray = new String[]{string.toLowerCase()};
            this.setHeaderValue(H_PROXY_CONNECTION, (HeaderValue)new HttpTokenList(stringArray));
        } else {
            httpTokenList.addToken(string, false);
        }
    }

    public void addPragma(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_PRAGMA);
        if (httpTokenList == null) {
            String[] stringArray = new String[]{string.toLowerCase()};
            this.setHeaderValue(H_PRAGMA, (HeaderValue)new HttpTokenList(stringArray));
        } else {
            httpTokenList.addToken(string, false);
        }
    }

    public void addNoCache(String string) {
        HttpCacheControl httpCacheControl = this.getCacheControl();
        if (httpCacheControl == null) {
            httpCacheControl = new HttpCacheControl(true);
            this.setCacheControl(httpCacheControl);
        }
        httpCacheControl.addNoCache(string);
    }

    public void addConnection(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_CONNECTION);
        if (httpTokenList == null) {
            String[] stringArray = new String[]{string.toLowerCase()};
            this.setHeaderValue(H_CONNECTION, (HeaderValue)new HttpTokenList(stringArray));
        } else {
            httpTokenList.addToken(string, false);
        }
    }

    public HttpMessage(MimeParser mimeParser) {
    }

    public HttpMessage() {
    }

    static {
        H_CACHE_CONTROL = 0;
        H_CONNECTION = 1;
        H_PROXY_CONNECTION = 2;
        H_DATE = 3;
        H_PRAGMA = 4;
        H_TRANSFER_ENCODING = 5;
        H_UPGRADE = 6;
        H_VIA = 7;
        H_PROTOCOL = 8;
        H_PROTOCOL_REQUEST = 9;
        H_PROTOCOL_INFO = 10;
        H_PROTOCOL_QUERY = 11;
        H_SET_COOKIE = 12;
        H_COOKIE = 13;
        H_TRAILER = 14;
        H_MAN_EXT = 15;
        H_OPT_EXT = 16;
        H_CMAN_EXT = 17;
        H_COPT_EXT = 18;
        MAX_HEADERS = 61;
        factory = new Hashtable(23);
        descriptors = new HeaderDescription[MAX_HEADERS];
        HttpMessage.registerHeader("Cache-Control", "org.w3c.www.http.HttpCacheControl", H_CACHE_CONTROL);
        HttpMessage.registerHeader("Connection", "org.w3c.www.http.HttpTokenList", H_CONNECTION);
        HttpMessage.registerHeader("Proxy-Connection", "org.w3c.www.http.HttpTokenList", H_PROXY_CONNECTION);
        HttpMessage.registerHeader("Date", "org.w3c.www.http.HttpDate", H_DATE);
        HttpMessage.registerHeader("Pragma", "org.w3c.www.http.HttpTokenList", H_PRAGMA);
        HttpMessage.registerHeader("Transfer-Encoding", "org.w3c.www.http.HttpTokenList", H_TRANSFER_ENCODING);
        HttpMessage.registerHeader("Upgrade", "org.w3c.www.http.HttpTokenList", H_UPGRADE);
        HttpMessage.registerHeader("Via", "org.w3c.www.http.HttpCaseTokenList", H_VIA);
        HttpMessage.registerHeader("Trailer", "org.w3c.www.http.HttpTokenList", H_TRAILER);
        HttpMessage.registerHeader("Protocol", "org.w3c.www.http.HttpBag", H_PROTOCOL);
        HttpMessage.registerHeader("Protocol-Request", "org.w3c.www.http.HttpBag", H_PROTOCOL_REQUEST);
        HttpMessage.registerHeader("Protocol-Query", "org.w3c.www.http.HttpBag", H_PROTOCOL_QUERY);
        HttpMessage.registerHeader("Protocol-Info", "org.w3c.www.http.HttpBag", H_PROTOCOL_INFO);
        HttpMessage.registerHeader("Set-Cookie", "org.w3c.www.http.HttpSetCookieList", H_SET_COOKIE);
        HttpMessage.registerHeader("Cookie", "org.w3c.www.http.HttpCookieList", H_COOKIE);
        HttpMessage.registerHeader("Man", "org.w3c.www.http.HttpExtList", H_MAN_EXT);
        HttpMessage.registerHeader("Opt", "org.w3c.www.http.HttpExtList", H_OPT_EXT);
        HttpMessage.registerHeader("C-Man", "org.w3c.www.http.HttpExtList", H_CMAN_EXT);
        HttpMessage.registerHeader("C-Opt", "org.w3c.www.http.HttpExtList", H_COPT_EXT);
    }
}

