/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.IOException;
import java.io.OutputStream;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpInvalidValueException;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.c;

public abstract class BasicValue
implements Cloneable,
HeaderValue {
    protected boolean isValid = false;
    protected int rlen = -1;
    protected int roff = -1;
    protected byte[] raw = null;

    protected final void validate() throws HttpInvalidValueException {
        if (this.isValid) {
            return;
        }
        try {
            this.parse();
        }
        catch (HttpParserException httpParserException) {
            throw new HttpInvalidValueException(httpParserException.getMessage());
        }
        this.isValid = true;
    }

    protected abstract void updateByteValue();

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        this.checkByteValue();
        return new String(this.raw, 0, this.roff, this.rlen - this.roff);
    }

    public void setString(String string) {
        int n = string.length();
        this.raw = new byte[n];
        this.roff = 0;
        this.rlen = n;
        string.getBytes(0, n, this.raw, 0);
        this.isValid = false;
    }

    public void setBytes(byte[] byArray, int n, int n2) {
        this.raw = new byte[n2];
        System.arraycopy(byArray, n, this.raw, 0, n2);
        this.roff = 0;
        this.rlen = this.raw.length;
        this.isValid = false;
    }

    protected abstract void parse() throws HttpParserException;

    protected void invalidateByteValue() {
        this.raw = null;
    }

    public abstract Object getValue();

    protected void error(String string) throws HttpParserException {
        throw new HttpParserException(string);
    }

    public void emit(OutputStream outputStream) throws IOException {
        this.checkByteValue();
        outputStream.write(this.raw);
    }

    protected final void checkByteValue() {
        if (this.raw == null) {
            this.updateByteValue();
            this.roff = 0;
            this.rlen = this.raw.length;
        }
    }

    public void appendValue(c c2) {
        this.checkByteValue();
        c2.a(this.raw, this.roff, this.rlen);
    }

    public void addBytes(byte[] byArray, int n, int n2) {
        if (this.raw != null) {
            int n3 = n2 + this.rlen;
            byte[] byArray2 = new byte[n3 + 1];
            System.arraycopy(this.raw, this.roff, byArray2, 0, this.rlen);
            byArray2[this.rlen] = 44;
            System.arraycopy(byArray, n, byArray2, this.rlen + 1, n2);
            this.raw = byArray2;
        } else {
            this.raw = new byte[n2];
            System.arraycopy(byArray, n, this.raw, 0, n2);
        }
        this.roff = 0;
        this.rlen = this.raw.length;
        this.isValid = false;
    }

    BasicValue() {
    }
}

